// services/network/public/mojom/tcp_socket.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/tcp_socket.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/tcp_socket.mojom-params-data.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/tcp_socket.mojom-import-headers.h"
#include "services/network/public/mojom/tcp_socket.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
TCPKeepAliveOptions::TCPKeepAliveOptions()
    : enable(false),
      delay(0U) {}

TCPKeepAliveOptions::TCPKeepAliveOptions(
    bool enable_in,
    uint16_t delay_in)
    : enable(std::move(enable_in)),
      delay(std::move(delay_in)) {}

TCPKeepAliveOptions::~TCPKeepAliveOptions() = default;
size_t TCPKeepAliveOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->enable);
  seed = mojo::internal::Hash(seed, this->delay);
  return seed;
}

void TCPKeepAliveOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable"), this->enable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delay"), this->delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TCPKeepAliveOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TCPConnectedSocketOptions::TCPConnectedSocketOptions()
    : send_buffer_size(0),
      receive_buffer_size(0),
      no_delay(true),
      keep_alive_options() {}

TCPConnectedSocketOptions::TCPConnectedSocketOptions(
    int32_t send_buffer_size_in,
    int32_t receive_buffer_size_in,
    bool no_delay_in,
    TCPKeepAliveOptionsPtr keep_alive_options_in)
    : send_buffer_size(std::move(send_buffer_size_in)),
      receive_buffer_size(std::move(receive_buffer_size_in)),
      no_delay(std::move(no_delay_in)),
      keep_alive_options(std::move(keep_alive_options_in)) {}

TCPConnectedSocketOptions::~TCPConnectedSocketOptions() = default;

void TCPConnectedSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_buffer_size"), this->send_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_buffer_size"), this->receive_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_delay"), this->no_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keep_alive_options"), this->keep_alive_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TCPKeepAliveOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TCPConnectedSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TCPServerSocketOptions::TCPServerSocketOptions()
    : backlog(),
      ipv6_only() {}

TCPServerSocketOptions::TCPServerSocketOptions(
    uint32_t backlog_in,
    ::network::mojom::OptionalBool ipv6_only_in)
    : backlog(std::move(backlog_in)),
      ipv6_only(std::move(ipv6_only_in)) {}

TCPServerSocketOptions::~TCPServerSocketOptions() = default;
size_t TCPServerSocketOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->backlog);
  seed = mojo::internal::Hash(seed, this->ipv6_only);
  return seed;
}

void TCPServerSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backlog"), this->backlog,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ipv6_only"), this->ipv6_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::OptionalBool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TCPServerSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TCPBoundSocket::Name_[] = "network.mojom.TCPBoundSocket";

TCPBoundSocket::IPCStableHashFunction TCPBoundSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TCPBoundSocket>(message.name())) {
    case messages::TCPBoundSocket::kListen: {
      return &TCPBoundSocket::Listen_Sym::IPCStableHash;
    }
    case messages::TCPBoundSocket::kConnect: {
      return &TCPBoundSocket::Connect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TCPBoundSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TCPBoundSocket>(message.name())) {
      case messages::TCPBoundSocket::kListen:
            return "Receive network::mojom::TCPBoundSocket::Listen";
      case messages::TCPBoundSocket::kConnect:
            return "Receive network::mojom::TCPBoundSocket::Connect";
    }
  } else {
    switch (static_cast<messages::TCPBoundSocket>(message.name())) {
      case messages::TCPBoundSocket::kListen:
            return "Receive reply network::mojom::TCPBoundSocket::Listen";
      case messages::TCPBoundSocket::kConnect:
            return "Receive reply network::mojom::TCPBoundSocket::Connect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TCPBoundSocket::Listen_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TCPBoundSocket::Listen");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TCPBoundSocket::Connect_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TCPBoundSocket::Connect");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TCPBoundSocket_Listen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPBoundSocket_Listen_ForwardToCallback(
      TCPBoundSocket::ListenCallback callback
      ) : callback_(std::move(callback)) {
  }

  TCPBoundSocket_Listen_ForwardToCallback(const TCPBoundSocket_Listen_ForwardToCallback&) = delete;
  TCPBoundSocket_Listen_ForwardToCallback& operator=(const TCPBoundSocket_Listen_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TCPBoundSocket::ListenCallback callback_;
};

class TCPBoundSocket_Connect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPBoundSocket_Connect_ForwardToCallback(
      TCPBoundSocket::ConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  TCPBoundSocket_Connect_ForwardToCallback(const TCPBoundSocket_Connect_ForwardToCallback&) = delete;
  TCPBoundSocket_Connect_ForwardToCallback& operator=(const TCPBoundSocket_Connect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TCPBoundSocket::ConnectCallback callback_;
};

TCPBoundSocketProxy::TCPBoundSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TCPBoundSocketProxy::Listen(
    uint32_t in_backlog, ::mojo::PendingReceiver<TCPServerSocket> in_socket, ListenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TCPBoundSocket::Listen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("backlog"), in_backlog,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingReceiver<TCPServerSocket>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPBoundSocket::kListen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPBoundSocket_Listen_Params_Data> params(
          message);
  params.Allocate();
  params->backlog = in_backlog;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPServerSocketInterfaceBase>>(
      in_socket, &params->socket, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in TCPBoundSocket.Listen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPBoundSocket::Name_);
  message.set_method_name("Listen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPBoundSocket_Listen_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TCPBoundSocketProxy::Connect(
    const ::net::AddressList& in_remote_addr_list, TCPConnectedSocketOptionsPtr in_tcp_connected_socket_options, ::mojo::PendingReceiver<TCPConnectedSocket> in_socket, ::mojo::PendingRemote<SocketObserver> in_observer, ConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TCPBoundSocket::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_addr_list"), in_remote_addr_list,
                        "<value of type const ::net::AddressList&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tcp_connected_socket_options"), in_tcp_connected_socket_options,
                        "<value of type TCPConnectedSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingReceiver<TCPConnectedSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<SocketObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPBoundSocket::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPBoundSocket_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->remote_addr_list)::BaseType> remote_addr_list_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
      in_remote_addr_list, remote_addr_list_fragment);
  params->remote_addr_list.Set(
      remote_addr_list_fragment.is_null() ? nullptr : remote_addr_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_addr_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_addr_list in TCPBoundSocket.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->tcp_connected_socket_options)::BaseType> tcp_connected_socket_options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::TCPConnectedSocketOptionsDataView>(
      in_tcp_connected_socket_options, tcp_connected_socket_options_fragment);
  params->tcp_connected_socket_options.Set(
      tcp_connected_socket_options_fragment.is_null() ? nullptr : tcp_connected_socket_options_fragment.data());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPConnectedSocketInterfaceBase>>(
      in_socket, &params->socket, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in TCPBoundSocket.Connect request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPBoundSocket::Name_);
  message.set_method_name("Connect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPBoundSocket_Connect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TCPBoundSocket_Listen_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TCPBoundSocket::ListenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TCPBoundSocket_Listen_ProxyToResponder> proxy(
        new TCPBoundSocket_Listen_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TCPBoundSocket_Listen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPBoundSocket_Listen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TCPBoundSocket_Listen_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPBoundSocket::ListenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);
};

bool TCPBoundSocket_Listen_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TCPBoundSocket_Listen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPBoundSocket_Listen_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TCPBoundSocket.0
  bool success = true;
  int32_t p_net_error{};
  TCPBoundSocket_Listen_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPBoundSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void TCPBoundSocket_Listen_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TCPBoundSocket::Listen", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPBoundSocket::kListen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPBoundSocket_Listen_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPBoundSocket::Name_);
  message.set_method_name("Listen");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPBoundSocket_Connect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TCPBoundSocket::ConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TCPBoundSocket_Connect_ProxyToResponder> proxy(
        new TCPBoundSocket_Connect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TCPBoundSocket_Connect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPBoundSocket_Connect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TCPBoundSocket_Connect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPBoundSocket::ConnectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream);
};

bool TCPBoundSocket_Connect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TCPBoundSocket_Connect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPBoundSocket_Connect_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TCPBoundSocket.1
  bool success = true;
  int32_t p_net_error{};
  std::optional<::net::IPEndPoint> p_local_addr{};
  std::optional<::net::IPEndPoint> p_peer_addr{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  TCPBoundSocket_Connect_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPBoundSocket::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_local_addr), 
std::move(p_peer_addr), 
std::move(p_receive_stream), 
std::move(p_send_stream));
  return true;
}

void TCPBoundSocket_Connect_ProxyToResponder::Run(
    int32_t in_net_error, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TCPBoundSocket::Connect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_addr"), in_peer_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPBoundSocket::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPBoundSocket_Connect_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, local_addr_fragment);
  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->peer_addr)::BaseType> peer_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_peer_addr, peer_addr_fragment);
  params->peer_addr.Set(
      peer_addr_fragment.is_null() ? nullptr : peer_addr_fragment.data());
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream, &params->send_stream, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPBoundSocket::Name_);
  message.set_method_name("Connect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TCPBoundSocketStubDispatch::Accept(
    TCPBoundSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TCPBoundSocket>(message->header()->name)) {
    case messages::TCPBoundSocket::kListen: {
      break;
    }
    case messages::TCPBoundSocket::kConnect: {
      break;
    }
  }
  return false;
}

// static
bool TCPBoundSocketStubDispatch::AcceptWithResponder(
    TCPBoundSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TCPBoundSocket>(message->header()->name)) {
    case messages::TCPBoundSocket::kListen: {
      internal::TCPBoundSocket_Listen_Params_Data* params =
          reinterpret_cast<
              internal::TCPBoundSocket_Listen_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TCPBoundSocket.0
      bool success = true;
      uint32_t p_backlog{};
      ::mojo::PendingReceiver<TCPServerSocket> p_socket{};
      TCPBoundSocket_Listen_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_backlog = input_data_view.backlog();
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPBoundSocket::Name_, 0, false);
        return false;
      }
      TCPBoundSocket::ListenCallback callback =
          TCPBoundSocket_Listen_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Listen(        
        std::move(p_backlog), 
        std::move(p_socket), std::move(callback));
      return true;
    }
    case messages::TCPBoundSocket::kConnect: {
      internal::TCPBoundSocket_Connect_Params_Data* params =
          reinterpret_cast<
              internal::TCPBoundSocket_Connect_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TCPBoundSocket.1
      bool success = true;
      ::net::AddressList p_remote_addr_list{};
      TCPConnectedSocketOptionsPtr p_tcp_connected_socket_options{};
      ::mojo::PendingReceiver<TCPConnectedSocket> p_socket{};
      ::mojo::PendingRemote<SocketObserver> p_observer{};
      TCPBoundSocket_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemoteAddrList(&p_remote_addr_list))
        success = false;
      if (success && !input_data_view.ReadTcpConnectedSocketOptions(&p_tcp_connected_socket_options))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPBoundSocket::Name_, 1, false);
        return false;
      }
      TCPBoundSocket::ConnectCallback callback =
          TCPBoundSocket_Connect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_remote_addr_list), 
        std::move(p_tcp_connected_socket_options), 
        std::move(p_socket), 
        std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTCPBoundSocketValidationInfo[] = {
    {base::to_underlying(messages::TCPBoundSocket::kListen),
     { &internal::TCPBoundSocket_Listen_Params_Data::Validate,
      &internal::TCPBoundSocket_Listen_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::TCPBoundSocket::kConnect),
     { &internal::TCPBoundSocket_Connect_Params_Data::Validate,
      &internal::TCPBoundSocket_Connect_ResponseParams_Data::Validate}},
};

bool TCPBoundSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPBoundSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTCPBoundSocketValidationInfo);
}

bool TCPBoundSocketResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPBoundSocket::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTCPBoundSocketValidationInfo);

}
const char TCPConnectedSocket::Name_[] = "network.mojom.TCPConnectedSocket";

TCPConnectedSocket::IPCStableHashFunction TCPConnectedSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TCPConnectedSocket>(message.name())) {
    case messages::TCPConnectedSocket::kUpgradeToTLS: {
      return &TCPConnectedSocket::UpgradeToTLS_Sym::IPCStableHash;
    }
    case messages::TCPConnectedSocket::kSetSendBufferSize: {
      return &TCPConnectedSocket::SetSendBufferSize_Sym::IPCStableHash;
    }
    case messages::TCPConnectedSocket::kSetReceiveBufferSize: {
      return &TCPConnectedSocket::SetReceiveBufferSize_Sym::IPCStableHash;
    }
    case messages::TCPConnectedSocket::kSetNoDelay: {
      return &TCPConnectedSocket::SetNoDelay_Sym::IPCStableHash;
    }
    case messages::TCPConnectedSocket::kSetKeepAlive: {
      return &TCPConnectedSocket::SetKeepAlive_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TCPConnectedSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TCPConnectedSocket>(message.name())) {
      case messages::TCPConnectedSocket::kUpgradeToTLS:
            return "Receive network::mojom::TCPConnectedSocket::UpgradeToTLS";
      case messages::TCPConnectedSocket::kSetSendBufferSize:
            return "Receive network::mojom::TCPConnectedSocket::SetSendBufferSize";
      case messages::TCPConnectedSocket::kSetReceiveBufferSize:
            return "Receive network::mojom::TCPConnectedSocket::SetReceiveBufferSize";
      case messages::TCPConnectedSocket::kSetNoDelay:
            return "Receive network::mojom::TCPConnectedSocket::SetNoDelay";
      case messages::TCPConnectedSocket::kSetKeepAlive:
            return "Receive network::mojom::TCPConnectedSocket::SetKeepAlive";
    }
  } else {
    switch (static_cast<messages::TCPConnectedSocket>(message.name())) {
      case messages::TCPConnectedSocket::kUpgradeToTLS:
            return "Receive reply network::mojom::TCPConnectedSocket::UpgradeToTLS";
      case messages::TCPConnectedSocket::kSetSendBufferSize:
            return "Receive reply network::mojom::TCPConnectedSocket::SetSendBufferSize";
      case messages::TCPConnectedSocket::kSetReceiveBufferSize:
            return "Receive reply network::mojom::TCPConnectedSocket::SetReceiveBufferSize";
      case messages::TCPConnectedSocket::kSetNoDelay:
            return "Receive reply network::mojom::TCPConnectedSocket::SetNoDelay";
      case messages::TCPConnectedSocket::kSetKeepAlive:
            return "Receive reply network::mojom::TCPConnectedSocket::SetKeepAlive";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TCPConnectedSocket::UpgradeToTLS_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TCPConnectedSocket::UpgradeToTLS");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TCPConnectedSocket::SetSendBufferSize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TCPConnectedSocket::SetSendBufferSize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TCPConnectedSocket::SetReceiveBufferSize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TCPConnectedSocket::SetReceiveBufferSize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TCPConnectedSocket::SetNoDelay_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TCPConnectedSocket::SetNoDelay");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TCPConnectedSocket::SetKeepAlive_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TCPConnectedSocket::SetKeepAlive");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TCPConnectedSocket_UpgradeToTLS_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_UpgradeToTLS_ForwardToCallback(
      TCPConnectedSocket::UpgradeToTLSCallback callback
      ) : callback_(std::move(callback)) {
  }

  TCPConnectedSocket_UpgradeToTLS_ForwardToCallback(const TCPConnectedSocket_UpgradeToTLS_ForwardToCallback&) = delete;
  TCPConnectedSocket_UpgradeToTLS_ForwardToCallback& operator=(const TCPConnectedSocket_UpgradeToTLS_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::UpgradeToTLSCallback callback_;
};

class TCPConnectedSocket_SetSendBufferSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_SetSendBufferSize_ForwardToCallback(
      TCPConnectedSocket::SetSendBufferSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  TCPConnectedSocket_SetSendBufferSize_ForwardToCallback(const TCPConnectedSocket_SetSendBufferSize_ForwardToCallback&) = delete;
  TCPConnectedSocket_SetSendBufferSize_ForwardToCallback& operator=(const TCPConnectedSocket_SetSendBufferSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::SetSendBufferSizeCallback callback_;
};

class TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback(
      TCPConnectedSocket::SetReceiveBufferSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback(const TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback&) = delete;
  TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback& operator=(const TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::SetReceiveBufferSizeCallback callback_;
};

class TCPConnectedSocket_SetNoDelay_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_SetNoDelay_ForwardToCallback(
      TCPConnectedSocket::SetNoDelayCallback callback
      ) : callback_(std::move(callback)) {
  }

  TCPConnectedSocket_SetNoDelay_ForwardToCallback(const TCPConnectedSocket_SetNoDelay_ForwardToCallback&) = delete;
  TCPConnectedSocket_SetNoDelay_ForwardToCallback& operator=(const TCPConnectedSocket_SetNoDelay_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::SetNoDelayCallback callback_;
};

class TCPConnectedSocket_SetKeepAlive_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_SetKeepAlive_ForwardToCallback(
      TCPConnectedSocket::SetKeepAliveCallback callback
      ) : callback_(std::move(callback)) {
  }

  TCPConnectedSocket_SetKeepAlive_ForwardToCallback(const TCPConnectedSocket_SetKeepAlive_ForwardToCallback&) = delete;
  TCPConnectedSocket_SetKeepAlive_ForwardToCallback& operator=(const TCPConnectedSocket_SetKeepAlive_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::SetKeepAliveCallback callback_;
};

TCPConnectedSocketProxy::TCPConnectedSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TCPConnectedSocketProxy::UpgradeToTLS(
    const ::net::HostPortPair& in_host_port_pair, ::network::mojom::TLSClientSocketOptionsPtr in_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> in_receiver, ::mojo::PendingRemote<SocketObserver> in_observer, UpgradeToTLSCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TCPConnectedSocket::UpgradeToTLS", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_port_pair"), in_host_port_pair,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::network::mojom::TLSClientSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::TLSClientSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<SocketObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kUpgradeToTLS), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_UpgradeToTLS_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host_port_pair)::BaseType> host_port_pair_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host_port_pair, host_port_pair_fragment);
  params->host_port_pair.Set(
      host_port_pair_fragment.is_null() ? nullptr : host_port_pair_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host_port_pair.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_port_pair in TCPConnectedSocket.UpgradeToTLS request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::TLSClientSocketOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in TCPConnectedSocket.UpgradeToTLS request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TLSClientSocketInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in TCPConnectedSocket.UpgradeToTLS request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("UpgradeToTLS");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_UpgradeToTLS_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TCPConnectedSocketProxy::SetSendBufferSize(
    int32_t in_send_buffer_size, SetSendBufferSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TCPConnectedSocket::SetSendBufferSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_buffer_size"), in_send_buffer_size,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kSetSendBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetSendBufferSize_Params_Data> params(
          message);
  params.Allocate();
  params->send_buffer_size = in_send_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetSendBufferSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_SetSendBufferSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TCPConnectedSocketProxy::SetReceiveBufferSize(
    int32_t in_receive_buffer_size, SetReceiveBufferSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TCPConnectedSocket::SetReceiveBufferSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_buffer_size"), in_receive_buffer_size,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kSetReceiveBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetReceiveBufferSize_Params_Data> params(
          message);
  params.Allocate();
  params->receive_buffer_size = in_receive_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetReceiveBufferSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TCPConnectedSocketProxy::SetNoDelay(
    bool in_no_delay, SetNoDelayCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TCPConnectedSocket::SetNoDelay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("no_delay"), in_no_delay,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kSetNoDelay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetNoDelay_Params_Data> params(
          message);
  params.Allocate();
  params->no_delay = in_no_delay;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetNoDelay");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_SetNoDelay_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TCPConnectedSocketProxy::SetKeepAlive(
    bool in_enable, int32_t in_delay_secs, SetKeepAliveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TCPConnectedSocket::SetKeepAlive", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delay_secs"), in_delay_secs,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kSetKeepAlive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetKeepAlive_Params_Data> params(
          message);
  params.Allocate();
  params->enable = in_enable;
  params->delay_secs = in_delay_secs;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetKeepAlive");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_SetKeepAlive_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TCPConnectedSocket_UpgradeToTLS_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TCPConnectedSocket::UpgradeToTLSCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TCPConnectedSocket_UpgradeToTLS_ProxyToResponder> proxy(
        new TCPConnectedSocket_UpgradeToTLS_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TCPConnectedSocket_UpgradeToTLS_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_UpgradeToTLS_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TCPConnectedSocket_UpgradeToTLS_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::UpgradeToTLSCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream, const std::optional<::net::SSLInfo>& in_ssl_info);
};

bool TCPConnectedSocket_UpgradeToTLS_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TCPConnectedSocket.0
  bool success = true;
  int32_t p_net_error{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  std::optional<::net::SSLInfo> p_ssl_info{};
  TCPConnectedSocket_UpgradeToTLS_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (success && !input_data_view.ReadSslInfo(&p_ssl_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_receive_stream), 
std::move(p_send_stream), 
std::move(p_ssl_info));
  return true;
}

void TCPConnectedSocket_UpgradeToTLS_ProxyToResponder::Run(
    int32_t in_net_error, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream, const std::optional<::net::SSLInfo>& in_ssl_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TCPConnectedSocket::UpgradeToTLS", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ssl_info"), in_ssl_info,
                        "<value of type const std::optional<::net::SSLInfo>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kUpgradeToTLS), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream, &params->send_stream, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->ssl_info)::BaseType> ssl_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
      in_ssl_info, ssl_info_fragment);
  params->ssl_info.Set(
      ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("UpgradeToTLS");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPConnectedSocket_SetSendBufferSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TCPConnectedSocket::SetSendBufferSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TCPConnectedSocket_SetSendBufferSize_ProxyToResponder> proxy(
        new TCPConnectedSocket_SetSendBufferSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TCPConnectedSocket_SetSendBufferSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_SetSendBufferSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TCPConnectedSocket_SetSendBufferSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::SetSendBufferSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);
};

bool TCPConnectedSocket_SetSendBufferSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TCPConnectedSocket.1
  bool success = true;
  int32_t p_net_error{};
  TCPConnectedSocket_SetSendBufferSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void TCPConnectedSocket_SetSendBufferSize_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TCPConnectedSocket::SetSendBufferSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kSetSendBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetSendBufferSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TCPConnectedSocket::SetReceiveBufferSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder> proxy(
        new TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::SetReceiveBufferSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);
};

bool TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TCPConnectedSocket.2
  bool success = true;
  int32_t p_net_error{};
  TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TCPConnectedSocket::SetReceiveBufferSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kSetReceiveBufferSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetReceiveBufferSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPConnectedSocket_SetNoDelay_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TCPConnectedSocket::SetNoDelayCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TCPConnectedSocket_SetNoDelay_ProxyToResponder> proxy(
        new TCPConnectedSocket_SetNoDelay_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TCPConnectedSocket_SetNoDelay_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_SetNoDelay_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TCPConnectedSocket_SetNoDelay_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::SetNoDelayCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool TCPConnectedSocket_SetNoDelay_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_SetNoDelay_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_SetNoDelay_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TCPConnectedSocket.3
  bool success = true;
  bool p_success{};
  TCPConnectedSocket_SetNoDelay_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void TCPConnectedSocket_SetNoDelay_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TCPConnectedSocket::SetNoDelay", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kSetNoDelay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetNoDelay_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetNoDelay");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPConnectedSocket_SetKeepAlive_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TCPConnectedSocket::SetKeepAliveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TCPConnectedSocket_SetKeepAlive_ProxyToResponder> proxy(
        new TCPConnectedSocket_SetKeepAlive_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TCPConnectedSocket_SetKeepAlive_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_SetKeepAlive_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TCPConnectedSocket_SetKeepAlive_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::SetKeepAliveCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool TCPConnectedSocket_SetKeepAlive_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TCPConnectedSocket.4
  bool success = true;
  bool p_success{};
  TCPConnectedSocket_SetKeepAlive_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void TCPConnectedSocket_SetKeepAlive_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TCPConnectedSocket::SetKeepAlive", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPConnectedSocket::kSetKeepAlive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetKeepAlive");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TCPConnectedSocketStubDispatch::Accept(
    TCPConnectedSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TCPConnectedSocket>(message->header()->name)) {
    case messages::TCPConnectedSocket::kUpgradeToTLS: {
      break;
    }
    case messages::TCPConnectedSocket::kSetSendBufferSize: {
      break;
    }
    case messages::TCPConnectedSocket::kSetReceiveBufferSize: {
      break;
    }
    case messages::TCPConnectedSocket::kSetNoDelay: {
      break;
    }
    case messages::TCPConnectedSocket::kSetKeepAlive: {
      break;
    }
  }
  return false;
}

// static
bool TCPConnectedSocketStubDispatch::AcceptWithResponder(
    TCPConnectedSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TCPConnectedSocket>(message->header()->name)) {
    case messages::TCPConnectedSocket::kUpgradeToTLS: {
      internal::TCPConnectedSocket_UpgradeToTLS_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_UpgradeToTLS_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TCPConnectedSocket.0
      bool success = true;
      ::net::HostPortPair p_host_port_pair{};
      ::network::mojom::TLSClientSocketOptionsPtr p_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> p_receiver{};
      ::mojo::PendingRemote<SocketObserver> p_observer{};
      TCPConnectedSocket_UpgradeToTLS_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHostPortPair(&p_host_port_pair))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 0, false);
        return false;
      }
      TCPConnectedSocket::UpgradeToTLSCallback callback =
          TCPConnectedSocket_UpgradeToTLS_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpgradeToTLS(        
        std::move(p_host_port_pair), 
        std::move(p_options), 
        std::move(p_traffic_annotation), 
        std::move(p_receiver), 
        std::move(p_observer), std::move(callback));
      return true;
    }
    case messages::TCPConnectedSocket::kSetSendBufferSize: {
      internal::TCPConnectedSocket_SetSendBufferSize_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_SetSendBufferSize_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TCPConnectedSocket.1
      bool success = true;
      int32_t p_send_buffer_size{};
      TCPConnectedSocket_SetSendBufferSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_send_buffer_size = input_data_view.send_buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 1, false);
        return false;
      }
      TCPConnectedSocket::SetSendBufferSizeCallback callback =
          TCPConnectedSocket_SetSendBufferSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSendBufferSize(        
        std::move(p_send_buffer_size), std::move(callback));
      return true;
    }
    case messages::TCPConnectedSocket::kSetReceiveBufferSize: {
      internal::TCPConnectedSocket_SetReceiveBufferSize_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_SetReceiveBufferSize_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TCPConnectedSocket.2
      bool success = true;
      int32_t p_receive_buffer_size{};
      TCPConnectedSocket_SetReceiveBufferSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_receive_buffer_size = input_data_view.receive_buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 2, false);
        return false;
      }
      TCPConnectedSocket::SetReceiveBufferSizeCallback callback =
          TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReceiveBufferSize(        
        std::move(p_receive_buffer_size), std::move(callback));
      return true;
    }
    case messages::TCPConnectedSocket::kSetNoDelay: {
      internal::TCPConnectedSocket_SetNoDelay_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_SetNoDelay_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TCPConnectedSocket.3
      bool success = true;
      bool p_no_delay{};
      TCPConnectedSocket_SetNoDelay_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_no_delay = input_data_view.no_delay();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 3, false);
        return false;
      }
      TCPConnectedSocket::SetNoDelayCallback callback =
          TCPConnectedSocket_SetNoDelay_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNoDelay(        
        std::move(p_no_delay), std::move(callback));
      return true;
    }
    case messages::TCPConnectedSocket::kSetKeepAlive: {
      internal::TCPConnectedSocket_SetKeepAlive_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_SetKeepAlive_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TCPConnectedSocket.4
      bool success = true;
      bool p_enable{};
      int32_t p_delay_secs{};
      TCPConnectedSocket_SetKeepAlive_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (success)
        p_delay_secs = input_data_view.delay_secs();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 4, false);
        return false;
      }
      TCPConnectedSocket::SetKeepAliveCallback callback =
          TCPConnectedSocket_SetKeepAlive_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetKeepAlive(        
        std::move(p_enable), 
        std::move(p_delay_secs), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTCPConnectedSocketValidationInfo[] = {
    {base::to_underlying(messages::TCPConnectedSocket::kUpgradeToTLS),
     { &internal::TCPConnectedSocket_UpgradeToTLS_Params_Data::Validate,
      &internal::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::TCPConnectedSocket::kSetSendBufferSize),
     { &internal::TCPConnectedSocket_SetSendBufferSize_Params_Data::Validate,
      &internal::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::TCPConnectedSocket::kSetReceiveBufferSize),
     { &internal::TCPConnectedSocket_SetReceiveBufferSize_Params_Data::Validate,
      &internal::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::TCPConnectedSocket::kSetNoDelay),
     { &internal::TCPConnectedSocket_SetNoDelay_Params_Data::Validate,
      &internal::TCPConnectedSocket_SetNoDelay_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::TCPConnectedSocket::kSetKeepAlive),
     { &internal::TCPConnectedSocket_SetKeepAlive_Params_Data::Validate,
      &internal::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data::Validate}},
};

bool TCPConnectedSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPConnectedSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTCPConnectedSocketValidationInfo);
}

bool TCPConnectedSocketResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPConnectedSocket::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTCPConnectedSocketValidationInfo);

}
const char SocketObserver::Name_[] = "network.mojom.SocketObserver";

SocketObserver::IPCStableHashFunction SocketObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SocketObserver>(message.name())) {
    case messages::SocketObserver::kOnReadError: {
      return &SocketObserver::OnReadError_Sym::IPCStableHash;
    }
    case messages::SocketObserver::kOnWriteError: {
      return &SocketObserver::OnWriteError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SocketObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SocketObserver>(message.name())) {
      case messages::SocketObserver::kOnReadError:
            return "Receive network::mojom::SocketObserver::OnReadError";
      case messages::SocketObserver::kOnWriteError:
            return "Receive network::mojom::SocketObserver::OnWriteError";
    }
  } else {
    switch (static_cast<messages::SocketObserver>(message.name())) {
      case messages::SocketObserver::kOnReadError:
            return "Receive reply network::mojom::SocketObserver::OnReadError";
      case messages::SocketObserver::kOnWriteError:
            return "Receive reply network::mojom::SocketObserver::OnWriteError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SocketObserver::OnReadError_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::SocketObserver::OnReadError");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SocketObserver::OnWriteError_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::SocketObserver::OnWriteError");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SocketObserverProxy::SocketObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SocketObserverProxy::OnReadError(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SocketObserver::OnReadError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SocketObserver::kOnReadError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SocketObserver_OnReadError_Params_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SocketObserver::Name_);
  message.set_method_name("OnReadError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SocketObserverProxy::OnWriteError(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SocketObserver::OnWriteError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SocketObserver::kOnWriteError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SocketObserver_OnWriteError_Params_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SocketObserver::Name_);
  message.set_method_name("OnWriteError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SocketObserverStubDispatch::Accept(
    SocketObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SocketObserver>(message->header()->name)) {
    case messages::SocketObserver::kOnReadError: {
      DCHECK(message->is_serialized());
      internal::SocketObserver_OnReadError_Params_Data* params =
          reinterpret_cast<internal::SocketObserver_OnReadError_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SocketObserver.0
      bool success = true;
      int32_t p_net_error{};
      SocketObserver_OnReadError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SocketObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadError(        
        std::move(p_net_error));
      return true;
    }
    case messages::SocketObserver::kOnWriteError: {
      DCHECK(message->is_serialized());
      internal::SocketObserver_OnWriteError_Params_Data* params =
          reinterpret_cast<internal::SocketObserver_OnWriteError_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SocketObserver.1
      bool success = true;
      int32_t p_net_error{};
      SocketObserver_OnWriteError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SocketObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWriteError(        
        std::move(p_net_error));
      return true;
    }
  }
  return false;
}

// static
bool SocketObserverStubDispatch::AcceptWithResponder(
    SocketObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SocketObserver>(message->header()->name)) {
    case messages::SocketObserver::kOnReadError: {
      break;
    }
    case messages::SocketObserver::kOnWriteError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSocketObserverValidationInfo[] = {
    {base::to_underlying(messages::SocketObserver::kOnReadError),
     { &internal::SocketObserver_OnReadError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::SocketObserver::kOnWriteError),
     { &internal::SocketObserver_OnWriteError_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SocketObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::SocketObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSocketObserverValidationInfo);
}

const char TCPServerSocket::Name_[] = "network.mojom.TCPServerSocket";

TCPServerSocket::IPCStableHashFunction TCPServerSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TCPServerSocket>(message.name())) {
    case messages::TCPServerSocket::kAccept: {
      return &TCPServerSocket::Accept_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TCPServerSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TCPServerSocket>(message.name())) {
      case messages::TCPServerSocket::kAccept:
            return "Receive network::mojom::TCPServerSocket::Accept";
    }
  } else {
    switch (static_cast<messages::TCPServerSocket>(message.name())) {
      case messages::TCPServerSocket::kAccept:
            return "Receive reply network::mojom::TCPServerSocket::Accept";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TCPServerSocket::Accept_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TCPServerSocket::Accept");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TCPServerSocket_Accept_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPServerSocket_Accept_ForwardToCallback(
      TCPServerSocket::AcceptCallback callback
      ) : callback_(std::move(callback)) {
  }

  TCPServerSocket_Accept_ForwardToCallback(const TCPServerSocket_Accept_ForwardToCallback&) = delete;
  TCPServerSocket_Accept_ForwardToCallback& operator=(const TCPServerSocket_Accept_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TCPServerSocket::AcceptCallback callback_;
};

TCPServerSocketProxy::TCPServerSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TCPServerSocketProxy::Accept(
    ::mojo::PendingRemote<SocketObserver> in_observer, AcceptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TCPServerSocket::Accept", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<SocketObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPServerSocket::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPServerSocket_Accept_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPServerSocket::Name_);
  message.set_method_name("Accept");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPServerSocket_Accept_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TCPServerSocket_Accept_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TCPServerSocket::AcceptCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TCPServerSocket_Accept_ProxyToResponder> proxy(
        new TCPServerSocket_Accept_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TCPServerSocket_Accept_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPServerSocket_Accept_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TCPServerSocket_Accept_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPServerSocket::AcceptCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, const std::optional<::net::IPEndPoint>& in_remote_addr, ::mojo::PendingRemote<TCPConnectedSocket> in_connected_socket, ::mojo::ScopedDataPipeConsumerHandle in_send_stream, ::mojo::ScopedDataPipeProducerHandle in_receive_stream);
};

bool TCPServerSocket_Accept_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TCPServerSocket_Accept_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPServerSocket_Accept_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TCPServerSocket.0
  bool success = true;
  int32_t p_net_error{};
  std::optional<::net::IPEndPoint> p_remote_addr{};
  ::mojo::PendingRemote<TCPConnectedSocket> p_connected_socket{};
  ::mojo::ScopedDataPipeConsumerHandle p_send_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_receive_stream{};
  TCPServerSocket_Accept_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadRemoteAddr(&p_remote_addr))
    success = false;
  if (success) {
    p_connected_socket =
        input_data_view.TakeConnectedSocket<decltype(p_connected_socket)>();
  }
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPServerSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_remote_addr), 
std::move(p_connected_socket), 
std::move(p_send_stream), 
std::move(p_receive_stream));
  return true;
}

void TCPServerSocket_Accept_ProxyToResponder::Run(
    int32_t in_net_error, const std::optional<::net::IPEndPoint>& in_remote_addr, ::mojo::PendingRemote<TCPConnectedSocket> in_connected_socket, ::mojo::ScopedDataPipeConsumerHandle in_send_stream, ::mojo::ScopedDataPipeProducerHandle in_receive_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TCPServerSocket::Accept", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_addr"), in_remote_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connected_socket"), in_connected_socket,
                        "<value of type ::mojo::PendingRemote<TCPConnectedSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TCPServerSocket::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPServerSocket_Accept_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->remote_addr)::BaseType> remote_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_addr, remote_addr_fragment);
  params->remote_addr.Set(
      remote_addr_fragment.is_null() ? nullptr : remote_addr_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TCPConnectedSocketInterfaceBase>>(
      in_connected_socket, &params->connected_socket, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_send_stream, &params->send_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPServerSocket::Name_);
  message.set_method_name("Accept");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TCPServerSocketStubDispatch::Accept(
    TCPServerSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TCPServerSocket>(message->header()->name)) {
    case messages::TCPServerSocket::kAccept: {
      break;
    }
  }
  return false;
}

// static
bool TCPServerSocketStubDispatch::AcceptWithResponder(
    TCPServerSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TCPServerSocket>(message->header()->name)) {
    case messages::TCPServerSocket::kAccept: {
      internal::TCPServerSocket_Accept_Params_Data* params =
          reinterpret_cast<
              internal::TCPServerSocket_Accept_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TCPServerSocket.0
      bool success = true;
      ::mojo::PendingRemote<SocketObserver> p_observer{};
      TCPServerSocket_Accept_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPServerSocket::Name_, 0, false);
        return false;
      }
      TCPServerSocket::AcceptCallback callback =
          TCPServerSocket_Accept_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(        
        std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTCPServerSocketValidationInfo[] = {
    {base::to_underlying(messages::TCPServerSocket::kAccept),
     { &internal::TCPServerSocket_Accept_Params_Data::Validate,
      &internal::TCPServerSocket_Accept_ResponseParams_Data::Validate}},
};

bool TCPServerSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPServerSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTCPServerSocketValidationInfo);
}

bool TCPServerSocketResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPServerSocket::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTCPServerSocketValidationInfo);

}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::TCPKeepAliveOptions::DataView, ::network::mojom::TCPKeepAliveOptionsPtr>::Read(
    ::network::mojom::TCPKeepAliveOptions::DataView input,
    ::network::mojom::TCPKeepAliveOptionsPtr* output) {
  bool success = true;
  ::network::mojom::TCPKeepAliveOptionsPtr result(::network::mojom::TCPKeepAliveOptions::New());
  
      if (success)
        result->enable = input.enable();
      if (success)
        result->delay = input.delay();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TCPConnectedSocketOptions::DataView, ::network::mojom::TCPConnectedSocketOptionsPtr>::Read(
    ::network::mojom::TCPConnectedSocketOptions::DataView input,
    ::network::mojom::TCPConnectedSocketOptionsPtr* output) {
  bool success = true;
  ::network::mojom::TCPConnectedSocketOptionsPtr result(::network::mojom::TCPConnectedSocketOptions::New());
  
      if (success)
        result->send_buffer_size = input.send_buffer_size();
      if (success)
        result->receive_buffer_size = input.receive_buffer_size();
      if (success)
        result->no_delay = input.no_delay();
      if (success && !input.ReadKeepAliveOptions(&result->keep_alive_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TCPServerSocketOptions::DataView, ::network::mojom::TCPServerSocketOptionsPtr>::Read(
    ::network::mojom::TCPServerSocketOptions::DataView input,
    ::network::mojom::TCPServerSocketOptionsPtr* output) {
  bool success = true;
  ::network::mojom::TCPServerSocketOptionsPtr result(::network::mojom::TCPServerSocketOptions::New());
  
      if (success)
        result->backlog = input.backlog();
      if (success && !input.ReadIpv6Only(&result->ipv6_only))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void TCPBoundSocketInterceptorForTesting::Listen(uint32_t backlog, ::mojo::PendingReceiver<TCPServerSocket> socket, ListenCallback callback) {
  GetForwardingInterface()->Listen(
    std::move(backlog)
    , 
    std::move(socket)
    , std::move(callback));
}
void TCPBoundSocketInterceptorForTesting::Connect(const ::net::AddressList& remote_addr_list, TCPConnectedSocketOptionsPtr tcp_connected_socket_options, ::mojo::PendingReceiver<TCPConnectedSocket> socket, ::mojo::PendingRemote<SocketObserver> observer, ConnectCallback callback) {
  GetForwardingInterface()->Connect(
    std::move(remote_addr_list)
    , 
    std::move(tcp_connected_socket_options)
    , 
    std::move(socket)
    , 
    std::move(observer)
    , std::move(callback));
}
TCPBoundSocketAsyncWaiter::TCPBoundSocketAsyncWaiter(
    TCPBoundSocket* proxy) : proxy_(proxy) {}

TCPBoundSocketAsyncWaiter::~TCPBoundSocketAsyncWaiter() = default;

void TCPBoundSocketAsyncWaiter::Listen(
    uint32_t backlog, ::mojo::PendingReceiver<TCPServerSocket> socket, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->Listen(
      std::move(backlog),
      std::move(socket),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             int32_t net_error) {*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_net_error));
  loop.Run();
}

int32_t TCPBoundSocketAsyncWaiter::Listen(
    uint32_t backlog, ::mojo::PendingReceiver<TCPServerSocket> socket) {
  int32_t async_wait_result;
  Listen(std::move(backlog),std::move(socket),&async_wait_result);
  return async_wait_result;
}

void TCPBoundSocketAsyncWaiter::Connect(
    const ::net::AddressList& remote_addr_list, TCPConnectedSocketOptionsPtr tcp_connected_socket_options, ::mojo::PendingReceiver<TCPConnectedSocket> socket, ::mojo::PendingRemote<SocketObserver> observer, int32_t* out_net_error, std::optional<::net::IPEndPoint>* out_local_addr, std::optional<::net::IPEndPoint>* out_peer_addr, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream) {
  base::RunLoop loop;
  proxy_->Connect(
      std::move(remote_addr_list),
      std::move(tcp_connected_socket_options),
      std::move(socket),
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             std::optional<::net::IPEndPoint>* out_local_addr
,
             std::optional<::net::IPEndPoint>* out_peer_addr
,
             ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream
,
             ::mojo::ScopedDataPipeProducerHandle* out_send_stream
,
             int32_t net_error,
             const std::optional<::net::IPEndPoint>& local_addr,
             const std::optional<::net::IPEndPoint>& peer_addr,
             ::mojo::ScopedDataPipeConsumerHandle receive_stream,
             ::mojo::ScopedDataPipeProducerHandle send_stream) {*out_net_error = std::move(net_error);*out_local_addr = std::move(local_addr);*out_peer_addr = std::move(peer_addr);*out_receive_stream = std::move(receive_stream);*out_send_stream = std::move(send_stream);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_local_addr,
          out_peer_addr,
          out_receive_stream,
          out_send_stream));
  loop.Run();
}






void TCPConnectedSocketInterceptorForTesting::UpgradeToTLS(const ::net::HostPortPair& host_port_pair, ::network::mojom::TLSClientSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> receiver, ::mojo::PendingRemote<SocketObserver> observer, UpgradeToTLSCallback callback) {
  GetForwardingInterface()->UpgradeToTLS(
    std::move(host_port_pair)
    , 
    std::move(options)
    , 
    std::move(traffic_annotation)
    , 
    std::move(receiver)
    , 
    std::move(observer)
    , std::move(callback));
}
void TCPConnectedSocketInterceptorForTesting::SetSendBufferSize(int32_t send_buffer_size, SetSendBufferSizeCallback callback) {
  GetForwardingInterface()->SetSendBufferSize(
    std::move(send_buffer_size)
    , std::move(callback));
}
void TCPConnectedSocketInterceptorForTesting::SetReceiveBufferSize(int32_t receive_buffer_size, SetReceiveBufferSizeCallback callback) {
  GetForwardingInterface()->SetReceiveBufferSize(
    std::move(receive_buffer_size)
    , std::move(callback));
}
void TCPConnectedSocketInterceptorForTesting::SetNoDelay(bool no_delay, SetNoDelayCallback callback) {
  GetForwardingInterface()->SetNoDelay(
    std::move(no_delay)
    , std::move(callback));
}
void TCPConnectedSocketInterceptorForTesting::SetKeepAlive(bool enable, int32_t delay_secs, SetKeepAliveCallback callback) {
  GetForwardingInterface()->SetKeepAlive(
    std::move(enable)
    , 
    std::move(delay_secs)
    , std::move(callback));
}
TCPConnectedSocketAsyncWaiter::TCPConnectedSocketAsyncWaiter(
    TCPConnectedSocket* proxy) : proxy_(proxy) {}

TCPConnectedSocketAsyncWaiter::~TCPConnectedSocketAsyncWaiter() = default;

void TCPConnectedSocketAsyncWaiter::UpgradeToTLS(
    const ::net::HostPortPair& host_port_pair, ::network::mojom::TLSClientSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> receiver, ::mojo::PendingRemote<SocketObserver> observer, int32_t* out_net_error, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream, std::optional<::net::SSLInfo>* out_ssl_info) {
  base::RunLoop loop;
  proxy_->UpgradeToTLS(
      std::move(host_port_pair),
      std::move(options),
      std::move(traffic_annotation),
      std::move(receiver),
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream
,
             ::mojo::ScopedDataPipeProducerHandle* out_send_stream
,
             std::optional<::net::SSLInfo>* out_ssl_info
,
             int32_t net_error,
             ::mojo::ScopedDataPipeConsumerHandle receive_stream,
             ::mojo::ScopedDataPipeProducerHandle send_stream,
             const std::optional<::net::SSLInfo>& ssl_info) {*out_net_error = std::move(net_error);*out_receive_stream = std::move(receive_stream);*out_send_stream = std::move(send_stream);*out_ssl_info = std::move(ssl_info);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_receive_stream,
          out_send_stream,
          out_ssl_info));
  loop.Run();
}



void TCPConnectedSocketAsyncWaiter::SetSendBufferSize(
    int32_t send_buffer_size, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->SetSendBufferSize(
      std::move(send_buffer_size),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             int32_t net_error) {*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_net_error));
  loop.Run();
}

int32_t TCPConnectedSocketAsyncWaiter::SetSendBufferSize(
    int32_t send_buffer_size) {
  int32_t async_wait_result;
  SetSendBufferSize(std::move(send_buffer_size),&async_wait_result);
  return async_wait_result;
}

void TCPConnectedSocketAsyncWaiter::SetReceiveBufferSize(
    int32_t receive_buffer_size, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->SetReceiveBufferSize(
      std::move(receive_buffer_size),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             int32_t net_error) {*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_net_error));
  loop.Run();
}

int32_t TCPConnectedSocketAsyncWaiter::SetReceiveBufferSize(
    int32_t receive_buffer_size) {
  int32_t async_wait_result;
  SetReceiveBufferSize(std::move(receive_buffer_size),&async_wait_result);
  return async_wait_result;
}

void TCPConnectedSocketAsyncWaiter::SetNoDelay(
    bool no_delay, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNoDelay(
      std::move(no_delay),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool TCPConnectedSocketAsyncWaiter::SetNoDelay(
    bool no_delay) {
  bool async_wait_result;
  SetNoDelay(std::move(no_delay),&async_wait_result);
  return async_wait_result;
}

void TCPConnectedSocketAsyncWaiter::SetKeepAlive(
    bool enable, int32_t delay_secs, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetKeepAlive(
      std::move(enable),
      std::move(delay_secs),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool TCPConnectedSocketAsyncWaiter::SetKeepAlive(
    bool enable, int32_t delay_secs) {
  bool async_wait_result;
  SetKeepAlive(std::move(enable),std::move(delay_secs),&async_wait_result);
  return async_wait_result;
}




void SocketObserverInterceptorForTesting::OnReadError(int32_t net_error) {
  GetForwardingInterface()->OnReadError(
    std::move(net_error)
    );
}
void SocketObserverInterceptorForTesting::OnWriteError(int32_t net_error) {
  GetForwardingInterface()->OnWriteError(
    std::move(net_error)
    );
}
SocketObserverAsyncWaiter::SocketObserverAsyncWaiter(
    SocketObserver* proxy) : proxy_(proxy) {}

SocketObserverAsyncWaiter::~SocketObserverAsyncWaiter() = default;




void TCPServerSocketInterceptorForTesting::Accept(::mojo::PendingRemote<SocketObserver> observer, AcceptCallback callback) {
  GetForwardingInterface()->Accept(
    std::move(observer)
    , std::move(callback));
}
TCPServerSocketAsyncWaiter::TCPServerSocketAsyncWaiter(
    TCPServerSocket* proxy) : proxy_(proxy) {}

TCPServerSocketAsyncWaiter::~TCPServerSocketAsyncWaiter() = default;

void TCPServerSocketAsyncWaiter::Accept(
    ::mojo::PendingRemote<SocketObserver> observer, int32_t* out_net_error, std::optional<::net::IPEndPoint>* out_remote_addr, ::mojo::PendingRemote<TCPConnectedSocket>* out_connected_socket, ::mojo::ScopedDataPipeConsumerHandle* out_send_stream, ::mojo::ScopedDataPipeProducerHandle* out_receive_stream) {
  base::RunLoop loop;
  proxy_->Accept(
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             std::optional<::net::IPEndPoint>* out_remote_addr
,
             ::mojo::PendingRemote<TCPConnectedSocket>* out_connected_socket
,
             ::mojo::ScopedDataPipeConsumerHandle* out_send_stream
,
             ::mojo::ScopedDataPipeProducerHandle* out_receive_stream
,
             int32_t net_error,
             const std::optional<::net::IPEndPoint>& remote_addr,
             ::mojo::PendingRemote<TCPConnectedSocket> connected_socket,
             ::mojo::ScopedDataPipeConsumerHandle send_stream,
             ::mojo::ScopedDataPipeProducerHandle receive_stream) {*out_net_error = std::move(net_error);*out_remote_addr = std::move(remote_addr);*out_connected_socket = std::move(connected_socket);*out_send_stream = std::move(send_stream);*out_receive_stream = std::move(receive_stream);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_remote_addr,
          out_connected_socket,
          out_send_stream,
          out_receive_stream));
  loop.Run();
}








}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif