// services/video_capture/public/mojom/video_source.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/video_source.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/video_source.mojom-params-data.h"
#include "services/video_capture/public/mojom/video_source.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/video_source.mojom-import-headers.h"
#include "services/video_capture/public/mojom/video_source.mojom-test-utils.h"


namespace video_capture::mojom {
CreatePushSubscriptionResultCode::CreatePushSubscriptionResultCode() : tag_(Tag::kSuccessCode) {
  data_.success_code = CreatePushSubscriptionSuccessCode();
}

CreatePushSubscriptionResultCode::~CreatePushSubscriptionResultCode() {
  DestroyActive();
}


void CreatePushSubscriptionResultCode::set_success_code(
    CreatePushSubscriptionSuccessCode success_code) {
  if (tag_ != Tag::kSuccessCode) {
    DestroyActive();
    tag_ = Tag::kSuccessCode;
  }
  data_.success_code = success_code;
}
void CreatePushSubscriptionResultCode::set_error_code(
    ::media::VideoCaptureError error_code) {
  if (tag_ != Tag::kErrorCode) {
    DestroyActive();
    tag_ = Tag::kErrorCode;
  }
  data_.error_code = error_code;
}

void CreatePushSubscriptionResultCode::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccessCode:

      break;
    case Tag::kErrorCode:

      break;
  }
}

bool CreatePushSubscriptionResultCode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char PushVideoStreamSubscription::Name_[] = "video_capture.mojom.PushVideoStreamSubscription";

PushVideoStreamSubscription::IPCStableHashFunction PushVideoStreamSubscription::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PushVideoStreamSubscription>(message.name())) {
    case messages::PushVideoStreamSubscription::kActivate: {
      return &PushVideoStreamSubscription::Activate_Sym::IPCStableHash;
    }
    case messages::PushVideoStreamSubscription::kSuspend: {
      return &PushVideoStreamSubscription::Suspend_Sym::IPCStableHash;
    }
    case messages::PushVideoStreamSubscription::kResume: {
      return &PushVideoStreamSubscription::Resume_Sym::IPCStableHash;
    }
    case messages::PushVideoStreamSubscription::kGetPhotoState: {
      return &PushVideoStreamSubscription::GetPhotoState_Sym::IPCStableHash;
    }
    case messages::PushVideoStreamSubscription::kSetPhotoOptions: {
      return &PushVideoStreamSubscription::SetPhotoOptions_Sym::IPCStableHash;
    }
    case messages::PushVideoStreamSubscription::kTakePhoto: {
      return &PushVideoStreamSubscription::TakePhoto_Sym::IPCStableHash;
    }
    case messages::PushVideoStreamSubscription::kClose: {
      return &PushVideoStreamSubscription::Close_Sym::IPCStableHash;
    }
    case messages::PushVideoStreamSubscription::kProcessFeedback: {
      return &PushVideoStreamSubscription::ProcessFeedback_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PushVideoStreamSubscription::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PushVideoStreamSubscription>(message.name())) {
      case messages::PushVideoStreamSubscription::kActivate:
            return "Receive video_capture::mojom::PushVideoStreamSubscription::Activate";
      case messages::PushVideoStreamSubscription::kSuspend:
            return "Receive video_capture::mojom::PushVideoStreamSubscription::Suspend";
      case messages::PushVideoStreamSubscription::kResume:
            return "Receive video_capture::mojom::PushVideoStreamSubscription::Resume";
      case messages::PushVideoStreamSubscription::kGetPhotoState:
            return "Receive video_capture::mojom::PushVideoStreamSubscription::GetPhotoState";
      case messages::PushVideoStreamSubscription::kSetPhotoOptions:
            return "Receive video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptions";
      case messages::PushVideoStreamSubscription::kTakePhoto:
            return "Receive video_capture::mojom::PushVideoStreamSubscription::TakePhoto";
      case messages::PushVideoStreamSubscription::kClose:
            return "Receive video_capture::mojom::PushVideoStreamSubscription::Close";
      case messages::PushVideoStreamSubscription::kProcessFeedback:
            return "Receive video_capture::mojom::PushVideoStreamSubscription::ProcessFeedback";
    }
  } else {
    switch (static_cast<messages::PushVideoStreamSubscription>(message.name())) {
      case messages::PushVideoStreamSubscription::kActivate:
            return "Receive reply video_capture::mojom::PushVideoStreamSubscription::Activate";
      case messages::PushVideoStreamSubscription::kSuspend:
            return "Receive reply video_capture::mojom::PushVideoStreamSubscription::Suspend";
      case messages::PushVideoStreamSubscription::kResume:
            return "Receive reply video_capture::mojom::PushVideoStreamSubscription::Resume";
      case messages::PushVideoStreamSubscription::kGetPhotoState:
            return "Receive reply video_capture::mojom::PushVideoStreamSubscription::GetPhotoState";
      case messages::PushVideoStreamSubscription::kSetPhotoOptions:
            return "Receive reply video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptions";
      case messages::PushVideoStreamSubscription::kTakePhoto:
            return "Receive reply video_capture::mojom::PushVideoStreamSubscription::TakePhoto";
      case messages::PushVideoStreamSubscription::kClose:
            return "Receive reply video_capture::mojom::PushVideoStreamSubscription::Close";
      case messages::PushVideoStreamSubscription::kProcessFeedback:
            return "Receive reply video_capture::mojom::PushVideoStreamSubscription::ProcessFeedback";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PushVideoStreamSubscription::Activate_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::Activate");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushVideoStreamSubscription::Suspend_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::Suspend");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushVideoStreamSubscription::Resume_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::Resume");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushVideoStreamSubscription::GetPhotoState_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::GetPhotoState");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushVideoStreamSubscription::SetPhotoOptions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushVideoStreamSubscription::TakePhoto_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::TakePhoto");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushVideoStreamSubscription::Close_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::Close");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushVideoStreamSubscription::ProcessFeedback_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::ProcessFeedback");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PushVideoStreamSubscription_Suspend_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_Suspend_ForwardToCallback(
      PushVideoStreamSubscription::SuspendCallback callback
      ) : callback_(std::move(callback)) {
  }

  PushVideoStreamSubscription_Suspend_ForwardToCallback(const PushVideoStreamSubscription_Suspend_ForwardToCallback&) = delete;
  PushVideoStreamSubscription_Suspend_ForwardToCallback& operator=(const PushVideoStreamSubscription_Suspend_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::SuspendCallback callback_;
};

class PushVideoStreamSubscription_GetPhotoState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_GetPhotoState_ForwardToCallback(
      PushVideoStreamSubscription::GetPhotoStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PushVideoStreamSubscription_GetPhotoState_ForwardToCallback(const PushVideoStreamSubscription_GetPhotoState_ForwardToCallback&) = delete;
  PushVideoStreamSubscription_GetPhotoState_ForwardToCallback& operator=(const PushVideoStreamSubscription_GetPhotoState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::GetPhotoStateCallback callback_;
};

class PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback(
      PushVideoStreamSubscription::SetPhotoOptionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback(const PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback&) = delete;
  PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback& operator=(const PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::SetPhotoOptionsCallback callback_;
};

class PushVideoStreamSubscription_TakePhoto_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_TakePhoto_ForwardToCallback(
      PushVideoStreamSubscription::TakePhotoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PushVideoStreamSubscription_TakePhoto_ForwardToCallback(const PushVideoStreamSubscription_TakePhoto_ForwardToCallback&) = delete;
  PushVideoStreamSubscription_TakePhoto_ForwardToCallback& operator=(const PushVideoStreamSubscription_TakePhoto_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::TakePhotoCallback callback_;
};

class PushVideoStreamSubscription_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_Close_ForwardToCallback(
      PushVideoStreamSubscription::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  PushVideoStreamSubscription_Close_ForwardToCallback(const PushVideoStreamSubscription_Close_ForwardToCallback&) = delete;
  PushVideoStreamSubscription_Close_ForwardToCallback& operator=(const PushVideoStreamSubscription_Close_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::CloseCallback callback_;
};

PushVideoStreamSubscriptionProxy::PushVideoStreamSubscriptionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PushVideoStreamSubscriptionProxy::Activate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::PushVideoStreamSubscription::Activate");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kActivate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_Activate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Activate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PushVideoStreamSubscriptionProxy::Suspend(
    SuspendCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::PushVideoStreamSubscription::Suspend");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_Suspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Suspend");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_Suspend_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PushVideoStreamSubscriptionProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::PushVideoStreamSubscription::Resume");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_Resume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PushVideoStreamSubscriptionProxy::GetPhotoState(
    GetPhotoStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::PushVideoStreamSubscription::GetPhotoState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kGetPhotoState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_GetPhotoState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("GetPhotoState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_GetPhotoState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PushVideoStreamSubscriptionProxy::SetPhotoOptions(
    ::media::mojom::PhotoSettingsPtr in_settings, SetPhotoOptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type ::media::mojom::PhotoSettingsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kSetPhotoOptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType> settings_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PhotoSettingsDataView>(
      in_settings, settings_fragment);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in PushVideoStreamSubscription.SetPhotoOptions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("SetPhotoOptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PushVideoStreamSubscriptionProxy::TakePhoto(
    TakePhotoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::PushVideoStreamSubscription::TakePhoto");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kTakePhoto), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_TakePhoto_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("TakePhoto");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_TakePhoto_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PushVideoStreamSubscriptionProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::PushVideoStreamSubscription::Close");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_Close_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PushVideoStreamSubscriptionProxy::ProcessFeedback(
    const ::media::VideoCaptureFeedback& in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::PushVideoStreamSubscription::ProcessFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type const ::media::VideoCaptureFeedback&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kProcessFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_ProcessFeedback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->feedback)::BaseType> feedback_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureFeedbackDataView>(
      in_feedback, feedback_fragment);
  params->feedback.Set(
      feedback_fragment.is_null() ? nullptr : feedback_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->feedback.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feedback in PushVideoStreamSubscription.ProcessFeedback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("ProcessFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PushVideoStreamSubscription_Suspend_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PushVideoStreamSubscription::SuspendCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PushVideoStreamSubscription_Suspend_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_Suspend_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PushVideoStreamSubscription_Suspend_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_Suspend_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PushVideoStreamSubscription_Suspend_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::SuspendCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PushVideoStreamSubscription_Suspend_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PushVideoStreamSubscription.1
  bool success = true;
  PushVideoStreamSubscription_Suspend_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PushVideoStreamSubscription_Suspend_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply video_capture::mojom::PushVideoStreamSubscription::Suspend");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Suspend");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushVideoStreamSubscription_GetPhotoState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PushVideoStreamSubscription::GetPhotoStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PushVideoStreamSubscription_GetPhotoState_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_GetPhotoState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PushVideoStreamSubscription_GetPhotoState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_GetPhotoState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PushVideoStreamSubscription_GetPhotoState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::GetPhotoStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::PhotoStatePtr in_capabilities);
};

bool PushVideoStreamSubscription_GetPhotoState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PushVideoStreamSubscription.3
  bool success = true;
  ::media::mojom::PhotoStatePtr p_capabilities{};
  PushVideoStreamSubscription_GetPhotoState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCapabilities(&p_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_capabilities));
  return true;
}

void PushVideoStreamSubscription_GetPhotoState_ProxyToResponder::Run(
    ::media::mojom::PhotoStatePtr in_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply video_capture::mojom::PushVideoStreamSubscription::GetPhotoState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilities"), in_capabilities,
                        "<value of type ::media::mojom::PhotoStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kGetPhotoState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->capabilities)::BaseType> capabilities_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PhotoStateDataView>(
      in_capabilities, capabilities_fragment);
  params->capabilities.Set(
      capabilities_fragment.is_null() ? nullptr : capabilities_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("GetPhotoState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PushVideoStreamSubscription::SetPhotoOptionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::SetPhotoOptionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PushVideoStreamSubscription.4
  bool success = true;
  bool p_success{};
  PushVideoStreamSubscription_SetPhotoOptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kSetPhotoOptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("SetPhotoOptions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushVideoStreamSubscription_TakePhoto_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PushVideoStreamSubscription::TakePhotoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PushVideoStreamSubscription_TakePhoto_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_TakePhoto_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PushVideoStreamSubscription_TakePhoto_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_TakePhoto_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PushVideoStreamSubscription_TakePhoto_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::TakePhotoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::BlobPtr in_blob);
};

bool PushVideoStreamSubscription_TakePhoto_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PushVideoStreamSubscription.5
  bool success = true;
  ::media::mojom::BlobPtr p_blob{};
  PushVideoStreamSubscription_TakePhoto_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_blob));
  return true;
}

void PushVideoStreamSubscription_TakePhoto_ProxyToResponder::Run(
    ::media::mojom::BlobPtr in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply video_capture::mojom::PushVideoStreamSubscription::TakePhoto", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::media::mojom::BlobPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kTakePhoto), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType> blob_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::BlobDataView>(
      in_blob, blob_fragment);
  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("TakePhoto");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushVideoStreamSubscription_Close_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PushVideoStreamSubscription::CloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PushVideoStreamSubscription_Close_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_Close_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PushVideoStreamSubscription_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PushVideoStreamSubscription_Close_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PushVideoStreamSubscription_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_Close_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PushVideoStreamSubscription.6
  bool success = true;
  PushVideoStreamSubscription_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PushVideoStreamSubscription_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply video_capture::mojom::PushVideoStreamSubscription::Close");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushVideoStreamSubscription::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::PushVideoStreamSubscription_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PushVideoStreamSubscriptionStubDispatch::Accept(
    PushVideoStreamSubscription* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PushVideoStreamSubscription>(message->header()->name)) {
    case messages::PushVideoStreamSubscription::kActivate: {
      DCHECK(message->is_serialized());
      internal::PushVideoStreamSubscription_Activate_Params_Data* params =
          reinterpret_cast<internal::PushVideoStreamSubscription_Activate_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PushVideoStreamSubscription.0
      bool success = true;
      PushVideoStreamSubscription_Activate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Activate(        );
      return true;
    }
    case messages::PushVideoStreamSubscription::kSuspend: {
      break;
    }
    case messages::PushVideoStreamSubscription::kResume: {
      DCHECK(message->is_serialized());
      internal::PushVideoStreamSubscription_Resume_Params_Data* params =
          reinterpret_cast<internal::PushVideoStreamSubscription_Resume_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PushVideoStreamSubscription.2
      bool success = true;
      PushVideoStreamSubscription_Resume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(        );
      return true;
    }
    case messages::PushVideoStreamSubscription::kGetPhotoState: {
      break;
    }
    case messages::PushVideoStreamSubscription::kSetPhotoOptions: {
      break;
    }
    case messages::PushVideoStreamSubscription::kTakePhoto: {
      break;
    }
    case messages::PushVideoStreamSubscription::kClose: {
      break;
    }
    case messages::PushVideoStreamSubscription::kProcessFeedback: {
      DCHECK(message->is_serialized());
      internal::PushVideoStreamSubscription_ProcessFeedback_Params_Data* params =
          reinterpret_cast<internal::PushVideoStreamSubscription_ProcessFeedback_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PushVideoStreamSubscription.7
      bool success = true;
      ::media::VideoCaptureFeedback p_feedback{};
      PushVideoStreamSubscription_ProcessFeedback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProcessFeedback(        
        std::move(p_feedback));
      return true;
    }
  }
  return false;
}

// static
bool PushVideoStreamSubscriptionStubDispatch::AcceptWithResponder(
    PushVideoStreamSubscription* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PushVideoStreamSubscription>(message->header()->name)) {
    case messages::PushVideoStreamSubscription::kActivate: {
      break;
    }
    case messages::PushVideoStreamSubscription::kSuspend: {
      internal::PushVideoStreamSubscription_Suspend_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_Suspend_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PushVideoStreamSubscription.1
      bool success = true;
      PushVideoStreamSubscription_Suspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 1, false);
        return false;
      }
      PushVideoStreamSubscription::SuspendCallback callback =
          PushVideoStreamSubscription_Suspend_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Suspend(std::move(callback));
      return true;
    }
    case messages::PushVideoStreamSubscription::kResume: {
      break;
    }
    case messages::PushVideoStreamSubscription::kGetPhotoState: {
      internal::PushVideoStreamSubscription_GetPhotoState_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_GetPhotoState_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PushVideoStreamSubscription.3
      bool success = true;
      PushVideoStreamSubscription_GetPhotoState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 3, false);
        return false;
      }
      PushVideoStreamSubscription::GetPhotoStateCallback callback =
          PushVideoStreamSubscription_GetPhotoState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPhotoState(std::move(callback));
      return true;
    }
    case messages::PushVideoStreamSubscription::kSetPhotoOptions: {
      internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PushVideoStreamSubscription.4
      bool success = true;
      ::media::mojom::PhotoSettingsPtr p_settings{};
      PushVideoStreamSubscription_SetPhotoOptions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 4, false);
        return false;
      }
      PushVideoStreamSubscription::SetPhotoOptionsCallback callback =
          PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPhotoOptions(        
        std::move(p_settings), std::move(callback));
      return true;
    }
    case messages::PushVideoStreamSubscription::kTakePhoto: {
      internal::PushVideoStreamSubscription_TakePhoto_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_TakePhoto_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PushVideoStreamSubscription.5
      bool success = true;
      PushVideoStreamSubscription_TakePhoto_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 5, false);
        return false;
      }
      PushVideoStreamSubscription::TakePhotoCallback callback =
          PushVideoStreamSubscription_TakePhoto_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakePhoto(std::move(callback));
      return true;
    }
    case messages::PushVideoStreamSubscription::kClose: {
      internal::PushVideoStreamSubscription_Close_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_Close_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PushVideoStreamSubscription.6
      bool success = true;
      PushVideoStreamSubscription_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 6, false);
        return false;
      }
      PushVideoStreamSubscription::CloseCallback callback =
          PushVideoStreamSubscription_Close_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
    case messages::PushVideoStreamSubscription::kProcessFeedback: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPushVideoStreamSubscriptionValidationInfo[] = {
    {base::to_underlying(messages::PushVideoStreamSubscription::kActivate),
     { &internal::PushVideoStreamSubscription_Activate_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PushVideoStreamSubscription::kSuspend),
     { &internal::PushVideoStreamSubscription_Suspend_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PushVideoStreamSubscription::kResume),
     { &internal::PushVideoStreamSubscription_Resume_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PushVideoStreamSubscription::kGetPhotoState),
     { &internal::PushVideoStreamSubscription_GetPhotoState_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PushVideoStreamSubscription::kSetPhotoOptions),
     { &internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PushVideoStreamSubscription::kTakePhoto),
     { &internal::PushVideoStreamSubscription_TakePhoto_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PushVideoStreamSubscription::kClose),
     { &internal::PushVideoStreamSubscription_Close_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_Close_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PushVideoStreamSubscription::kProcessFeedback),
     { &internal::PushVideoStreamSubscription_ProcessFeedback_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PushVideoStreamSubscriptionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::PushVideoStreamSubscription::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPushVideoStreamSubscriptionValidationInfo);
}

bool PushVideoStreamSubscriptionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::PushVideoStreamSubscription::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPushVideoStreamSubscriptionValidationInfo);

}
const char VideoSource::Name_[] = "video_capture.mojom.VideoSource";

VideoSource::IPCStableHashFunction VideoSource::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoSource>(message.name())) {
    case messages::VideoSource::kCreatePushSubscription: {
      return &VideoSource::CreatePushSubscription_Sym::IPCStableHash;
    }
    case messages::VideoSource::kRegisterVideoEffectsProcessor: {
      return &VideoSource::RegisterVideoEffectsProcessor_Sym::IPCStableHash;
    }
    case messages::VideoSource::kRegisterReadonlyVideoEffectsManager: {
      return &VideoSource::RegisterReadonlyVideoEffectsManager_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoSource::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoSource>(message.name())) {
      case messages::VideoSource::kCreatePushSubscription:
            return "Receive video_capture::mojom::VideoSource::CreatePushSubscription";
      case messages::VideoSource::kRegisterVideoEffectsProcessor:
            return "Receive video_capture::mojom::VideoSource::RegisterVideoEffectsProcessor";
      case messages::VideoSource::kRegisterReadonlyVideoEffectsManager:
            return "Receive video_capture::mojom::VideoSource::RegisterReadonlyVideoEffectsManager";
    }
  } else {
    switch (static_cast<messages::VideoSource>(message.name())) {
      case messages::VideoSource::kCreatePushSubscription:
            return "Receive reply video_capture::mojom::VideoSource::CreatePushSubscription";
      case messages::VideoSource::kRegisterVideoEffectsProcessor:
            return "Receive reply video_capture::mojom::VideoSource::RegisterVideoEffectsProcessor";
      case messages::VideoSource::kRegisterReadonlyVideoEffectsManager:
            return "Receive reply video_capture::mojom::VideoSource::RegisterReadonlyVideoEffectsManager";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoSource::CreatePushSubscription_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::VideoSource::CreatePushSubscription");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoSource::RegisterVideoEffectsProcessor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::VideoSource::RegisterVideoEffectsProcessor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoSource::RegisterReadonlyVideoEffectsManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_capture::mojom::VideoSource::RegisterReadonlyVideoEffectsManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class VideoSource_CreatePushSubscription_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoSource_CreatePushSubscription_ForwardToCallback(
      VideoSource::CreatePushSubscriptionCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoSource_CreatePushSubscription_ForwardToCallback(const VideoSource_CreatePushSubscription_ForwardToCallback&) = delete;
  VideoSource_CreatePushSubscription_ForwardToCallback& operator=(const VideoSource_CreatePushSubscription_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoSource::CreatePushSubscriptionCallback callback_;
};

VideoSourceProxy::VideoSourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoSourceProxy::CreatePushSubscription(
    ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> in_subscriber, const ::media::VideoCaptureParams& in_requested_settings, bool in_force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> in_subscription, CreatePushSubscriptionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoSource::CreatePushSubscription", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscriber"), in_subscriber,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_settings"), in_requested_settings,
                        "<value of type const ::media::VideoCaptureParams&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force_reopen_with_new_settings"), in_force_reopen_with_new_settings,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription"), in_subscription,
                        "<value of type ::mojo::PendingReceiver<PushVideoStreamSubscription>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSource::kCreatePushSubscription), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSource_CreatePushSubscription_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameHandlerInterfaceBase>>(
      in_subscriber, &params->subscriber, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->subscriber),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid subscriber in VideoSource.CreatePushSubscription request");
  mojo::internal::MessageFragment<
      typename decltype(params->requested_settings)::BaseType> requested_settings_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
      in_requested_settings, requested_settings_fragment);
  params->requested_settings.Set(
      requested_settings_fragment.is_null() ? nullptr : requested_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requested_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_settings in VideoSource.CreatePushSubscription request");
  params->force_reopen_with_new_settings = in_force_reopen_with_new_settings;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::PushVideoStreamSubscriptionInterfaceBase>>(
      in_subscription, &params->subscription, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->subscription),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid subscription in VideoSource.CreatePushSubscription request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSource::Name_);
  message.set_method_name("CreatePushSubscription");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoSource_CreatePushSubscription_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoSourceProxy::RegisterVideoEffectsProcessor(
    ::mojo::PendingRemote<::video_effects::mojom::VideoEffectsProcessor> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoSource::RegisterVideoEffectsProcessor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote,
                        "<value of type ::mojo::PendingRemote<::video_effects::mojom::VideoEffectsProcessor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSource::kRegisterVideoEffectsProcessor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSource_RegisterVideoEffectsProcessor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_effects::mojom::VideoEffectsProcessorInterfaceBase>>(
      in_remote, &params->remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote in VideoSource.RegisterVideoEffectsProcessor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSource::Name_);
  message.set_method_name("RegisterVideoEffectsProcessor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoSourceProxy::RegisterReadonlyVideoEffectsManager(
    ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoSource::RegisterReadonlyVideoEffectsManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote,
                        "<value of type ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSource::kRegisterReadonlyVideoEffectsManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSource_RegisterReadonlyVideoEffectsManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::ReadonlyVideoEffectsManagerInterfaceBase>>(
      in_remote, &params->remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote in VideoSource.RegisterReadonlyVideoEffectsManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSource::Name_);
  message.set_method_name("RegisterReadonlyVideoEffectsManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class VideoSource_CreatePushSubscription_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoSource::CreatePushSubscriptionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoSource_CreatePushSubscription_ProxyToResponder> proxy(
        new VideoSource_CreatePushSubscription_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoSource_CreatePushSubscription_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoSource_CreatePushSubscription_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoSource_CreatePushSubscription_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoSource::CreatePushSubscriptionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreatePushSubscriptionResultCodePtr in_result_code, const ::media::VideoCaptureParams& in_settings_source_was_opened_with);
};

bool VideoSource_CreatePushSubscription_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoSource_CreatePushSubscription_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoSource_CreatePushSubscription_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for VideoSource.0
  bool success = true;
  CreatePushSubscriptionResultCodePtr p_result_code{};
  ::media::VideoCaptureParams p_settings_source_was_opened_with{};
  VideoSource_CreatePushSubscription_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (success && !input_data_view.ReadSettingsSourceWasOpenedWith(&p_settings_source_was_opened_with))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoSource::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result_code), 
std::move(p_settings_source_was_opened_with));
  return true;
}

void VideoSource_CreatePushSubscription_ProxyToResponder::Run(
    CreatePushSubscriptionResultCodePtr in_result_code, const ::media::VideoCaptureParams& in_settings_source_was_opened_with) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply video_capture::mojom::VideoSource::CreatePushSubscription", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_code"), in_result_code,
                        "<value of type CreatePushSubscriptionResultCodePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings_source_was_opened_with"), in_settings_source_was_opened_with,
                        "<value of type const ::media::VideoCaptureParams&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSource::kCreatePushSubscription), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSource_CreatePushSubscription_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result_code)>
      result_code_fragment(params.message());
  result_code_fragment.Claim(&params->result_code);
  mojo::internal::Serialize<::video_capture::mojom::CreatePushSubscriptionResultCodeDataView>(
      in_result_code, result_code_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result_code.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result_code in ");
  mojo::internal::MessageFragment<
      typename decltype(params->settings_source_was_opened_with)::BaseType> settings_source_was_opened_with_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
      in_settings_source_was_opened_with, settings_source_was_opened_with_fragment);
  params->settings_source_was_opened_with.Set(
      settings_source_was_opened_with_fragment.is_null() ? nullptr : settings_source_was_opened_with_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings_source_was_opened_with.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings_source_was_opened_with in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSource::Name_);
  message.set_method_name("CreatePushSubscription");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoSourceStubDispatch::Accept(
    VideoSource* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoSource>(message->header()->name)) {
    case messages::VideoSource::kCreatePushSubscription: {
      break;
    }
    case messages::VideoSource::kRegisterVideoEffectsProcessor: {
      DCHECK(message->is_serialized());
      internal::VideoSource_RegisterVideoEffectsProcessor_Params_Data* params =
          reinterpret_cast<internal::VideoSource_RegisterVideoEffectsProcessor_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VideoSource.1
      bool success = true;
      ::mojo::PendingRemote<::video_effects::mojom::VideoEffectsProcessor> p_remote{};
      VideoSource_RegisterVideoEffectsProcessor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote =
            input_data_view.TakeRemote<decltype(p_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSource::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterVideoEffectsProcessor(        
        std::move(p_remote));
      return true;
    }
    case messages::VideoSource::kRegisterReadonlyVideoEffectsManager: {
      DCHECK(message->is_serialized());
      internal::VideoSource_RegisterReadonlyVideoEffectsManager_Params_Data* params =
          reinterpret_cast<internal::VideoSource_RegisterReadonlyVideoEffectsManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VideoSource.2
      bool success = true;
      ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager> p_remote{};
      VideoSource_RegisterReadonlyVideoEffectsManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote =
            input_data_view.TakeRemote<decltype(p_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSource::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterReadonlyVideoEffectsManager(        
        std::move(p_remote));
      return true;
    }
  }
  return false;
}

// static
bool VideoSourceStubDispatch::AcceptWithResponder(
    VideoSource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoSource>(message->header()->name)) {
    case messages::VideoSource::kCreatePushSubscription: {
      internal::VideoSource_CreatePushSubscription_Params_Data* params =
          reinterpret_cast<
              internal::VideoSource_CreatePushSubscription_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for VideoSource.0
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> p_subscriber{};
      ::media::VideoCaptureParams p_requested_settings{};
      bool p_force_reopen_with_new_settings{};
      ::mojo::PendingReceiver<PushVideoStreamSubscription> p_subscription{};
      VideoSource_CreatePushSubscription_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_subscriber =
            input_data_view.TakeSubscriber<decltype(p_subscriber)>();
      }
      if (success && !input_data_view.ReadRequestedSettings(&p_requested_settings))
        success = false;
      if (success)
        p_force_reopen_with_new_settings = input_data_view.force_reopen_with_new_settings();
      if (success) {
        p_subscription =
            input_data_view.TakeSubscription<decltype(p_subscription)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSource::Name_, 0, false);
        return false;
      }
      VideoSource::CreatePushSubscriptionCallback callback =
          VideoSource_CreatePushSubscription_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePushSubscription(        
        std::move(p_subscriber), 
        std::move(p_requested_settings), 
        std::move(p_force_reopen_with_new_settings), 
        std::move(p_subscription), std::move(callback));
      return true;
    }
    case messages::VideoSource::kRegisterVideoEffectsProcessor: {
      break;
    }
    case messages::VideoSource::kRegisterReadonlyVideoEffectsManager: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoSourceValidationInfo[] = {
    {base::to_underlying(messages::VideoSource::kCreatePushSubscription),
     { &internal::VideoSource_CreatePushSubscription_Params_Data::Validate,
      &internal::VideoSource_CreatePushSubscription_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::VideoSource::kRegisterVideoEffectsProcessor),
     { &internal::VideoSource_RegisterVideoEffectsProcessor_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VideoSource::kRegisterReadonlyVideoEffectsManager),
     { &internal::VideoSource_RegisterReadonlyVideoEffectsManager_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoSourceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::VideoSource::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoSourceValidationInfo);
}

bool VideoSourceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::VideoSource::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVideoSourceValidationInfo);

}


}  // video_capture::mojom


namespace mojo {

// static
bool UnionTraits<::video_capture::mojom::CreatePushSubscriptionResultCode::DataView, ::video_capture::mojom::CreatePushSubscriptionResultCodePtr>::Read(
    ::video_capture::mojom::CreatePushSubscriptionResultCode::DataView input,
    ::video_capture::mojom::CreatePushSubscriptionResultCodePtr* output) {
  using UnionType = ::video_capture::mojom::CreatePushSubscriptionResultCode;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccessCode: {
      ::video_capture::mojom::CreatePushSubscriptionSuccessCode result_success_code;
      if (!input.ReadSuccessCode(&result_success_code))
        return false;

      *output = UnionType::NewSuccessCode(result_success_code);
      break;
    }
    case Tag::kErrorCode: {
      ::media::VideoCaptureError result_error_code;
      if (!input.ReadErrorCode(&result_error_code))
        return false;

      *output = UnionType::NewErrorCode(result_error_code);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace video_capture::mojom {


void PushVideoStreamSubscriptionInterceptorForTesting::Activate() {
  GetForwardingInterface()->Activate();
}
void PushVideoStreamSubscriptionInterceptorForTesting::Suspend(SuspendCallback callback) {
  GetForwardingInterface()->Suspend(std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::Resume() {
  GetForwardingInterface()->Resume();
}
void PushVideoStreamSubscriptionInterceptorForTesting::GetPhotoState(GetPhotoStateCallback callback) {
  GetForwardingInterface()->GetPhotoState(std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) {
  GetForwardingInterface()->SetPhotoOptions(
    std::move(settings)
    , std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::TakePhoto(TakePhotoCallback callback) {
  GetForwardingInterface()->TakePhoto(std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::ProcessFeedback(const ::media::VideoCaptureFeedback& feedback) {
  GetForwardingInterface()->ProcessFeedback(
    std::move(feedback)
    );
}
PushVideoStreamSubscriptionAsyncWaiter::PushVideoStreamSubscriptionAsyncWaiter(
    PushVideoStreamSubscription* proxy) : proxy_(proxy) {}

PushVideoStreamSubscriptionAsyncWaiter::~PushVideoStreamSubscriptionAsyncWaiter() = default;

void PushVideoStreamSubscriptionAsyncWaiter::Suspend(
    ) {
  base::RunLoop loop;
  proxy_->Suspend(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PushVideoStreamSubscriptionAsyncWaiter::GetPhotoState(
    ::media::mojom::PhotoStatePtr* out_capabilities) {
  base::RunLoop loop;
  proxy_->GetPhotoState(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::PhotoStatePtr* out_capabilities
,
             ::media::mojom::PhotoStatePtr capabilities) {*out_capabilities = std::move(capabilities);
            loop->Quit();
          },
          &loop,
          out_capabilities));
  loop.Run();
}

::media::mojom::PhotoStatePtr PushVideoStreamSubscriptionAsyncWaiter::GetPhotoState(
    ) {
  ::media::mojom::PhotoStatePtr async_wait_result;
  GetPhotoState(&async_wait_result);
  return async_wait_result;
}

void PushVideoStreamSubscriptionAsyncWaiter::SetPhotoOptions(
    ::media::mojom::PhotoSettingsPtr settings, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetPhotoOptions(
      std::move(settings),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PushVideoStreamSubscriptionAsyncWaiter::SetPhotoOptions(
    ::media::mojom::PhotoSettingsPtr settings) {
  bool async_wait_result;
  SetPhotoOptions(std::move(settings),&async_wait_result);
  return async_wait_result;
}

void PushVideoStreamSubscriptionAsyncWaiter::TakePhoto(
    ::media::mojom::BlobPtr* out_blob) {
  base::RunLoop loop;
  proxy_->TakePhoto(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::BlobPtr* out_blob
,
             ::media::mojom::BlobPtr blob) {*out_blob = std::move(blob);
            loop->Quit();
          },
          &loop,
          out_blob));
  loop.Run();
}

::media::mojom::BlobPtr PushVideoStreamSubscriptionAsyncWaiter::TakePhoto(
    ) {
  ::media::mojom::BlobPtr async_wait_result;
  TakePhoto(&async_wait_result);
  return async_wait_result;
}

void PushVideoStreamSubscriptionAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void VideoSourceInterceptorForTesting::CreatePushSubscription(::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> subscriber, const ::media::VideoCaptureParams& requested_settings, bool force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> subscription, CreatePushSubscriptionCallback callback) {
  GetForwardingInterface()->CreatePushSubscription(
    std::move(subscriber)
    , 
    std::move(requested_settings)
    , 
    std::move(force_reopen_with_new_settings)
    , 
    std::move(subscription)
    , std::move(callback));
}
void VideoSourceInterceptorForTesting::RegisterVideoEffectsProcessor(::mojo::PendingRemote<::video_effects::mojom::VideoEffectsProcessor> remote) {
  GetForwardingInterface()->RegisterVideoEffectsProcessor(
    std::move(remote)
    );
}
void VideoSourceInterceptorForTesting::RegisterReadonlyVideoEffectsManager(::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager> remote) {
  GetForwardingInterface()->RegisterReadonlyVideoEffectsManager(
    std::move(remote)
    );
}
VideoSourceAsyncWaiter::VideoSourceAsyncWaiter(
    VideoSource* proxy) : proxy_(proxy) {}

VideoSourceAsyncWaiter::~VideoSourceAsyncWaiter() = default;

void VideoSourceAsyncWaiter::CreatePushSubscription(
    ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> subscriber, const ::media::VideoCaptureParams& requested_settings, bool force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> subscription, CreatePushSubscriptionResultCodePtr* out_result_code, ::media::VideoCaptureParams* out_settings_source_was_opened_with) {
  base::RunLoop loop;
  proxy_->CreatePushSubscription(
      std::move(subscriber),
      std::move(requested_settings),
      std::move(force_reopen_with_new_settings),
      std::move(subscription),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreatePushSubscriptionResultCodePtr* out_result_code
,
             ::media::VideoCaptureParams* out_settings_source_was_opened_with
,
             CreatePushSubscriptionResultCodePtr result_code,
             const ::media::VideoCaptureParams& settings_source_was_opened_with) {*out_result_code = std::move(result_code);*out_settings_source_was_opened_with = std::move(settings_source_was_opened_with);
            loop->Quit();
          },
          &loop,
          out_result_code,
          out_settings_source_was_opened_with));
  loop.Run();
}








}  // video_capture::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif