// services/viz/public/mojom/compositing/compositor_frame_sink.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-test-utils.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_mojom_traits.h"


namespace viz::mojom {
const char CompositorFrameSink::Name_[] = "viz.mojom.CompositorFrameSink";

CompositorFrameSink::IPCStableHashFunction CompositorFrameSink::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CompositorFrameSink>(message.name())) {
    case messages::CompositorFrameSink::kSetNeedsBeginFrame: {
      return &CompositorFrameSink::SetNeedsBeginFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kSetWantsAnimateOnlyBeginFrames: {
      return &CompositorFrameSink::SetWantsAnimateOnlyBeginFrames_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kSetWantsBeginFrameAcks: {
      return &CompositorFrameSink::SetWantsBeginFrameAcks_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kSetAutoNeedsBeginFrame: {
      return &CompositorFrameSink::SetAutoNeedsBeginFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrame: {
      return &CompositorFrameSink::SubmitCompositorFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrameSync: {
      return &CompositorFrameSink::SubmitCompositorFrameSync_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kDidNotProduceFrame: {
      return &CompositorFrameSink::DidNotProduceFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kInitializeCompositorFrameSinkType: {
      return &CompositorFrameSink::InitializeCompositorFrameSinkType_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSink::kBindLayerContext: {
      return &CompositorFrameSink::BindLayerContext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CompositorFrameSink::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CompositorFrameSink>(message.name())) {
      case messages::CompositorFrameSink::kSetNeedsBeginFrame:
            return "Receive viz::mojom::CompositorFrameSink::SetNeedsBeginFrame";
      case messages::CompositorFrameSink::kSetWantsAnimateOnlyBeginFrames:
            return "Receive viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames";
      case messages::CompositorFrameSink::kSetWantsBeginFrameAcks:
            return "Receive viz::mojom::CompositorFrameSink::SetWantsBeginFrameAcks";
      case messages::CompositorFrameSink::kSetAutoNeedsBeginFrame:
            return "Receive viz::mojom::CompositorFrameSink::SetAutoNeedsBeginFrame";
      case messages::CompositorFrameSink::kSubmitCompositorFrame:
            return "Receive viz::mojom::CompositorFrameSink::SubmitCompositorFrame";
      case messages::CompositorFrameSink::kSubmitCompositorFrameSync:
            return "Receive viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync";
      case messages::CompositorFrameSink::kDidNotProduceFrame:
            return "Receive viz::mojom::CompositorFrameSink::DidNotProduceFrame";
      case messages::CompositorFrameSink::kInitializeCompositorFrameSinkType:
            return "Receive viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType";
      case messages::CompositorFrameSink::kBindLayerContext:
            return "Receive viz::mojom::CompositorFrameSink::BindLayerContext";
    }
  } else {
    switch (static_cast<messages::CompositorFrameSink>(message.name())) {
      case messages::CompositorFrameSink::kSetNeedsBeginFrame:
            return "Receive reply viz::mojom::CompositorFrameSink::SetNeedsBeginFrame";
      case messages::CompositorFrameSink::kSetWantsAnimateOnlyBeginFrames:
            return "Receive reply viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames";
      case messages::CompositorFrameSink::kSetWantsBeginFrameAcks:
            return "Receive reply viz::mojom::CompositorFrameSink::SetWantsBeginFrameAcks";
      case messages::CompositorFrameSink::kSetAutoNeedsBeginFrame:
            return "Receive reply viz::mojom::CompositorFrameSink::SetAutoNeedsBeginFrame";
      case messages::CompositorFrameSink::kSubmitCompositorFrame:
            return "Receive reply viz::mojom::CompositorFrameSink::SubmitCompositorFrame";
      case messages::CompositorFrameSink::kSubmitCompositorFrameSync:
            return "Receive reply viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync";
      case messages::CompositorFrameSink::kDidNotProduceFrame:
            return "Receive reply viz::mojom::CompositorFrameSink::DidNotProduceFrame";
      case messages::CompositorFrameSink::kInitializeCompositorFrameSinkType:
            return "Receive reply viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType";
      case messages::CompositorFrameSink::kBindLayerContext:
            return "Receive reply viz::mojom::CompositorFrameSink::BindLayerContext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CompositorFrameSink::SetNeedsBeginFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::SetNeedsBeginFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::SetWantsAnimateOnlyBeginFrames_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::SetWantsBeginFrameAcks_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::SetWantsBeginFrameAcks");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::SetAutoNeedsBeginFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::SetAutoNeedsBeginFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::SubmitCompositorFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::SubmitCompositorFrameSync_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::DidNotProduceFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::DidNotProduceFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::InitializeCompositorFrameSinkType_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSink::BindLayerContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSink::BindLayerContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool CompositorFrameSink::SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, std::vector<::viz::ReturnedResource>* out_resources) {
  NOTREACHED();
}
class CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse(
      bool* result, std::vector<::viz::ReturnedResource>* out_resources)
      : result_(result), out_resources_(out_resources) {
    DCHECK(!*result_);
  }

  CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse(const CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse&) = delete;
  CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse& operator=(const CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<::viz::ReturnedResource>* out_resources_;};

class CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback(
      CompositorFrameSink::SubmitCompositorFrameSyncCallback callback
      ) : callback_(std::move(callback)) {
  }

  CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback(const CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback&) = delete;
  CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback& operator=(const CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CompositorFrameSink::SubmitCompositorFrameSyncCallback callback_;
};

CompositorFrameSinkProxy::CompositorFrameSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
  if (base::FeatureList::IsEnabled(mojo::features::kMojoPredictiveAllocation)) {
    size_estimator_.EnablePredictiveAllocation(base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame));
  }
}

void CompositorFrameSinkProxy::SetNeedsBeginFrame(
    bool in_needs_begin_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::SetNeedsBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_begin_frame"), in_needs_begin_frame,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSetNeedsBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  params->needs_begin_frame = in_needs_begin_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetNeedsBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::SetWantsAnimateOnlyBeginFrames(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSetWantsAnimateOnlyBeginFrames), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetWantsAnimateOnlyBeginFrames");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::SetWantsBeginFrameAcks(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::CompositorFrameSink::SetWantsBeginFrameAcks");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSetWantsBeginFrameAcks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SetWantsBeginFrameAcks_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetWantsBeginFrameAcks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::SetAutoNeedsBeginFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::CompositorFrameSink::SetAutoNeedsBeginFrame");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSetAutoNeedsBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SetAutoNeedsBeginFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetAutoNeedsBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::SubmitCompositorFrame(
    const ::viz::LocalSurfaceId& in_local_surface_id, ::viz::CompositorFrame in_frame, std::optional<::viz::HitTestRegionList> in_hit_test_region_list, uint64_t in_submit_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::SubmitCompositorFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::viz::CompositorFrame>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_region_list"), in_hit_test_region_list,
                        "<value of type std::optional<::viz::HitTestRegionList>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submit_time"), in_submit_time,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    size_estimator_.EstimatePayloadSize(base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame));
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id, local_surface_id_fragment);
  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list, hit_test_region_list_fragment);
  params->hit_test_region_list.Set(
      hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());
  params->submit_time = in_submit_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrame");
#endif
  size_estimator_.TrackPayloadSize(base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame), message.payload_num_bytes());
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool CompositorFrameSinkProxy::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& param_local_surface_id, ::viz::CompositorFrame param_frame, std::optional<::viz::HitTestRegionList> param_hit_test_region_list, uint64_t param_submit_time, std::vector<::viz::ReturnedResource>* out_param_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), param_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), param_frame,
                        "<value of type ::viz::CompositorFrame>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_region_list"), param_hit_test_region_list,
                        "<value of type std::optional<::viz::HitTestRegionList>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submit_time"), param_submit_time,
                        "<value of type uint64_t>");
   });
#else
  TRACE_EVENT0("mojom", "CompositorFrameSink::SubmitCompositorFrameSync");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrameSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      param_local_surface_id, local_surface_id_fragment);
  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrameSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      param_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrameSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      param_hit_test_region_list, hit_test_region_list_fragment);
  params->hit_test_region_list.Set(
      hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());
  params->submit_time = param_submit_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse(
          &result, out_param_resources));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "CompositorFrameSink::SubmitCompositorFrameSync", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), out_param_resources,
                        "<value of type std::vector<::viz::ReturnedResource>>");
   });
#endif
  return result;
}

void CompositorFrameSinkProxy::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& in_local_surface_id, ::viz::CompositorFrame in_frame, std::optional<::viz::HitTestRegionList> in_hit_test_region_list, uint64_t in_submit_time, SubmitCompositorFrameSyncCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::viz::CompositorFrame>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_region_list"), in_hit_test_region_list,
                        "<value of type std::optional<::viz::HitTestRegionList>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submit_time"), in_submit_time,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrameSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id, local_surface_id_fragment);
  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrameSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrameSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list, hit_test_region_list_fragment);
  params->hit_test_region_list.Set(
      hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());
  params->submit_time = in_submit_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CompositorFrameSinkProxy::DidNotProduceFrame(
    const ::viz::BeginFrameAck& in_ack) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::DidNotProduceFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack"), in_ack,
                        "<value of type const ::viz::BeginFrameAck&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kDidNotProduceFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_DidNotProduceFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ack)::BaseType> ack_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView>(
      in_ack, ack_fragment);
  params->ack.Set(
      ack_fragment.is_null() ? nullptr : ack_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ack.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ack in CompositorFrameSink.DidNotProduceFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("DidNotProduceFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::InitializeCompositorFrameSinkType(
    CompositorFrameSinkType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type CompositorFrameSinkType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kInitializeCompositorFrameSinkType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("InitializeCompositorFrameSinkType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkProxy::BindLayerContext(
    ::viz::mojom::PendingLayerContextPtr in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSink::BindLayerContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::viz::mojom::PendingLayerContextPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kBindLayerContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_BindLayerContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context)::BaseType> context_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::PendingLayerContextDataView>(
      in_context, context_fragment);
  params->context.Set(
      context_fragment.is_null() ? nullptr : context_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->context.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null context in CompositorFrameSink.BindLayerContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("BindLayerContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CompositorFrameSink::SubmitCompositorFrameSyncCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder> proxy(
        new CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CompositorFrameSink::SubmitCompositorFrameSyncCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::viz::ReturnedResource> in_resources);
};

bool CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for CompositorFrameSink.5
  bool success = true;
  std::vector<::viz::ReturnedResource> p_resources{};
  CompositorFrameSink_SubmitCompositorFrameSync_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResources(&p_resources))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CompositorFrameSink::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_resources));
  return true;
}

void CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::Run(
    std::vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type std::vector<::viz::ReturnedResource>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrameSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, resources_fragment, &resources_validate_params);
  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data* params =
      reinterpret_cast<internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for CompositorFrameSink.5
  bool success = true;
  std::vector<::viz::ReturnedResource> p_resources{};
  CompositorFrameSink_SubmitCompositorFrameSync_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResources(&p_resources))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CompositorFrameSink::Name_, 5, true);
    return false;
  }
  *out_resources_ = std::move(p_resources);
  *result_ = true;
  return true;
}

// static
bool CompositorFrameSinkStubDispatch::Accept(
    CompositorFrameSink* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CompositorFrameSink>(message->header()->name)) {
    case messages::CompositorFrameSink::kSetNeedsBeginFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.0
      bool success = true;
      bool p_needs_begin_frame{};
      CompositorFrameSink_SetNeedsBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_needs_begin_frame = input_data_view.needs_begin_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsBeginFrame(        
        std::move(p_needs_begin_frame));
      return true;
    }
    case messages::CompositorFrameSink::kSetWantsAnimateOnlyBeginFrames: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.1
      bool success = true;
      CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWantsAnimateOnlyBeginFrames(        );
      return true;
    }
    case messages::CompositorFrameSink::kSetWantsBeginFrameAcks: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetWantsBeginFrameAcks_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetWantsBeginFrameAcks_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.2
      bool success = true;
      CompositorFrameSink_SetWantsBeginFrameAcks_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWantsBeginFrameAcks(        );
      return true;
    }
    case messages::CompositorFrameSink::kSetAutoNeedsBeginFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetAutoNeedsBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetAutoNeedsBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.3
      bool success = true;
      CompositorFrameSink_SetAutoNeedsBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAutoNeedsBeginFrame(        );
      return true;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.4
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      ::viz::CompositorFrame p_frame{};
      std::optional<::viz::HitTestRegionList> p_hit_test_region_list{};
      uint64_t p_submit_time{};
      CompositorFrameSink_SubmitCompositorFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
        success = false;
      if (success)
        p_submit_time = input_data_view.submit_time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitCompositorFrame(        
        std::move(p_local_surface_id), 
        std::move(p_frame), 
        std::move(p_hit_test_region_list), 
        std::move(p_submit_time));
      return true;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrameSync: {
      break;
    }
    case messages::CompositorFrameSink::kDidNotProduceFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_DidNotProduceFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_DidNotProduceFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.6
      bool success = true;
      ::viz::BeginFrameAck p_ack{};
      CompositorFrameSink_DidNotProduceFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAck(&p_ack))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidNotProduceFrame(        
        std::move(p_ack));
      return true;
    }
    case messages::CompositorFrameSink::kInitializeCompositorFrameSinkType: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.7
      bool success = true;
      CompositorFrameSinkType p_type{};
      CompositorFrameSink_InitializeCompositorFrameSinkType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeCompositorFrameSinkType(        
        std::move(p_type));
      return true;
    }
    case messages::CompositorFrameSink::kBindLayerContext: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_BindLayerContext_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_BindLayerContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.8
      bool success = true;
      ::viz::mojom::PendingLayerContextPtr p_context{};
      CompositorFrameSink_BindLayerContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContext(&p_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindLayerContext(        
        std::move(p_context));
      return true;
    }
  }
  return false;
}

// static
bool CompositorFrameSinkStubDispatch::AcceptWithResponder(
    CompositorFrameSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CompositorFrameSink>(message->header()->name)) {
    case messages::CompositorFrameSink::kSetNeedsBeginFrame: {
      break;
    }
    case messages::CompositorFrameSink::kSetWantsAnimateOnlyBeginFrames: {
      break;
    }
    case messages::CompositorFrameSink::kSetWantsBeginFrameAcks: {
      break;
    }
    case messages::CompositorFrameSink::kSetAutoNeedsBeginFrame: {
      break;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrame: {
      break;
    }
    case messages::CompositorFrameSink::kSubmitCompositorFrameSync: {
      internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data* params =
          reinterpret_cast<
              internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for CompositorFrameSink.5
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      ::viz::CompositorFrame p_frame{};
      std::optional<::viz::HitTestRegionList> p_hit_test_region_list{};
      uint64_t p_submit_time{};
      CompositorFrameSink_SubmitCompositorFrameSync_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
        success = false;
      if (success)
        p_submit_time = input_data_view.submit_time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 5, false);
        return false;
      }
      CompositorFrameSink::SubmitCompositorFrameSyncCallback callback =
          CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitCompositorFrameSync(        
        std::move(p_local_surface_id), 
        std::move(p_frame), 
        std::move(p_hit_test_region_list), 
        std::move(p_submit_time), std::move(callback));
      return true;
    }
    case messages::CompositorFrameSink::kDidNotProduceFrame: {
      break;
    }
    case messages::CompositorFrameSink::kInitializeCompositorFrameSinkType: {
      break;
    }
    case messages::CompositorFrameSink::kBindLayerContext: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCompositorFrameSinkValidationInfo[] = {
    {base::to_underlying(messages::CompositorFrameSink::kSetNeedsBeginFrame),
     { &internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSink::kSetWantsAnimateOnlyBeginFrames),
     { &internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSink::kSetWantsBeginFrameAcks),
     { &internal::CompositorFrameSink_SetWantsBeginFrameAcks_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSink::kSetAutoNeedsBeginFrame),
     { &internal::CompositorFrameSink_SetAutoNeedsBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrame),
     { &internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSink::kSubmitCompositorFrameSync),
     { &internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data::Validate,
      &internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CompositorFrameSink::kDidNotProduceFrame),
     { &internal::CompositorFrameSink_DidNotProduceFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSink::kInitializeCompositorFrameSinkType),
     { &internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSink::kBindLayerContext),
     { &internal::CompositorFrameSink_BindLayerContext_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CompositorFrameSinkRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::CompositorFrameSink::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCompositorFrameSinkValidationInfo);
}

bool CompositorFrameSinkResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::CompositorFrameSink::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCompositorFrameSinkValidationInfo);

}
const char CompositorFrameSinkClient::Name_[] = "viz.mojom.CompositorFrameSinkClient";

CompositorFrameSinkClient::IPCStableHashFunction CompositorFrameSinkClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CompositorFrameSinkClient>(message.name())) {
    case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck: {
      return &CompositorFrameSinkClient::DidReceiveCompositorFrameAck_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFrame: {
      return &CompositorFrameSinkClient::OnBeginFrame_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged: {
      return &CompositorFrameSinkClient::OnBeginFramePausedChanged_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kReclaimResources: {
      return &CompositorFrameSinkClient::ReclaimResources_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      return &CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed_Sym::IPCStableHash;
    }
    case messages::CompositorFrameSinkClient::kOnSurfaceEvicted: {
      return &CompositorFrameSinkClient::OnSurfaceEvicted_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CompositorFrameSinkClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CompositorFrameSinkClient>(message.name())) {
      case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck:
            return "Receive viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck";
      case messages::CompositorFrameSinkClient::kOnBeginFrame:
            return "Receive viz::mojom::CompositorFrameSinkClient::OnBeginFrame";
      case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged:
            return "Receive viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged";
      case messages::CompositorFrameSinkClient::kReclaimResources:
            return "Receive viz::mojom::CompositorFrameSinkClient::ReclaimResources";
      case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed:
            return "Receive viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed";
      case messages::CompositorFrameSinkClient::kOnSurfaceEvicted:
            return "Receive viz::mojom::CompositorFrameSinkClient::OnSurfaceEvicted";
    }
  } else {
    switch (static_cast<messages::CompositorFrameSinkClient>(message.name())) {
      case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck";
      case messages::CompositorFrameSinkClient::kOnBeginFrame:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::OnBeginFrame";
      case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged";
      case messages::CompositorFrameSinkClient::kReclaimResources:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::ReclaimResources";
      case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed";
      case messages::CompositorFrameSinkClient::kOnSurfaceEvicted:
            return "Receive reply viz::mojom::CompositorFrameSinkClient::OnSurfaceEvicted";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CompositorFrameSinkClient::DidReceiveCompositorFrameAck_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::OnBeginFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::OnBeginFramePausedChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::ReclaimResources_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSinkClient::ReclaimResources");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CompositorFrameSinkClient::OnSurfaceEvicted_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnSurfaceEvicted");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CompositorFrameSinkClientProxy::CompositorFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CompositorFrameSinkClientProxy::DidReceiveCompositorFrameAck(
    std::vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type std::vector<::viz::ReturnedResource>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, resources_fragment, &resources_validate_params);
  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in CompositorFrameSinkClient.DidReceiveCompositorFrameAck request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("DidReceiveCompositorFrameAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::OnBeginFrame(
    const ::viz::BeginFrameArgs& in_args, const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& in_details, bool in_frame_ack, std::vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::OnBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type const ::viz::BeginFrameArgs&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const base::flat_map<uint32_t, ::viz::FrameTimingDetails>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_ack"), in_frame_ack,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type std::vector<::viz::ReturnedResource>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kOnBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
      in_args, args_fragment);
  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in CompositorFrameSinkClient.OnBeginFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType>
      details_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>>(
      in_details, details_fragment, &details_validate_params);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in CompositorFrameSinkClient.OnBeginFrame request");
  params->frame_ack = in_frame_ack;
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, resources_fragment, &resources_validate_params);
  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in CompositorFrameSinkClient.OnBeginFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::OnBeginFramePausedChanged(
    bool in_paused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("paused"), in_paused,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data> params(
          message);
  params.Allocate();
  params->paused = in_paused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnBeginFramePausedChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::ReclaimResources(
    std::vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::ReclaimResources", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type std::vector<::viz::ReturnedResource>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kReclaimResources), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_ReclaimResources_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, resources_fragment, &resources_validate_params);
  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in CompositorFrameSinkClient.ReclaimResources request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("ReclaimResources");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::OnCompositorFrameTransitionDirectiveProcessed(
    uint32_t in_sequence_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_id"), in_sequence_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data> params(
          message);
  params.Allocate();
  params->sequence_id = in_sequence_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnCompositorFrameTransitionDirectiveProcessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CompositorFrameSinkClientProxy::OnSurfaceEvicted(
    const ::viz::LocalSurfaceId& in_local_surface_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::CompositorFrameSinkClient::OnSurfaceEvicted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CompositorFrameSinkClient::kOnSurfaceEvicted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnSurfaceEvicted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id, local_surface_id_fragment);
  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSinkClient.OnSurfaceEvicted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnSurfaceEvicted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CompositorFrameSinkClientStubDispatch::Accept(
    CompositorFrameSinkClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CompositorFrameSinkClient>(message->header()->name)) {
    case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSinkClient.0
      bool success = true;
      std::vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveCompositorFrameAck(        
        std::move(p_resources));
      return true;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFrame: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSinkClient.1
      bool success = true;
      ::viz::BeginFrameArgs p_args{};
      base::flat_map<uint32_t, ::viz::FrameTimingDetails> p_details{};
      bool p_frame_ack{};
      std::vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_OnBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success)
        p_frame_ack = input_data_view.frame_ack();
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFrame(        
        std::move(p_args), 
        std::move(p_details), 
        std::move(p_frame_ack), 
        std::move(p_resources));
      return true;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSinkClient.2
      bool success = true;
      bool p_paused{};
      CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_paused = input_data_view.paused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFramePausedChanged(        
        std::move(p_paused));
      return true;
    }
    case messages::CompositorFrameSinkClient::kReclaimResources: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_ReclaimResources_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_ReclaimResources_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSinkClient.3
      bool success = true;
      std::vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_ReclaimResources_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReclaimResources(        
        std::move(p_resources));
      return true;
    }
    case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSinkClient.4
      bool success = true;
      uint32_t p_sequence_id{};
      CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sequence_id = input_data_view.sequence_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompositorFrameTransitionDirectiveProcessed(        
        std::move(p_sequence_id));
      return true;
    }
    case messages::CompositorFrameSinkClient::kOnSurfaceEvicted: {
      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnSurfaceEvicted_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnSurfaceEvicted_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CompositorFrameSinkClient.5
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      CompositorFrameSinkClient_OnSurfaceEvicted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSurfaceEvicted(        
        std::move(p_local_surface_id));
      return true;
    }
  }
  return false;
}

// static
bool CompositorFrameSinkClientStubDispatch::AcceptWithResponder(
    CompositorFrameSinkClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CompositorFrameSinkClient>(message->header()->name)) {
    case messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck: {
      break;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFrame: {
      break;
    }
    case messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged: {
      break;
    }
    case messages::CompositorFrameSinkClient::kReclaimResources: {
      break;
    }
    case messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      break;
    }
    case messages::CompositorFrameSinkClient::kOnSurfaceEvicted: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCompositorFrameSinkClientValidationInfo[] = {
    {base::to_underlying(messages::CompositorFrameSinkClient::kDidReceiveCompositorFrameAck),
     { &internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSinkClient::kOnBeginFrame),
     { &internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSinkClient::kOnBeginFramePausedChanged),
     { &internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSinkClient::kReclaimResources),
     { &internal::CompositorFrameSinkClient_ReclaimResources_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSinkClient::kOnCompositorFrameTransitionDirectiveProcessed),
     { &internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CompositorFrameSinkClient::kOnSurfaceEvicted),
     { &internal::CompositorFrameSinkClient_OnSurfaceEvicted_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CompositorFrameSinkClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::CompositorFrameSinkClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCompositorFrameSinkClientValidationInfo);
}



}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void CompositorFrameSinkInterceptorForTesting::SetNeedsBeginFrame(bool needs_begin_frame) {
  GetForwardingInterface()->SetNeedsBeginFrame(
    std::move(needs_begin_frame)
    );
}
void CompositorFrameSinkInterceptorForTesting::SetWantsAnimateOnlyBeginFrames() {
  GetForwardingInterface()->SetWantsAnimateOnlyBeginFrames();
}
void CompositorFrameSinkInterceptorForTesting::SetWantsBeginFrameAcks() {
  GetForwardingInterface()->SetWantsBeginFrameAcks();
}
void CompositorFrameSinkInterceptorForTesting::SetAutoNeedsBeginFrame() {
  GetForwardingInterface()->SetAutoNeedsBeginFrame();
}
void CompositorFrameSinkInterceptorForTesting::SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) {
  GetForwardingInterface()->SubmitCompositorFrame(
    std::move(local_surface_id)
    , 
    std::move(frame)
    , 
    std::move(hit_test_region_list)
    , 
    std::move(submit_time)
    );
}
void CompositorFrameSinkInterceptorForTesting::SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, SubmitCompositorFrameSyncCallback callback) {
  GetForwardingInterface()->SubmitCompositorFrameSync(
    std::move(local_surface_id)
    , 
    std::move(frame)
    , 
    std::move(hit_test_region_list)
    , 
    std::move(submit_time)
    , std::move(callback));
}
void CompositorFrameSinkInterceptorForTesting::DidNotProduceFrame(const ::viz::BeginFrameAck& ack) {
  GetForwardingInterface()->DidNotProduceFrame(
    std::move(ack)
    );
}
void CompositorFrameSinkInterceptorForTesting::InitializeCompositorFrameSinkType(CompositorFrameSinkType type) {
  GetForwardingInterface()->InitializeCompositorFrameSinkType(
    std::move(type)
    );
}
void CompositorFrameSinkInterceptorForTesting::BindLayerContext(::viz::mojom::PendingLayerContextPtr context) {
  GetForwardingInterface()->BindLayerContext(
    std::move(context)
    );
}
CompositorFrameSinkAsyncWaiter::CompositorFrameSinkAsyncWaiter(
    CompositorFrameSink* proxy) : proxy_(proxy) {}

CompositorFrameSinkAsyncWaiter::~CompositorFrameSinkAsyncWaiter() = default;

void CompositorFrameSinkAsyncWaiter::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, std::vector<::viz::ReturnedResource>* out_resources) {
  base::RunLoop loop;
  proxy_->SubmitCompositorFrameSync(
      std::move(local_surface_id),
      std::move(frame),
      std::move(hit_test_region_list),
      std::move(submit_time),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::viz::ReturnedResource>* out_resources
,
             std::vector<::viz::ReturnedResource> resources) {*out_resources = std::move(resources);
            loop->Quit();
          },
          &loop,
          out_resources));
  loop.Run();
}

std::vector<::viz::ReturnedResource> CompositorFrameSinkAsyncWaiter::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) {
  std::vector<::viz::ReturnedResource> async_wait_result;
  SubmitCompositorFrameSync(std::move(local_surface_id),std::move(frame),std::move(hit_test_region_list),std::move(submit_time),&async_wait_result);
  return async_wait_result;
}




void CompositorFrameSinkClientInterceptorForTesting::DidReceiveCompositorFrameAck(std::vector<::viz::ReturnedResource> resources) {
  GetForwardingInterface()->DidReceiveCompositorFrameAck(
    std::move(resources)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::OnBeginFrame(const ::viz::BeginFrameArgs& args, const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& details, bool frame_ack, std::vector<::viz::ReturnedResource> resources) {
  GetForwardingInterface()->OnBeginFrame(
    std::move(args)
    , 
    std::move(details)
    , 
    std::move(frame_ack)
    , 
    std::move(resources)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::OnBeginFramePausedChanged(bool paused) {
  GetForwardingInterface()->OnBeginFramePausedChanged(
    std::move(paused)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::ReclaimResources(std::vector<::viz::ReturnedResource> resources) {
  GetForwardingInterface()->ReclaimResources(
    std::move(resources)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) {
  GetForwardingInterface()->OnCompositorFrameTransitionDirectiveProcessed(
    std::move(sequence_id)
    );
}
void CompositorFrameSinkClientInterceptorForTesting::OnSurfaceEvicted(const ::viz::LocalSurfaceId& local_surface_id) {
  GetForwardingInterface()->OnSurfaceEvicted(
    std::move(local_surface_id)
    );
}
CompositorFrameSinkClientAsyncWaiter::CompositorFrameSinkClientAsyncWaiter(
    CompositorFrameSinkClient* proxy) : proxy_(proxy) {}

CompositorFrameSinkClientAsyncWaiter::~CompositorFrameSinkClientAsyncWaiter() = default;






}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif