// third_party/blink/public/mojom/dom_storage/dom_storage.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_DOM_STORAGE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_DOM_STORAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-forward.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-forward.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class DomStorageProviderProxy;

template <typename ImplRefTraits>
class DomStorageProviderStub;

class DomStorageProviderRequestValidator;


class BLINK_COMMON_EXPORT DomStorageProvider
    : public DomStorageProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DomStorageProviderInterfaceBase;
  using Proxy_ = DomStorageProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = DomStorageProviderStub<ImplRefTraits>;

  using RequestValidator_ = DomStorageProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindDomStorageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindDomStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DomStorageProvider() = default;

  
  virtual void BindDomStorage(::mojo::PendingReceiver<DomStorage> receiver, ::mojo::PendingRemote<DomStorageClient> client) = 0;
};

class DomStorageProxy;

template <typename ImplRefTraits>
class DomStorageStub;

class DomStorageRequestValidator;


class BLINK_COMMON_EXPORT DomStorage
    : public DomStorageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DomStorageInterfaceBase;
  using Proxy_ = DomStorageProxy;

  template <typename ImplRefTraits>
  using Stub_ = DomStorageStub<ImplRefTraits>;

  using RequestValidator_ = DomStorageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOpenLocalStorageMinVersion = 0,
    kBindSessionStorageNamespaceMinVersion = 0,
    kBindSessionStorageAreaMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OpenLocalStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindSessionStorageNamespace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindSessionStorageArea_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DomStorage() = default;

  
  virtual void OpenLocalStorage(const ::blink::StorageKey& storage_key, const ::blink::LocalFrameToken& local_frame_token, ::mojo::PendingReceiver<::blink::mojom::StorageArea> area) = 0;

  
  virtual void BindSessionStorageNamespace(const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver) = 0;

  
  virtual void BindSessionStorageArea(const ::blink::StorageKey& storage_key, const ::blink::LocalFrameToken& local_frame_token, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> session_namespace) = 0;
};

class DomStorageClientProxy;

template <typename ImplRefTraits>
class DomStorageClientStub;

class DomStorageClientRequestValidator;


class BLINK_COMMON_EXPORT DomStorageClient
    : public DomStorageClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DomStorageClientInterfaceBase;
  using Proxy_ = DomStorageClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DomStorageClientStub<ImplRefTraits>;

  using RequestValidator_ = DomStorageClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kResetStorageAreaAndNamespaceConnectionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ResetStorageAreaAndNamespaceConnections_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DomStorageClient() = default;

  
  virtual void ResetStorageAreaAndNamespaceConnections() = 0;
};



class BLINK_COMMON_EXPORT DomStorageProviderProxy
    : public DomStorageProvider {
 public:
  using InterfaceType = DomStorageProvider;

  explicit DomStorageProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindDomStorage(::mojo::PendingReceiver<DomStorage> receiver, ::mojo::PendingRemote<DomStorageClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT DomStorageProxy
    : public DomStorage {
 public:
  using InterfaceType = DomStorage;

  explicit DomStorageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenLocalStorage(const ::blink::StorageKey& storage_key, const ::blink::LocalFrameToken& local_frame_token, ::mojo::PendingReceiver<::blink::mojom::StorageArea> area) final;
  
  void BindSessionStorageNamespace(const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver) final;
  
  void BindSessionStorageArea(const ::blink::StorageKey& storage_key, const ::blink::LocalFrameToken& local_frame_token, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> session_namespace) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT DomStorageClientProxy
    : public DomStorageClient {
 public:
  using InterfaceType = DomStorageClient;

  explicit DomStorageClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ResetStorageAreaAndNamespaceConnections() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT DomStorageProviderStubDispatch {
 public:
  static bool Accept(DomStorageProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DomStorageProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DomStorageProvider>>
class DomStorageProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DomStorageProviderStub() = default;
  ~DomStorageProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DomStorageStubDispatch {
 public:
  static bool Accept(DomStorage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DomStorage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DomStorage>>
class DomStorageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DomStorageStub() = default;
  ~DomStorageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DomStorageClientStubDispatch {
 public:
  static bool Accept(DomStorageClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DomStorageClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DomStorageClient>>
class DomStorageClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DomStorageClientStub() = default;
  ~DomStorageClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DomStorageProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DomStorageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DomStorageClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_DOM_STORAGE_MOJOM_H_