// third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class AdSizeDataView;

class AdDescriptorDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AdSizeDataView> {
  using Data = ::blink::mojom::internal::AdSize_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdDescriptorDataView> {
  using Data = ::blink::mojom::internal::AdDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AdSize_LengthUnit : int32_t {
  
  kInvalid = 0,
  
  kPixels = 1,
  
  kScreenWidth = 2,
  
  kScreenHeight = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AdSize_LengthUnit value);
inline bool IsKnownEnumValue(AdSize_LengthUnit value) {
  return internal::AdSize_LengthUnit_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline AdSize_LengthUnit ToKnownEnumValue(AdSize_LengthUnit value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return AdSize_LengthUnit::kDefaultValue;
}


class AdSizeDataView {
 public:
  AdSizeDataView() = default;

  AdSizeDataView(
      internal::AdSize_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double width() const {
    return data_->width;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWidthUnits(UserType* output) const {
    auto data_value = data_->width_units;
    return mojo::internal::Deserialize<::blink::mojom::AdSize_LengthUnit>(
        data_value, output);
  }
  AdSize_LengthUnit width_units() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AdSize_LengthUnit>(data_->width_units));
  }
  double height() const {
    return data_->height;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHeightUnits(UserType* output) const {
    auto data_value = data_->height_units;
    return mojo::internal::Deserialize<::blink::mojom::AdSize_LengthUnit>(
        data_value, output);
  }
  AdSize_LengthUnit height_units() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AdSize_LengthUnit>(data_->height_units));
  }
 private:
  internal::AdSize_Data* data_ = nullptr;
};


class AdDescriptorDataView {
 public:
  AdDescriptorDataView() = default;

  AdDescriptorDataView(
      internal::AdDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      AdSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdSizeDataView, UserType>(),
    "Attempting to read the optional `size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSize` instead "
    "of `ReadSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdSizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::AdSize_LengthUnit>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AdSize_LengthUnit> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdSize_LengthUnit, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AdSize_LengthUnit, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AdSize_LengthUnit>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdSizeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdSizeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdSize_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->width = Traits::width(input);
    mojo::internal::Serialize<::blink::mojom::AdSize_LengthUnit>(
        Traits::width_units(input), &fragment->width_units);
    fragment->height = Traits::height(input);
    mojo::internal::Serialize<::blink::mojom::AdSize_LengthUnit>(
        Traits::height_units(input), &fragment->height_units);
  }

  static bool Deserialize(::blink::mojom::internal::AdSize_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdSizeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in AdDescriptor struct");
    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AdSizeDataView>(
        in_size, size_fragment);
    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AdDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void AdDescriptorDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AdDescriptorDataView::GetSizeDataView(
    AdSizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = AdSizeDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AdSize_LengthUnit> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AdSize_LengthUnit value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_SHARED_H_