// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* DeviceThermalStateToStringHelper(DeviceThermalState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceThermalState::kUnknown:
      return "kUnknown";
    case DeviceThermalState::kNominal:
      return "kNominal";
    case DeviceThermalState::kFair:
      return "kFair";
    case DeviceThermalState::kSerious:
      return "kSerious";
    case DeviceThermalState::kCritical:
      return "kCritical";
    default:
      return nullptr;
  }
}

std::string DeviceThermalStateToString(DeviceThermalState value) {
  const char *str = DeviceThermalStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceThermalState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceThermalState value) {
  return os << DeviceThermalStateToString(value);
}

namespace internal {


// static
bool PeerConnectionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionInfo_Data* object =
      static_cast<const PeerConnectionInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rtc_configuration, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rtc_configuration_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rtc_configuration, validation_context,
                                         &rtc_configuration_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionInfo_Data::PeerConnectionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_OnSuspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionManager_OnSuspend_Params_Data* object =
      static_cast<const PeerConnectionManager_OnSuspend_Params_Data*>(data);

  return true;
}

PeerConnectionManager_OnSuspend_Params_Data::PeerConnectionManager_OnSuspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_OnThermalStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionManager_OnThermalStateChange_Params_Data* object =
      static_cast<const PeerConnectionManager_OnThermalStateChange_Params_Data*>(data);


  if (!::blink::mojom::internal::DeviceThermalState_Data
        ::Validate(object->thermal_state, validation_context))
    return false;

  return true;
}

PeerConnectionManager_OnThermalStateChange_Params_Data::PeerConnectionManager_OnThermalStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_StartEventLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionManager_StartEventLog_Params_Data* object =
      static_cast<const PeerConnectionManager_StartEventLog_Params_Data*>(data);

  return true;
}

PeerConnectionManager_StartEventLog_Params_Data::PeerConnectionManager_StartEventLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_StopEventLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionManager_StopEventLog_Params_Data* object =
      static_cast<const PeerConnectionManager_StopEventLog_Params_Data*>(data);

  return true;
}

PeerConnectionManager_StopEventLog_Params_Data::PeerConnectionManager_StopEventLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_GetStandardStats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionManager_GetStandardStats_Params_Data* object =
      static_cast<const PeerConnectionManager_GetStandardStats_Params_Data*>(data);

  return true;
}

PeerConnectionManager_GetStandardStats_Params_Data::PeerConnectionManager_GetStandardStats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionManager_GetCurrentState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionManager_GetCurrentState_Params_Data* object =
      static_cast<const PeerConnectionManager_GetCurrentState_Params_Data*>(data);

  return true;
}

PeerConnectionManager_GetCurrentState_Params_Data::PeerConnectionManager_GetCurrentState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_AddPeerConnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_AddPeerConnection_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_AddPeerConnection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

PeerConnectionTrackerHost_AddPeerConnection_Params_Data::PeerConnectionTrackerHost_AddPeerConnection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_RemovePeerConnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_RemovePeerConnection_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_RemovePeerConnection_Params_Data*>(data);

  return true;
}

PeerConnectionTrackerHost_RemovePeerConnection_Params_Data::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_GetUserMedia_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_GetUserMedia_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_GetUserMedia_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_constraints, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& audio_constraints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->audio_constraints, validation_context,
                                         &audio_constraints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_constraints, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& video_constraints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->video_constraints, validation_context,
                                         &video_constraints_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_GetUserMedia_Params_Data::PeerConnectionTrackerHost_GetUserMedia_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stream_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& stream_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->stream_id, validation_context,
                                         &stream_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_track_info, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& audio_track_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->audio_track_info, validation_context,
                                         &audio_track_info_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_track_info, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& video_track_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->video_track_info, validation_context,
                                         &video_track_info_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data::PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data::PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_GetDisplayMedia_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_GetDisplayMedia_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_GetDisplayMedia_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_constraints, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& audio_constraints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->audio_constraints, validation_context,
                                         &audio_constraints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_constraints, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& video_constraints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->video_constraints, validation_context,
                                         &video_constraints_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_GetDisplayMedia_Params_Data::PeerConnectionTrackerHost_GetDisplayMedia_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stream_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& stream_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->stream_id, validation_context,
                                         &stream_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_track_info, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& audio_track_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->audio_track_info, validation_context,
                                         &audio_track_info_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_track_info, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& video_track_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->video_track_info, validation_context,
                                         &video_track_info_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data::PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data::PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output, validation_context,
                                         &output_validate_params)) {
    return false;
  }

  return true;
}

PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerConnectionTrackerHost_AddStandardStats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PeerConnectionTrackerHost_AddStandardStats_Params_Data* object =
      static_cast<const PeerConnectionTrackerHost_AddStandardStats_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

PeerConnectionTrackerHost_AddStandardStats_Params_Data::PeerConnectionTrackerHost_AddStandardStats_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DeviceThermalState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::DeviceThermalState value) {
  return std::move(context).WriteString(::blink::mojom::DeviceThermalStateToString(value));
}

} // namespace perfetto