// third_party/blink/public/mojom/permissions_policy/permissions_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/permissions_policy/permissions_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class OriginWithPossibleWildcardsDataView;

class ParsedPermissionsPolicyDeclarationDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::OriginWithPossibleWildcardsDataView> {
  using Data = ::blink::mojom::internal::OriginWithPossibleWildcards_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView> {
  using Data = ::blink::mojom::internal::ParsedPermissionsPolicyDeclaration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class OriginWithPossibleWildcardsDataView {
 public:
  OriginWithPossibleWildcardsDataView() = default;

  OriginWithPossibleWildcardsDataView(
      internal::OriginWithPossibleWildcards_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t port() const {
    return data_->port;
  }
  bool is_host_wildcard() const {
    return data_->is_host_wildcard;
  }
  bool is_port_wildcard() const {
    return data_->is_port_wildcard;
  }
 private:
  internal::OriginWithPossibleWildcards_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParsedPermissionsPolicyDeclarationDataView {
 public:
  ParsedPermissionsPolicyDeclarationDataView() = default;

  ParsedPermissionsPolicyDeclarationDataView(
      internal::ParsedPermissionsPolicyDeclaration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFeature(UserType* output) const {
    auto data_value = data_->feature;
    return mojo::internal::Deserialize<::network::mojom::PermissionsPolicyFeature>(
        data_value, output);
  }
  ::network::mojom::PermissionsPolicyFeature feature() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::PermissionsPolicyFeature>(data_->feature));
  }
  inline void GetAllowedOriginsDataView(
      mojo::ArrayDataView<OriginWithPossibleWildcardsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedOrigins(UserType* output) {
    
    auto* pointer = data_->allowed_origins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::OriginWithPossibleWildcardsDataView>>(
        pointer, output, message_);
  }
  inline void GetSelfIfMatchesDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelfIfMatches(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `self_if_matches` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelfIfMatches` instead "
    "of `ReadSelfIfMatches if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->self_if_matches.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool matches_all_origins() const {
    return data_->matches_all_origins;
  }
  bool matches_opaque_src() const {
    return data_->matches_opaque_src;
  }
  inline void GetReportingEndpointDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `reporting_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingEndpoint` instead "
    "of `ReadReportingEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_endpoint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ParsedPermissionsPolicyDeclaration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::OriginWithPossibleWildcardsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::OriginWithPossibleWildcardsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::OriginWithPossibleWildcards_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scheme)::BaseType> scheme_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_scheme, scheme_fragment);
    fragment->scheme.Set(
        scheme_fragment.is_null() ? nullptr : scheme_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scheme.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in OriginWithPossibleWildcards struct");
    decltype(Traits::host(input)) in_host = Traits::host(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host)::BaseType> host_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_host, host_fragment);
    fragment->host.Set(
        host_fragment.is_null() ? nullptr : host_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host in OriginWithPossibleWildcards struct");
    fragment->port = Traits::port(input);
    fragment->is_host_wildcard = Traits::is_host_wildcard(input);
    fragment->is_port_wildcard = Traits::is_port_wildcard(input);
  }

  static bool Deserialize(::blink::mojom::internal::OriginWithPossibleWildcards_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::OriginWithPossibleWildcardsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ParsedPermissionsPolicyDeclaration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::PermissionsPolicyFeature>(
        Traits::feature(input), &fragment->feature);
    decltype(Traits::allowed_origins(input)) in_allowed_origins = Traits::allowed_origins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowed_origins)::BaseType>
        allowed_origins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allowed_origins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::OriginWithPossibleWildcardsDataView>>(
        in_allowed_origins, allowed_origins_fragment, &allowed_origins_validate_params);
    fragment->allowed_origins.Set(
        allowed_origins_fragment.is_null() ? nullptr : allowed_origins_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->allowed_origins.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null allowed_origins in ParsedPermissionsPolicyDeclaration struct");
    decltype(Traits::self_if_matches(input)) in_self_if_matches = Traits::self_if_matches(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->self_if_matches)::BaseType> self_if_matches_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_self_if_matches, self_if_matches_fragment);
    fragment->self_if_matches.Set(
        self_if_matches_fragment.is_null() ? nullptr : self_if_matches_fragment.data());
    fragment->matches_all_origins = Traits::matches_all_origins(input);
    fragment->matches_opaque_src = Traits::matches_opaque_src(input);
    decltype(Traits::reporting_endpoint(input)) in_reporting_endpoint = Traits::reporting_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_endpoint)::BaseType> reporting_endpoint_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_reporting_endpoint, reporting_endpoint_fragment);
    fragment->reporting_endpoint.Set(
        reporting_endpoint_fragment.is_null() ? nullptr : reporting_endpoint_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ParsedPermissionsPolicyDeclaration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ParsedPermissionsPolicyDeclarationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void OriginWithPossibleWildcardsDataView::GetSchemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scheme.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OriginWithPossibleWildcardsDataView::GetHostDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ParsedPermissionsPolicyDeclarationDataView::GetAllowedOriginsDataView(
    mojo::ArrayDataView<OriginWithPossibleWildcardsDataView>* output) {
  auto pointer = data_->allowed_origins.Get();
  *output = mojo::ArrayDataView<OriginWithPossibleWildcardsDataView>(pointer, message_);
}
inline void ParsedPermissionsPolicyDeclarationDataView::GetSelfIfMatchesDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->self_if_matches.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void ParsedPermissionsPolicyDeclarationDataView::GetReportingEndpointDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reporting_endpoint.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SHARED_H_