// ui/base/ime/mojom/ime_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/ime/mojom/ime_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/ime/mojom/ime_types.mojom-params-data.h"
namespace ui {
namespace mojom {

NOINLINE static const char* TextInputModeToStringHelper(TextInputMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextInputMode::kDefault:
      return "kDefault";
    case TextInputMode::kNone:
      return "kNone";
    case TextInputMode::kText:
      return "kText";
    case TextInputMode::kTel:
      return "kTel";
    case TextInputMode::kUrl:
      return "kUrl";
    case TextInputMode::kEmail:
      return "kEmail";
    case TextInputMode::kNumeric:
      return "kNumeric";
    case TextInputMode::kDecimal:
      return "kDecimal";
    case TextInputMode::kSearch:
      return "kSearch";
    default:
      return nullptr;
  }
}

std::string TextInputModeToString(TextInputMode value) {
  const char *str = TextInputModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextInputMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextInputMode value) {
  return os << TextInputModeToString(value);
}

NOINLINE static const char* TextInputActionToStringHelper(TextInputAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextInputAction::kDefault:
      return "kDefault";
    case TextInputAction::kEnter:
      return "kEnter";
    case TextInputAction::kDone:
      return "kDone";
    case TextInputAction::kGo:
      return "kGo";
    case TextInputAction::kNext:
      return "kNext";
    case TextInputAction::kPrevious:
      return "kPrevious";
    case TextInputAction::kSearch:
      return "kSearch";
    case TextInputAction::kSend:
      return "kSend";
    default:
      return nullptr;
  }
}

std::string TextInputActionToString(TextInputAction value) {
  const char *str = TextInputActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextInputAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextInputAction value) {
  return os << TextInputActionToString(value);
}

NOINLINE static const char* TextInputTypeToStringHelper(TextInputType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextInputType::NONE:
      return "NONE";
    case TextInputType::TEXT:
      return "TEXT";
    case TextInputType::PASSWORD:
      return "PASSWORD";
    case TextInputType::SEARCH:
      return "SEARCH";
    case TextInputType::EMAIL:
      return "EMAIL";
    case TextInputType::NUMBER:
      return "NUMBER";
    case TextInputType::TELEPHONE:
      return "TELEPHONE";
    case TextInputType::URL:
      return "URL";
    case TextInputType::DATE:
      return "DATE";
    case TextInputType::DATE_TIME:
      return "DATE_TIME";
    case TextInputType::DATE_TIME_LOCAL:
      return "DATE_TIME_LOCAL";
    case TextInputType::MONTH:
      return "MONTH";
    case TextInputType::TIME:
      return "TIME";
    case TextInputType::WEEK:
      return "WEEK";
    case TextInputType::TEXT_AREA:
      return "TEXT_AREA";
    case TextInputType::CONTENT_EDITABLE:
      return "CONTENT_EDITABLE";
    case TextInputType::DATE_TIME_FIELD:
      return "DATE_TIME_FIELD";
    case TextInputType::TYPE_NULL:
      return "{TYPE_NULL, MAX}";
    default:
      return nullptr;
  }
}

std::string TextInputTypeToString(TextInputType value) {
  const char *str = TextInputTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextInputType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextInputType value) {
  return os << TextInputTypeToString(value);
}

NOINLINE static const char* ImeTextSpanTypeToStringHelper(ImeTextSpanType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImeTextSpanType::kComposition:
      return "kComposition";
    case ImeTextSpanType::kSuggestion:
      return "kSuggestion";
    case ImeTextSpanType::kMisspellingSuggestion:
      return "kMisspellingSuggestion";
    case ImeTextSpanType::kAutocorrect:
      return "kAutocorrect";
    case ImeTextSpanType::kGrammarSuggestion:
      return "kGrammarSuggestion";
    default:
      return nullptr;
  }
}

std::string ImeTextSpanTypeToString(ImeTextSpanType value) {
  const char *str = ImeTextSpanTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImeTextSpanType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanType value) {
  return os << ImeTextSpanTypeToString(value);
}

NOINLINE static const char* ImeTextSpanThicknessToStringHelper(ImeTextSpanThickness value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImeTextSpanThickness::kNone:
      return "kNone";
    case ImeTextSpanThickness::kThin:
      return "kThin";
    case ImeTextSpanThickness::kThick:
      return "kThick";
    default:
      return nullptr;
  }
}

std::string ImeTextSpanThicknessToString(ImeTextSpanThickness value) {
  const char *str = ImeTextSpanThicknessToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImeTextSpanThickness value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanThickness value) {
  return os << ImeTextSpanThicknessToString(value);
}

NOINLINE static const char* ImeTextSpanUnderlineStyleToStringHelper(ImeTextSpanUnderlineStyle value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImeTextSpanUnderlineStyle::kNone:
      return "kNone";
    case ImeTextSpanUnderlineStyle::kSolid:
      return "kSolid";
    case ImeTextSpanUnderlineStyle::kDot:
      return "kDot";
    case ImeTextSpanUnderlineStyle::kDash:
      return "kDash";
    case ImeTextSpanUnderlineStyle::kSquiggle:
      return "kSquiggle";
    default:
      return nullptr;
  }
}

std::string ImeTextSpanUnderlineStyleToString(ImeTextSpanUnderlineStyle value) {
  const char *str = ImeTextSpanUnderlineStyleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImeTextSpanUnderlineStyle value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanUnderlineStyle value) {
  return os << ImeTextSpanUnderlineStyleToString(value);
}

namespace internal {


// static
bool ImeTextSpan_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImeTextSpan_Data* object =
      static_cast<const ImeTextSpan_Data*>(data);


  if (!::ui::mojom::internal::ImeTextSpanType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::ui::mojom::internal::ImeTextSpanThickness_Data
        ::Validate(object->thickness, validation_context))
    return false;


  if (!::ui::mojom::internal::ImeTextSpanUnderlineStyle_Data
        ::Validate(object->underline_style, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestions, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->suggestions, validation_context,
                                         &suggestions_validate_params)) {
    return false;
  }

  return true;
}

ImeTextSpan_Data::ImeTextSpan_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::TextInputMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::TextInputMode value) {
  return std::move(context).WriteString(::ui::mojom::TextInputModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::TextInputAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::TextInputAction value) {
  return std::move(context).WriteString(::ui::mojom::TextInputActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::TextInputType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::TextInputType value) {
  return std::move(context).WriteString(::ui::mojom::TextInputTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ImeTextSpanType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::ImeTextSpanType value) {
  return std::move(context).WriteString(::ui::mojom::ImeTextSpanTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ImeTextSpanThickness>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::ImeTextSpanThickness value) {
  return std::move(context).WriteString(::ui::mojom::ImeTextSpanThicknessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ImeTextSpanUnderlineStyle>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::ImeTextSpanUnderlineStyle value) {
  return std::move(context).WriteString(::ui::mojom::ImeTextSpanUnderlineStyleToString(value));
}

} // namespace perfetto