// ui/gfx/mojom/gpu_extra_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_GPU_EXTRA_INFO_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_GPU_EXTRA_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/gpu_extra_info.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"







namespace gfx::mojom {
class ANGLEFeatureDataView;

class GpuExtraInfoDataView;



}  // gfx::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::ANGLEFeatureDataView> {
  using Data = ::gfx::mojom::internal::ANGLEFeature_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuExtraInfoDataView> {
  using Data = ::gfx::mojom::internal::GpuExtraInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class ANGLEFeatureDataView {
 public:
  ANGLEFeatureDataView() = default;

  ANGLEFeatureDataView(
      internal::ANGLEFeature_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCategoryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCategory(UserType* output) {
    
    auto* pointer = data_->category.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStatusDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ANGLEFeature_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuExtraInfoDataView {
 public:
  GpuExtraInfoDataView() = default;

  GpuExtraInfoDataView(
      internal::GpuExtraInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAngleFeaturesDataView(
      mojo::ArrayDataView<ANGLEFeatureDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAngleFeatures(UserType* output) {
    
    auto* pointer = data_->angle_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::ANGLEFeatureDataView>>(
        pointer, output, message_);
  }
  inline void GetGpuMemoryBufferSupportX11DataView(
      mojo::ArrayDataView<::gfx::mojom::BufferUsageAndFormatDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuMemoryBufferSupportX11(UserType* output) {
    
    auto* pointer = data_->gpu_memory_buffer_support_x11.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::BufferUsageAndFormatDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GpuExtraInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::ANGLEFeatureDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::ANGLEFeatureDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::ANGLEFeature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ANGLEFeature struct");
    decltype(Traits::category(input)) in_category = Traits::category(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->category)::BaseType> category_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_category, category_fragment);
    fragment->category.Set(
        category_fragment.is_null() ? nullptr : category_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->category.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null category in ANGLEFeature struct");
    decltype(Traits::status(input)) in_status = Traits::status(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->status)::BaseType> status_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_status, status_fragment);
    fragment->status.Set(
        status_fragment.is_null() ? nullptr : status_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->status.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null status in ANGLEFeature struct");
  }

  static bool Deserialize(::gfx::mojom::internal::ANGLEFeature_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::ANGLEFeatureDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuExtraInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuExtraInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::GpuExtraInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::angle_features(input)) in_angle_features = Traits::angle_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->angle_features)::BaseType>
        angle_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& angle_features_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::ANGLEFeatureDataView>>(
        in_angle_features, angle_features_fragment, &angle_features_validate_params);
    fragment->angle_features.Set(
        angle_features_fragment.is_null() ? nullptr : angle_features_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->angle_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null angle_features in GpuExtraInfo struct");
    decltype(Traits::gpu_memory_buffer_support_x11(input)) in_gpu_memory_buffer_support_x11 = Traits::gpu_memory_buffer_support_x11(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gpu_memory_buffer_support_x11)::BaseType>
        gpu_memory_buffer_support_x11_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& gpu_memory_buffer_support_x11_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::BufferUsageAndFormatDataView>>(
        in_gpu_memory_buffer_support_x11, gpu_memory_buffer_support_x11_fragment, &gpu_memory_buffer_support_x11_validate_params);
    fragment->gpu_memory_buffer_support_x11.Set(
        gpu_memory_buffer_support_x11_fragment.is_null() ? nullptr : gpu_memory_buffer_support_x11_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->gpu_memory_buffer_support_x11.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gpu_memory_buffer_support_x11 in GpuExtraInfo struct");
  }

  static bool Deserialize(::gfx::mojom::internal::GpuExtraInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuExtraInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void ANGLEFeatureDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ANGLEFeatureDataView::GetCategoryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->category.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ANGLEFeatureDataView::GetStatusDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->status.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GpuExtraInfoDataView::GetAngleFeaturesDataView(
    mojo::ArrayDataView<ANGLEFeatureDataView>* output) {
  auto pointer = data_->angle_features.Get();
  *output = mojo::ArrayDataView<ANGLEFeatureDataView>(pointer, message_);
}
inline void GpuExtraInfoDataView::GetGpuMemoryBufferSupportX11DataView(
    mojo::ArrayDataView<::gfx::mojom::BufferUsageAndFormatDataView>* output) {
  auto pointer = data_->gpu_memory_buffer_support_x11.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::BufferUsageAndFormatDataView>(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_GPU_EXTRA_INFO_MOJOM_SHARED_H_