// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NET_DEVICE_BOUND_SESSIONS_SESSION_BINDING_UTILS_H_
#define NET_DEVICE_BOUND_SESSIONS_SESSION_BINDING_UTILS_H_

#include <optional>
#include <string>
#include <string_view>

#include "base/containers/span.h"
#include "crypto/signature_verifier.h"
#include "net/base/net_export.h"

class GURL;

namespace base {
class Time;
}

namespace net::device_bound_sessions {

// Creates header and payload parts of a registration JWT.
std::optional<std::string> NET_EXPORT CreateKeyRegistrationHeaderAndPayload(
    std::string_view challenge,
    const GURL& registration_url,
    crypto::SignatureVerifier::SignatureAlgorithm algorithm,
    base::span<const uint8_t> pubkey_spki,
    base::Time timestamp,
    std::optional<std::string> authorization);

// Appends `signature` generated by `algorithm` to provided `header_and_payload`
// to form a complete JWT.
std::optional<std::string> NET_EXPORT AppendSignatureToHeaderAndPayload(
    std::string_view header_and_payload,
    crypto::SignatureVerifier::SignatureAlgorithm algorithm,
    base::span<const uint8_t> signature);

}  // namespace net::device_bound_sessions

#endif  // NET_DEVICE_BOUND_SESSIONS_SESSION_BINDING_UTILS_H_
