// components/network_hints/common/network_hints.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/network_hints/common/network_hints.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/network_hints/common/network_hints.mojom-params-data.h"
#include "components/network_hints/common/network_hints.mojom-shared-message-ids.h"

#include "components/network_hints/common/network_hints.mojom-import-headers.h"
#include "components/network_hints/common/network_hints.mojom-test-utils.h"


namespace network_hints::mojom {
// The declaration includes the definition on other builds.

NetworkHintsHandler::IPCStableHashFunction NetworkHintsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkHintsHandler>(message.name())) {
    case messages::NetworkHintsHandler::kPrefetchDNS: {
      return &NetworkHintsHandler::PrefetchDNS_Sym::IPCStableHash;
    }
    case messages::NetworkHintsHandler::kPreconnect: {
      return &NetworkHintsHandler::Preconnect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkHintsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkHintsHandler>(message.name())) {
      case messages::NetworkHintsHandler::kPrefetchDNS:
            return "Receive network_hints::mojom::NetworkHintsHandler::PrefetchDNS";
      case messages::NetworkHintsHandler::kPreconnect:
            return "Receive network_hints::mojom::NetworkHintsHandler::Preconnect";
    }
  } else {
    switch (static_cast<messages::NetworkHintsHandler>(message.name())) {
      case messages::NetworkHintsHandler::kPrefetchDNS:
            return "Receive reply network_hints::mojom::NetworkHintsHandler::PrefetchDNS";
      case messages::NetworkHintsHandler::kPreconnect:
            return "Receive reply network_hints::mojom::NetworkHintsHandler::Preconnect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkHintsHandler::PrefetchDNS_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc0b052ec;  // IPCStableHash for network_hints::mojom::NetworkHintsHandler::PrefetchDNS
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkHintsHandler::Preconnect_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9d1fa46;  // IPCStableHash for network_hints::mojom::NetworkHintsHandler::Preconnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetworkHintsHandlerProxy::NetworkHintsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkHintsHandlerProxy::PrefetchDNS(
    const std::vector<::url::SchemeHostPort>& in_url_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network_hints::mojom::NetworkHintsHandler::PrefetchDNS", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_list"), in_url_list,
                        "<value of type const std::vector<::url::SchemeHostPort>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkHintsHandler::kPrefetchDNS), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network_hints::mojom::internal::NetworkHintsHandler_PrefetchDNS_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url_list)::BaseType>
      url_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& url_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::SchemeHostPortDataView>>(
    in_url_list,
    url_list_fragment,
    &url_list_validate_params);

  params->url_list.Set(
      url_list_fragment.is_null() ? nullptr : url_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url_list in NetworkHintsHandler.PrefetchDNS request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkHintsHandler::Name_);
  message.set_method_name("PrefetchDNS");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkHintsHandlerProxy::Preconnect(
    const ::url::SchemeHostPort& in_url, bool in_allow_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network_hints::mojom::NetworkHintsHandler::Preconnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::url::SchemeHostPort&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_credentials"), in_allow_credentials,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkHintsHandler::kPreconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network_hints::mojom::internal::NetworkHintsHandler_Preconnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::SchemeHostPortDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkHintsHandler.Preconnect request");

  params->allow_credentials = in_allow_credentials;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkHintsHandler::Name_);
  message.set_method_name("Preconnect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetworkHintsHandlerStubDispatch::Accept(
    NetworkHintsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkHintsHandler>(message->header()->name)) {
    case messages::NetworkHintsHandler::kPrefetchDNS: {
      DCHECK(message->is_serialized());
      internal::NetworkHintsHandler_PrefetchDNS_Params_Data* params =
          reinterpret_cast<internal::NetworkHintsHandler_PrefetchDNS_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkHintsHandler.0
      bool success = true;
      std::vector<::url::SchemeHostPort> p_url_list{};
      NetworkHintsHandler_PrefetchDNS_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrlList(&p_url_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkHintsHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrefetchDNS(        
        std::move(p_url_list));
      return true;
    }
    case messages::NetworkHintsHandler::kPreconnect: {
      DCHECK(message->is_serialized());
      internal::NetworkHintsHandler_Preconnect_Params_Data* params =
          reinterpret_cast<internal::NetworkHintsHandler_Preconnect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkHintsHandler.1
      bool success = true;
      ::url::SchemeHostPort p_url{};
      bool p_allow_credentials{};
      NetworkHintsHandler_Preconnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_allow_credentials = input_data_view.allow_credentials();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkHintsHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Preconnect(        
        std::move(p_url), 
        std::move(p_allow_credentials));
      return true;
    }
  }
  return false;
}

// static
bool NetworkHintsHandlerStubDispatch::AcceptWithResponder(
    NetworkHintsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkHintsHandler>(message->header()->name)) {
    case messages::NetworkHintsHandler::kPrefetchDNS: {
      break;
    }
    case messages::NetworkHintsHandler::kPreconnect: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkHintsHandlerValidationInfo[] = {
    {base::to_underlying(messages::NetworkHintsHandler::kPrefetchDNS),
     { &internal::NetworkHintsHandler_PrefetchDNS_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkHintsHandler::kPreconnect),
     { &internal::NetworkHintsHandler_Preconnect_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkHintsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network_hints::mojom::NetworkHintsHandler::Name_,
    kNetworkHintsHandlerValidationInfo);
}



}  // network_hints::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network_hints::mojom {


void NetworkHintsHandlerInterceptorForTesting::PrefetchDNS(const std::vector<::url::SchemeHostPort>& url_list) {
  GetForwardingInterface()->PrefetchDNS(
    std::move(url_list)
    );
}
void NetworkHintsHandlerInterceptorForTesting::Preconnect(const ::url::SchemeHostPort& url, bool allow_credentials) {
  GetForwardingInterface()->Preconnect(
    std::move(url)
    , 
    std::move(allow_credentials)
    );
}
NetworkHintsHandlerAsyncWaiter::NetworkHintsHandlerAsyncWaiter(
    NetworkHintsHandler* proxy) : proxy_(proxy) {}

NetworkHintsHandlerAsyncWaiter::~NetworkHintsHandlerAsyncWaiter() = default;







}  // network_hints::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif