// components/services/storage/privileged/mojom/indexed_db_control_test.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/privileged/mojom/indexed_db_control_test.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/privileged/mojom/indexed_db_control_test.mojom-params-data.h"
#include "components/services/storage/privileged/mojom/indexed_db_control_test.mojom-shared-message-ids.h"

#include "components/services/storage/privileged/mojom/indexed_db_control_test.mojom-import-headers.h"
#include "components/services/storage/privileged/mojom/indexed_db_control_test.mojom-test-utils.h"


namespace storage::mojom {
// The declaration includes the definition on other builds.

MockFailureInjector::IPCStableHashFunction MockFailureInjector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MockFailureInjector>(message.name())) {
    case messages::MockFailureInjector::kFailOperation: {
      return &MockFailureInjector::FailOperation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MockFailureInjector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MockFailureInjector>(message.name())) {
      case messages::MockFailureInjector::kFailOperation:
            return "Receive storage::mojom::MockFailureInjector::FailOperation";
    }
  } else {
    switch (static_cast<messages::MockFailureInjector>(message.name())) {
      case messages::MockFailureInjector::kFailOperation:
            return "Receive reply storage::mojom::MockFailureInjector::FailOperation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MockFailureInjector::FailOperation_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb7f0b3f;  // IPCStableHash for storage::mojom::MockFailureInjector::FailOperation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MockFailureInjectorProxy::MockFailureInjectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MockFailureInjectorProxy::FailOperation(
    FailClass in_failure_class, FailMethod in_failure_method, int32_t in_instance_num, int32_t in_call_num) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::MockFailureInjector::FailOperation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failure_class"), in_failure_class,
                        "<value of type FailClass>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failure_method"), in_failure_method,
                        "<value of type FailMethod>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance_num"), in_instance_num,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_num"), in_call_num,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MockFailureInjector::kFailOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::MockFailureInjector_FailOperation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::FailClass>(
    in_failure_class,
    &params->failure_class);

  
  mojo::internal::Serialize<::storage::mojom::FailMethod>(
    in_failure_method,
    &params->failure_method);

  params->instance_num = in_instance_num;

  params->call_num = in_call_num;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MockFailureInjector::Name_);
  message.set_method_name("FailOperation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MockFailureInjectorStubDispatch::Accept(
    MockFailureInjector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MockFailureInjector>(message->header()->name)) {
    case messages::MockFailureInjector::kFailOperation: {
      DCHECK(message->is_serialized());
      internal::MockFailureInjector_FailOperation_Params_Data* params =
          reinterpret_cast<internal::MockFailureInjector_FailOperation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MockFailureInjector.0
      bool success = true;
      FailClass p_failure_class{};
      FailMethod p_failure_method{};
      int32_t p_instance_num{};
      int32_t p_call_num{};
      MockFailureInjector_FailOperation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFailureClass(&p_failure_class))
        success = false;
      if (success && !input_data_view.ReadFailureMethod(&p_failure_method))
        success = false;
      if (success)
        p_instance_num = input_data_view.instance_num();
      if (success)
        p_call_num = input_data_view.call_num();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MockFailureInjector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FailOperation(        
        std::move(p_failure_class), 
        std::move(p_failure_method), 
        std::move(p_instance_num), 
        std::move(p_call_num));
      return true;
    }
  }
  return false;
}

// static
bool MockFailureInjectorStubDispatch::AcceptWithResponder(
    MockFailureInjector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MockFailureInjector>(message->header()->name)) {
    case messages::MockFailureInjector::kFailOperation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMockFailureInjectorValidationInfo[] = {
    {base::to_underlying(messages::MockFailureInjector::kFailOperation),
     { &internal::MockFailureInjector_FailOperation_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MockFailureInjectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::storage::mojom::MockFailureInjector::Name_,
    kMockFailureInjectorValidationInfo);
}

// The declaration includes the definition on other builds.

IndexedDBControlTest::IPCStableHashFunction IndexedDBControlTest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IndexedDBControlTest>(message.name())) {
    case messages::IndexedDBControlTest::kGetBaseDataPathForTesting: {
      return &IndexedDBControlTest::GetBaseDataPathForTesting_Sym::IPCStableHash;
    }
    case messages::IndexedDBControlTest::kGetFilePathForTesting: {
      return &IndexedDBControlTest::GetFilePathForTesting_Sym::IPCStableHash;
    }
    case messages::IndexedDBControlTest::kResetCachesForTesting: {
      return &IndexedDBControlTest::ResetCachesForTesting_Sym::IPCStableHash;
    }
    case messages::IndexedDBControlTest::kGetPathForBlobForTesting: {
      return &IndexedDBControlTest::GetPathForBlobForTesting_Sym::IPCStableHash;
    }
    case messages::IndexedDBControlTest::kFlushBackingStoreForTesting: {
      return &IndexedDBControlTest::FlushBackingStoreForTesting_Sym::IPCStableHash;
    }
    case messages::IndexedDBControlTest::kGetSchedulingPriorityForTesting: {
      return &IndexedDBControlTest::GetSchedulingPriorityForTesting_Sym::IPCStableHash;
    }
    case messages::IndexedDBControlTest::kGetUsageForTesting: {
      return &IndexedDBControlTest::GetUsageForTesting_Sym::IPCStableHash;
    }
    case messages::IndexedDBControlTest::kBindMockFailureSingletonForTesting: {
      return &IndexedDBControlTest::BindMockFailureSingletonForTesting_Sym::IPCStableHash;
    }
    case messages::IndexedDBControlTest::kForceInitializeFromFilesForTesting: {
      return &IndexedDBControlTest::ForceInitializeFromFilesForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IndexedDBControlTest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IndexedDBControlTest>(message.name())) {
      case messages::IndexedDBControlTest::kGetBaseDataPathForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::GetBaseDataPathForTesting";
      case messages::IndexedDBControlTest::kGetFilePathForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::GetFilePathForTesting";
      case messages::IndexedDBControlTest::kResetCachesForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::ResetCachesForTesting";
      case messages::IndexedDBControlTest::kGetPathForBlobForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::GetPathForBlobForTesting";
      case messages::IndexedDBControlTest::kFlushBackingStoreForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::FlushBackingStoreForTesting";
      case messages::IndexedDBControlTest::kGetSchedulingPriorityForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::GetSchedulingPriorityForTesting";
      case messages::IndexedDBControlTest::kGetUsageForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::GetUsageForTesting";
      case messages::IndexedDBControlTest::kBindMockFailureSingletonForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::BindMockFailureSingletonForTesting";
      case messages::IndexedDBControlTest::kForceInitializeFromFilesForTesting:
            return "Receive storage::mojom::IndexedDBControlTest::ForceInitializeFromFilesForTesting";
    }
  } else {
    switch (static_cast<messages::IndexedDBControlTest>(message.name())) {
      case messages::IndexedDBControlTest::kGetBaseDataPathForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::GetBaseDataPathForTesting";
      case messages::IndexedDBControlTest::kGetFilePathForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::GetFilePathForTesting";
      case messages::IndexedDBControlTest::kResetCachesForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::ResetCachesForTesting";
      case messages::IndexedDBControlTest::kGetPathForBlobForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::GetPathForBlobForTesting";
      case messages::IndexedDBControlTest::kFlushBackingStoreForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::FlushBackingStoreForTesting";
      case messages::IndexedDBControlTest::kGetSchedulingPriorityForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::GetSchedulingPriorityForTesting";
      case messages::IndexedDBControlTest::kGetUsageForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::GetUsageForTesting";
      case messages::IndexedDBControlTest::kBindMockFailureSingletonForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::BindMockFailureSingletonForTesting";
      case messages::IndexedDBControlTest::kForceInitializeFromFilesForTesting:
            return "Receive reply storage::mojom::IndexedDBControlTest::ForceInitializeFromFilesForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IndexedDBControlTest::GetBaseDataPathForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1a8aab3;  // IPCStableHash for storage::mojom::IndexedDBControlTest::GetBaseDataPathForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControlTest::GetFilePathForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe559f02b;  // IPCStableHash for storage::mojom::IndexedDBControlTest::GetFilePathForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControlTest::ResetCachesForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0493a734;  // IPCStableHash for storage::mojom::IndexedDBControlTest::ResetCachesForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControlTest::GetPathForBlobForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2f763b6;  // IPCStableHash for storage::mojom::IndexedDBControlTest::GetPathForBlobForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControlTest::FlushBackingStoreForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61106a2a;  // IPCStableHash for storage::mojom::IndexedDBControlTest::FlushBackingStoreForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControlTest::GetSchedulingPriorityForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x26986b7f;  // IPCStableHash for storage::mojom::IndexedDBControlTest::GetSchedulingPriorityForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControlTest::GetUsageForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe28c7490;  // IPCStableHash for storage::mojom::IndexedDBControlTest::GetUsageForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControlTest::BindMockFailureSingletonForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6c7a45c8;  // IPCStableHash for storage::mojom::IndexedDBControlTest::BindMockFailureSingletonForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControlTest::ForceInitializeFromFilesForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4a73ca2;  // IPCStableHash for storage::mojom::IndexedDBControlTest::ForceInitializeFromFilesForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback(
      IndexedDBControlTest::GetBaseDataPathForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback(const IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback&) = delete;
  IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback& operator=(const IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetBaseDataPathForTestingCallback callback_;
};

class IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback(
      IndexedDBControlTest::GetFilePathForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback(const IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback&) = delete;
  IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback& operator=(const IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetFilePathForTestingCallback callback_;
};

class IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback(
      IndexedDBControlTest::ResetCachesForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback(const IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback&) = delete;
  IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback& operator=(const IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::ResetCachesForTestingCallback callback_;
};

class IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback(
      IndexedDBControlTest::GetPathForBlobForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback(const IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback&) = delete;
  IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback& operator=(const IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetPathForBlobForTestingCallback callback_;
};

class IndexedDBControlTest_FlushBackingStoreForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_FlushBackingStoreForTesting_ForwardToCallback(
      IndexedDBControlTest::FlushBackingStoreForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControlTest_FlushBackingStoreForTesting_ForwardToCallback(const IndexedDBControlTest_FlushBackingStoreForTesting_ForwardToCallback&) = delete;
  IndexedDBControlTest_FlushBackingStoreForTesting_ForwardToCallback& operator=(const IndexedDBControlTest_FlushBackingStoreForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::FlushBackingStoreForTestingCallback callback_;
};

class IndexedDBControlTest_GetSchedulingPriorityForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetSchedulingPriorityForTesting_ForwardToCallback(
      IndexedDBControlTest::GetSchedulingPriorityForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControlTest_GetSchedulingPriorityForTesting_ForwardToCallback(const IndexedDBControlTest_GetSchedulingPriorityForTesting_ForwardToCallback&) = delete;
  IndexedDBControlTest_GetSchedulingPriorityForTesting_ForwardToCallback& operator=(const IndexedDBControlTest_GetSchedulingPriorityForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetSchedulingPriorityForTestingCallback callback_;
};

class IndexedDBControlTest_GetUsageForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetUsageForTesting_ForwardToCallback(
      IndexedDBControlTest::GetUsageForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControlTest_GetUsageForTesting_ForwardToCallback(const IndexedDBControlTest_GetUsageForTesting_ForwardToCallback&) = delete;
  IndexedDBControlTest_GetUsageForTesting_ForwardToCallback& operator=(const IndexedDBControlTest_GetUsageForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetUsageForTestingCallback callback_;
};

class IndexedDBControlTest_ForceInitializeFromFilesForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_ForceInitializeFromFilesForTesting_ForwardToCallback(
      IndexedDBControlTest::ForceInitializeFromFilesForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControlTest_ForceInitializeFromFilesForTesting_ForwardToCallback(const IndexedDBControlTest_ForceInitializeFromFilesForTesting_ForwardToCallback&) = delete;
  IndexedDBControlTest_ForceInitializeFromFilesForTesting_ForwardToCallback& operator=(const IndexedDBControlTest_ForceInitializeFromFilesForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::ForceInitializeFromFilesForTestingCallback callback_;
};

IndexedDBControlTestProxy::IndexedDBControlTestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBControlTestProxy::GetBaseDataPathForTesting(
    GetBaseDataPathForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::IndexedDBControlTest::GetBaseDataPathForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetBaseDataPathForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetBaseDataPathForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlTestProxy::GetFilePathForTesting(
    const ::storage::BucketLocator& in_bucket_locator, GetFilePathForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControlTest::GetFilePathForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetFilePathForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetFilePathForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
    in_bucket_locator,
    bucket_locator_fragment);

  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_locator.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_locator in IndexedDBControlTest.GetFilePathForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetFilePathForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlTestProxy::ResetCachesForTesting(
    ResetCachesForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::IndexedDBControlTest::ResetCachesForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kResetCachesForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_ResetCachesForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("ResetCachesForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlTestProxy::GetPathForBlobForTesting(
    const ::storage::BucketLocator& in_bucket_locator, int64_t in_database_id, int64_t in_blob_number, GetPathForBlobForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControlTest::GetPathForBlobForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_id"), in_database_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob_number"), in_blob_number,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetPathForBlobForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
    in_bucket_locator,
    bucket_locator_fragment);

  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_locator.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_locator in IndexedDBControlTest.GetPathForBlobForTesting request");

  params->database_id = in_database_id;

  params->blob_number = in_blob_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetPathForBlobForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlTestProxy::FlushBackingStoreForTesting(
    const ::storage::BucketLocator& in_bucket_locator, FlushBackingStoreForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControlTest::FlushBackingStoreForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kFlushBackingStoreForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_FlushBackingStoreForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
    in_bucket_locator,
    bucket_locator_fragment);

  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_locator.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_locator in IndexedDBControlTest.FlushBackingStoreForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("FlushBackingStoreForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_FlushBackingStoreForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlTestProxy::GetSchedulingPriorityForTesting(
    GetSchedulingPriorityForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::IndexedDBControlTest::GetSchedulingPriorityForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetSchedulingPriorityForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetSchedulingPriorityForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetSchedulingPriorityForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetSchedulingPriorityForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlTestProxy::GetUsageForTesting(
    GetUsageForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::IndexedDBControlTest::GetUsageForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetUsageForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetUsageForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetUsageForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetUsageForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlTestProxy::BindMockFailureSingletonForTesting(
    ::mojo::PendingReceiver<MockFailureInjector> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControlTest::BindMockFailureSingletonForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<MockFailureInjector>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kBindMockFailureSingletonForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::MockFailureInjectorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in IndexedDBControlTest.BindMockFailureSingletonForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("BindMockFailureSingletonForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IndexedDBControlTestProxy::ForceInitializeFromFilesForTesting(
    ForceInitializeFromFilesForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::IndexedDBControlTest::ForceInitializeFromFilesForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kForceInitializeFromFilesForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_ForceInitializeFromFilesForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("ForceInitializeFromFilesForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_ForceInitializeFromFilesForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControlTest::GetBaseDataPathForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetBaseDataPathForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_path);
};

bool IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControlTest.0
  bool success = true;
  ::base::FilePath p_path{};
  IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_path));
  }
  return true;
}

void IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder::Run(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBControlTest::GetBaseDataPathForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetBaseDataPathForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetBaseDataPathForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControlTest::GetFilePathForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetFilePathForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_path);
};

bool IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControlTest.1
  bool success = true;
  ::base::FilePath p_path{};
  IndexedDBControlTest_GetFilePathForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_path));
  }
  return true;
}

void IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder::Run(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBControlTest::GetFilePathForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetFilePathForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetFilePathForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControlTest::ResetCachesForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::ResetCachesForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControlTest.2
  bool success = true;
  IndexedDBControlTest_ResetCachesForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::IndexedDBControlTest::ResetCachesForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kResetCachesForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("ResetCachesForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControlTest::GetPathForBlobForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetPathForBlobForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_path);
};

bool IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControlTest.3
  bool success = true;
  ::base::FilePath p_path{};
  IndexedDBControlTest_GetPathForBlobForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_path));
  }
  return true;
}

void IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder::Run(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBControlTest::GetPathForBlobForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetPathForBlobForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetPathForBlobForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_FlushBackingStoreForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControlTest::FlushBackingStoreForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControlTest_FlushBackingStoreForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_FlushBackingStoreForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControlTest_FlushBackingStoreForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_FlushBackingStoreForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControlTest_FlushBackingStoreForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::FlushBackingStoreForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool IndexedDBControlTest_FlushBackingStoreForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_FlushBackingStoreForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_FlushBackingStoreForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControlTest.4
  bool success = true;
  IndexedDBControlTest_FlushBackingStoreForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void IndexedDBControlTest_FlushBackingStoreForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::IndexedDBControlTest::FlushBackingStoreForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kFlushBackingStoreForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_FlushBackingStoreForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("FlushBackingStoreForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetSchedulingPriorityForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControlTest::GetSchedulingPriorityForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControlTest_GetSchedulingPriorityForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetSchedulingPriorityForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControlTest_GetSchedulingPriorityForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetSchedulingPriorityForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControlTest_GetSchedulingPriorityForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetSchedulingPriorityForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<int32_t> in_priority);
};

bool IndexedDBControlTest_GetSchedulingPriorityForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetSchedulingPriorityForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetSchedulingPriorityForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControlTest.5
  bool success = true;
  std::optional<int32_t> p_priority{};
  IndexedDBControlTest_GetSchedulingPriorityForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_priority = input_data_view.priority();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_priority));
  }
  return true;
}

void IndexedDBControlTest_GetSchedulingPriorityForTesting_ProxyToResponder::Run(
    std::optional<int32_t> in_priority) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBControlTest::GetSchedulingPriorityForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type std::optional<int32_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetSchedulingPriorityForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetSchedulingPriorityForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->priority_$flag = in_priority.has_value();
  if (in_priority.has_value()) {
    params->priority_$value = in_priority.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetSchedulingPriorityForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetUsageForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControlTest::GetUsageForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControlTest_GetUsageForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetUsageForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControlTest_GetUsageForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetUsageForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControlTest_GetUsageForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetUsageForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_total_usage);
};

bool IndexedDBControlTest_GetUsageForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetUsageForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetUsageForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControlTest.6
  bool success = true;
  int64_t p_total_usage{};
  IndexedDBControlTest_GetUsageForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_total_usage = input_data_view.total_usage();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_total_usage));
  }
  return true;
}

void IndexedDBControlTest_GetUsageForTesting_ProxyToResponder::Run(
    int64_t in_total_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBControlTest::GetUsageForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_usage"), in_total_usage,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kGetUsageForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetUsageForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->total_usage = in_total_usage;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetUsageForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_ForceInitializeFromFilesForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControlTest::ForceInitializeFromFilesForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControlTest_ForceInitializeFromFilesForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_ForceInitializeFromFilesForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControlTest_ForceInitializeFromFilesForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_ForceInitializeFromFilesForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControlTest_ForceInitializeFromFilesForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::ForceInitializeFromFilesForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool IndexedDBControlTest_ForceInitializeFromFilesForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_ForceInitializeFromFilesForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_ForceInitializeFromFilesForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControlTest.8
  bool success = true;
  IndexedDBControlTest_ForceInitializeFromFilesForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void IndexedDBControlTest_ForceInitializeFromFilesForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::IndexedDBControlTest::ForceInitializeFromFilesForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControlTest::kForceInitializeFromFilesForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_ForceInitializeFromFilesForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("ForceInitializeFromFilesForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IndexedDBControlTestStubDispatch::Accept(
    IndexedDBControlTest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IndexedDBControlTest>(message->header()->name)) {
    case messages::IndexedDBControlTest::kGetBaseDataPathForTesting: {
      break;
    }
    case messages::IndexedDBControlTest::kGetFilePathForTesting: {
      break;
    }
    case messages::IndexedDBControlTest::kResetCachesForTesting: {
      break;
    }
    case messages::IndexedDBControlTest::kGetPathForBlobForTesting: {
      break;
    }
    case messages::IndexedDBControlTest::kFlushBackingStoreForTesting: {
      break;
    }
    case messages::IndexedDBControlTest::kGetSchedulingPriorityForTesting: {
      break;
    }
    case messages::IndexedDBControlTest::kGetUsageForTesting: {
      break;
    }
    case messages::IndexedDBControlTest::kBindMockFailureSingletonForTesting: {
      DCHECK(message->is_serialized());
      internal::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IndexedDBControlTest.7
      bool success = true;
      ::mojo::PendingReceiver<MockFailureInjector> p_receiver{};
      IndexedDBControlTest_BindMockFailureSingletonForTesting_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMockFailureSingletonForTesting(        
        std::move(p_receiver));
      return true;
    }
    case messages::IndexedDBControlTest::kForceInitializeFromFilesForTesting: {
      break;
    }
  }
  return false;
}

// static
bool IndexedDBControlTestStubDispatch::AcceptWithResponder(
    IndexedDBControlTest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IndexedDBControlTest>(message->header()->name)) {
    case messages::IndexedDBControlTest::kGetBaseDataPathForTesting: {
      internal::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControlTest.0
      bool success = true;
      IndexedDBControlTest_GetBaseDataPathForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 0, false);
        return false;
      }
      auto callback =
          IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBaseDataPathForTesting(std::move(callback));
      return true;
    }
    case messages::IndexedDBControlTest::kGetFilePathForTesting: {
      internal::IndexedDBControlTest_GetFilePathForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetFilePathForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControlTest.1
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      IndexedDBControlTest_GetFilePathForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 1, false);
        return false;
      }
      auto callback =
          IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFilePathForTesting(        
        std::move(p_bucket_locator), std::move(callback));
      return true;
    }
    case messages::IndexedDBControlTest::kResetCachesForTesting: {
      internal::IndexedDBControlTest_ResetCachesForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_ResetCachesForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControlTest.2
      bool success = true;
      IndexedDBControlTest_ResetCachesForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 2, false);
        return false;
      }
      auto callback =
          IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetCachesForTesting(std::move(callback));
      return true;
    }
    case messages::IndexedDBControlTest::kGetPathForBlobForTesting: {
      internal::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControlTest.3
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      int64_t p_database_id{};
      int64_t p_blob_number{};
      IndexedDBControlTest_GetPathForBlobForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (success)
        p_database_id = input_data_view.database_id();
      if (success)
        p_blob_number = input_data_view.blob_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 3, false);
        return false;
      }
      auto callback =
          IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPathForBlobForTesting(        
        std::move(p_bucket_locator), 
        std::move(p_database_id), 
        std::move(p_blob_number), std::move(callback));
      return true;
    }
    case messages::IndexedDBControlTest::kFlushBackingStoreForTesting: {
      internal::IndexedDBControlTest_FlushBackingStoreForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_FlushBackingStoreForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControlTest.4
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      IndexedDBControlTest_FlushBackingStoreForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 4, false);
        return false;
      }
      auto callback =
          IndexedDBControlTest_FlushBackingStoreForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushBackingStoreForTesting(        
        std::move(p_bucket_locator), std::move(callback));
      return true;
    }
    case messages::IndexedDBControlTest::kGetSchedulingPriorityForTesting: {
      internal::IndexedDBControlTest_GetSchedulingPriorityForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetSchedulingPriorityForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControlTest.5
      bool success = true;
      IndexedDBControlTest_GetSchedulingPriorityForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 5, false);
        return false;
      }
      auto callback =
          IndexedDBControlTest_GetSchedulingPriorityForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSchedulingPriorityForTesting(std::move(callback));
      return true;
    }
    case messages::IndexedDBControlTest::kGetUsageForTesting: {
      internal::IndexedDBControlTest_GetUsageForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetUsageForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControlTest.6
      bool success = true;
      IndexedDBControlTest_GetUsageForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 6, false);
        return false;
      }
      auto callback =
          IndexedDBControlTest_GetUsageForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsageForTesting(std::move(callback));
      return true;
    }
    case messages::IndexedDBControlTest::kBindMockFailureSingletonForTesting: {
      break;
    }
    case messages::IndexedDBControlTest::kForceInitializeFromFilesForTesting: {
      internal::IndexedDBControlTest_ForceInitializeFromFilesForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_ForceInitializeFromFilesForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControlTest.8
      bool success = true;
      IndexedDBControlTest_ForceInitializeFromFilesForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 8, false);
        return false;
      }
      auto callback =
          IndexedDBControlTest_ForceInitializeFromFilesForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceInitializeFromFilesForTesting(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBControlTestValidationInfo[] = {
    {base::to_underlying(messages::IndexedDBControlTest::kGetBaseDataPathForTesting),
     { &internal::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControlTest::kGetFilePathForTesting),
     { &internal::IndexedDBControlTest_GetFilePathForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControlTest::kResetCachesForTesting),
     { &internal::IndexedDBControlTest_ResetCachesForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControlTest::kGetPathForBlobForTesting),
     { &internal::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControlTest::kFlushBackingStoreForTesting),
     { &internal::IndexedDBControlTest_FlushBackingStoreForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_FlushBackingStoreForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControlTest::kGetSchedulingPriorityForTesting),
     { &internal::IndexedDBControlTest_GetSchedulingPriorityForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetSchedulingPriorityForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControlTest::kGetUsageForTesting),
     { &internal::IndexedDBControlTest_GetUsageForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetUsageForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControlTest::kBindMockFailureSingletonForTesting),
     { &internal::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::IndexedDBControlTest::kForceInitializeFromFilesForTesting),
     { &internal::IndexedDBControlTest_ForceInitializeFromFilesForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_ForceInitializeFromFilesForTesting_ResponseParams_Data::Validate}},
};

bool IndexedDBControlTestRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::storage::mojom::IndexedDBControlTest::Name_,
    kIndexedDBControlTestValidationInfo);
}

bool IndexedDBControlTestResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::storage::mojom::IndexedDBControlTest::Name_,
    kIndexedDBControlTestValidationInfo);

}


}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void MockFailureInjectorInterceptorForTesting::FailOperation(FailClass failure_class, FailMethod failure_method, int32_t instance_num, int32_t call_num) {
  GetForwardingInterface()->FailOperation(
    std::move(failure_class)
    , 
    std::move(failure_method)
    , 
    std::move(instance_num)
    , 
    std::move(call_num)
    );
}
MockFailureInjectorAsyncWaiter::MockFailureInjectorAsyncWaiter(
    MockFailureInjector* proxy) : proxy_(proxy) {}

MockFailureInjectorAsyncWaiter::~MockFailureInjectorAsyncWaiter() = default;





void IndexedDBControlTestInterceptorForTesting::GetBaseDataPathForTesting(GetBaseDataPathForTestingCallback callback) {
  GetForwardingInterface()->GetBaseDataPathForTesting(std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::GetFilePathForTesting(const ::storage::BucketLocator& bucket_locator, GetFilePathForTestingCallback callback) {
  GetForwardingInterface()->GetFilePathForTesting(
    std::move(bucket_locator)
    , std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::ResetCachesForTesting(ResetCachesForTestingCallback callback) {
  GetForwardingInterface()->ResetCachesForTesting(std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::GetPathForBlobForTesting(const ::storage::BucketLocator& bucket_locator, int64_t database_id, int64_t blob_number, GetPathForBlobForTestingCallback callback) {
  GetForwardingInterface()->GetPathForBlobForTesting(
    std::move(bucket_locator)
    , 
    std::move(database_id)
    , 
    std::move(blob_number)
    , std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::FlushBackingStoreForTesting(const ::storage::BucketLocator& bucket_locator, FlushBackingStoreForTestingCallback callback) {
  GetForwardingInterface()->FlushBackingStoreForTesting(
    std::move(bucket_locator)
    , std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::GetSchedulingPriorityForTesting(GetSchedulingPriorityForTestingCallback callback) {
  GetForwardingInterface()->GetSchedulingPriorityForTesting(std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::GetUsageForTesting(GetUsageForTestingCallback callback) {
  GetForwardingInterface()->GetUsageForTesting(std::move(callback));
}
void IndexedDBControlTestInterceptorForTesting::BindMockFailureSingletonForTesting(::mojo::PendingReceiver<MockFailureInjector> receiver) {
  GetForwardingInterface()->BindMockFailureSingletonForTesting(
    std::move(receiver)
    );
}
void IndexedDBControlTestInterceptorForTesting::ForceInitializeFromFilesForTesting(ForceInitializeFromFilesForTestingCallback callback) {
  GetForwardingInterface()->ForceInitializeFromFilesForTesting(std::move(callback));
}
IndexedDBControlTestAsyncWaiter::IndexedDBControlTestAsyncWaiter(
    IndexedDBControlTest* proxy) : proxy_(proxy) {}

IndexedDBControlTestAsyncWaiter::~IndexedDBControlTestAsyncWaiter() = default;


void IndexedDBControlTestAsyncWaiter::GetBaseDataPathForTesting(
    ::base::FilePath* out_path) {
  base::RunLoop loop;
  proxy_->GetBaseDataPathForTesting(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_path
,
             const ::base::FilePath& path) {*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_path));
  loop.Run();
}

::base::FilePath IndexedDBControlTestAsyncWaiter::GetBaseDataPathForTesting(
    ) {
  ::base::FilePath async_wait_result;
  GetBaseDataPathForTesting(&async_wait_result);
  return async_wait_result;
}

void IndexedDBControlTestAsyncWaiter::GetFilePathForTesting(
    const ::storage::BucketLocator& bucket_locator, ::base::FilePath* out_path) {
  base::RunLoop loop;
  proxy_->GetFilePathForTesting(
      std::move(bucket_locator),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_path
,
             const ::base::FilePath& path) {*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_path));
  loop.Run();
}

::base::FilePath IndexedDBControlTestAsyncWaiter::GetFilePathForTesting(
    const ::storage::BucketLocator& bucket_locator) {
  ::base::FilePath async_wait_result;
  GetFilePathForTesting(std::move(bucket_locator),&async_wait_result);
  return async_wait_result;
}

void IndexedDBControlTestAsyncWaiter::ResetCachesForTesting(
    ) {
  base::RunLoop loop;
  proxy_->ResetCachesForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void IndexedDBControlTestAsyncWaiter::GetPathForBlobForTesting(
    const ::storage::BucketLocator& bucket_locator, int64_t database_id, int64_t blob_number, ::base::FilePath* out_path) {
  base::RunLoop loop;
  proxy_->GetPathForBlobForTesting(
      std::move(bucket_locator),
      std::move(database_id),
      std::move(blob_number),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_path
,
             const ::base::FilePath& path) {*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_path));
  loop.Run();
}

::base::FilePath IndexedDBControlTestAsyncWaiter::GetPathForBlobForTesting(
    const ::storage::BucketLocator& bucket_locator, int64_t database_id, int64_t blob_number) {
  ::base::FilePath async_wait_result;
  GetPathForBlobForTesting(std::move(bucket_locator),std::move(database_id),std::move(blob_number),&async_wait_result);
  return async_wait_result;
}

void IndexedDBControlTestAsyncWaiter::FlushBackingStoreForTesting(
    const ::storage::BucketLocator& bucket_locator) {
  base::RunLoop loop;
  proxy_->FlushBackingStoreForTesting(
      std::move(bucket_locator),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void IndexedDBControlTestAsyncWaiter::GetSchedulingPriorityForTesting(
    std::optional<int32_t>* out_priority) {
  base::RunLoop loop;
  proxy_->GetSchedulingPriorityForTesting(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<int32_t>* out_priority
,
             std::optional<int32_t> priority) {*out_priority = std::move(priority);
            loop->Quit();
          },
          &loop,
          out_priority));
  loop.Run();
}

std::optional<int32_t> IndexedDBControlTestAsyncWaiter::GetSchedulingPriorityForTesting(
    ) {
  std::optional<int32_t> async_wait_result;
  GetSchedulingPriorityForTesting(&async_wait_result);
  return async_wait_result;
}

void IndexedDBControlTestAsyncWaiter::GetUsageForTesting(
    int64_t* out_total_usage) {
  base::RunLoop loop;
  proxy_->GetUsageForTesting(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_total_usage
,
             int64_t total_usage) {*out_total_usage = std::move(total_usage);
            loop->Quit();
          },
          &loop,
          out_total_usage));
  loop.Run();
}

int64_t IndexedDBControlTestAsyncWaiter::GetUsageForTesting(
    ) {
  int64_t async_wait_result;
  GetUsageForTesting(&async_wait_result);
  return async_wait_result;
}

void IndexedDBControlTestAsyncWaiter::ForceInitializeFromFilesForTesting(
    ) {
  base::RunLoop loop;
  proxy_->ForceInitializeFromFilesForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif