// content/browser/indexed_db/indexed_db_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_DATA_VIEW_H_
#define CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/browser/indexed_db/indexed_db_internals.mojom-shared-internal.h"
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared.h"
#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared.h"
#include "components/services/storage/public/mojom/buckets/bucket_id.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"


namespace storage::mojom {
class IdbPartitionMetadataDataView;



}  // storage::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::IdbPartitionMetadataDataView> {
  using Data = ::storage::mojom::internal::IdbPartitionMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {
// Interface base classes. They are used for type safety check.
class IdbInternalsHandlerInterfaceBase {};

using IdbInternalsHandlerPtrDataView =
    mojo::InterfacePtrDataView<IdbInternalsHandlerInterfaceBase>;
using IdbInternalsHandlerRequestDataView =
    mojo::InterfaceRequestDataView<IdbInternalsHandlerInterfaceBase>;
using IdbInternalsHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IdbInternalsHandlerInterfaceBase>;
using IdbInternalsHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IdbInternalsHandlerInterfaceBase>;


class IdbPartitionMetadataDataView {
 public:
  IdbPartitionMetadataDataView() = default;

  IdbPartitionMetadataDataView(
      internal::IdbPartitionMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPartitionPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionPath(UserType* output) {
    
    auto* pointer = data_->partition_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetOriginListDataView(
      mojo::ArrayDataView<::storage::mojom::IdbOriginMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginList(UserType* output) {
    
    auto* pointer = data_->origin_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::IdbOriginMetadataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IdbPartitionMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // storage::mojom

#endif  // CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_DATA_VIEW_H_