// content/common/thread_type_switcher.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/thread_type_switcher.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/thread_type_switcher.mojom-params-data.h"
#include "content/common/thread_type_switcher.mojom-shared-message-ids.h"

#include "content/common/thread_type_switcher.mojom-import-headers.h"
#include "content/common/thread_type_switcher.mojom-test-utils.h"


namespace content::mojom {
// The declaration includes the definition on other builds.

ThreadTypeSwitcher::IPCStableHashFunction ThreadTypeSwitcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ThreadTypeSwitcher>(message.name())) {
    case messages::ThreadTypeSwitcher::kSetThreadType: {
      return &ThreadTypeSwitcher::SetThreadType_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ThreadTypeSwitcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ThreadTypeSwitcher>(message.name())) {
      case messages::ThreadTypeSwitcher::kSetThreadType:
            return "Receive content::mojom::ThreadTypeSwitcher::SetThreadType";
    }
  } else {
    switch (static_cast<messages::ThreadTypeSwitcher>(message.name())) {
      case messages::ThreadTypeSwitcher::kSetThreadType:
            return "Receive reply content::mojom::ThreadTypeSwitcher::SetThreadType";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ThreadTypeSwitcher::SetThreadType_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4915e9d1;  // IPCStableHash for content::mojom::ThreadTypeSwitcher::SetThreadType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ThreadTypeSwitcherProxy::ThreadTypeSwitcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ThreadTypeSwitcherProxy::SetThreadType(
    int32_t in_platform_thread_id, ::base::ThreadType in_thread_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ThreadTypeSwitcher::SetThreadType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform_thread_id"), in_platform_thread_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thread_type"), in_thread_type,
                        "<value of type ::base::ThreadType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThreadTypeSwitcher::kSetThreadType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ThreadTypeSwitcher_SetThreadType_Params_Data> params(
          message);
  params.Allocate();

  params->platform_thread_id = in_platform_thread_id;

  
  mojo::internal::Serialize<::mojo_base::mojom::ThreadType>(
    in_thread_type,
    &params->thread_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThreadTypeSwitcher::Name_);
  message.set_method_name("SetThreadType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ThreadTypeSwitcherStubDispatch::Accept(
    ThreadTypeSwitcher* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ThreadTypeSwitcher>(message->header()->name)) {
    case messages::ThreadTypeSwitcher::kSetThreadType: {
      DCHECK(message->is_serialized());
      internal::ThreadTypeSwitcher_SetThreadType_Params_Data* params =
          reinterpret_cast<internal::ThreadTypeSwitcher_SetThreadType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThreadTypeSwitcher.0
      bool success = true;
      int32_t p_platform_thread_id{};
      ::base::ThreadType p_thread_type{};
      ThreadTypeSwitcher_SetThreadType_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_platform_thread_id = input_data_view.platform_thread_id();
      if (success && !input_data_view.ReadThreadType(&p_thread_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThreadTypeSwitcher::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetThreadType(        
        std::move(p_platform_thread_id), 
        std::move(p_thread_type));
      return true;
    }
  }
  return false;
}

// static
bool ThreadTypeSwitcherStubDispatch::AcceptWithResponder(
    ThreadTypeSwitcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ThreadTypeSwitcher>(message->header()->name)) {
    case messages::ThreadTypeSwitcher::kSetThreadType: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kThreadTypeSwitcherValidationInfo[] = {
    {base::to_underlying(messages::ThreadTypeSwitcher::kSetThreadType),
     { &internal::ThreadTypeSwitcher_SetThreadType_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ThreadTypeSwitcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::ThreadTypeSwitcher::Name_,
    kThreadTypeSwitcherValidationInfo);
}



}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void ThreadTypeSwitcherInterceptorForTesting::SetThreadType(int32_t platform_thread_id, ::base::ThreadType thread_type) {
  GetForwardingInterface()->SetThreadType(
    std::move(platform_thread_id)
    , 
    std::move(thread_type)
    );
}
ThreadTypeSwitcherAsyncWaiter::ThreadTypeSwitcherAsyncWaiter(
    ThreadTypeSwitcher* proxy) : proxy_(proxy) {}

ThreadTypeSwitcherAsyncWaiter::~ThreadTypeSwitcherAsyncWaiter() = default;







}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif