// extensions/common/mojom/stack_frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/stack_frame.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/stack_frame.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/stack_frame.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>




#include "extensions/common/mojom/stack_frame_mojom_traits.h"




namespace extensions::mojom {








class  StackFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StackFrame, T>::value>;
  using DataView = StackFrameDataView;
  using Data_ = internal::StackFrame_Data;

  template <typename... Args>
  static StackFramePtr New(Args&&... args) {
    return StackFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StackFramePtr From(const U& u) {
    return mojo::TypeConverter<StackFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StackFrame>::Convert(*this);
  }


  StackFrame();

  StackFrame(
      uint32_t line_number,
      uint32_t column_number,
      const ::std::u16string& source,
      const ::std::u16string& function);


  ~StackFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StackFramePtr>
  StackFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StackFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StackFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StackFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StackFrame::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StackFrame::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StackFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StackFrame_UnserializedMessageContext<
            UserType, StackFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StackFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StackFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StackFrame_UnserializedMessageContext<
            UserType, StackFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StackFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t line_number;
  
  uint32_t column_number;
  
  ::std::u16string source;
  
  ::std::u16string function;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StackFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StackFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StackFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StackFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StackFramePtr StackFrame::Clone() const {
  return New(
      mojo::Clone(line_number),
      mojo::Clone(column_number),
      mojo::Clone(source),
      mojo::Clone(function)
  );
}

template <typename T, StackFrame::EnableIfSame<T>*>
bool StackFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->line_number, other_struct.line_number))
    return false;
  if (!mojo::Equals(this->column_number, other_struct.column_number))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->function, other_struct.function))
    return false;
  return true;
}

template <typename T, StackFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.line_number < rhs.line_number)
    return true;
  if (rhs.line_number < lhs.line_number)
    return false;
  if (lhs.column_number < rhs.column_number)
    return true;
  if (rhs.column_number < lhs.column_number)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.function < rhs.function)
    return true;
  if (rhs.function < lhs.function)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::StackFrame::DataView,
                                         ::extensions::mojom::StackFramePtr> {
  static bool IsNull(const ::extensions::mojom::StackFramePtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::StackFramePtr* output) { output->reset(); }

  static decltype(::extensions::mojom::StackFrame::line_number) line_number(
      const ::extensions::mojom::StackFramePtr& input) {
    return input->line_number;
  }

  static decltype(::extensions::mojom::StackFrame::column_number) column_number(
      const ::extensions::mojom::StackFramePtr& input) {
    return input->column_number;
  }

  static const decltype(::extensions::mojom::StackFrame::source)& source(
      const ::extensions::mojom::StackFramePtr& input) {
    return input->source;
  }

  static const decltype(::extensions::mojom::StackFrame::function)& function(
      const ::extensions::mojom::StackFramePtr& input) {
    return input->function;
  }

  static bool Read(::extensions::mojom::StackFrame::DataView input, ::extensions::mojom::StackFramePtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_H_