// gpu/ipc/common/vulkan_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/vulkan_types.mojom-shared-internal.h"




#include "gpu/ipc/common/vulkan_types.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::gpu::mojom::VkPhysicalDeviceType>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::VkPhysicalDeviceType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::VkPhysicalDeviceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::VkPhysicalDeviceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkExtensionPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkExtensionPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkExtensionProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::extensionName(input)) in_extensionName = Traits::extensionName(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensionName)::BaseType> extensionName_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_extensionName,
      extensionName_fragment);

    fragment->extensionName.Set(
        extensionName_fragment.is_null() ? nullptr : extensionName_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extensionName.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extensionName in VkExtensionProperties struct");

    fragment->specVersion = Traits::specVersion(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkExtensionProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkExtensionPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkLayerPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkLayerPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkLayerProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::layerName(input)) in_layerName = Traits::layerName(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->layerName)::BaseType> layerName_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_layerName,
      layerName_fragment);

    fragment->layerName.Set(
        layerName_fragment.is_null() ? nullptr : layerName_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->layerName.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null layerName in VkLayerProperties struct");

    fragment->specVersion = Traits::specVersion(input);

    fragment->implementationVersion = Traits::implementationVersion(input);

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in VkLayerProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkLayerProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkLayerPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceLimitsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceLimitsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkPhysicalDeviceLimits_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->maxImageDimension1D = Traits::maxImageDimension1D(input);

    fragment->maxImageDimension2D = Traits::maxImageDimension2D(input);

    fragment->maxImageDimension3D = Traits::maxImageDimension3D(input);

    fragment->maxImageDimensionCube = Traits::maxImageDimensionCube(input);

    fragment->maxImageArrayLayers = Traits::maxImageArrayLayers(input);

    fragment->maxTexelBufferElements = Traits::maxTexelBufferElements(input);

    fragment->maxUniformBufferRange = Traits::maxUniformBufferRange(input);

    fragment->maxStorageBufferRange = Traits::maxStorageBufferRange(input);

    fragment->maxPushConstantsSize = Traits::maxPushConstantsSize(input);

    fragment->maxMemoryAllocationCount = Traits::maxMemoryAllocationCount(input);

    fragment->maxSamplerAllocationCount = Traits::maxSamplerAllocationCount(input);

    fragment->bufferImageGranularity = Traits::bufferImageGranularity(input);

    fragment->sparseAddressSpaceSize = Traits::sparseAddressSpaceSize(input);

    fragment->maxBoundDescriptorSets = Traits::maxBoundDescriptorSets(input);

    fragment->maxPerStageDescriptorSamplers = Traits::maxPerStageDescriptorSamplers(input);

    fragment->maxPerStageDescriptorUniformBuffers = Traits::maxPerStageDescriptorUniformBuffers(input);

    fragment->maxPerStageDescriptorStorageBuffers = Traits::maxPerStageDescriptorStorageBuffers(input);

    fragment->maxPerStageDescriptorSampledImages = Traits::maxPerStageDescriptorSampledImages(input);

    fragment->maxPerStageDescriptorStorageImages = Traits::maxPerStageDescriptorStorageImages(input);

    fragment->maxPerStageDescriptorInputAttachments = Traits::maxPerStageDescriptorInputAttachments(input);

    fragment->maxPerStageResources = Traits::maxPerStageResources(input);

    fragment->maxDescriptorSetSamplers = Traits::maxDescriptorSetSamplers(input);

    fragment->maxDescriptorSetUniformBuffers = Traits::maxDescriptorSetUniformBuffers(input);

    fragment->maxDescriptorSetUniformBuffersDynamic = Traits::maxDescriptorSetUniformBuffersDynamic(input);

    fragment->maxDescriptorSetStorageBuffers = Traits::maxDescriptorSetStorageBuffers(input);

    fragment->maxDescriptorSetStorageBuffersDynamic = Traits::maxDescriptorSetStorageBuffersDynamic(input);

    fragment->maxDescriptorSetSampledImages = Traits::maxDescriptorSetSampledImages(input);

    fragment->maxDescriptorSetStorageImages = Traits::maxDescriptorSetStorageImages(input);

    fragment->maxDescriptorSetInputAttachments = Traits::maxDescriptorSetInputAttachments(input);

    fragment->maxVertexInputAttributes = Traits::maxVertexInputAttributes(input);

    fragment->maxVertexInputBindings = Traits::maxVertexInputBindings(input);

    fragment->maxVertexInputAttributeOffset = Traits::maxVertexInputAttributeOffset(input);

    fragment->maxVertexInputBindingStride = Traits::maxVertexInputBindingStride(input);

    fragment->maxVertexOutputComponents = Traits::maxVertexOutputComponents(input);

    fragment->maxTessellationGenerationLevel = Traits::maxTessellationGenerationLevel(input);

    fragment->maxTessellationPatchSize = Traits::maxTessellationPatchSize(input);

    fragment->maxTessellationControlPerVertexInputComponents = Traits::maxTessellationControlPerVertexInputComponents(input);

    fragment->maxTessellationControlPerVertexOutputComponents = Traits::maxTessellationControlPerVertexOutputComponents(input);

    fragment->maxTessellationControlPerPatchOutputComponents = Traits::maxTessellationControlPerPatchOutputComponents(input);

    fragment->maxTessellationControlTotalOutputComponents = Traits::maxTessellationControlTotalOutputComponents(input);

    fragment->maxTessellationEvaluationInputComponents = Traits::maxTessellationEvaluationInputComponents(input);

    fragment->maxTessellationEvaluationOutputComponents = Traits::maxTessellationEvaluationOutputComponents(input);

    fragment->maxGeometryShaderInvocations = Traits::maxGeometryShaderInvocations(input);

    fragment->maxGeometryInputComponents = Traits::maxGeometryInputComponents(input);

    fragment->maxGeometryOutputComponents = Traits::maxGeometryOutputComponents(input);

    fragment->maxGeometryOutputVertices = Traits::maxGeometryOutputVertices(input);

    fragment->maxGeometryTotalOutputComponents = Traits::maxGeometryTotalOutputComponents(input);

    fragment->maxFragmentInputComponents = Traits::maxFragmentInputComponents(input);

    fragment->maxFragmentOutputAttachments = Traits::maxFragmentOutputAttachments(input);

    fragment->maxFragmentDualSrcAttachments = Traits::maxFragmentDualSrcAttachments(input);

    fragment->maxFragmentCombinedOutputResources = Traits::maxFragmentCombinedOutputResources(input);

    fragment->maxComputeSharedMemorySize = Traits::maxComputeSharedMemorySize(input);

    decltype(Traits::maxComputeWorkGroupCount(input)) in_maxComputeWorkGroupCount = Traits::maxComputeWorkGroupCount(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->maxComputeWorkGroupCount)::BaseType>
        maxComputeWorkGroupCount_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& maxComputeWorkGroupCount_validate_params =
        mojo::internal::GetArrayValidator<3, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_maxComputeWorkGroupCount,
      maxComputeWorkGroupCount_fragment,
      &maxComputeWorkGroupCount_validate_params);

    fragment->maxComputeWorkGroupCount.Set(
        maxComputeWorkGroupCount_fragment.is_null() ? nullptr : maxComputeWorkGroupCount_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->maxComputeWorkGroupCount.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null maxComputeWorkGroupCount in VkPhysicalDeviceLimits struct");

    fragment->maxComputeWorkGroupInvocations = Traits::maxComputeWorkGroupInvocations(input);

    decltype(Traits::maxComputeWorkGroupSize(input)) in_maxComputeWorkGroupSize = Traits::maxComputeWorkGroupSize(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->maxComputeWorkGroupSize)::BaseType>
        maxComputeWorkGroupSize_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& maxComputeWorkGroupSize_validate_params =
        mojo::internal::GetArrayValidator<3, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_maxComputeWorkGroupSize,
      maxComputeWorkGroupSize_fragment,
      &maxComputeWorkGroupSize_validate_params);

    fragment->maxComputeWorkGroupSize.Set(
        maxComputeWorkGroupSize_fragment.is_null() ? nullptr : maxComputeWorkGroupSize_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->maxComputeWorkGroupSize.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null maxComputeWorkGroupSize in VkPhysicalDeviceLimits struct");

    fragment->subPixelPrecisionBits = Traits::subPixelPrecisionBits(input);

    fragment->subTexelPrecisionBits = Traits::subTexelPrecisionBits(input);

    fragment->mipmapPrecisionBits = Traits::mipmapPrecisionBits(input);

    fragment->maxDrawIndexedIndexValue = Traits::maxDrawIndexedIndexValue(input);

    fragment->maxDrawIndirectCount = Traits::maxDrawIndirectCount(input);

    fragment->maxSamplerLodBias = Traits::maxSamplerLodBias(input);

    fragment->maxSamplerAnisotropy = Traits::maxSamplerAnisotropy(input);

    fragment->maxViewports = Traits::maxViewports(input);

    decltype(Traits::maxViewportDimensions(input)) in_maxViewportDimensions = Traits::maxViewportDimensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->maxViewportDimensions)::BaseType>
        maxViewportDimensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& maxViewportDimensions_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_maxViewportDimensions,
      maxViewportDimensions_fragment,
      &maxViewportDimensions_validate_params);

    fragment->maxViewportDimensions.Set(
        maxViewportDimensions_fragment.is_null() ? nullptr : maxViewportDimensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->maxViewportDimensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null maxViewportDimensions in VkPhysicalDeviceLimits struct");

    decltype(Traits::viewportBoundsRange(input)) in_viewportBoundsRange = Traits::viewportBoundsRange(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewportBoundsRange)::BaseType>
        viewportBoundsRange_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& viewportBoundsRange_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_viewportBoundsRange,
      viewportBoundsRange_fragment,
      &viewportBoundsRange_validate_params);

    fragment->viewportBoundsRange.Set(
        viewportBoundsRange_fragment.is_null() ? nullptr : viewportBoundsRange_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->viewportBoundsRange.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null viewportBoundsRange in VkPhysicalDeviceLimits struct");

    fragment->viewportSubPixelBits = Traits::viewportSubPixelBits(input);

    fragment->minMemoryMapAlignment = Traits::minMemoryMapAlignment(input);

    fragment->minTexelBufferOffsetAlignment = Traits::minTexelBufferOffsetAlignment(input);

    fragment->minUniformBufferOffsetAlignment = Traits::minUniformBufferOffsetAlignment(input);

    fragment->minStorageBufferOffsetAlignment = Traits::minStorageBufferOffsetAlignment(input);

    fragment->minTexelOffset = Traits::minTexelOffset(input);

    fragment->maxTexelOffset = Traits::maxTexelOffset(input);

    fragment->minTexelGatherOffset = Traits::minTexelGatherOffset(input);

    fragment->maxTexelGatherOffset = Traits::maxTexelGatherOffset(input);

    fragment->minInterpolationOffset = Traits::minInterpolationOffset(input);

    fragment->maxInterpolationOffset = Traits::maxInterpolationOffset(input);

    fragment->subPixelInterpolationOffsetBits = Traits::subPixelInterpolationOffsetBits(input);

    fragment->maxFramebufferWidth = Traits::maxFramebufferWidth(input);

    fragment->maxFramebufferHeight = Traits::maxFramebufferHeight(input);

    fragment->maxFramebufferLayers = Traits::maxFramebufferLayers(input);

    fragment->framebufferColorSampleCounts = Traits::framebufferColorSampleCounts(input);

    fragment->framebufferDepthSampleCounts = Traits::framebufferDepthSampleCounts(input);

    fragment->framebufferStencilSampleCounts = Traits::framebufferStencilSampleCounts(input);

    fragment->framebufferNoAttachmentsSampleCounts = Traits::framebufferNoAttachmentsSampleCounts(input);

    fragment->maxColorAttachments = Traits::maxColorAttachments(input);

    fragment->sampledImageColorSampleCounts = Traits::sampledImageColorSampleCounts(input);

    fragment->sampledImageIntegerSampleCounts = Traits::sampledImageIntegerSampleCounts(input);

    fragment->sampledImageDepthSampleCounts = Traits::sampledImageDepthSampleCounts(input);

    fragment->sampledImageStencilSampleCounts = Traits::sampledImageStencilSampleCounts(input);

    fragment->storageImageSampleCounts = Traits::storageImageSampleCounts(input);

    fragment->maxSampleMaskWords = Traits::maxSampleMaskWords(input);

    fragment->timestampComputeAndGraphics = Traits::timestampComputeAndGraphics(input);

    fragment->timestampPeriod = Traits::timestampPeriod(input);

    fragment->maxClipDistances = Traits::maxClipDistances(input);

    fragment->maxCullDistances = Traits::maxCullDistances(input);

    fragment->maxCombinedClipAndCullDistances = Traits::maxCombinedClipAndCullDistances(input);

    fragment->discreteQueuePriorities = Traits::discreteQueuePriorities(input);

    decltype(Traits::pointSizeRange(input)) in_pointSizeRange = Traits::pointSizeRange(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pointSizeRange)::BaseType>
        pointSizeRange_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pointSizeRange_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_pointSizeRange,
      pointSizeRange_fragment,
      &pointSizeRange_validate_params);

    fragment->pointSizeRange.Set(
        pointSizeRange_fragment.is_null() ? nullptr : pointSizeRange_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pointSizeRange.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pointSizeRange in VkPhysicalDeviceLimits struct");

    decltype(Traits::lineWidthRange(input)) in_lineWidthRange = Traits::lineWidthRange(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lineWidthRange)::BaseType>
        lineWidthRange_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& lineWidthRange_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_lineWidthRange,
      lineWidthRange_fragment,
      &lineWidthRange_validate_params);

    fragment->lineWidthRange.Set(
        lineWidthRange_fragment.is_null() ? nullptr : lineWidthRange_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lineWidthRange.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lineWidthRange in VkPhysicalDeviceLimits struct");

    fragment->pointSizeGranularity = Traits::pointSizeGranularity(input);

    fragment->lineWidthGranularity = Traits::lineWidthGranularity(input);

    fragment->strictLines = Traits::strictLines(input);

    fragment->standardSampleLocations = Traits::standardSampleLocations(input);

    fragment->optimalBufferCopyOffsetAlignment = Traits::optimalBufferCopyOffsetAlignment(input);

    fragment->optimalBufferCopyRowPitchAlignment = Traits::optimalBufferCopyRowPitchAlignment(input);

    fragment->nonCoherentAtomSize = Traits::nonCoherentAtomSize(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceLimits_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceLimitsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->residencyStandard2DBlockShape = Traits::residencyStandard2DBlockShape(input);

    fragment->residencyStandard2DMultisampleBlockShape = Traits::residencyStandard2DMultisampleBlockShape(input);

    fragment->residencyStandard3DBlockShape = Traits::residencyStandard3DBlockShape(input);

    fragment->residencyAlignedMipSize = Traits::residencyAlignedMipSize(input);

    fragment->residencyNonResidentStrict = Traits::residencyNonResidentStrict(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDevicePropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDevicePropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkPhysicalDeviceProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->apiVersion = Traits::apiVersion(input);

    fragment->driverVersion = Traits::driverVersion(input);

    fragment->vendorID = Traits::vendorID(input);

    fragment->deviceID = Traits::deviceID(input);

    
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceType>(
      Traits::deviceType(input),
      &fragment->deviceType);

    decltype(Traits::deviceName(input)) in_deviceName = Traits::deviceName(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->deviceName)::BaseType> deviceName_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_deviceName,
      deviceName_fragment);

    fragment->deviceName.Set(
        deviceName_fragment.is_null() ? nullptr : deviceName_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->deviceName.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null deviceName in VkPhysicalDeviceProperties struct");

    decltype(Traits::pipelineCacheUUID(input)) in_pipelineCacheUUID = Traits::pipelineCacheUUID(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pipelineCacheUUID)::BaseType>
        pipelineCacheUUID_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pipelineCacheUUID_validate_params =
        mojo::internal::GetArrayValidator<16, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_pipelineCacheUUID,
      pipelineCacheUUID_fragment,
      &pipelineCacheUUID_validate_params);

    fragment->pipelineCacheUUID.Set(
        pipelineCacheUUID_fragment.is_null() ? nullptr : pipelineCacheUUID_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pipelineCacheUUID.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pipelineCacheUUID in VkPhysicalDeviceProperties struct");

    decltype(Traits::limits(input)) in_limits = Traits::limits(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->limits)::BaseType> limits_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceLimitsDataView>(
      in_limits,
      limits_fragment);

    fragment->limits.Set(
        limits_fragment.is_null() ? nullptr : limits_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->limits.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null limits in VkPhysicalDeviceProperties struct");

    decltype(Traits::sparseProperties(input)) in_sparseProperties = Traits::sparseProperties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sparseProperties)::BaseType> sparseProperties_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView>(
      in_sparseProperties,
      sparseProperties_fragment);

    fragment->sparseProperties.Set(
        sparseProperties_fragment.is_null() ? nullptr : sparseProperties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sparseProperties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sparseProperties in VkPhysicalDeviceProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDevicePropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceFeaturesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceFeaturesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->robustBufferAccess = Traits::robustBufferAccess(input);

    fragment->fullDrawIndexUint32 = Traits::fullDrawIndexUint32(input);

    fragment->imageCubeArray = Traits::imageCubeArray(input);

    fragment->independentBlend = Traits::independentBlend(input);

    fragment->geometryShader = Traits::geometryShader(input);

    fragment->tessellationShader = Traits::tessellationShader(input);

    fragment->sampleRateShading = Traits::sampleRateShading(input);

    fragment->dualSrcBlend = Traits::dualSrcBlend(input);

    fragment->logicOp = Traits::logicOp(input);

    fragment->multiDrawIndirect = Traits::multiDrawIndirect(input);

    fragment->drawIndirectFirstInstance = Traits::drawIndirectFirstInstance(input);

    fragment->depthClamp = Traits::depthClamp(input);

    fragment->depthBiasClamp = Traits::depthBiasClamp(input);

    fragment->fillModeNonSolid = Traits::fillModeNonSolid(input);

    fragment->depthBounds = Traits::depthBounds(input);

    fragment->wideLines = Traits::wideLines(input);

    fragment->largePoints = Traits::largePoints(input);

    fragment->alphaToOne = Traits::alphaToOne(input);

    fragment->multiViewport = Traits::multiViewport(input);

    fragment->samplerAnisotropy = Traits::samplerAnisotropy(input);

    fragment->textureCompressionETC2 = Traits::textureCompressionETC2(input);

    fragment->textureCompressionASTC_LDR = Traits::textureCompressionASTC_LDR(input);

    fragment->textureCompressionBC = Traits::textureCompressionBC(input);

    fragment->occlusionQueryPrecise = Traits::occlusionQueryPrecise(input);

    fragment->pipelineStatisticsQuery = Traits::pipelineStatisticsQuery(input);

    fragment->vertexPipelineStoresAndAtomics = Traits::vertexPipelineStoresAndAtomics(input);

    fragment->fragmentStoresAndAtomics = Traits::fragmentStoresAndAtomics(input);

    fragment->shaderTessellationAndGeometryPointSize = Traits::shaderTessellationAndGeometryPointSize(input);

    fragment->shaderImageGatherExtended = Traits::shaderImageGatherExtended(input);

    fragment->shaderStorageImageExtendedFormats = Traits::shaderStorageImageExtendedFormats(input);

    fragment->shaderStorageImageMultisample = Traits::shaderStorageImageMultisample(input);

    fragment->shaderStorageImageReadWithoutFormat = Traits::shaderStorageImageReadWithoutFormat(input);

    fragment->shaderStorageImageWriteWithoutFormat = Traits::shaderStorageImageWriteWithoutFormat(input);

    fragment->shaderUniformBufferArrayDynamicIndexing = Traits::shaderUniformBufferArrayDynamicIndexing(input);

    fragment->shaderSampledImageArrayDynamicIndexing = Traits::shaderSampledImageArrayDynamicIndexing(input);

    fragment->shaderStorageBufferArrayDynamicIndexing = Traits::shaderStorageBufferArrayDynamicIndexing(input);

    fragment->shaderStorageImageArrayDynamicIndexing = Traits::shaderStorageImageArrayDynamicIndexing(input);

    fragment->shaderClipDistance = Traits::shaderClipDistance(input);

    fragment->shaderCullDistance = Traits::shaderCullDistance(input);

    fragment->shaderFloat64 = Traits::shaderFloat64(input);

    fragment->shaderInt64 = Traits::shaderInt64(input);

    fragment->shaderInt16 = Traits::shaderInt16(input);

    fragment->shaderResourceResidency = Traits::shaderResourceResidency(input);

    fragment->shaderResourceMinLod = Traits::shaderResourceMinLod(input);

    fragment->sparseBinding = Traits::sparseBinding(input);

    fragment->sparseResidencyBuffer = Traits::sparseResidencyBuffer(input);

    fragment->sparseResidencyImage2D = Traits::sparseResidencyImage2D(input);

    fragment->sparseResidencyImage3D = Traits::sparseResidencyImage3D(input);

    fragment->sparseResidency2Samples = Traits::sparseResidency2Samples(input);

    fragment->sparseResidency4Samples = Traits::sparseResidency4Samples(input);

    fragment->sparseResidency8Samples = Traits::sparseResidency8Samples(input);

    fragment->sparseResidency16Samples = Traits::sparseResidency16Samples(input);

    fragment->sparseResidencyAliased = Traits::sparseResidencyAliased(input);

    fragment->variableMultisampleRate = Traits::variableMultisampleRate(input);

    fragment->inheritedQueries = Traits::inheritedQueries(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceFeaturesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkExtent3DDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkExtent3DDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkExtent3D_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->width = Traits::width(input);

    fragment->height = Traits::height(input);

    fragment->depth = Traits::depth(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkExtent3D_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkExtent3DDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkQueueFamilyPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkQueueFamilyPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkQueueFamilyProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->queueFlags = Traits::queueFlags(input);

    fragment->queueCount = Traits::queueCount(input);

    fragment->timestampValidBits = Traits::timestampValidBits(input);

    decltype(Traits::minImageTransferGranularity(input)) in_minImageTransferGranularity = Traits::minImageTransferGranularity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->minImageTransferGranularity)::BaseType> minImageTransferGranularity_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::VkExtent3DDataView>(
      in_minImageTransferGranularity,
      minImageTransferGranularity_fragment);

    fragment->minImageTransferGranularity.Set(
        minImageTransferGranularity_fragment.is_null() ? nullptr : minImageTransferGranularity_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->minImageTransferGranularity.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null minImageTransferGranularity in VkQueueFamilyProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkQueueFamilyProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkQueueFamilyPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void VkExtensionPropertiesDataView::GetExtensionNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extensionName.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void VkLayerPropertiesDataView::GetLayerNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->layerName.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VkLayerPropertiesDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void VkPhysicalDeviceLimitsDataView::GetMaxComputeWorkGroupCountDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxComputeWorkGroupCount.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetMaxComputeWorkGroupSizeDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxComputeWorkGroupSize.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetMaxViewportDimensionsDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxViewportDimensions.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetViewportBoundsRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->viewportBoundsRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetPointSizeRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->pointSizeRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetLineWidthRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->lineWidthRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}




inline void VkPhysicalDevicePropertiesDataView::GetDeviceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->deviceName.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VkPhysicalDevicePropertiesDataView::GetPipelineCacheUuidDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->pipelineCacheUUID.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void VkPhysicalDevicePropertiesDataView::GetLimitsDataView(
    VkPhysicalDeviceLimitsDataView* output) {
  auto pointer = data_->limits.Get();
  *output = VkPhysicalDeviceLimitsDataView(pointer, message_);
}
inline void VkPhysicalDevicePropertiesDataView::GetSparsePropertiesDataView(
    VkPhysicalDeviceSparsePropertiesDataView* output) {
  auto pointer = data_->sparseProperties.Get();
  *output = VkPhysicalDeviceSparsePropertiesDataView(pointer, message_);
}






inline void VkQueueFamilyPropertiesDataView::GetMinImageTransferGranularityDataView(
    VkExtent3DDataView* output) {
  auto pointer = data_->minImageTransferGranularity.Get();
  *output = VkExtent3DDataView(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::VkPhysicalDeviceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::VkPhysicalDeviceType value);
};

} // namespace perfetto

#endif  // GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_