// media/mojo/mojom/video_encoder_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "media/mojo/mojom/video_encoder_info.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace media::mojom {
class ResolutionRateLimitDataView;

class VideoEncoderInfoDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::ResolutionRateLimitDataView> {
  using Data = ::media::mojom::internal::ResolutionRateLimit_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoEncoderInfoDataView> {
  using Data = ::media::mojom::internal::VideoEncoderInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


class ResolutionRateLimitDataView {
 public:
  ResolutionRateLimitDataView() = default;

  ResolutionRateLimitDataView(
      internal::ResolutionRateLimit_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSize(UserType* output) {
    
    auto* pointer = data_->frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  int32_t min_start_bitrate_bps() const {
    return data_->min_start_bitrate_bps;
  }
  int32_t min_bitrate_bps() const {
    return data_->min_bitrate_bps;
  }
  int32_t max_bitrate_bps() const {
    return data_->max_bitrate_bps;
  }
  uint32_t max_framerate_numerator() const {
    return data_->max_framerate_numerator;
  }
  uint32_t max_framerate_denominator() const {
    return data_->max_framerate_denominator;
  }
 private:
  internal::ResolutionRateLimit_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncoderInfoDataView {
 public:
  VideoEncoderInfoDataView() = default;

  VideoEncoderInfoDataView(
      internal::VideoEncoderInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImplementationNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImplementationName(UserType* output) {
    
    auto* pointer = data_->implementation_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_frame_delay() const {
    return data_->has_frame_delay;
  }
  int32_t frame_delay() const {
    return data_->frame_delay;
  }
  bool has_input_capacity() const {
    return data_->has_input_capacity;
  }
  int32_t input_capacity() const {
    return data_->input_capacity;
  }
  bool supports_native_handle() const {
    return data_->supports_native_handle;
  }
  bool has_trusted_rate_controller() const {
    return data_->has_trusted_rate_controller;
  }
  bool is_hardware_accelerated() const {
    return data_->is_hardware_accelerated;
  }
  bool supports_simulcast() const {
    return data_->supports_simulcast;
  }
  bool reports_average_qp() const {
    return data_->reports_average_qp;
  }
  uint32_t requested_resolution_alignment() const {
    return data_->requested_resolution_alignment;
  }
  bool apply_alignment_to_all_simulcast_layers() const {
    return data_->apply_alignment_to_all_simulcast_layers;
  }
  bool supports_frame_size_change() const {
    return data_->supports_frame_size_change;
  }
  inline void GetFpsAllocationDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFpsAllocation(UserType* output) {
    
    auto* pointer = data_->fps_allocation.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetResolutionRateLimitsDataView(
      mojo::ArrayDataView<ResolutionRateLimitDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResolutionRateLimits(UserType* output) {
    
    auto* pointer = data_->resolution_rate_limits.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::ResolutionRateLimitDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncoderInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_DATA_VIEW_H_