// mojo/public/interfaces/bindings/pipe_control_messages.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-params-data.h"
#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-shared-message-ids.h"

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-import-headers.h"
#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-test-utils.h"


namespace mojo::pipe_control {
RunOrClosePipeMessageParams::RunOrClosePipeMessageParams()
    : input() {}

RunOrClosePipeMessageParams::RunOrClosePipeMessageParams(
    RunOrClosePipeInputPtr input_in)
    : input(std::move(input_in)) {}

RunOrClosePipeMessageParams::~RunOrClosePipeMessageParams() = default;

void RunOrClosePipeMessageParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input"), this->input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RunOrClosePipeInputPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RunOrClosePipeMessageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DisconnectReason::DisconnectReason()
    : custom_reason(),
      description() {}

DisconnectReason::DisconnectReason(
    uint32_t custom_reason_in,
    const std::string& description_in)
    : custom_reason(std::move(custom_reason_in)),
      description(std::move(description_in)) {}

DisconnectReason::~DisconnectReason() = default;
size_t DisconnectReason::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->custom_reason);
  seed = mojo::internal::Hash(seed, this->description);
  return seed;
}

void DisconnectReason::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_reason"), this->custom_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisconnectReason::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PeerAssociatedEndpointClosedEvent::PeerAssociatedEndpointClosedEvent()
    : id(),
      disconnect_reason() {}

PeerAssociatedEndpointClosedEvent::PeerAssociatedEndpointClosedEvent(
    uint32_t id_in,
    DisconnectReasonPtr disconnect_reason_in)
    : id(std::move(id_in)),
      disconnect_reason(std::move(disconnect_reason_in)) {}

PeerAssociatedEndpointClosedEvent::~PeerAssociatedEndpointClosedEvent() = default;

void PeerAssociatedEndpointClosedEvent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disconnect_reason"), this->disconnect_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DisconnectReasonPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PeerAssociatedEndpointClosedEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PauseUntilFlushCompletes::PauseUntilFlushCompletes()
    : flush_pipe() {}

PauseUntilFlushCompletes::PauseUntilFlushCompletes(
    ::mojo::ScopedMessagePipeHandle flush_pipe_in)
    : flush_pipe(std::move(flush_pipe_in)) {}

PauseUntilFlushCompletes::~PauseUntilFlushCompletes() = default;

void PauseUntilFlushCompletes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flush_pipe"), this->flush_pipe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedMessagePipeHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PauseUntilFlushCompletes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FlushAsync::FlushAsync()
    : flusher_pipe() {}

FlushAsync::FlushAsync(
    ::mojo::ScopedMessagePipeHandle flusher_pipe_in)
    : flusher_pipe(std::move(flusher_pipe_in)) {}

FlushAsync::~FlushAsync() = default;

void FlushAsync::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flusher_pipe"), this->flusher_pipe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedMessagePipeHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FlushAsync::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RunOrClosePipeInputPtr
RunOrClosePipeInput::NewPeerAssociatedEndpointClosedEvent(
    PeerAssociatedEndpointClosedEventPtr value) {
  return RunOrClosePipeInputPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPeerAssociatedEndpointClosedEvent)>,
      std::move(value));
}

RunOrClosePipeInputPtr
RunOrClosePipeInput::NewPauseUntilFlushCompletes(
    PauseUntilFlushCompletesPtr value) {
  return RunOrClosePipeInputPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPauseUntilFlushCompletes)>,
      std::move(value));
}

RunOrClosePipeInputPtr
RunOrClosePipeInput::NewFlushAsync(
    FlushAsyncPtr value) {
  return RunOrClosePipeInputPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFlushAsync)>,
      std::move(value));
}

RunOrClosePipeInput::RunOrClosePipeInput(
    std::in_place_index_t<static_cast<size_t>(Tag::kPeerAssociatedEndpointClosedEvent)>,
    PeerAssociatedEndpointClosedEventPtr value)
    : tag_(Tag::kPeerAssociatedEndpointClosedEvent),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPeerAssociatedEndpointClosedEvent)>,
            std::move(value)) {}

RunOrClosePipeInput::RunOrClosePipeInput(
    std::in_place_index_t<static_cast<size_t>(Tag::kPauseUntilFlushCompletes)>,
    PauseUntilFlushCompletesPtr value)
    : tag_(Tag::kPauseUntilFlushCompletes),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPauseUntilFlushCompletes)>,
            std::move(value)) {}

RunOrClosePipeInput::RunOrClosePipeInput(
    std::in_place_index_t<static_cast<size_t>(Tag::kFlushAsync)>,
    FlushAsyncPtr value)
    : tag_(Tag::kFlushAsync),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFlushAsync)>,
            std::move(value)) {}
RunOrClosePipeInput::~RunOrClosePipeInput() {
  DestroyActive();
}

void RunOrClosePipeInput::set_peer_associated_endpoint_closed_event(PeerAssociatedEndpointClosedEventPtr peer_associated_endpoint_closed_event) {
  if (tag_ == Tag::kPeerAssociatedEndpointClosedEvent) {
    data_.peer_associated_endpoint_closed_event = std::move(peer_associated_endpoint_closed_event);
  } else {
    DestroyActive();
    tag_ = Tag::kPeerAssociatedEndpointClosedEvent;
    new (&data_.peer_associated_endpoint_closed_event) PeerAssociatedEndpointClosedEventPtr(
        std::move(peer_associated_endpoint_closed_event));
  }
}

void RunOrClosePipeInput::set_pause_until_flush_completes(PauseUntilFlushCompletesPtr pause_until_flush_completes) {
  if (tag_ == Tag::kPauseUntilFlushCompletes) {
    data_.pause_until_flush_completes = std::move(pause_until_flush_completes);
  } else {
    DestroyActive();
    tag_ = Tag::kPauseUntilFlushCompletes;
    new (&data_.pause_until_flush_completes) PauseUntilFlushCompletesPtr(
        std::move(pause_until_flush_completes));
  }
}

void RunOrClosePipeInput::set_flush_async(FlushAsyncPtr flush_async) {
  if (tag_ == Tag::kFlushAsync) {
    data_.flush_async = std::move(flush_async);
  } else {
    DestroyActive();
    tag_ = Tag::kFlushAsync;
    new (&data_.flush_async) FlushAsyncPtr(
        std::move(flush_async));
  }
}


RunOrClosePipeInput::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPeerAssociatedEndpointClosedEvent)>,
    PeerAssociatedEndpointClosedEventPtr value)
    : peer_associated_endpoint_closed_event(std::move(value)) {}

RunOrClosePipeInput::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPauseUntilFlushCompletes)>,
    PauseUntilFlushCompletesPtr value)
    : pause_until_flush_completes(std::move(value)) {}

RunOrClosePipeInput::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFlushAsync)>,
    FlushAsyncPtr value)
    : flush_async(std::move(value)) {}

void RunOrClosePipeInput::DestroyActive() {
  switch (tag_) {

    case Tag::kPeerAssociatedEndpointClosedEvent:
      std::destroy_at(&data_.peer_associated_endpoint_closed_event);
      break;
    case Tag::kPauseUntilFlushCompletes:
      std::destroy_at(&data_.pause_until_flush_completes);
      break;
    case Tag::kFlushAsync:
      std::destroy_at(&data_.flush_async);
      break;
  }
}

bool RunOrClosePipeInput::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // mojo::pipe_control


namespace mojo {


// static
bool StructTraits<::mojo::pipe_control::RunOrClosePipeMessageParams::DataView, ::mojo::pipe_control::RunOrClosePipeMessageParamsPtr>::Read(
    ::mojo::pipe_control::RunOrClosePipeMessageParams::DataView input,
    ::mojo::pipe_control::RunOrClosePipeMessageParamsPtr* output) {
  bool success = true;
  ::mojo::pipe_control::RunOrClosePipeMessageParamsPtr result(::mojo::pipe_control::RunOrClosePipeMessageParams::New());
  
      if (success && !input.ReadInput(&result->input))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojo::pipe_control::DisconnectReason::DataView, ::mojo::pipe_control::DisconnectReasonPtr>::Read(
    ::mojo::pipe_control::DisconnectReason::DataView input,
    ::mojo::pipe_control::DisconnectReasonPtr* output) {
  bool success = true;
  ::mojo::pipe_control::DisconnectReasonPtr result(::mojo::pipe_control::DisconnectReason::New());
  
      if (success)
        result->custom_reason = input.custom_reason();
      if (success && !input.ReadDescription(&result->description))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojo::pipe_control::PeerAssociatedEndpointClosedEvent::DataView, ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr>::Read(
    ::mojo::pipe_control::PeerAssociatedEndpointClosedEvent::DataView input,
    ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr* output) {
  bool success = true;
  ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr result(::mojo::pipe_control::PeerAssociatedEndpointClosedEvent::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadDisconnectReason(&result->disconnect_reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojo::pipe_control::PauseUntilFlushCompletes::DataView, ::mojo::pipe_control::PauseUntilFlushCompletesPtr>::Read(
    ::mojo::pipe_control::PauseUntilFlushCompletes::DataView input,
    ::mojo::pipe_control::PauseUntilFlushCompletesPtr* output) {
  bool success = true;
  ::mojo::pipe_control::PauseUntilFlushCompletesPtr result(::mojo::pipe_control::PauseUntilFlushCompletes::New());
  
      if (success)
        result->flush_pipe = input.TakeFlushPipe();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojo::pipe_control::FlushAsync::DataView, ::mojo::pipe_control::FlushAsyncPtr>::Read(
    ::mojo::pipe_control::FlushAsync::DataView input,
    ::mojo::pipe_control::FlushAsyncPtr* output) {
  bool success = true;
  ::mojo::pipe_control::FlushAsyncPtr result(::mojo::pipe_control::FlushAsync::New());
  
      if (success)
        result->flusher_pipe = input.TakeFlusherPipe();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::mojo::pipe_control::RunOrClosePipeInput::DataView, ::mojo::pipe_control::RunOrClosePipeInputPtr>::Read(
    ::mojo::pipe_control::RunOrClosePipeInput::DataView input,
    ::mojo::pipe_control::RunOrClosePipeInputPtr* output) {
  using UnionType = ::mojo::pipe_control::RunOrClosePipeInput;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPeerAssociatedEndpointClosedEvent: {
      ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr result_peer_associated_endpoint_closed_event{};
      if (!input.ReadPeerAssociatedEndpointClosedEvent(&result_peer_associated_endpoint_closed_event))
        return false;

      *output = UnionType::NewPeerAssociatedEndpointClosedEvent(
          std::move(result_peer_associated_endpoint_closed_event));
      break;
    }
    case Tag::kPauseUntilFlushCompletes: {
      ::mojo::pipe_control::PauseUntilFlushCompletesPtr result_pause_until_flush_completes{};
      if (!input.ReadPauseUntilFlushCompletes(&result_pause_until_flush_completes))
        return false;

      *output = UnionType::NewPauseUntilFlushCompletes(
          std::move(result_pause_until_flush_completes));
      break;
    }
    case Tag::kFlushAsync: {
      ::mojo::pipe_control::FlushAsyncPtr result_flush_async{};
      if (!input.ReadFlushAsync(&result_flush_async))
        return false;

      *output = UnionType::NewFlushAsync(
          std::move(result_flush_async));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mojo::pipe_control {




}  // mojo::pipe_control


#if defined(__clang__)
#pragma clang diagnostic pop
#endif