// qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_BROWSER_EXTENSIONS_WEBUI_EXTENSIONS_UI_QT_MOJOM_H_
#define QTWEBENGINE_BROWSER_EXTENSIONS_WEBUI_EXTENSIONS_UI_QT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-features.h"  // IWYU pragma: export
#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-shared.h"  // IWYU pragma: export
#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace qtwebengine::mojom {

class ExtensionsUIHandlerFactoryProxy;

template <typename ImplRefTraits>
class ExtensionsUIHandlerFactoryStub;

class ExtensionsUIHandlerFactoryRequestValidator;


class ExtensionsUIHandlerFactory
    : public ExtensionsUIHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "qtwebengine.mojom.ExtensionsUIHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ExtensionsUIHandlerFactoryInterfaceBase;
  using Proxy_ = ExtensionsUIHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ExtensionsUIHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ExtensionsUIHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ExtensionsUIHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "qtwebengine.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllExtensionInfoMinVersion = 0,
    kLoadExtensionMinVersion = 0,
    kInstallExtensionMinVersion = 0,
    kUninstallExtensionMinVersion = 0,
    kUnloadExtensionMinVersion = 0,
    kSetExtensionEnabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAllExtensionInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstallExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UninstallExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnloadExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetExtensionEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetAllExtensionInfoCallback = base::OnceCallback<void(std::vector<ExtensionInfoPtr>)>;
  using GetAllExtensionInfoMojoCallback = base::OnceCallback<void(std::vector<ExtensionInfoPtr>)>;

  virtual void GetAllExtensionInfo(GetAllExtensionInfoCallback callback) = 0;

  virtual void LoadExtension() = 0;

  virtual void InstallExtension() = 0;

  using UninstallExtensionCallback = base::OnceCallback<void(const std::string&)>;
  using UninstallExtensionMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void UninstallExtension(const std::string& id, UninstallExtensionCallback callback) = 0;

  using UnloadExtensionCallback = base::OnceCallback<void(const std::string&)>;
  using UnloadExtensionMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void UnloadExtension(const std::string& id, UnloadExtensionCallback callback) = 0;

  using SetExtensionEnabledCallback = base::OnceCallback<void()>;
  using SetExtensionEnabledMojoCallback = base::OnceCallback<void()>;

  virtual void SetExtensionEnabled(const std::string& id, bool isEnabled, SetExtensionEnabledCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "qtwebengine.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReloadPageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReloadPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void ReloadPage() = 0;
};



class  ExtensionsUIHandlerFactoryProxy
    : public ExtensionsUIHandlerFactory {
 public:
  using InterfaceType = ExtensionsUIHandlerFactory;

  explicit ExtensionsUIHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllExtensionInfo(GetAllExtensionInfoCallback callback) final;
  
  void LoadExtension() final;
  
  void InstallExtension() final;
  
  void UninstallExtension(const std::string& id, UninstallExtensionCallback callback) final;
  
  void UnloadExtension(const std::string& id, UnloadExtensionCallback callback) final;
  
  void SetExtensionEnabled(const std::string& id, bool isEnabled, SetExtensionEnabledCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReloadPage() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ExtensionsUIHandlerFactoryStubDispatch {
 public:
  static bool Accept(ExtensionsUIHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ExtensionsUIHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ExtensionsUIHandlerFactory>>
class ExtensionsUIHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ExtensionsUIHandlerFactoryStub() = default;
  ~ExtensionsUIHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ExtensionsUIHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ExtensionsUIHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ExtensionsUIHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  ExtensionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionInfo, T>::value>;
  using DataView = ExtensionInfoDataView;
  using Data_ = internal::ExtensionInfo_Data;

  template <typename... Args>
  static ExtensionInfoPtr New(Args&&... args) {
    return ExtensionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionInfoPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionInfo>::Convert(*this);
  }


  ExtensionInfo();

  ExtensionInfo(
      const std::string& name,
      const std::string& description,
      const std::string& version,
      const std::string& id,
      bool isEnabled,
      bool isInstalled,
      bool isLoaded);


  ~ExtensionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionInfoPtr>
  ExtensionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionInfo_UnserializedMessageContext<
            UserType, ExtensionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionInfo_UnserializedMessageContext<
            UserType, ExtensionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string description;
  
  std::string version;
  
  std::string id;
  
  bool isEnabled;
  
  bool isInstalled;
  
  bool isLoaded;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExtensionInfoPtr ExtensionInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(description),
      mojo::Clone(version),
      mojo::Clone(id),
      mojo::Clone(isEnabled),
      mojo::Clone(isInstalled),
      mojo::Clone(isLoaded)
  );
}

template <typename T, ExtensionInfo::EnableIfSame<T>*>
bool ExtensionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->isEnabled, other_struct.isEnabled))
    return false;
  if (!mojo::Equals(this->isInstalled, other_struct.isInstalled))
    return false;
  if (!mojo::Equals(this->isLoaded, other_struct.isLoaded))
    return false;
  return true;
}

template <typename T, ExtensionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.isEnabled < rhs.isEnabled)
    return true;
  if (rhs.isEnabled < lhs.isEnabled)
    return false;
  if (lhs.isInstalled < rhs.isInstalled)
    return true;
  if (rhs.isInstalled < lhs.isInstalled)
    return false;
  if (lhs.isLoaded < rhs.isLoaded)
    return true;
  if (rhs.isLoaded < lhs.isLoaded)
    return false;
  return false;
}


}  // qtwebengine::mojom

namespace mojo {


template <>
struct  StructTraits<::qtwebengine::mojom::ExtensionInfo::DataView,
                                         ::qtwebengine::mojom::ExtensionInfoPtr> {
  static bool IsNull(const ::qtwebengine::mojom::ExtensionInfoPtr& input) { return !input; }
  static void SetToNull(::qtwebengine::mojom::ExtensionInfoPtr* output) { output->reset(); }

  static const decltype(::qtwebengine::mojom::ExtensionInfo::name)& name(
      const ::qtwebengine::mojom::ExtensionInfoPtr& input) {
    return input->name;
  }

  static const decltype(::qtwebengine::mojom::ExtensionInfo::description)& description(
      const ::qtwebengine::mojom::ExtensionInfoPtr& input) {
    return input->description;
  }

  static const decltype(::qtwebengine::mojom::ExtensionInfo::version)& version(
      const ::qtwebengine::mojom::ExtensionInfoPtr& input) {
    return input->version;
  }

  static const decltype(::qtwebengine::mojom::ExtensionInfo::id)& id(
      const ::qtwebengine::mojom::ExtensionInfoPtr& input) {
    return input->id;
  }

  static decltype(::qtwebengine::mojom::ExtensionInfo::isEnabled) isEnabled(
      const ::qtwebengine::mojom::ExtensionInfoPtr& input) {
    return input->isEnabled;
  }

  static decltype(::qtwebengine::mojom::ExtensionInfo::isInstalled) isInstalled(
      const ::qtwebengine::mojom::ExtensionInfoPtr& input) {
    return input->isInstalled;
  }

  static decltype(::qtwebengine::mojom::ExtensionInfo::isLoaded) isLoaded(
      const ::qtwebengine::mojom::ExtensionInfoPtr& input) {
    return input->isLoaded;
  }

  static bool Read(::qtwebengine::mojom::ExtensionInfo::DataView input, ::qtwebengine::mojom::ExtensionInfoPtr* output);
};

}  // namespace mojo

#endif  // QTWEBENGINE_BROWSER_EXTENSIONS_WEBUI_EXTENSIONS_UI_QT_MOJOM_H_