// services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_DATA_VIEW_H_
#define SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared.h"
#include "services/network/public/mojom/network_context.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared.h"


namespace cert_verifier::mojom {
class CertVerifierCreationParamsDataView;

class ChromeRootCertInfoDataView;

class ChromeRootStoreInfoDataView;

class PlatformCertInfoDataView;

class PlatformRootStoreInfoDataView;



}  // cert_verifier::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cert_verifier::mojom::CertVerifierCreationParamsDataView> {
  using Data = ::cert_verifier::mojom::internal::CertVerifierCreationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::ChromeRootCertInfoDataView> {
  using Data = ::cert_verifier::mojom::internal::ChromeRootCertInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::ChromeRootStoreInfoDataView> {
  using Data = ::cert_verifier::mojom::internal::ChromeRootStoreInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::PlatformCertInfoDataView> {
  using Data = ::cert_verifier::mojom::internal::PlatformCertInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::PlatformRootStoreInfoDataView> {
  using Data = ::cert_verifier::mojom::internal::PlatformRootStoreInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cert_verifier::mojom {


enum class CertificateTrust : int32_t {
  
  kUnspecified = 0,
  
  kDistrusted = 1,
  
  kTrusted = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CertificateTrust value);
inline bool IsKnownEnumValue(CertificateTrust value) {
  return internal::CertificateTrust_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CertVerifierServiceFactoryInterfaceBase {};

using CertVerifierServiceFactoryPtrDataView =
    mojo::InterfacePtrDataView<CertVerifierServiceFactoryInterfaceBase>;
using CertVerifierServiceFactoryRequestDataView =
    mojo::InterfaceRequestDataView<CertVerifierServiceFactoryInterfaceBase>;
using CertVerifierServiceFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertVerifierServiceFactoryInterfaceBase>;
using CertVerifierServiceFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertVerifierServiceFactoryInterfaceBase>;


class CertVerifierCreationParamsDataView {
 public:
  CertVerifierCreationParamsDataView() = default;

  CertVerifierCreationParamsDataView(
      internal::CertVerifierCreationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInitialAdditionalCertificatesDataView(
      ::cert_verifier::mojom::AdditionalCertificatesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialAdditionalCertificates(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cert_verifier::mojom::AdditionalCertificatesDataView, UserType>(),
    "Attempting to read the optional `initial_additional_certificates` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialAdditionalCertificates` instead "
    "of `ReadInitialAdditionalCertificates if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_additional_certificates.Get();
    return mojo::internal::Deserialize<::cert_verifier::mojom::AdditionalCertificatesDataView>(
        pointer, output, message_);
  }
  bool wait_for_update() const {
    return data_->wait_for_update;
  }
  inline void GetCtPolicyDataView(
      ::network::mojom::CTPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCtPolicy(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CTPolicyDataView, UserType>(),
    "Attempting to read the optional `ct_policy` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCtPolicy` instead "
    "of `ReadCtPolicy if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ct_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CTPolicyDataView>(
        pointer, output, message_);
  }
 private:
  internal::CertVerifierCreationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChromeRootCertInfoDataView {
 public:
  ChromeRootCertInfoDataView() = default;

  ChromeRootCertInfoDataView(
      internal::ChromeRootCertInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSha256hashHexDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSha256hashHex(UserType* output) {
    
    auto* pointer = data_->sha256hash_hex.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCertDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCert(UserType* output) {
    
    auto* pointer = data_->cert.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::ChromeRootCertInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChromeRootStoreInfoDataView {
 public:
  ChromeRootStoreInfoDataView() = default;

  ChromeRootStoreInfoDataView(
      internal::ChromeRootStoreInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t version() const {
    return data_->version;
  }
  inline void GetRootCertInfoDataView(
      mojo::ArrayDataView<ChromeRootCertInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootCertInfo(UserType* output) {
    
    auto* pointer = data_->root_cert_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cert_verifier::mojom::ChromeRootCertInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ChromeRootStoreInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PlatformCertInfoDataView {
 public:
  PlatformCertInfoDataView() = default;

  PlatformCertInfoDataView(
      internal::PlatformCertInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCertDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCert(UserType* output) {
    
    auto* pointer = data_->cert.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustSetting(UserType* output) const {
    auto data_value = data_->trust_setting;
    return mojo::internal::Deserialize<::cert_verifier::mojom::CertificateTrust>(
        data_value, output);
  }
  CertificateTrust trust_setting() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cert_verifier::mojom::CertificateTrust>(data_->trust_setting));
  }
 private:
  internal::PlatformCertInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PlatformRootStoreInfoDataView {
 public:
  PlatformRootStoreInfoDataView() = default;

  PlatformRootStoreInfoDataView(
      internal::PlatformRootStoreInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserAddedCertsDataView(
      mojo::ArrayDataView<PlatformCertInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAddedCerts(UserType* output) {
    
    auto* pointer = data_->user_added_certs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cert_verifier::mojom::PlatformCertInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PlatformRootStoreInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // cert_verifier::mojom

#endif  // SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_DATA_VIEW_H_