// services/data_decoder/public/mojom/image_decoder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/data_decoder/public/mojom/image_decoder.mojom-features.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/image_decoder.mojom-shared.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/image_decoder.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace data_decoder::mojom {

class ImageDecoderProxy;

template <typename ImplRefTraits>
class ImageDecoderStub;

class ImageDecoderRequestValidator;
class ImageDecoderResponseValidator;


class ImageDecoder
    : public ImageDecoderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "data_decoder.mojom.ImageDecoder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ImageDecoderInterfaceBase;
  using Proxy_ = ImageDecoderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ImageDecoderStub<ImplRefTraits>;

  using RequestValidator_ = ImageDecoderRequestValidator;
  using ResponseValidator_ = ImageDecoderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDecodeImageMinVersion = 0,
    kDecodeAnimationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DecodeImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DecodeAnimation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ImageDecoder() = default;

  using DecodeImageCallback = base::OnceCallback<void(::base::TimeDelta, const ::SkBitmap&)>;
  using DecodeImageMojoCallback = base::OnceCallback<void(::base::TimeDelta, const ::SkBitmap&)>;

  virtual void DecodeImage(::mojo_base::BigBuffer encoded_data, ImageCodec codec, bool shrink_to_fit, int64_t max_size_in_bytes, const ::gfx::Size& desired_image_frame_size, DecodeImageCallback callback) = 0;

  using DecodeAnimationCallback = base::OnceCallback<void(std::vector<AnimationFramePtr>)>;
  using DecodeAnimationMojoCallback = base::OnceCallback<void(std::vector<AnimationFramePtr>)>;

  virtual void DecodeAnimation(::mojo_base::BigBuffer encoded_data, bool shrink_to_fit, int64_t max_size_in_bytes, DecodeAnimationCallback callback) = 0;
};



class  ImageDecoderProxy
    : public ImageDecoder {
 public:
  using InterfaceType = ImageDecoder;

  explicit ImageDecoderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DecodeImage(::mojo_base::BigBuffer encoded_data, ImageCodec codec, bool shrink_to_fit, int64_t max_size_in_bytes, const ::gfx::Size& desired_image_frame_size, DecodeImageCallback callback) final;
  
  void DecodeAnimation(::mojo_base::BigBuffer encoded_data, bool shrink_to_fit, int64_t max_size_in_bytes, DecodeAnimationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ImageDecoderStubDispatch {
 public:
  static bool Accept(ImageDecoder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ImageDecoder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ImageDecoder>>
class ImageDecoderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ImageDecoderStub() = default;
  ~ImageDecoderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageDecoderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageDecoderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ImageDecoderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ImageDecoderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  AnimationFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnimationFrame, T>::value>;
  using DataView = AnimationFrameDataView;
  using Data_ = internal::AnimationFrame_Data;

  template <typename... Args>
  static AnimationFramePtr New(Args&&... args) {
    return AnimationFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnimationFramePtr From(const U& u) {
    return mojo::TypeConverter<AnimationFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnimationFrame>::Convert(*this);
  }


  AnimationFrame();

  AnimationFrame(
      const ::SkBitmap& bitmap,
      ::base::TimeDelta duration);


  ~AnimationFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnimationFramePtr>
  AnimationFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnimationFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnimationFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnimationFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnimationFrame::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnimationFrame::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnimationFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnimationFrame_UnserializedMessageContext<
            UserType, AnimationFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnimationFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnimationFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnimationFrame_UnserializedMessageContext<
            UserType, AnimationFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnimationFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkBitmap bitmap;
  
  ::base::TimeDelta duration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnimationFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnimationFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnimationFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnimationFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AnimationFramePtr AnimationFrame::Clone() const {
  return New(
      mojo::Clone(bitmap),
      mojo::Clone(duration)
  );
}

template <typename T, AnimationFrame::EnableIfSame<T>*>
bool AnimationFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bitmap, other_struct.bitmap))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  return true;
}

template <typename T, AnimationFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bitmap < rhs.bitmap)
    return true;
  if (rhs.bitmap < lhs.bitmap)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  return false;
}


}  // data_decoder::mojom

namespace mojo {


template <>
struct  StructTraits<::data_decoder::mojom::AnimationFrame::DataView,
                                         ::data_decoder::mojom::AnimationFramePtr> {
  static bool IsNull(const ::data_decoder::mojom::AnimationFramePtr& input) { return !input; }
  static void SetToNull(::data_decoder::mojom::AnimationFramePtr* output) { output->reset(); }

  static const decltype(::data_decoder::mojom::AnimationFrame::bitmap)& bitmap(
      const ::data_decoder::mojom::AnimationFramePtr& input) {
    return input->bitmap;
  }

  static const decltype(::data_decoder::mojom::AnimationFrame::duration)& duration(
      const ::data_decoder::mojom::AnimationFramePtr& input) {
    return input->duration;
  }

  static bool Read(::data_decoder::mojom::AnimationFrame::DataView input, ::data_decoder::mojom::AnimationFramePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_H_