// services/device/public/mojom/sensor_provider.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/device/public/mojom/sensor_provider.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/device/public/mojom/sensor.mojom-shared.h"


namespace device::mojom {
class SensorInitParamsDataView;

class VirtualSensorMetadataDataView;

class VirtualSensorInformationDataView;

class GetVirtualSensorInformationResultDataView;


}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::SensorInitParamsDataView> {
  using Data = ::device::mojom::internal::SensorInitParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VirtualSensorMetadataDataView> {
  using Data = ::device::mojom::internal::VirtualSensorMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VirtualSensorInformationDataView> {
  using Data = ::device::mojom::internal::VirtualSensorInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GetVirtualSensorInformationResultDataView> {
  using Data = ::device::mojom::internal::GetVirtualSensorInformationResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class SensorCreationResult : int32_t {
  
  SUCCESS = 0,
  
  ERROR_NOT_AVAILABLE = 1,
  
  ERROR_NOT_ALLOWED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SensorCreationResult value);
inline bool IsKnownEnumValue(SensorCreationResult value) {
  return internal::SensorCreationResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateVirtualSensorResult : int32_t {
  
  kSuccess = 0,
  
  kSensorTypeAlreadyOverridden = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CreateVirtualSensorResult value);
inline bool IsKnownEnumValue(CreateVirtualSensorResult value) {
  return internal::CreateVirtualSensorResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UpdateVirtualSensorResult : int32_t {
  
  kSuccess = 0,
  
  kSensorTypeNotOverridden = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, UpdateVirtualSensorResult value);
inline bool IsKnownEnumValue(UpdateVirtualSensorResult value) {
  return internal::UpdateVirtualSensorResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GetVirtualSensorInformationError : int32_t {
  
  kSensorTypeNotOverridden = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, GetVirtualSensorInformationError value);
inline bool IsKnownEnumValue(GetVirtualSensorInformationError value) {
  return internal::GetVirtualSensorInformationError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SensorProviderInterfaceBase {};

using SensorProviderPtrDataView =
    mojo::InterfacePtrDataView<SensorProviderInterfaceBase>;
using SensorProviderRequestDataView =
    mojo::InterfaceRequestDataView<SensorProviderInterfaceBase>;
using SensorProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SensorProviderInterfaceBase>;
using SensorProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SensorProviderInterfaceBase>;


class SensorInitParamsDataView {
 public:
  SensorInitParamsDataView() = default;

  SensorInitParamsDataView(
      internal::SensorInitParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSensor() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::SensorInterfaceBase>>(
            &data_->sensor, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::SensorClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetMemoryDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemory(UserType* output) {
    
    auto* pointer = data_->memory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  uint64_t buffer_offset() const {
    return data_->buffer_offset;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::device::mojom::ReportingMode>(
        data_value, output);
  }
  ::device::mojom::ReportingMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::ReportingMode>(data_->mode));
  }
  inline void GetDefaultConfigurationDataView(
      ::device::mojom::SensorConfigurationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultConfiguration(UserType* output) {
    
    auto* pointer = data_->default_configuration.Get();
    return mojo::internal::Deserialize<::device::mojom::SensorConfigurationDataView>(
        pointer, output, message_);
  }
  double maximum_frequency() const {
    return data_->maximum_frequency;
  }
  double minimum_frequency() const {
    return data_->minimum_frequency;
  }
 private:
  internal::SensorInitParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VirtualSensorMetadataDataView {
 public:
  VirtualSensorMetadataDataView() = default;

  VirtualSensorMetadataDataView(
      internal::VirtualSensorMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool available() const {
    return data_->available;
  }
  std::optional<double> maximum_frequency() const {

    return data_->maximum_frequency_$flag
        ? std::make_optional(data_->maximum_frequency_$value)
        : std::nullopt;
  }
  std::optional<double> minimum_frequency() const {

    return data_->minimum_frequency_$flag
        ? std::make_optional(data_->minimum_frequency_$value)
        : std::nullopt;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReportingMode(UserType* output) const {
    if (!data_->reporting_mode_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::device::mojom::ReportingMode>(
        data_->reporting_mode_$value, &output->emplace());
  }
  std::optional<::device::mojom::ReportingMode> reporting_mode() const {
    if (!data_->reporting_mode_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::ReportingMode>(data_->reporting_mode_$value));
  }
 private:
  internal::VirtualSensorMetadata_Data* data_ = nullptr;
};


class VirtualSensorInformationDataView {
 public:
  VirtualSensorInformationDataView() = default;

  VirtualSensorInformationDataView(
      internal::VirtualSensorInformation_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double sampling_frequency() const {
    return data_->sampling_frequency;
  }
 private:
  internal::VirtualSensorInformation_Data* data_ = nullptr;
};


class GetVirtualSensorInformationResultDataView {
 public:
  using Tag = internal::GetVirtualSensorInformationResult_Data::GetVirtualSensorInformationResult_Tag;

  GetVirtualSensorInformationResultDataView() = default;

  GetVirtualSensorInformationResultDataView(
      internal::GetVirtualSensorInformationResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_info() const { return data_->tag == Tag::kInfo; }
  inline void GetInfoDataView(
      VirtualSensorInformationDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) const {
    
    CHECK(is_info());
    return mojo::internal::Deserialize<::device::mojom::VirtualSensorInformationDataView>(
        data_->data.f_info.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::GetVirtualSensorInformationError>(
        data_->data.f_error, output);
  }
  GetVirtualSensorInformationError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GetVirtualSensorInformationError>(data_->data.f_error));
  }

 private:
  internal::GetVirtualSensorInformationResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_DATA_VIEW_H_