// services/media_session/public/mojom/audio_focus.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/media_session/public/mojom/audio_focus.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/media_session/public/mojom/audio_focus.mojom-params-data.h"
#include "services/media_session/public/mojom/audio_focus.mojom-shared-message-ids.h"

#include "services/media_session/public/mojom/audio_focus.mojom-blink-import-headers.h"
#include "services/media_session/public/mojom/audio_focus.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media_session::mojom::blink {
AudioFocusRequestState::AudioFocusRequestState()
    : session_info(),
      audio_focus_type(),
      source_name(),
      request_id(),
      source_id() {}

AudioFocusRequestState::AudioFocusRequestState(
    ::media_session::mojom::blink::MediaSessionInfoPtr session_info_in,
    AudioFocusType audio_focus_type_in)
    : session_info(std::move(session_info_in)),
      audio_focus_type(std::move(audio_focus_type_in)),
      source_name(),
      request_id(),
      source_id() {}

AudioFocusRequestState::AudioFocusRequestState(
    ::media_session::mojom::blink::MediaSessionInfoPtr session_info_in,
    AudioFocusType audio_focus_type_in,
    const ::blink::String& source_name_in)
    : session_info(std::move(session_info_in)),
      audio_focus_type(std::move(audio_focus_type_in)),
      source_name(std::move(source_name_in)),
      request_id(),
      source_id() {}

AudioFocusRequestState::AudioFocusRequestState(
    ::media_session::mojom::blink::MediaSessionInfoPtr session_info_in,
    AudioFocusType audio_focus_type_in,
    const ::blink::String& source_name_in,
    const std::optional<::base::UnguessableToken>& request_id_in)
    : session_info(std::move(session_info_in)),
      audio_focus_type(std::move(audio_focus_type_in)),
      source_name(std::move(source_name_in)),
      request_id(std::move(request_id_in)),
      source_id() {}

AudioFocusRequestState::AudioFocusRequestState(
    ::media_session::mojom::blink::MediaSessionInfoPtr session_info_in,
    AudioFocusType audio_focus_type_in,
    const ::blink::String& source_name_in,
    const std::optional<::base::UnguessableToken>& request_id_in,
    const std::optional<::base::UnguessableToken>& source_id_in)
    : session_info(std::move(session_info_in)),
      audio_focus_type(std::move(audio_focus_type_in)),
      source_name(std::move(source_name_in)),
      request_id(std::move(request_id_in)),
      source_id(std::move(source_id_in)) {}

AudioFocusRequestState::~AudioFocusRequestState() = default;

void AudioFocusRequestState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_info"), this->session_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media_session::mojom::blink::MediaSessionInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_focus_type"), this->audio_focus_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AudioFocusType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_name"), this->source_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioFocusRequestState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AudioFocusObserver::IPCStableHashFunction AudioFocusObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioFocusObserver>(message.name())) {
    case messages::AudioFocusObserver::kOnFocusGained: {
      return &AudioFocusObserver::OnFocusGained_Sym::IPCStableHash;
    }
    case messages::AudioFocusObserver::kOnFocusLost: {
      return &AudioFocusObserver::OnFocusLost_Sym::IPCStableHash;
    }
    case messages::AudioFocusObserver::kOnRequestIdReleased: {
      return &AudioFocusObserver::OnRequestIdReleased_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioFocusObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioFocusObserver>(message.name())) {
      case messages::AudioFocusObserver::kOnFocusGained:
            return "Receive media_session::mojom::AudioFocusObserver::OnFocusGained";
      case messages::AudioFocusObserver::kOnFocusLost:
            return "Receive media_session::mojom::AudioFocusObserver::OnFocusLost";
      case messages::AudioFocusObserver::kOnRequestIdReleased:
            return "Receive media_session::mojom::AudioFocusObserver::OnRequestIdReleased";
    }
  } else {
    switch (static_cast<messages::AudioFocusObserver>(message.name())) {
      case messages::AudioFocusObserver::kOnFocusGained:
            return "Receive reply media_session::mojom::AudioFocusObserver::OnFocusGained";
      case messages::AudioFocusObserver::kOnFocusLost:
            return "Receive reply media_session::mojom::AudioFocusObserver::OnFocusLost";
      case messages::AudioFocusObserver::kOnRequestIdReleased:
            return "Receive reply media_session::mojom::AudioFocusObserver::OnRequestIdReleased";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioFocusObserver::OnFocusGained_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81352950;  // IPCStableHash for media_session::mojom::AudioFocusObserver::OnFocusGained
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusObserver::OnFocusLost_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3f9a81b;  // IPCStableHash for media_session::mojom::AudioFocusObserver::OnFocusLost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusObserver::OnRequestIdReleased_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d11fb65;  // IPCStableHash for media_session::mojom::AudioFocusObserver::OnRequestIdReleased
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioFocusObserverProxy::AudioFocusObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioFocusObserverProxy::OnFocusGained(
    AudioFocusRequestStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusObserver::OnFocusGained", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type AudioFocusRequestStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusObserver::kOnFocusGained), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusObserver_OnFocusGained_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::AudioFocusRequestStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in AudioFocusObserver.OnFocusGained request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusObserver::Name_);
  message.set_method_name("OnFocusGained");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusObserverProxy::OnFocusLost(
    AudioFocusRequestStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusObserver::OnFocusLost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type AudioFocusRequestStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusObserver::kOnFocusLost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusObserver_OnFocusLost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::AudioFocusRequestStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in AudioFocusObserver.OnFocusLost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusObserver::Name_);
  message.set_method_name("OnFocusLost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusObserverProxy::OnRequestIdReleased(
    const ::base::UnguessableToken& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusObserver::OnRequestIdReleased", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusObserver::kOnRequestIdReleased), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusObserver_OnRequestIdReleased_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_id in AudioFocusObserver.OnRequestIdReleased request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusObserver::Name_);
  message.set_method_name("OnRequestIdReleased");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioFocusObserverStubDispatch::Accept(
    AudioFocusObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioFocusObserver>(message->header()->name)) {
    case messages::AudioFocusObserver::kOnFocusGained: {
      DCHECK(message->is_serialized());
      internal::AudioFocusObserver_OnFocusGained_Params_Data* params =
          reinterpret_cast<internal::AudioFocusObserver_OnFocusGained_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusObserver.0
      bool success = true;
      AudioFocusRequestStatePtr p_state{};
      AudioFocusObserver_OnFocusGained_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFocusGained(        
        std::move(p_state));
      return true;
    }
    case messages::AudioFocusObserver::kOnFocusLost: {
      DCHECK(message->is_serialized());
      internal::AudioFocusObserver_OnFocusLost_Params_Data* params =
          reinterpret_cast<internal::AudioFocusObserver_OnFocusLost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusObserver.1
      bool success = true;
      AudioFocusRequestStatePtr p_state{};
      AudioFocusObserver_OnFocusLost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFocusLost(        
        std::move(p_state));
      return true;
    }
    case messages::AudioFocusObserver::kOnRequestIdReleased: {
      DCHECK(message->is_serialized());
      internal::AudioFocusObserver_OnRequestIdReleased_Params_Data* params =
          reinterpret_cast<internal::AudioFocusObserver_OnRequestIdReleased_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusObserver.2
      bool success = true;
      ::base::UnguessableToken p_request_id{};
      AudioFocusObserver_OnRequestIdReleased_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRequestIdReleased(        
        std::move(p_request_id));
      return true;
    }
  }
  return false;
}

// static
bool AudioFocusObserverStubDispatch::AcceptWithResponder(
    AudioFocusObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioFocusObserver>(message->header()->name)) {
    case messages::AudioFocusObserver::kOnFocusGained: {
      break;
    }
    case messages::AudioFocusObserver::kOnFocusLost: {
      break;
    }
    case messages::AudioFocusObserver::kOnRequestIdReleased: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioFocusObserverValidationInfo[] = {
    { &internal::AudioFocusObserver_OnFocusGained_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusObserver_OnFocusLost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusObserver_OnRequestIdReleased_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioFocusObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::blink::AudioFocusObserver::Name_,
    kAudioFocusObserverValidationInfo);
}

// The declaration includes the definition on other builds.

AudioFocusRequestClient::IPCStableHashFunction AudioFocusRequestClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioFocusRequestClient>(message.name())) {
    case messages::AudioFocusRequestClient::kRequestAudioFocus: {
      return &AudioFocusRequestClient::RequestAudioFocus_Sym::IPCStableHash;
    }
    case messages::AudioFocusRequestClient::kAbandonAudioFocus: {
      return &AudioFocusRequestClient::AbandonAudioFocus_Sym::IPCStableHash;
    }
    case messages::AudioFocusRequestClient::kMediaSessionInfoChanged: {
      return &AudioFocusRequestClient::MediaSessionInfoChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioFocusRequestClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioFocusRequestClient>(message.name())) {
      case messages::AudioFocusRequestClient::kRequestAudioFocus:
            return "Receive media_session::mojom::AudioFocusRequestClient::RequestAudioFocus";
      case messages::AudioFocusRequestClient::kAbandonAudioFocus:
            return "Receive media_session::mojom::AudioFocusRequestClient::AbandonAudioFocus";
      case messages::AudioFocusRequestClient::kMediaSessionInfoChanged:
            return "Receive media_session::mojom::AudioFocusRequestClient::MediaSessionInfoChanged";
    }
  } else {
    switch (static_cast<messages::AudioFocusRequestClient>(message.name())) {
      case messages::AudioFocusRequestClient::kRequestAudioFocus:
            return "Receive reply media_session::mojom::AudioFocusRequestClient::RequestAudioFocus";
      case messages::AudioFocusRequestClient::kAbandonAudioFocus:
            return "Receive reply media_session::mojom::AudioFocusRequestClient::AbandonAudioFocus";
      case messages::AudioFocusRequestClient::kMediaSessionInfoChanged:
            return "Receive reply media_session::mojom::AudioFocusRequestClient::MediaSessionInfoChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioFocusRequestClient::RequestAudioFocus_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3493d0d5;  // IPCStableHash for media_session::mojom::AudioFocusRequestClient::RequestAudioFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusRequestClient::AbandonAudioFocus_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8be18bf7;  // IPCStableHash for media_session::mojom::AudioFocusRequestClient::AbandonAudioFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusRequestClient::MediaSessionInfoChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x299e297d;  // IPCStableHash for media_session::mojom::AudioFocusRequestClient::MediaSessionInfoChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback(
      AudioFocusRequestClient::RequestAudioFocusCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback(const AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback&) = delete;
  AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback& operator=(const AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusRequestClient::RequestAudioFocusCallback callback_;
};

AudioFocusRequestClientProxy::AudioFocusRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioFocusRequestClientProxy::RequestAudioFocus(
    ::media_session::mojom::blink::MediaSessionInfoPtr in_session_info, AudioFocusType in_type, RequestAudioFocusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusRequestClient::RequestAudioFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_info"), in_session_info,
                        "<value of type ::media_session::mojom::blink::MediaSessionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type AudioFocusType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusRequestClient::kRequestAudioFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusRequestClient_RequestAudioFocus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_info)::BaseType> session_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
    in_session_info,
    session_info_fragment);

  params->session_info.Set(
      session_info_fragment.is_null() ? nullptr : session_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_info in AudioFocusRequestClient.RequestAudioFocus request");

  
  mojo::internal::Serialize<::media_session::mojom::AudioFocusType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusRequestClient::Name_);
  message.set_method_name("RequestAudioFocus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioFocusRequestClientProxy::AbandonAudioFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::AudioFocusRequestClient::AbandonAudioFocus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusRequestClient::kAbandonAudioFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusRequestClient_AbandonAudioFocus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusRequestClient::Name_);
  message.set_method_name("AbandonAudioFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusRequestClientProxy::MediaSessionInfoChanged(
    ::media_session::mojom::blink::MediaSessionInfoPtr in_session_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusRequestClient::MediaSessionInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_info"), in_session_info,
                        "<value of type ::media_session::mojom::blink::MediaSessionInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusRequestClient::kMediaSessionInfoChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_info)::BaseType> session_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
    in_session_info,
    session_info_fragment);

  params->session_info.Set(
      session_info_fragment.is_null() ? nullptr : session_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_info in AudioFocusRequestClient.MediaSessionInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusRequestClient::Name_);
  message.set_method_name("MediaSessionInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioFocusRequestClient::RequestAudioFocusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder> proxy(
        new AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusRequestClient::RequestAudioFocusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioFocusRequestClient.0
  bool success = true;
  AudioFocusRequestClient_RequestAudioFocus_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusRequestClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply media_session::mojom::AudioFocusRequestClient::RequestAudioFocus");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusRequestClient::kRequestAudioFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusRequestClient::Name_);
  message.set_method_name("RequestAudioFocus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioFocusRequestClientStubDispatch::Accept(
    AudioFocusRequestClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioFocusRequestClient>(message->header()->name)) {
    case messages::AudioFocusRequestClient::kRequestAudioFocus: {
      break;
    }
    case messages::AudioFocusRequestClient::kAbandonAudioFocus: {
      DCHECK(message->is_serialized());
      internal::AudioFocusRequestClient_AbandonAudioFocus_Params_Data* params =
          reinterpret_cast<internal::AudioFocusRequestClient_AbandonAudioFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusRequestClient.1
      bool success = true;
      AudioFocusRequestClient_AbandonAudioFocus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AbandonAudioFocus(        );
      return true;
    }
    case messages::AudioFocusRequestClient::kMediaSessionInfoChanged: {
      DCHECK(message->is_serialized());
      internal::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data* params =
          reinterpret_cast<internal::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusRequestClient.2
      bool success = true;
      ::media_session::mojom::blink::MediaSessionInfoPtr p_session_info{};
      AudioFocusRequestClient_MediaSessionInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionInfo(&p_session_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionInfoChanged(        
        std::move(p_session_info));
      return true;
    }
  }
  return false;
}

// static
bool AudioFocusRequestClientStubDispatch::AcceptWithResponder(
    AudioFocusRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioFocusRequestClient>(message->header()->name)) {
    case messages::AudioFocusRequestClient::kRequestAudioFocus: {
      internal::AudioFocusRequestClient_RequestAudioFocus_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusRequestClient_RequestAudioFocus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioFocusRequestClient.0
      bool success = true;
      ::media_session::mojom::blink::MediaSessionInfoPtr p_session_info{};
      AudioFocusType p_type{};
      AudioFocusRequestClient_RequestAudioFocus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionInfo(&p_session_info))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusRequestClient::Name_, 0, false);
        return false;
      }
      auto callback =
          AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAudioFocus(        
        std::move(p_session_info), 
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::AudioFocusRequestClient::kAbandonAudioFocus: {
      break;
    }
    case messages::AudioFocusRequestClient::kMediaSessionInfoChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioFocusRequestClientValidationInfo[] = {
    { &internal::AudioFocusRequestClient_RequestAudioFocus_Params_Data::Validate,
     &internal::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data::Validate},
    { &internal::AudioFocusRequestClient_AbandonAudioFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioFocusRequestClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::blink::AudioFocusRequestClient::Name_,
    kAudioFocusRequestClientValidationInfo);
}

bool AudioFocusRequestClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media_session::mojom::blink::AudioFocusRequestClient::Name_,
    kAudioFocusRequestClientValidationInfo);
}
// The declaration includes the definition on other builds.
constexpr base::Token AudioFocusManager::Uuid_;

AudioFocusManager::IPCStableHashFunction AudioFocusManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioFocusManager>(message.name())) {
    case messages::AudioFocusManager::kRequestAudioFocus: {
      return &AudioFocusManager::RequestAudioFocus_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kRequestGroupedAudioFocus: {
      return &AudioFocusManager::RequestGroupedAudioFocus_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kGetFocusRequests: {
      return &AudioFocusManager::GetFocusRequests_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kAddObserver: {
      return &AudioFocusManager::AddObserver_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kSetSource: {
      return &AudioFocusManager::SetSource_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kSetEnforcementMode: {
      return &AudioFocusManager::SetEnforcementMode_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kAddSourceObserver: {
      return &AudioFocusManager::AddSourceObserver_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kGetSourceFocusRequests: {
      return &AudioFocusManager::GetSourceFocusRequests_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kRequestIdReleased: {
      return &AudioFocusManager::RequestIdReleased_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kStartDuckingAllAudio: {
      return &AudioFocusManager::StartDuckingAllAudio_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kStopDuckingAllAudio: {
      return &AudioFocusManager::StopDuckingAllAudio_Sym::IPCStableHash;
    }
    case messages::AudioFocusManager::kFlushForTesting: {
      return &AudioFocusManager::FlushForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioFocusManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioFocusManager>(message.name())) {
      case messages::AudioFocusManager::kRequestAudioFocus:
            return "Receive media_session::mojom::AudioFocusManager::RequestAudioFocus";
      case messages::AudioFocusManager::kRequestGroupedAudioFocus:
            return "Receive media_session::mojom::AudioFocusManager::RequestGroupedAudioFocus";
      case messages::AudioFocusManager::kGetFocusRequests:
            return "Receive media_session::mojom::AudioFocusManager::GetFocusRequests";
      case messages::AudioFocusManager::kAddObserver:
            return "Receive media_session::mojom::AudioFocusManager::AddObserver";
      case messages::AudioFocusManager::kSetSource:
            return "Receive media_session::mojom::AudioFocusManager::SetSource";
      case messages::AudioFocusManager::kSetEnforcementMode:
            return "Receive media_session::mojom::AudioFocusManager::SetEnforcementMode";
      case messages::AudioFocusManager::kAddSourceObserver:
            return "Receive media_session::mojom::AudioFocusManager::AddSourceObserver";
      case messages::AudioFocusManager::kGetSourceFocusRequests:
            return "Receive media_session::mojom::AudioFocusManager::GetSourceFocusRequests";
      case messages::AudioFocusManager::kRequestIdReleased:
            return "Receive media_session::mojom::AudioFocusManager::RequestIdReleased";
      case messages::AudioFocusManager::kStartDuckingAllAudio:
            return "Receive media_session::mojom::AudioFocusManager::StartDuckingAllAudio";
      case messages::AudioFocusManager::kStopDuckingAllAudio:
            return "Receive media_session::mojom::AudioFocusManager::StopDuckingAllAudio";
      case messages::AudioFocusManager::kFlushForTesting:
            return "Receive media_session::mojom::AudioFocusManager::FlushForTesting";
    }
  } else {
    switch (static_cast<messages::AudioFocusManager>(message.name())) {
      case messages::AudioFocusManager::kRequestAudioFocus:
            return "Receive reply media_session::mojom::AudioFocusManager::RequestAudioFocus";
      case messages::AudioFocusManager::kRequestGroupedAudioFocus:
            return "Receive reply media_session::mojom::AudioFocusManager::RequestGroupedAudioFocus";
      case messages::AudioFocusManager::kGetFocusRequests:
            return "Receive reply media_session::mojom::AudioFocusManager::GetFocusRequests";
      case messages::AudioFocusManager::kAddObserver:
            return "Receive reply media_session::mojom::AudioFocusManager::AddObserver";
      case messages::AudioFocusManager::kSetSource:
            return "Receive reply media_session::mojom::AudioFocusManager::SetSource";
      case messages::AudioFocusManager::kSetEnforcementMode:
            return "Receive reply media_session::mojom::AudioFocusManager::SetEnforcementMode";
      case messages::AudioFocusManager::kAddSourceObserver:
            return "Receive reply media_session::mojom::AudioFocusManager::AddSourceObserver";
      case messages::AudioFocusManager::kGetSourceFocusRequests:
            return "Receive reply media_session::mojom::AudioFocusManager::GetSourceFocusRequests";
      case messages::AudioFocusManager::kRequestIdReleased:
            return "Receive reply media_session::mojom::AudioFocusManager::RequestIdReleased";
      case messages::AudioFocusManager::kStartDuckingAllAudio:
            return "Receive reply media_session::mojom::AudioFocusManager::StartDuckingAllAudio";
      case messages::AudioFocusManager::kStopDuckingAllAudio:
            return "Receive reply media_session::mojom::AudioFocusManager::StopDuckingAllAudio";
      case messages::AudioFocusManager::kFlushForTesting:
            return "Receive reply media_session::mojom::AudioFocusManager::FlushForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioFocusManager::RequestAudioFocus_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e39ff0b;  // IPCStableHash for media_session::mojom::AudioFocusManager::RequestAudioFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::RequestGroupedAudioFocus_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x277cb4aa;  // IPCStableHash for media_session::mojom::AudioFocusManager::RequestGroupedAudioFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::GetFocusRequests_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6abccb87;  // IPCStableHash for media_session::mojom::AudioFocusManager::GetFocusRequests
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc518d6be;  // IPCStableHash for media_session::mojom::AudioFocusManager::AddObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::SetSource_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e8c59a1;  // IPCStableHash for media_session::mojom::AudioFocusManager::SetSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::SetEnforcementMode_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57872431;  // IPCStableHash for media_session::mojom::AudioFocusManager::SetEnforcementMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::AddSourceObserver_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8b79c2d;  // IPCStableHash for media_session::mojom::AudioFocusManager::AddSourceObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::GetSourceFocusRequests_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed209e18;  // IPCStableHash for media_session::mojom::AudioFocusManager::GetSourceFocusRequests
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::RequestIdReleased_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdeee019d;  // IPCStableHash for media_session::mojom::AudioFocusManager::RequestIdReleased
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::StartDuckingAllAudio_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x606c422a;  // IPCStableHash for media_session::mojom::AudioFocusManager::StartDuckingAllAudio
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::StopDuckingAllAudio_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x618ca22d;  // IPCStableHash for media_session::mojom::AudioFocusManager::StopDuckingAllAudio
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioFocusManager::FlushForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0569426e;  // IPCStableHash for media_session::mojom::AudioFocusManager::FlushForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AudioFocusManager_RequestAudioFocus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_RequestAudioFocus_ForwardToCallback(
      AudioFocusManager::RequestAudioFocusCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioFocusManager_RequestAudioFocus_ForwardToCallback(const AudioFocusManager_RequestAudioFocus_ForwardToCallback&) = delete;
  AudioFocusManager_RequestAudioFocus_ForwardToCallback& operator=(const AudioFocusManager_RequestAudioFocus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::RequestAudioFocusCallback callback_;
};

class AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback(
      AudioFocusManager::RequestGroupedAudioFocusCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback(const AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback&) = delete;
  AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback& operator=(const AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::RequestGroupedAudioFocusCallback callback_;
};

class AudioFocusManager_GetFocusRequests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_GetFocusRequests_ForwardToCallback(
      AudioFocusManager::GetFocusRequestsCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioFocusManager_GetFocusRequests_ForwardToCallback(const AudioFocusManager_GetFocusRequests_ForwardToCallback&) = delete;
  AudioFocusManager_GetFocusRequests_ForwardToCallback& operator=(const AudioFocusManager_GetFocusRequests_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::GetFocusRequestsCallback callback_;
};

class AudioFocusManager_GetSourceFocusRequests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_GetSourceFocusRequests_ForwardToCallback(
      AudioFocusManager::GetSourceFocusRequestsCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioFocusManager_GetSourceFocusRequests_ForwardToCallback(const AudioFocusManager_GetSourceFocusRequests_ForwardToCallback&) = delete;
  AudioFocusManager_GetSourceFocusRequests_ForwardToCallback& operator=(const AudioFocusManager_GetSourceFocusRequests_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::GetSourceFocusRequestsCallback callback_;
};

class AudioFocusManager_FlushForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_FlushForTesting_ForwardToCallback(
      AudioFocusManager::FlushForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioFocusManager_FlushForTesting_ForwardToCallback(const AudioFocusManager_FlushForTesting_ForwardToCallback&) = delete;
  AudioFocusManager_FlushForTesting_ForwardToCallback& operator=(const AudioFocusManager_FlushForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::FlushForTestingCallback callback_;
};

AudioFocusManagerProxy::AudioFocusManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioFocusManagerProxy::RequestAudioFocus(
    ::mojo::PendingReceiver<AudioFocusRequestClient> in_client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> in_session, ::media_session::mojom::blink::MediaSessionInfoPtr in_session_info, AudioFocusType in_type, RequestAudioFocusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::RequestAudioFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingReceiver<AudioFocusRequestClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_info"), in_session_info,
                        "<value of type ::media_session::mojom::blink::MediaSessionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type AudioFocusType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kRequestAudioFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestAudioFocus_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::AudioFocusRequestClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AudioFocusManager.RequestAudioFocus request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaSessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session in AudioFocusManager.RequestAudioFocus request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_info)::BaseType> session_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
    in_session_info,
    session_info_fragment);

  params->session_info.Set(
      session_info_fragment.is_null() ? nullptr : session_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_info in AudioFocusManager.RequestAudioFocus request");

  
  mojo::internal::Serialize<::media_session::mojom::AudioFocusType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestAudioFocus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_RequestAudioFocus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioFocusManagerProxy::RequestGroupedAudioFocus(
    const ::base::UnguessableToken& in_request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> in_client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> in_session, ::media_session::mojom::blink::MediaSessionInfoPtr in_session_info, AudioFocusType in_type, const ::base::UnguessableToken& in_group_id, RequestGroupedAudioFocusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::RequestGroupedAudioFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingReceiver<AudioFocusRequestClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_info"), in_session_info,
                        "<value of type ::media_session::mojom::blink::MediaSessionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type AudioFocusType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kRequestGroupedAudioFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestGroupedAudioFocus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_id in AudioFocusManager.RequestGroupedAudioFocus request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::AudioFocusRequestClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AudioFocusManager.RequestGroupedAudioFocus request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaSessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session in AudioFocusManager.RequestGroupedAudioFocus request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_info)::BaseType> session_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
    in_session_info,
    session_info_fragment);

  params->session_info.Set(
      session_info_fragment.is_null() ? nullptr : session_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_info in AudioFocusManager.RequestGroupedAudioFocus request");

  
  mojo::internal::Serialize<::media_session::mojom::AudioFocusType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in AudioFocusManager.RequestGroupedAudioFocus request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestGroupedAudioFocus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioFocusManagerProxy::GetFocusRequests(
    GetFocusRequestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::AudioFocusManager::GetFocusRequests");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kGetFocusRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_GetFocusRequests_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("GetFocusRequests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_GetFocusRequests_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioFocusManagerProxy::AddObserver(
    ::mojo::PendingRemote<AudioFocusObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<AudioFocusObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_AddObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::AudioFocusObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in AudioFocusManager.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusManagerProxy::SetSource(
    const ::base::UnguessableToken& in_identity, const ::blink::String& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::SetSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kSetSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_SetSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identity in AudioFocusManager.SetSource request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in AudioFocusManager.SetSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("SetSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusManagerProxy::SetEnforcementMode(
    EnforcementMode in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::SetEnforcementMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type EnforcementMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kSetEnforcementMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_SetEnforcementMode_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::EnforcementMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("SetEnforcementMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusManagerProxy::AddSourceObserver(
    const ::base::UnguessableToken& in_source_id, ::mojo::PendingRemote<AudioFocusObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::AddSourceObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<AudioFocusObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kAddSourceObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_AddSourceObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_source_id,
    source_id_fragment);

  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_id in AudioFocusManager.AddSourceObserver request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::AudioFocusObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in AudioFocusManager.AddSourceObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("AddSourceObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusManagerProxy::GetSourceFocusRequests(
    const ::base::UnguessableToken& in_source_id, GetSourceFocusRequestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::GetSourceFocusRequests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kGetSourceFocusRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_GetSourceFocusRequests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_source_id,
    source_id_fragment);

  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_id in AudioFocusManager.GetSourceFocusRequests request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("GetSourceFocusRequests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_GetSourceFocusRequests_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioFocusManagerProxy::RequestIdReleased(
    const ::base::UnguessableToken& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::RequestIdReleased", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kRequestIdReleased), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestIdReleased_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_id in AudioFocusManager.RequestIdReleased request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestIdReleased");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusManagerProxy::StartDuckingAllAudio(
    const std::optional<::base::UnguessableToken>& in_exempted_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManager::StartDuckingAllAudio", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exempted_request_id"), in_exempted_request_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kStartDuckingAllAudio), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_StartDuckingAllAudio_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->exempted_request_id)::BaseType> exempted_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_exempted_request_id,
    exempted_request_id_fragment);

  params->exempted_request_id.Set(
      exempted_request_id_fragment.is_null() ? nullptr : exempted_request_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("StartDuckingAllAudio");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusManagerProxy::StopDuckingAllAudio(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::AudioFocusManager::StopDuckingAllAudio");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kStopDuckingAllAudio), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_StopDuckingAllAudio_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("StopDuckingAllAudio");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioFocusManagerProxy::FlushForTesting(
    FlushForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::AudioFocusManager::FlushForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kFlushForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_FlushForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("FlushForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_FlushForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AudioFocusManager_RequestAudioFocus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioFocusManager::RequestAudioFocusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioFocusManager_RequestAudioFocus_ProxyToResponder> proxy(
        new AudioFocusManager_RequestAudioFocus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioFocusManager_RequestAudioFocus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_RequestAudioFocus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioFocusManager_RequestAudioFocus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::RequestAudioFocusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_request_id);
};

bool AudioFocusManager_RequestAudioFocus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioFocusManager_RequestAudioFocus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_RequestAudioFocus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioFocusManager.0
  bool success = true;
  ::base::UnguessableToken p_request_id{};
  AudioFocusManager_RequestAudioFocus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequestId(&p_request_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_request_id));
  }
  return true;
}

void AudioFocusManager_RequestAudioFocus_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::AudioFocusManager::RequestAudioFocus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kRequestAudioFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestAudioFocus_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestAudioFocus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioFocusManager::RequestGroupedAudioFocusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder> proxy(
        new AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::RequestGroupedAudioFocusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioFocusManager.4
  bool success = true;
  bool p_success{};
  AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::AudioFocusManager::RequestGroupedAudioFocus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kRequestGroupedAudioFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestGroupedAudioFocus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioFocusManager_GetFocusRequests_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioFocusManager::GetFocusRequestsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioFocusManager_GetFocusRequests_ProxyToResponder> proxy(
        new AudioFocusManager_GetFocusRequests_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioFocusManager_GetFocusRequests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_GetFocusRequests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioFocusManager_GetFocusRequests_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::GetFocusRequestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<AudioFocusRequestStatePtr> in_requests);
};

bool AudioFocusManager_GetFocusRequests_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioFocusManager_GetFocusRequests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_GetFocusRequests_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioFocusManager.1
  bool success = true;
  ::blink::Vector<AudioFocusRequestStatePtr> p_requests{};
  AudioFocusManager_GetFocusRequests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequests(&p_requests))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_requests));
  }
  return true;
}

void AudioFocusManager_GetFocusRequests_ProxyToResponder::Run(
    ::blink::Vector<AudioFocusRequestStatePtr> in_requests) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::AudioFocusManager::GetFocusRequests", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests,
                        "<value of type ::blink::Vector<AudioFocusRequestStatePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kGetFocusRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_GetFocusRequests_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::AudioFocusRequestStateDataView>>(
    in_requests,
    requests_fragment,
    &requests_validate_params);

  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requests in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("GetFocusRequests");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioFocusManager_GetSourceFocusRequests_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioFocusManager::GetSourceFocusRequestsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioFocusManager_GetSourceFocusRequests_ProxyToResponder> proxy(
        new AudioFocusManager_GetSourceFocusRequests_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioFocusManager_GetSourceFocusRequests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_GetSourceFocusRequests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioFocusManager_GetSourceFocusRequests_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::GetSourceFocusRequestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<AudioFocusRequestStatePtr> in_requests);
};

bool AudioFocusManager_GetSourceFocusRequests_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioFocusManager.8
  bool success = true;
  ::blink::Vector<AudioFocusRequestStatePtr> p_requests{};
  AudioFocusManager_GetSourceFocusRequests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequests(&p_requests))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_requests));
  }
  return true;
}

void AudioFocusManager_GetSourceFocusRequests_ProxyToResponder::Run(
    ::blink::Vector<AudioFocusRequestStatePtr> in_requests) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::AudioFocusManager::GetSourceFocusRequests", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests,
                        "<value of type ::blink::Vector<AudioFocusRequestStatePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kGetSourceFocusRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::AudioFocusRequestStateDataView>>(
    in_requests,
    requests_fragment,
    &requests_validate_params);

  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requests in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("GetSourceFocusRequests");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioFocusManager_FlushForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioFocusManager::FlushForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioFocusManager_FlushForTesting_ProxyToResponder> proxy(
        new AudioFocusManager_FlushForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioFocusManager_FlushForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_FlushForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioFocusManager_FlushForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::FlushForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool AudioFocusManager_FlushForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioFocusManager_FlushForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_FlushForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioFocusManager.12
  bool success = true;
  AudioFocusManager_FlushForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void AudioFocusManager_FlushForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply media_session::mojom::AudioFocusManager::FlushForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManager::kFlushForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_FlushForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("FlushForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioFocusManagerStubDispatch::Accept(
    AudioFocusManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioFocusManager>(message->header()->name)) {
    case messages::AudioFocusManager::kRequestAudioFocus: {
      break;
    }
    case messages::AudioFocusManager::kRequestGroupedAudioFocus: {
      break;
    }
    case messages::AudioFocusManager::kGetFocusRequests: {
      break;
    }
    case messages::AudioFocusManager::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::AudioFocusManager_AddObserver_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_AddObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusManager.2
      bool success = true;
      ::mojo::PendingRemote<AudioFocusObserver> p_observer{};
      AudioFocusManager_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::AudioFocusManager::kSetSource: {
      DCHECK(message->is_serialized());
      internal::AudioFocusManager_SetSource_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_SetSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusManager.6
      bool success = true;
      ::base::UnguessableToken p_identity{};
      ::blink::String p_name{};
      AudioFocusManager_SetSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSource(        
        std::move(p_identity), 
        std::move(p_name));
      return true;
    }
    case messages::AudioFocusManager::kSetEnforcementMode: {
      DCHECK(message->is_serialized());
      internal::AudioFocusManager_SetEnforcementMode_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_SetEnforcementMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusManager.5
      bool success = true;
      EnforcementMode p_mode{};
      AudioFocusManager_SetEnforcementMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnforcementMode(        
        std::move(p_mode));
      return true;
    }
    case messages::AudioFocusManager::kAddSourceObserver: {
      DCHECK(message->is_serialized());
      internal::AudioFocusManager_AddSourceObserver_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_AddSourceObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusManager.7
      bool success = true;
      ::base::UnguessableToken p_source_id{};
      ::mojo::PendingRemote<AudioFocusObserver> p_observer{};
      AudioFocusManager_AddSourceObserver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSourceObserver(        
        std::move(p_source_id), 
        std::move(p_observer));
      return true;
    }
    case messages::AudioFocusManager::kGetSourceFocusRequests: {
      break;
    }
    case messages::AudioFocusManager::kRequestIdReleased: {
      DCHECK(message->is_serialized());
      internal::AudioFocusManager_RequestIdReleased_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_RequestIdReleased_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusManager.9
      bool success = true;
      ::base::UnguessableToken p_request_id{};
      AudioFocusManager_RequestIdReleased_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestIdReleased(        
        std::move(p_request_id));
      return true;
    }
    case messages::AudioFocusManager::kStartDuckingAllAudio: {
      DCHECK(message->is_serialized());
      internal::AudioFocusManager_StartDuckingAllAudio_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_StartDuckingAllAudio_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusManager.10
      bool success = true;
      std::optional<::base::UnguessableToken> p_exempted_request_id{};
      AudioFocusManager_StartDuckingAllAudio_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExemptedRequestId(&p_exempted_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDuckingAllAudio(        
        std::move(p_exempted_request_id));
      return true;
    }
    case messages::AudioFocusManager::kStopDuckingAllAudio: {
      DCHECK(message->is_serialized());
      internal::AudioFocusManager_StopDuckingAllAudio_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_StopDuckingAllAudio_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioFocusManager.11
      bool success = true;
      AudioFocusManager_StopDuckingAllAudio_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopDuckingAllAudio(        );
      return true;
    }
    case messages::AudioFocusManager::kFlushForTesting: {
      break;
    }
  }
  return false;
}

// static
bool AudioFocusManagerStubDispatch::AcceptWithResponder(
    AudioFocusManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioFocusManager>(message->header()->name)) {
    case messages::AudioFocusManager::kRequestAudioFocus: {
      internal::AudioFocusManager_RequestAudioFocus_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_RequestAudioFocus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioFocusManager.0
      bool success = true;
      ::mojo::PendingReceiver<AudioFocusRequestClient> p_client{};
      ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> p_session{};
      ::media_session::mojom::blink::MediaSessionInfoPtr p_session_info{};
      AudioFocusType p_type{};
      AudioFocusManager_RequestAudioFocus_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (success && !input_data_view.ReadSessionInfo(&p_session_info))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 0, false);
        return false;
      }
      auto callback =
          AudioFocusManager_RequestAudioFocus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAudioFocus(        
        std::move(p_client), 
        std::move(p_session), 
        std::move(p_session_info), 
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::AudioFocusManager::kRequestGroupedAudioFocus: {
      internal::AudioFocusManager_RequestGroupedAudioFocus_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_RequestGroupedAudioFocus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioFocusManager.4
      bool success = true;
      ::base::UnguessableToken p_request_id{};
      ::mojo::PendingReceiver<AudioFocusRequestClient> p_client{};
      ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> p_session{};
      ::media_session::mojom::blink::MediaSessionInfoPtr p_session_info{};
      AudioFocusType p_type{};
      ::base::UnguessableToken p_group_id{};
      AudioFocusManager_RequestGroupedAudioFocus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (success && !input_data_view.ReadSessionInfo(&p_session_info))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 4, false);
        return false;
      }
      auto callback =
          AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestGroupedAudioFocus(        
        std::move(p_request_id), 
        std::move(p_client), 
        std::move(p_session), 
        std::move(p_session_info), 
        std::move(p_type), 
        std::move(p_group_id), std::move(callback));
      return true;
    }
    case messages::AudioFocusManager::kGetFocusRequests: {
      internal::AudioFocusManager_GetFocusRequests_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_GetFocusRequests_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioFocusManager.1
      bool success = true;
      AudioFocusManager_GetFocusRequests_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 1, false);
        return false;
      }
      auto callback =
          AudioFocusManager_GetFocusRequests_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFocusRequests(std::move(callback));
      return true;
    }
    case messages::AudioFocusManager::kAddObserver: {
      break;
    }
    case messages::AudioFocusManager::kSetSource: {
      break;
    }
    case messages::AudioFocusManager::kSetEnforcementMode: {
      break;
    }
    case messages::AudioFocusManager::kAddSourceObserver: {
      break;
    }
    case messages::AudioFocusManager::kGetSourceFocusRequests: {
      internal::AudioFocusManager_GetSourceFocusRequests_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_GetSourceFocusRequests_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioFocusManager.8
      bool success = true;
      ::base::UnguessableToken p_source_id{};
      AudioFocusManager_GetSourceFocusRequests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 8, false);
        return false;
      }
      auto callback =
          AudioFocusManager_GetSourceFocusRequests_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSourceFocusRequests(        
        std::move(p_source_id), std::move(callback));
      return true;
    }
    case messages::AudioFocusManager::kRequestIdReleased: {
      break;
    }
    case messages::AudioFocusManager::kStartDuckingAllAudio: {
      break;
    }
    case messages::AudioFocusManager::kStopDuckingAllAudio: {
      break;
    }
    case messages::AudioFocusManager::kFlushForTesting: {
      internal::AudioFocusManager_FlushForTesting_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_FlushForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioFocusManager.12
      bool success = true;
      AudioFocusManager_FlushForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 12, false);
        return false;
      }
      auto callback =
          AudioFocusManager_FlushForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushForTesting(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioFocusManagerValidationInfo[] = {
    { &internal::AudioFocusManager_RequestAudioFocus_Params_Data::Validate,
     &internal::AudioFocusManager_RequestAudioFocus_ResponseParams_Data::Validate},
    { &internal::AudioFocusManager_GetFocusRequests_Params_Data::Validate,
     &internal::AudioFocusManager_GetFocusRequests_ResponseParams_Data::Validate},
    { &internal::AudioFocusManager_AddObserver_Params_Data::Validate,
     nullptr /* no response */},
    {nullptr, nullptr},  // nonexistent
    { &internal::AudioFocusManager_RequestGroupedAudioFocus_Params_Data::Validate,
     &internal::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data::Validate},
    { &internal::AudioFocusManager_SetEnforcementMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusManager_SetSource_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusManager_AddSourceObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusManager_GetSourceFocusRequests_Params_Data::Validate,
     &internal::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data::Validate},
    { &internal::AudioFocusManager_RequestIdReleased_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusManager_StartDuckingAllAudio_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusManager_StopDuckingAllAudio_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioFocusManager_FlushForTesting_Params_Data::Validate,
     &internal::AudioFocusManager_FlushForTesting_ResponseParams_Data::Validate},
};

bool AudioFocusManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::blink::AudioFocusManager::Name_,
    kAudioFocusManagerValidationInfo);
}

bool AudioFocusManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media_session::mojom::blink::AudioFocusManager::Name_,
    kAudioFocusManagerValidationInfo);
}
// The declaration includes the definition on other builds.
constexpr base::Token AudioFocusManagerDebug::Uuid_;

AudioFocusManagerDebug::IPCStableHashFunction AudioFocusManagerDebug::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioFocusManagerDebug>(message.name())) {
    case messages::AudioFocusManagerDebug::kGetDebugInfoForRequest: {
      return &AudioFocusManagerDebug::GetDebugInfoForRequest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioFocusManagerDebug::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioFocusManagerDebug>(message.name())) {
      case messages::AudioFocusManagerDebug::kGetDebugInfoForRequest:
            return "Receive media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequest";
    }
  } else {
    switch (static_cast<messages::AudioFocusManagerDebug>(message.name())) {
      case messages::AudioFocusManagerDebug::kGetDebugInfoForRequest:
            return "Receive reply media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioFocusManagerDebug::GetDebugInfoForRequest_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe8bb9331;  // IPCStableHash for media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback(
      AudioFocusManagerDebug::GetDebugInfoForRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback(const AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback&) = delete;
  AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback& operator=(const AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManagerDebug::GetDebugInfoForRequestCallback callback_;
};

AudioFocusManagerDebugProxy::AudioFocusManagerDebugProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioFocusManagerDebugProxy::GetDebugInfoForRequest(
    const ::base::UnguessableToken& in_request_id, GetDebugInfoForRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManagerDebug::kGetDebugInfoForRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_id in AudioFocusManagerDebug.GetDebugInfoForRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManagerDebug::Name_);
  message.set_method_name("GetDebugInfoForRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioFocusManagerDebug::GetDebugInfoForRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder> proxy(
        new AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManagerDebug::GetDebugInfoForRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media_session::mojom::blink::MediaSessionDebugInfoPtr in_debug_info);
};

bool AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioFocusManagerDebug.0
  bool success = true;
  ::media_session::mojom::blink::MediaSessionDebugInfoPtr p_debug_info{};
  AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDebugInfo(&p_debug_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManagerDebug::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_debug_info));
  }
  return true;
}

void AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder::Run(
    ::media_session::mojom::blink::MediaSessionDebugInfoPtr in_debug_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_info"), in_debug_info,
                        "<value of type ::media_session::mojom::blink::MediaSessionDebugInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioFocusManagerDebug::kGetDebugInfoForRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->debug_info)::BaseType> debug_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionDebugInfoDataView>(
    in_debug_info,
    debug_info_fragment);

  params->debug_info.Set(
      debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->debug_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null debug_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManagerDebug::Name_);
  message.set_method_name("GetDebugInfoForRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioFocusManagerDebugStubDispatch::Accept(
    AudioFocusManagerDebug* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioFocusManagerDebug>(message->header()->name)) {
    case messages::AudioFocusManagerDebug::kGetDebugInfoForRequest: {
      break;
    }
  }
  return false;
}

// static
bool AudioFocusManagerDebugStubDispatch::AcceptWithResponder(
    AudioFocusManagerDebug* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioFocusManagerDebug>(message->header()->name)) {
    case messages::AudioFocusManagerDebug::kGetDebugInfoForRequest: {
      internal::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioFocusManagerDebug.0
      bool success = true;
      ::base::UnguessableToken p_request_id{};
      AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManagerDebug::Name_, 0, false);
        return false;
      }
      auto callback =
          AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDebugInfoForRequest(        
        std::move(p_request_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioFocusManagerDebugValidationInfo[] = {
    { &internal::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data::Validate,
     &internal::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data::Validate},
};

bool AudioFocusManagerDebugRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::blink::AudioFocusManagerDebug::Name_,
    kAudioFocusManagerDebugValidationInfo);
}

bool AudioFocusManagerDebugResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media_session::mojom::blink::AudioFocusManagerDebug::Name_,
    kAudioFocusManagerDebugValidationInfo);
}


}  // media_session::mojom::blink


namespace mojo {


// static
bool StructTraits<::media_session::mojom::blink::AudioFocusRequestState::DataView, ::media_session::mojom::blink::AudioFocusRequestStatePtr>::Read(
    ::media_session::mojom::blink::AudioFocusRequestState::DataView input,
    ::media_session::mojom::blink::AudioFocusRequestStatePtr* output) {
  bool success = true;
  ::media_session::mojom::blink::AudioFocusRequestStatePtr result(::media_session::mojom::blink::AudioFocusRequestState::New());
  
      if (success && !input.ReadSessionInfo(&result->session_info))
        success = false;
      if (success && !input.ReadAudioFocusType(&result->audio_focus_type))
        success = false;
      if (success && !input.ReadSourceName(&result->source_name))
        success = false;
      if (success && !input.ReadRequestId(&result->request_id))
        success = false;
      if (success && !input.ReadSourceId(&result->source_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media_session::mojom::blink {


void AudioFocusObserverInterceptorForTesting::OnFocusGained(AudioFocusRequestStatePtr state) {
  GetForwardingInterface()->OnFocusGained(
    std::move(state)
    );
}
void AudioFocusObserverInterceptorForTesting::OnFocusLost(AudioFocusRequestStatePtr state) {
  GetForwardingInterface()->OnFocusLost(
    std::move(state)
    );
}
void AudioFocusObserverInterceptorForTesting::OnRequestIdReleased(const ::base::UnguessableToken& request_id) {
  GetForwardingInterface()->OnRequestIdReleased(
    std::move(request_id)
    );
}
AudioFocusObserverAsyncWaiter::AudioFocusObserverAsyncWaiter(
    AudioFocusObserver* proxy) : proxy_(proxy) {}

AudioFocusObserverAsyncWaiter::~AudioFocusObserverAsyncWaiter() = default;





void AudioFocusRequestClientInterceptorForTesting::RequestAudioFocus(::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) {
  GetForwardingInterface()->RequestAudioFocus(
    std::move(session_info)
    , 
    std::move(type)
    , std::move(callback));
}
void AudioFocusRequestClientInterceptorForTesting::AbandonAudioFocus() {
  GetForwardingInterface()->AbandonAudioFocus();
}
void AudioFocusRequestClientInterceptorForTesting::MediaSessionInfoChanged(::media_session::mojom::blink::MediaSessionInfoPtr session_info) {
  GetForwardingInterface()->MediaSessionInfoChanged(
    std::move(session_info)
    );
}
AudioFocusRequestClientAsyncWaiter::AudioFocusRequestClientAsyncWaiter(
    AudioFocusRequestClient* proxy) : proxy_(proxy) {}

AudioFocusRequestClientAsyncWaiter::~AudioFocusRequestClientAsyncWaiter() = default;


void AudioFocusRequestClientAsyncWaiter::RequestAudioFocus(
    ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type) {
  base::RunLoop loop;
  proxy_->RequestAudioFocus(
      std::move(session_info),
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void AudioFocusManagerInterceptorForTesting::RequestAudioFocus(::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) {
  GetForwardingInterface()->RequestAudioFocus(
    std::move(client)
    , 
    std::move(session)
    , 
    std::move(session_info)
    , 
    std::move(type)
    , std::move(callback));
}
void AudioFocusManagerInterceptorForTesting::RequestGroupedAudioFocus(const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id, RequestGroupedAudioFocusCallback callback) {
  GetForwardingInterface()->RequestGroupedAudioFocus(
    std::move(request_id)
    , 
    std::move(client)
    , 
    std::move(session)
    , 
    std::move(session_info)
    , 
    std::move(type)
    , 
    std::move(group_id)
    , std::move(callback));
}
void AudioFocusManagerInterceptorForTesting::GetFocusRequests(GetFocusRequestsCallback callback) {
  GetForwardingInterface()->GetFocusRequests(std::move(callback));
}
void AudioFocusManagerInterceptorForTesting::AddObserver(::mojo::PendingRemote<AudioFocusObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    );
}
void AudioFocusManagerInterceptorForTesting::SetSource(const ::base::UnguessableToken& identity, const ::blink::String& name) {
  GetForwardingInterface()->SetSource(
    std::move(identity)
    , 
    std::move(name)
    );
}
void AudioFocusManagerInterceptorForTesting::SetEnforcementMode(EnforcementMode mode) {
  GetForwardingInterface()->SetEnforcementMode(
    std::move(mode)
    );
}
void AudioFocusManagerInterceptorForTesting::AddSourceObserver(const ::base::UnguessableToken& source_id, ::mojo::PendingRemote<AudioFocusObserver> observer) {
  GetForwardingInterface()->AddSourceObserver(
    std::move(source_id)
    , 
    std::move(observer)
    );
}
void AudioFocusManagerInterceptorForTesting::GetSourceFocusRequests(const ::base::UnguessableToken& source_id, GetSourceFocusRequestsCallback callback) {
  GetForwardingInterface()->GetSourceFocusRequests(
    std::move(source_id)
    , std::move(callback));
}
void AudioFocusManagerInterceptorForTesting::RequestIdReleased(const ::base::UnguessableToken& request_id) {
  GetForwardingInterface()->RequestIdReleased(
    std::move(request_id)
    );
}
void AudioFocusManagerInterceptorForTesting::StartDuckingAllAudio(const std::optional<::base::UnguessableToken>& exempted_request_id) {
  GetForwardingInterface()->StartDuckingAllAudio(
    std::move(exempted_request_id)
    );
}
void AudioFocusManagerInterceptorForTesting::StopDuckingAllAudio() {
  GetForwardingInterface()->StopDuckingAllAudio();
}
void AudioFocusManagerInterceptorForTesting::FlushForTesting(FlushForTestingCallback callback) {
  GetForwardingInterface()->FlushForTesting(std::move(callback));
}
AudioFocusManagerAsyncWaiter::AudioFocusManagerAsyncWaiter(
    AudioFocusManager* proxy) : proxy_(proxy) {}

AudioFocusManagerAsyncWaiter::~AudioFocusManagerAsyncWaiter() = default;


void AudioFocusManagerAsyncWaiter::RequestAudioFocus(
    ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, ::base::UnguessableToken* out_request_id) {
  base::RunLoop loop;
  proxy_->RequestAudioFocus(
      std::move(client),
      std::move(session),
      std::move(session_info),
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_request_id
,
             const ::base::UnguessableToken& request_id) {*out_request_id = std::move(request_id);
            loop->Quit();
          },
          &loop,
          out_request_id));
  loop.Run();
}

::base::UnguessableToken AudioFocusManagerAsyncWaiter::RequestAudioFocus(
    ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type) {
  ::base::UnguessableToken async_wait_result;
  RequestAudioFocus(std::move(client),std::move(session),std::move(session_info),std::move(type),&async_wait_result);
  return async_wait_result;
}

void AudioFocusManagerAsyncWaiter::RequestGroupedAudioFocus(
    const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->RequestGroupedAudioFocus(
      std::move(request_id),
      std::move(client),
      std::move(session),
      std::move(session_info),
      std::move(type),
      std::move(group_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool AudioFocusManagerAsyncWaiter::RequestGroupedAudioFocus(
    const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id) {
  bool async_wait_result;
  RequestGroupedAudioFocus(std::move(request_id),std::move(client),std::move(session),std::move(session_info),std::move(type),std::move(group_id),&async_wait_result);
  return async_wait_result;
}

void AudioFocusManagerAsyncWaiter::GetFocusRequests(
    ::blink::Vector<AudioFocusRequestStatePtr>* out_requests) {
  base::RunLoop loop;
  proxy_->GetFocusRequests(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<AudioFocusRequestStatePtr>* out_requests
,
             ::blink::Vector<AudioFocusRequestStatePtr> requests) {*out_requests = std::move(requests);
            loop->Quit();
          },
          &loop,
          out_requests));
  loop.Run();
}

::blink::Vector<AudioFocusRequestStatePtr> AudioFocusManagerAsyncWaiter::GetFocusRequests(
    ) {
  ::blink::Vector<AudioFocusRequestStatePtr> async_wait_result;
  GetFocusRequests(&async_wait_result);
  return async_wait_result;
}

void AudioFocusManagerAsyncWaiter::GetSourceFocusRequests(
    const ::base::UnguessableToken& source_id, ::blink::Vector<AudioFocusRequestStatePtr>* out_requests) {
  base::RunLoop loop;
  proxy_->GetSourceFocusRequests(
      std::move(source_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<AudioFocusRequestStatePtr>* out_requests
,
             ::blink::Vector<AudioFocusRequestStatePtr> requests) {*out_requests = std::move(requests);
            loop->Quit();
          },
          &loop,
          out_requests));
  loop.Run();
}

::blink::Vector<AudioFocusRequestStatePtr> AudioFocusManagerAsyncWaiter::GetSourceFocusRequests(
    const ::base::UnguessableToken& source_id) {
  ::blink::Vector<AudioFocusRequestStatePtr> async_wait_result;
  GetSourceFocusRequests(std::move(source_id),&async_wait_result);
  return async_wait_result;
}

void AudioFocusManagerAsyncWaiter::FlushForTesting(
    ) {
  base::RunLoop loop;
  proxy_->FlushForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void AudioFocusManagerDebugInterceptorForTesting::GetDebugInfoForRequest(const ::base::UnguessableToken& request_id, GetDebugInfoForRequestCallback callback) {
  GetForwardingInterface()->GetDebugInfoForRequest(
    std::move(request_id)
    , std::move(callback));
}
AudioFocusManagerDebugAsyncWaiter::AudioFocusManagerDebugAsyncWaiter(
    AudioFocusManagerDebug* proxy) : proxy_(proxy) {}

AudioFocusManagerDebugAsyncWaiter::~AudioFocusManagerDebugAsyncWaiter() = default;


void AudioFocusManagerDebugAsyncWaiter::GetDebugInfoForRequest(
    const ::base::UnguessableToken& request_id, ::media_session::mojom::blink::MediaSessionDebugInfoPtr* out_debug_info) {
  base::RunLoop loop;
  proxy_->GetDebugInfoForRequest(
      std::move(request_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media_session::mojom::blink::MediaSessionDebugInfoPtr* out_debug_info
,
             ::media_session::mojom::blink::MediaSessionDebugInfoPtr debug_info) {*out_debug_info = std::move(debug_info);
            loop->Quit();
          },
          &loop,
          out_debug_info));
  loop.Run();
}

::media_session::mojom::blink::MediaSessionDebugInfoPtr AudioFocusManagerDebugAsyncWaiter::GetDebugInfoForRequest(
    const ::base::UnguessableToken& request_id) {
  ::media_session::mojom::blink::MediaSessionDebugInfoPtr async_wait_result;
  GetDebugInfoForRequest(std::move(request_id),&async_wait_result);
  return async_wait_result;
}






}  // media_session::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif