// services/media_session/public/mojom/media_session.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_DATA_VIEW_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/media_session/public/mojom/media_session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace media_session::mojom {
class MediaImageDataView;

class ChapterInformationDataView;

class MediaMetadataDataView;

class MediaImageBitmapDataView;

class MediaPositionDataView;

class RemotePlaybackMetadataDataView;

class MediaSessionInfoDataView;

class MediaSessionDebugInfoDataView;



}  // media_session::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media_session::mojom::MediaImageDataView> {
  using Data = ::media_session::mojom::internal::MediaImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::ChapterInformationDataView> {
  using Data = ::media_session::mojom::internal::ChapterInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaMetadataDataView> {
  using Data = ::media_session::mojom::internal::MediaMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaImageBitmapDataView> {
  using Data = ::media_session::mojom::internal::MediaImageBitmap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaPositionDataView> {
  using Data = ::media_session::mojom::internal::MediaPosition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::RemotePlaybackMetadataDataView> {
  using Data = ::media_session::mojom::internal::RemotePlaybackMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaSessionInfoDataView> {
  using Data = ::media_session::mojom::internal::MediaSessionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_session::mojom::MediaSessionDebugInfoDataView> {
  using Data = ::media_session::mojom::internal::MediaSessionDebugInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media_session::mojom {


enum class MediaPlaybackState : int32_t {
  
  kPaused = 0,
  
  kPlaying = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, MediaPlaybackState value);
inline bool IsKnownEnumValue(MediaPlaybackState value) {
  return internal::MediaPlaybackState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSessionAction : int32_t {
  
  kPlay = 0,
  
  kPause = 1,
  
  kPreviousTrack = 2,
  
  kNextTrack = 3,
  
  kSeekBackward = 4,
  
  kSeekForward = 5,
  
  kSkipAd = 6,
  
  kStop = 7,
  
  kSeekTo = 8,
  
  kScrubTo = 9,
  
  kEnterPictureInPicture = 10,
  
  kExitPictureInPicture = 11,
  
  kSwitchAudioDevice = 12,
  
  kToggleMicrophone = 13,
  
  kToggleCamera = 14,
  
  kHangUp = 15,
  
  kRaise = 16,
  
  kSetMute = 17,
  
  kPreviousSlide = 18,
  
  kNextSlide = 19,
  
  kEnterAutoPictureInPicture = 20,
  kMinValue = 0,
  kMaxValue = 20,
};

 std::ostream& operator<<(std::ostream& os, MediaSessionAction value);
inline bool IsKnownEnumValue(MediaSessionAction value) {
  return internal::MediaSessionAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSessionImageType : int32_t {
  
  kArtwork = 0,
  
  kSourceIcon = 1,
  
  kChapter = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MediaSessionImageType value);
inline bool IsKnownEnumValue(MediaSessionImageType value) {
  return internal::MediaSessionImageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaPictureInPictureState : int32_t {
  
  kNotInPictureInPicture = 0,
  
  kInPictureInPicture = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, MediaPictureInPictureState value);
inline bool IsKnownEnumValue(MediaPictureInPictureState value) {
  return internal::MediaPictureInPictureState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaAudioVideoState : int32_t {
  
  kDeprecatedUnknown = 0,
  
  kAudioOnly = 1,
  
  kAudioVideo = 2,
  
  kVideoOnly = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MediaAudioVideoState value);
inline bool IsKnownEnumValue(MediaAudioVideoState value) {
  return internal::MediaAudioVideoState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaImageBitmapColorType : int32_t {
  
  kRGBA_8888 = 0,
  
  kBGRA_8888 = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, MediaImageBitmapColorType value);
inline bool IsKnownEnumValue(MediaImageBitmapColorType value) {
  return internal::MediaImageBitmapColorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MicrophoneState : int32_t {
  
  kUnknown = 0,
  
  kMuted = 1,
  
  kUnmuted = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MicrophoneState value);
inline bool IsKnownEnumValue(MicrophoneState value) {
  return internal::MicrophoneState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CameraState : int32_t {
  
  kUnknown = 0,
  
  kTurnedOn = 1,
  
  kTurnedOff = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CameraState value);
inline bool IsKnownEnumValue(CameraState value) {
  return internal::CameraState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSessionInfo_SessionState : int32_t {
  
  kActive = 0,
  
  kDucking = 1,
  
  kSuspended = 2,
  
  kInactive = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MediaSessionInfo_SessionState value);
inline bool IsKnownEnumValue(MediaSessionInfo_SessionState value) {
  return internal::MediaSessionInfo_SessionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSession_SuspendType : int32_t {
  
  kSystem = 0,
  
  kUI = 1,
  
  kContent = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MediaSession_SuspendType value);
inline bool IsKnownEnumValue(MediaSession_SuspendType value) {
  return internal::MediaSession_SuspendType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaSessionObserverInterfaceBase {};

using MediaSessionObserverPtrDataView =
    mojo::InterfacePtrDataView<MediaSessionObserverInterfaceBase>;
using MediaSessionObserverRequestDataView =
    mojo::InterfaceRequestDataView<MediaSessionObserverInterfaceBase>;
using MediaSessionObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaSessionObserverInterfaceBase>;
using MediaSessionObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaSessionObserverInterfaceBase>;
class MediaSessionInterfaceBase {};

using MediaSessionPtrDataView =
    mojo::InterfacePtrDataView<MediaSessionInterfaceBase>;
using MediaSessionRequestDataView =
    mojo::InterfaceRequestDataView<MediaSessionInterfaceBase>;
using MediaSessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaSessionInterfaceBase>;
using MediaSessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaSessionInterfaceBase>;


class MediaImageDataView {
 public:
  MediaImageDataView() = default;

  MediaImageDataView(
      internal::MediaImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrcDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTypeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizes(UserType* output) {
    
    auto* pointer = data_->sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChapterInformationDataView {
 public:
  ChapterInformationDataView() = default;

  ChapterInformationDataView(
      internal::ChapterInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->startTime.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetArtworkDataView(
      mojo::ArrayDataView<MediaImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArtwork(UserType* output) {
    
    auto* pointer = data_->artwork.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ChapterInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaMetadataDataView {
 public:
  MediaMetadataDataView() = default;

  MediaMetadataDataView(
      internal::MediaMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetArtistDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArtist(UserType* output) {
    
    auto* pointer = data_->artist.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAlbumDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlbum(UserType* output) {
    
    auto* pointer = data_->album.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSourceTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceTitle(UserType* output) {
    
    auto* pointer = data_->source_title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetChaptersDataView(
      mojo::ArrayDataView<ChapterInformationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChapters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>, UserType>(),
    "Attempting to read the optional `chapters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadChapters` instead "
    "of `ReadChapters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 21
                    ? data_->chapters.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaImageBitmapDataView {
 public:
  MediaImageBitmapDataView() = default;

  MediaImageBitmapDataView(
      internal::MediaImageBitmap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t width() const {
    return data_->width;
  }
  int32_t height() const {
    return data_->height;
  }
  inline void GetPixelDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelData(UserType* output) {
    
    auto* pointer = data_->pixel_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColorType(UserType* output) const {
    auto data_value = data_->header_.version >= 5
                      ? data_->color_type : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MediaImageBitmapColorType>(
        data_value, output);
  }
  MediaImageBitmapColorType color_type() const {
    if (data_->header_.version < 5)
      return MediaImageBitmapColorType{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaImageBitmapColorType>(data_->color_type));
  }
 private:
  internal::MediaImageBitmap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaPositionDataView {
 public:
  MediaPositionDataView() = default;

  MediaPositionDataView(
      internal::MediaPosition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double playback_rate() const {
    return data_->playback_rate;
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLastUpdatedTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUpdatedTime(UserType* output) {
    
    auto* pointer = data_->last_updated_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  bool end_of_media() const {
    if (data_->header_.version < 13)
      return bool{};
    return data_->end_of_media;
  }
 private:
  internal::MediaPosition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotePlaybackMetadataDataView {
 public:
  RemotePlaybackMetadataDataView() = default;

  RemotePlaybackMetadataDataView(
      internal::RemotePlaybackMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVideoCodecDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoCodec(UserType* output) {
    
    auto* pointer = data_->video_codec.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAudioCodecDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioCodec(UserType* output) {
    
    auto* pointer = data_->audio_codec.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool remote_playback_disabled() const {
    return data_->remote_playback_disabled;
  }
  bool remote_playback_started() const {
    if (data_->header_.version < 17)
      return bool{};
    return data_->remote_playback_started;
  }
  inline void GetUnusedFieldDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnusedField(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `unused_field` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUnusedField` instead "
    "of `ReadUnusedField if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 17
                    ? data_->unused_field.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_encrypted_media() const {
    if (data_->header_.version < 18)
      return bool{};
    return data_->is_encrypted_media;
  }
 private:
  internal::RemotePlaybackMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaSessionInfoDataView {
 public:
  MediaSessionInfoDataView() = default;

  MediaSessionInfoDataView(
      internal::MediaSessionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionInfo_SessionState>(
        data_value, output);
  }
  MediaSessionInfo_SessionState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaSessionInfo_SessionState>(data_->state));
  }
  bool force_duck() const {
    return data_->force_duck;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPlaybackState(UserType* output) const {
    auto data_value = data_->header_.version >= 1
                      ? data_->playback_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MediaPlaybackState>(
        data_value, output);
  }
  MediaPlaybackState playback_state() const {
    if (data_->header_.version < 1)
      return MediaPlaybackState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaPlaybackState>(data_->playback_state));
  }
  bool is_controllable() const {
    if (data_->header_.version < 2)
      return bool{};
    return data_->is_controllable;
  }
  bool prefer_stop_for_gain_focus_loss() const {
    if (data_->header_.version < 4)
      return bool{};
    return data_->prefer_stop_for_gain_focus_loss;
  }
  bool deprecated_is_sensitive() const {
    if (data_->header_.version < 6)
      return bool{};
    return data_->deprecated_is_sensitive;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPictureInPictureState(UserType* output) const {
    auto data_value = data_->header_.version >= 7
                      ? data_->picture_in_picture_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MediaPictureInPictureState>(
        data_value, output);
  }
  MediaPictureInPictureState picture_in_picture_state() const {
    if (data_->header_.version < 7)
      return MediaPictureInPictureState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaPictureInPictureState>(data_->picture_in_picture_state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedAudioVideoState(UserType* output) const {
    auto data_value = data_->header_.version >= 8
                      ? data_->deprecated_audio_video_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MediaAudioVideoState>(
        data_value, output);
  }
  MediaAudioVideoState deprecated_audio_video_state() const {
    if (data_->header_.version < 8)
      return MediaAudioVideoState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaAudioVideoState>(data_->deprecated_audio_video_state));
  }
  inline void GetAudioSinkIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioSinkId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `audio_sink_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAudioSinkId` instead "
    "of `ReadAudioSinkId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 9
                    ? data_->audio_sink_id.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAudioVideoStatesDataView(
      mojo::ArrayDataView<MediaAudioVideoState>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioVideoStates(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media_session::mojom::MediaAudioVideoState>, UserType>(),
    "Attempting to read the optional `audio_video_states` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAudioVideoStates` instead "
    "of `ReadAudioVideoStates if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 10
                    ? data_->audio_video_states.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::MediaAudioVideoState>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMicrophoneState(UserType* output) const {
    auto data_value = data_->header_.version >= 11
                      ? data_->microphone_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::MicrophoneState>(
        data_value, output);
  }
  MicrophoneState microphone_state() const {
    if (data_->header_.version < 11)
      return MicrophoneState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MicrophoneState>(data_->microphone_state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCameraState(UserType* output) const {
    auto data_value = data_->header_.version >= 11
                      ? data_->camera_state : 0;
    return mojo::internal::Deserialize<::media_session::mojom::CameraState>(
        data_value, output);
  }
  CameraState camera_state() const {
    if (data_->header_.version < 11)
      return CameraState{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::CameraState>(data_->camera_state));
  }
  bool muted() const {
    if (data_->header_.version < 12)
      return bool{};
    return data_->muted;
  }
  bool has_presentation() const {
    if (data_->header_.version < 14)
      return bool{};
    return data_->has_presentation;
  }
  inline void GetRemotePlaybackMetadataDataView(
      RemotePlaybackMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemotePlaybackMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::RemotePlaybackMetadataDataView, UserType>(),
    "Attempting to read the optional `remote_playback_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemotePlaybackMetadata` instead "
    "of `ReadRemotePlaybackMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 15
                    ? data_->remote_playback_metadata.Get() : nullptr;
    return mojo::internal::Deserialize<::media_session::mojom::RemotePlaybackMetadataDataView>(
        pointer, output, message_);
  }
  bool hide_metadata() const {
    if (data_->header_.version < 16)
      return bool{};
    return data_->hide_metadata;
  }
  bool ignore_for_active_session() const {
    if (data_->header_.version < 20)
      return bool{};
    return data_->ignore_for_active_session;
  }
  bool meets_visibility_threshold() const {
    if (data_->header_.version < 21)
      return bool{};
    return data_->meets_visibility_threshold;
  }
 private:
  internal::MediaSessionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaSessionDebugInfoDataView {
 public:
  MediaSessionDebugInfoDataView() = default;

  MediaSessionDebugInfoDataView(
      internal::MediaSessionDebugInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOwnerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOwner(UserType* output) {
    
    auto* pointer = data_->owner.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) {
    
    auto* pointer = data_->state.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaSessionDebugInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media_session::mojom

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_DATA_VIEW_H_