// services/network/public/mojom/address_list.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/address_list.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"




#include "services/network/public/mojom/address_list.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::AddressListDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::AddressListDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::AddressList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::addresses(input)) in_addresses = Traits::addresses(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->addresses)::BaseType>
        addresses_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& addresses_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>>(
      in_addresses,
      addresses_fragment,
      &addresses_validate_params);

    fragment->addresses.Set(
        addresses_fragment.is_null() ? nullptr : addresses_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->addresses.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null addresses in AddressList struct");

    decltype(Traits::dns_aliases(input)) in_dns_aliases = Traits::dns_aliases(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dns_aliases)::BaseType>
        dns_aliases_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& dns_aliases_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_dns_aliases,
      dns_aliases_fragment,
      &dns_aliases_validate_params);

    fragment->dns_aliases.Set(
        dns_aliases_fragment.is_null() ? nullptr : dns_aliases_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dns_aliases.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dns_aliases in AddressList struct");
  }

  static bool Deserialize(::network::mojom::internal::AddressList_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::AddressListDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void AddressListDataView::GetAddressesDataView(
    mojo::ArrayDataView<::network::mojom::IPEndPointDataView>* output) {
  auto pointer = data_->addresses.Get();
  *output = mojo::ArrayDataView<::network::mojom::IPEndPointDataView>(pointer, message_);
}
inline void AddressListDataView::GetDnsAliasesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->dns_aliases.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_SHARED_H_