// services/network/public/mojom/cookie_partition_key.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/cookie_partition_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"


namespace network::mojom {
class CookiePartitionKeyDataView;

class CookiePartitionKeyCollectionDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CookiePartitionKeyDataView> {
  using Data = ::network::mojom::internal::CookiePartitionKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookiePartitionKeyCollectionDataView> {
  using Data = ::network::mojom::internal::CookiePartitionKeyCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class AncestorChainBit : int32_t {
  
  kSameSite = 0,
  
  kCrossSite = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, AncestorChainBit value);
inline bool IsKnownEnumValue(AncestorChainBit value) {
  return internal::AncestorChainBit_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CookiePartitionKeyDataView {
 public:
  CookiePartitionKeyDataView() = default;

  CookiePartitionKeyDataView(
      internal::CookiePartitionKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  bool from_script() const {
    return data_->from_script;
  }
  inline void GetNonceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAncestorChainBit(UserType* output) const {
    auto data_value = data_->ancestor_chain_bit;
    return mojo::internal::Deserialize<::network::mojom::AncestorChainBit>(
        data_value, output);
  }
  AncestorChainBit ancestor_chain_bit() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AncestorChainBit>(data_->ancestor_chain_bit));
  }
 private:
  internal::CookiePartitionKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookiePartitionKeyCollectionDataView {
 public:
  CookiePartitionKeyCollectionDataView() = default;

  CookiePartitionKeyCollectionDataView(
      internal::CookiePartitionKeyCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool contains_all_partitions() const {
    return data_->contains_all_partitions;
  }
  inline void GetKeysDataView(
      mojo::ArrayDataView<CookiePartitionKeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeys(UserType* output) {
    
    auto* pointer = data_->keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookiePartitionKeyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CookiePartitionKeyCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_PARTITION_KEY_MOJOM_DATA_VIEW_H_