// services/network/public/mojom/cors.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/cors.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"


namespace network::mojom {
class CorsErrorStatusDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CorsErrorStatusDataView> {
  using Data = ::network::mojom::internal::CorsErrorStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class CorsPreflightPolicy : int32_t {
  
  kConsiderPreflight = 0,
  
  kPreventPreflight = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CorsPreflightPolicy value);
inline bool IsKnownEnumValue(CorsPreflightPolicy value) {
  return internal::CorsPreflightPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CorsError : int32_t {
  
  kDisallowedByMode = 0,
  
  kInvalidResponse = 1,
  
  kWildcardOriginNotAllowed = 2,
  
  kMissingAllowOriginHeader = 3,
  
  kMultipleAllowOriginValues = 4,
  
  kInvalidAllowOriginValue = 5,
  
  kAllowOriginMismatch = 6,
  
  kInvalidAllowCredentials = 7,
  
  kCorsDisabledScheme = 8,
  
  kPreflightInvalidStatus = 9,
  
  kPreflightDisallowedRedirect = 10,
  
  kPreflightWildcardOriginNotAllowed = 11,
  
  kPreflightMissingAllowOriginHeader = 12,
  
  kPreflightMultipleAllowOriginValues = 13,
  
  kPreflightInvalidAllowOriginValue = 14,
  
  kPreflightAllowOriginMismatch = 15,
  
  kPreflightInvalidAllowCredentials = 16,
  
  kPreflightMissingAllowPrivateNetwork = 17,
  
  kPreflightInvalidAllowPrivateNetwork = 18,
  
  kInvalidAllowMethodsPreflightResponse = 19,
  
  kInvalidAllowHeadersPreflightResponse = 20,
  
  kMethodDisallowedByPreflightResponse = 21,
  
  kHeaderDisallowedByPreflightResponse = 22,
  
  kRedirectContainsCredentials = 23,
  
  kInsecurePrivateNetwork = 24,
  
  kInvalidPrivateNetworkAccess = 25,
  
  kUnexpectedPrivateNetworkAccess = 26,
  
  kPreflightMissingPrivateNetworkAccessId = 27,
  
  kPreflightMissingPrivateNetworkAccessName = 28,
  
  kPrivateNetworkAccessPermissionUnavailable = 29,
  
  kPrivateNetworkAccessPermissionDenied = 30,
  
  kLocalNetworkAccessPermissionDenied = 31,
  kMinValue = 0,
  kMaxValue = 31,
};

 std::ostream& operator<<(std::ostream& os, CorsError value);
inline bool IsKnownEnumValue(CorsError value) {
  return internal::CorsError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PrivateNetworkAccessPreflightResult : int32_t {
  
  kNone = 0,
  
  kSuccess = 1,
  
  kWarning = 2,
  
  kError = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PrivateNetworkAccessPreflightResult value);
inline bool IsKnownEnumValue(PrivateNetworkAccessPreflightResult value) {
  return internal::PrivateNetworkAccessPreflightResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CorsErrorStatusDataView {
 public:
  CorsErrorStatusDataView() = default;

  CorsErrorStatusDataView(
      internal::CorsErrorStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCorsError(UserType* output) const {
    auto data_value = data_->cors_error;
    return mojo::internal::Deserialize<::network::mojom::CorsError>(
        data_value, output);
  }
  CorsError cors_error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CorsError>(data_->cors_error));
  }
  inline void GetFailedParameterDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFailedParameter(UserType* output) {
    
    auto* pointer = data_->failed_parameter.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetAddressSpace(UserType* output) const {
    auto data_value = data_->target_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace target_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->target_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResourceAddressSpace(UserType* output) const {
    auto data_value = data_->resource_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace resource_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->resource_address_space));
  }
  bool has_authorization_covered_by_wildcard_on_preflight() const {
    return data_->has_authorization_covered_by_wildcard_on_preflight;
  }
  inline void GetIssueIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssueId(UserType* output) {
    
    auto* pointer = data_->issue_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::CorsErrorStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_DATA_VIEW_H_