// services/network/public/mojom/cors_origin_pattern.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"




#include "services/network/public/mojom/cors_origin_pattern.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::CorsPortMatchMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::CorsPortMatchMode> {};

template <>
struct hash<::network::mojom::CorsDomainMatchMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::CorsDomainMatchMode> {};

template <>
struct hash<::network::mojom::CorsOriginAccessMatchPriority>
    : public mojo::internal::EnumHashImpl<::network::mojom::CorsOriginAccessMatchPriority> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CorsPortMatchMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CorsPortMatchMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CorsPortMatchMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CorsDomainMatchMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CorsDomainMatchMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CorsDomainMatchMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CorsOriginAccessMatchPriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CorsOriginAccessMatchPriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CorsOriginAccessMatchPriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CorsOriginPatternDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CorsOriginPatternDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CorsOriginPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::protocol(input)) in_protocol = Traits::protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protocol)::BaseType> protocol_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_protocol,
      protocol_fragment);

    fragment->protocol.Set(
        protocol_fragment.is_null() ? nullptr : protocol_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->protocol.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null protocol in CorsOriginPattern struct");

    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain)::BaseType> domain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_domain,
      domain_fragment);

    fragment->domain.Set(
        domain_fragment.is_null() ? nullptr : domain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in CorsOriginPattern struct");

    fragment->port = Traits::port(input);

    
    mojo::internal::Serialize<::network::mojom::CorsDomainMatchMode>(
      Traits::domain_match_mode(input),
      &fragment->domain_match_mode);

    
    mojo::internal::Serialize<::network::mojom::CorsPortMatchMode>(
      Traits::port_match_mode(input),
      &fragment->port_match_mode);

    
    mojo::internal::Serialize<::network::mojom::CorsOriginAccessMatchPriority>(
      Traits::priority(input),
      &fragment->priority);
  }

  static bool Deserialize(::network::mojom::internal::CorsOriginPattern_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CorsOriginPatternDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CorsOriginAccessPatternsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CorsOriginAccessPatternsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CorsOriginAccessPatterns_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::source_origin(input)) in_source_origin = Traits::source_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_origin)::BaseType> source_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_source_origin,
      source_origin_fragment);

    fragment->source_origin.Set(
        source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in CorsOriginAccessPatterns struct");

    decltype(Traits::allow_patterns(input)) in_allow_patterns = Traits::allow_patterns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allow_patterns)::BaseType>
        allow_patterns_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allow_patterns_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>>(
      in_allow_patterns,
      allow_patterns_fragment,
      &allow_patterns_validate_params);

    fragment->allow_patterns.Set(
        allow_patterns_fragment.is_null() ? nullptr : allow_patterns_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allow_patterns.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allow_patterns in CorsOriginAccessPatterns struct");

    decltype(Traits::block_patterns(input)) in_block_patterns = Traits::block_patterns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->block_patterns)::BaseType>
        block_patterns_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& block_patterns_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>>(
      in_block_patterns,
      block_patterns_fragment,
      &block_patterns_validate_params);

    fragment->block_patterns.Set(
        block_patterns_fragment.is_null() ? nullptr : block_patterns_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->block_patterns.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null block_patterns in CorsOriginAccessPatterns struct");
  }

  static bool Deserialize(::network::mojom::internal::CorsOriginAccessPatterns_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CorsOriginAccessPatternsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void CorsOriginPatternDataView::GetProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->protocol.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CorsOriginPatternDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CorsOriginAccessPatternsDataView::GetSourceOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->source_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void CorsOriginAccessPatternsDataView::GetAllowPatternsDataView(
    mojo::ArrayDataView<CorsOriginPatternDataView>* output) {
  auto pointer = data_->allow_patterns.Get();
  *output = mojo::ArrayDataView<CorsOriginPatternDataView>(pointer, message_);
}
inline void CorsOriginAccessPatternsDataView::GetBlockPatternsDataView(
    mojo::ArrayDataView<CorsOriginPatternDataView>* output) {
  auto pointer = data_->block_patterns.Get();
  *output = mojo::ArrayDataView<CorsOriginPatternDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CorsPortMatchMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CorsPortMatchMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CorsDomainMatchMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CorsDomainMatchMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CorsOriginAccessMatchPriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CorsOriginAccessMatchPriority value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_SHARED_H_