// services/network/public/mojom/network_context.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/network_context.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "components/ip_protection/mojom/core.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared.h"
#include "services/network/public/mojom/cookie_encryption_provider.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_setting_overrides.mojom-shared.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/default_credentials.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/devtools_observer.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-shared.h"
#include "services/network/public/mojom/hash_value.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/mdns_responder.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/net_log.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_context_client.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/oblivious_http_request.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/proxy_config.mojom-shared.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-shared.h"
#include "services/network/public/mojom/proxy_lookup_client.mojom-shared.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom-shared.h"
#include "services/network/public/mojom/connection_change_observer_client.mojom-shared.h"
#include "services/network/public/mojom/reporting_service.mojom-shared.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/socket_broker.mojom-shared.h"
#include "services/network/public/mojom/ssl_config.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared.h"
#include "services/network/public/mojom/transferable_directory.mojom-shared.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/udp_socket.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_transport.mojom-shared.h"
#include "services/network/public/mojom/websocket.mojom-shared.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/p2p.mojom-shared.h"
#include "services/network/public/mojom/p2p_trusted.mojom-shared.h"


namespace network::mojom {
class CustomProxyConfigDataView;

class CertVerifierServiceRemoteParamsDataView;

class HttpAuthStaticNetworkContextParamsDataView;

class CTPolicyDataView;

class NetworkContextFilePathsDataView;

class NetworkContextParamsDataView;

class NetworkConditionsDataView;

class SharedDictionaryInfoDataView;

class SignedExchangeReportDataView;

class URLLoaderFactoryOverrideDataView;

class URLLoaderFactoryParamsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CustomProxyConfigDataView> {
  using Data = ::network::mojom::internal::CustomProxyConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CertVerifierServiceRemoteParamsDataView> {
  using Data = ::network::mojom::internal::CertVerifierServiceRemoteParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HttpAuthStaticNetworkContextParamsDataView> {
  using Data = ::network::mojom::internal::HttpAuthStaticNetworkContextParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CTPolicyDataView> {
  using Data = ::network::mojom::internal::CTPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkContextFilePathsDataView> {
  using Data = ::network::mojom::internal::NetworkContextFilePaths_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkContextParamsDataView> {
  using Data = ::network::mojom::internal::NetworkContextParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkConditionsDataView> {
  using Data = ::network::mojom::internal::NetworkConditions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedDictionaryInfoDataView> {
  using Data = ::network::mojom::internal::SharedDictionaryInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SignedExchangeReportDataView> {
  using Data = ::network::mojom::internal::SignedExchangeReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLLoaderFactoryOverrideDataView> {
  using Data = ::network::mojom::internal::URLLoaderFactoryOverride_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLLoaderFactoryParamsDataView> {
  using Data = ::network::mojom::internal::URLLoaderFactoryParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class TrustTokenOperationPolicyVerdict : int32_t {
  
  kForbid = 0,
  
  kPotentiallyPermit = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenOperationPolicyVerdict value);
inline bool IsKnownEnumValue(TrustTokenOperationPolicyVerdict value) {
  return internal::TrustTokenOperationPolicyVerdict_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SCTAuditingMode : int32_t {
  
  kDisabled = 0,
  
  kEnhancedSafeBrowsingReporting = 1,
  
  kHashdance = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SCTAuditingMode value);
inline bool IsKnownEnumValue(SCTAuditingMode value) {
  return internal::SCTAuditingMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NetworkContext_DomainReliabilityClearMode : int32_t {
  
  CLEAR_CONTEXTS = 0,
  
  CLEAR_BEACONS = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, NetworkContext_DomainReliabilityClearMode value);
inline bool IsKnownEnumValue(NetworkContext_DomainReliabilityClearMode value) {
  return internal::NetworkContext_DomainReliabilityClearMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CustomProxyConnectionObserverInterfaceBase {};

using CustomProxyConnectionObserverPtrDataView =
    mojo::InterfacePtrDataView<CustomProxyConnectionObserverInterfaceBase>;
using CustomProxyConnectionObserverRequestDataView =
    mojo::InterfaceRequestDataView<CustomProxyConnectionObserverInterfaceBase>;
using CustomProxyConnectionObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomProxyConnectionObserverInterfaceBase>;
using CustomProxyConnectionObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomProxyConnectionObserverInterfaceBase>;
class CustomProxyConfigClientInterfaceBase {};

using CustomProxyConfigClientPtrDataView =
    mojo::InterfacePtrDataView<CustomProxyConfigClientInterfaceBase>;
using CustomProxyConfigClientRequestDataView =
    mojo::InterfaceRequestDataView<CustomProxyConfigClientInterfaceBase>;
using CustomProxyConfigClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomProxyConfigClientInterfaceBase>;
using CustomProxyConfigClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomProxyConfigClientInterfaceBase>;
class TrustedHeaderClientInterfaceBase {};

using TrustedHeaderClientPtrDataView =
    mojo::InterfacePtrDataView<TrustedHeaderClientInterfaceBase>;
using TrustedHeaderClientRequestDataView =
    mojo::InterfaceRequestDataView<TrustedHeaderClientInterfaceBase>;
using TrustedHeaderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TrustedHeaderClientInterfaceBase>;
using TrustedHeaderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TrustedHeaderClientInterfaceBase>;
class TrustedURLLoaderHeaderClientInterfaceBase {};

using TrustedURLLoaderHeaderClientPtrDataView =
    mojo::InterfacePtrDataView<TrustedURLLoaderHeaderClientInterfaceBase>;
using TrustedURLLoaderHeaderClientRequestDataView =
    mojo::InterfaceRequestDataView<TrustedURLLoaderHeaderClientInterfaceBase>;
using TrustedURLLoaderHeaderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TrustedURLLoaderHeaderClientInterfaceBase>;
using TrustedURLLoaderHeaderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TrustedURLLoaderHeaderClientInterfaceBase>;
class PreloadedSharedDictionaryInfoHandleInterfaceBase {};

using PreloadedSharedDictionaryInfoHandlePtrDataView =
    mojo::InterfacePtrDataView<PreloadedSharedDictionaryInfoHandleInterfaceBase>;
using PreloadedSharedDictionaryInfoHandleRequestDataView =
    mojo::InterfaceRequestDataView<PreloadedSharedDictionaryInfoHandleInterfaceBase>;
using PreloadedSharedDictionaryInfoHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PreloadedSharedDictionaryInfoHandleInterfaceBase>;
using PreloadedSharedDictionaryInfoHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PreloadedSharedDictionaryInfoHandleInterfaceBase>;
class NetworkContextInterfaceBase {};

using NetworkContextPtrDataView =
    mojo::InterfacePtrDataView<NetworkContextInterfaceBase>;
using NetworkContextRequestDataView =
    mojo::InterfaceRequestDataView<NetworkContextInterfaceBase>;
using NetworkContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NetworkContextInterfaceBase>;
using NetworkContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NetworkContextInterfaceBase>;


class CustomProxyConfigDataView {
 public:
  CustomProxyConfigDataView() = default;

  CustomProxyConfigDataView(
      internal::CustomProxyConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRulesDataView(
      ::network::mojom::ProxyRulesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRules(UserType* output) {
    
    auto* pointer = data_->rules.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyRulesDataView>(
        pointer, output, message_);
  }
  bool should_override_existing_config() const {
    return data_->should_override_existing_config;
  }
  bool allow_non_idempotent_methods() const {
    return data_->allow_non_idempotent_methods;
  }
  inline void GetConnectTunnelHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectTunnelHeaders(UserType* output) {
    
    auto* pointer = data_->connect_tunnel_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
 private:
  internal::CustomProxyConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CertVerifierServiceRemoteParamsDataView {
 public:
  CertVerifierServiceRemoteParamsDataView() = default;

  CertVerifierServiceRemoteParamsDataView(
      internal::CertVerifierServiceRemoteParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeCertVerifierService() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::CertVerifierServiceInterfaceBase>>(
            &data_->cert_verifier_service, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCertVerifierServiceClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::cert_verifier::mojom::CertVerifierServiceClientInterfaceBase>>(
            &data_->cert_verifier_service_client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CertVerifierServiceRemoteParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HttpAuthStaticNetworkContextParamsDataView {
 public:
  HttpAuthStaticNetworkContextParamsDataView() = default;

  HttpAuthStaticNetworkContextParamsDataView(
      internal::HttpAuthStaticNetworkContextParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAllowDefaultCredentials(UserType* output) const {
    auto data_value = data_->allow_default_credentials;
    return mojo::internal::Deserialize<::network::mojom::DefaultCredentials>(
        data_value, output);
  }
  ::network::mojom::DefaultCredentials allow_default_credentials() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DefaultCredentials>(data_->allow_default_credentials));
  }
 private:
  internal::HttpAuthStaticNetworkContextParams_Data* data_ = nullptr;
};


class CTPolicyDataView {
 public:
  CTPolicyDataView() = default;

  CTPolicyDataView(
      internal::CTPolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExcludedHostsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludedHosts(UserType* output) {
    
    auto* pointer = data_->excluded_hosts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetExcludedSpkisDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludedSpkis(UserType* output) {
    
    auto* pointer = data_->excluded_spkis.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CTPolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkContextFilePathsDataView {
 public:
  NetworkContextFilePathsDataView() = default;

  NetworkContextFilePathsDataView(
      internal::NetworkContextFilePaths_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSharedDictionaryDirectoryDataView(
      ::network::mojom::TransferableDirectoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedDictionaryDirectory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TransferableDirectoryDataView, UserType>(),
    "Attempting to read the optional `shared_dictionary_directory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedDictionaryDirectory` instead "
    "of `ReadSharedDictionaryDirectory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->shared_dictionary_directory.is_null() ? &data_->shared_dictionary_directory : nullptr;
    return mojo::internal::Deserialize<::network::mojom::TransferableDirectoryDataView>(
        pointer, output, message_);
  }
  inline void GetHttpCacheDirectoryDataView(
      ::network::mojom::TransferableDirectoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpCacheDirectory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TransferableDirectoryDataView, UserType>(),
    "Attempting to read the optional `http_cache_directory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHttpCacheDirectory` instead "
    "of `ReadHttpCacheDirectory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->http_cache_directory.is_null() ? &data_->http_cache_directory : nullptr;
    return mojo::internal::Deserialize<::network::mojom::TransferableDirectoryDataView>(
        pointer, output, message_);
  }
  inline void GetNoVarySearchDirectoryDataView(
      ::network::mojom::TransferableDirectoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNoVarySearchDirectory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TransferableDirectoryDataView, UserType>(),
    "Attempting to read the optional `no_vary_search_directory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNoVarySearchDirectory` instead "
    "of `ReadNoVarySearchDirectory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->no_vary_search_directory.is_null() ? &data_->no_vary_search_directory : nullptr;
    return mojo::internal::Deserialize<::network::mojom::TransferableDirectoryDataView>(
        pointer, output, message_);
  }
  inline void GetDataDirectoryDataView(
      ::network::mojom::TransferableDirectoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataDirectory(UserType* output) {
    
    auto* pointer = !data_->data_directory.is_null() ? &data_->data_directory : nullptr;
    return mojo::internal::Deserialize<::network::mojom::TransferableDirectoryDataView>(
        pointer, output, message_);
  }
  inline void GetUnsandboxedDataPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnsandboxedDataPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `unsandboxed_data_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUnsandboxedDataPath` instead "
    "of `ReadUnsandboxedDataPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->unsandboxed_data_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetCookieDatabaseNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieDatabaseName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `cookie_database_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieDatabaseName` instead "
    "of `ReadCookieDatabaseName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_database_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceBoundSessionsDatabaseNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceBoundSessionsDatabaseName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `device_bound_sessions_database_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeviceBoundSessionsDatabaseName` instead "
    "of `ReadDeviceBoundSessionsDatabaseName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->device_bound_sessions_database_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetTrustTokenDatabaseNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenDatabaseName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `trust_token_database_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenDatabaseName` instead "
    "of `ReadTrustTokenDatabaseName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_database_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetHttpServerPropertiesFileNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpServerPropertiesFileName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `http_server_properties_file_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHttpServerPropertiesFileName` instead "
    "of `ReadHttpServerPropertiesFileName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->http_server_properties_file_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetTransportSecurityPersisterFileNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransportSecurityPersisterFileName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `transport_security_persister_file_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTransportSecurityPersisterFileName` instead "
    "of `ReadTransportSecurityPersisterFileName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->transport_security_persister_file_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetReportingAndNelStoreDatabaseNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingAndNelStoreDatabaseName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `reporting_and_nel_store_database_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingAndNelStoreDatabaseName` instead "
    "of `ReadReportingAndNelStoreDatabaseName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_and_nel_store_database_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetSctAuditingPendingReportsFileNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSctAuditingPendingReportsFileName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `sct_auditing_pending_reports_file_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSctAuditingPendingReportsFileName` instead "
    "of `ReadSctAuditingPendingReportsFileName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sct_auditing_pending_reports_file_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  bool trigger_migration() const {
    return data_->trigger_migration;
  }
 private:
  internal::NetworkContextFilePaths_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkContextParamsDataView {
 public:
  NetworkContextParamsDataView() = default;

  NetworkContextParamsDataView(
      internal::NetworkContextParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserAgentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAgent(UserType* output) {
    
    auto* pointer = data_->user_agent.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAcceptLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAcceptLanguage(UserType* output) {
    
    auto* pointer = data_->accept_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool enable_brotli() const {
    return data_->enable_brotli;
  }
  bool enable_zstd() const {
    return data_->enable_zstd;
  }
  bool enable_referrers() const {
    return data_->enable_referrers;
  }
  bool validate_referrer_policy_on_initial_request() const {
    return data_->validate_referrer_policy_on_initial_request;
  }
  template <typename UserType>
  UserType TakeProxyResolverFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::ProxyResolverFactoryInterfaceBase>>(
            &data_->proxy_resolver_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool enable_encrypted_cookies() const {
    return data_->enable_encrypted_cookies;
  }
  bool restore_old_session_cookies() const {
    return data_->restore_old_session_cookies;
  }
  bool persist_session_cookies() const {
    return data_->persist_session_cookies;
  }
  bool http_cache_enabled() const {
    return data_->http_cache_enabled;
  }
  int32_t http_cache_max_size() const {
    return data_->http_cache_max_size;
  }
  template <typename UserType>
  UserType TakeHttpCacheFileOperationsFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::HttpCacheBackendFileOperationsFactoryInterfaceBase>>(
            &data_->http_cache_file_operations_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool disable_idle_sockets_close_on_memory_pressure() const {
    return data_->disable_idle_sockets_close_on_memory_pressure;
  }
  inline void GetInitialSslConfigDataView(
      ::network::mojom::SSLConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialSslConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::SSLConfigDataView, UserType>(),
    "Attempting to read the optional `initial_ssl_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialSslConfig` instead "
    "of `ReadInitialSslConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_ssl_config.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeSslConfigClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::SSLConfigClientInterfaceBase>>(
            &data_->ssl_config_client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetInitialProxyConfigDataView(
      ::network::mojom::ProxyConfigWithAnnotationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialProxyConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ProxyConfigWithAnnotationDataView, UserType>(),
    "Attempting to read the optional `initial_proxy_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialProxyConfig` instead "
    "of `ReadInitialProxyConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_proxy_config.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyConfigWithAnnotationDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeProxyConfigClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::ProxyConfigClientInterfaceBase>>(
            &data_->proxy_config_client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetInitialCustomProxyConfigDataView(
      CustomProxyConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialCustomProxyConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CustomProxyConfigDataView, UserType>(),
    "Attempting to read the optional `initial_custom_proxy_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialCustomProxyConfig` instead "
    "of `ReadInitialCustomProxyConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_custom_proxy_config.Get();
    return mojo::internal::Deserialize<::network::mojom::CustomProxyConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCustomProxyConfigClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::CustomProxyConfigClientInterfaceBase>>(
            &data_->custom_proxy_config_client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCustomProxyConnectionObserverRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CustomProxyConnectionObserverInterfaceBase>>(
            &data_->custom_proxy_connection_observer_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeProxyConfigPollerClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ProxyConfigPollerClientInterfaceBase>>(
            &data_->proxy_config_poller_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeProxyErrorClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ProxyErrorClientInterfaceBase>>(
            &data_->proxy_error_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeIpProtectionCoreHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::ip_protection::mojom::CoreHostInterfaceBase>>(
            &data_->ip_protection_core_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeIpProtectionControl() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::ip_protection::mojom::CoreControlInterfaceBase>>(
            &data_->ip_protection_control, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool enable_ip_protection() const {
    return data_->enable_ip_protection;
  }
  bool ip_protection_incognito() const {
    return data_->ip_protection_incognito;
  }
  inline void GetIpProtectionDataDirectoryDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIpProtectionDataDirectory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `ip_protection_data_directory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIpProtectionDataDirectory` instead "
    "of `ReadIpProtectionDataDirectory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ip_protection_data_directory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  bool pac_quick_check_enabled() const {
    return data_->pac_quick_check_enabled;
  }
  bool enable_certificate_reporting() const {
    return data_->enable_certificate_reporting;
  }
  bool enforce_chrome_ct_policy() const {
    return data_->enforce_chrome_ct_policy;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSctAuditingMode(UserType* output) const {
    auto data_value = data_->sct_auditing_mode;
    return mojo::internal::Deserialize<::network::mojom::SCTAuditingMode>(
        data_value, output);
  }
  SCTAuditingMode sct_auditing_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SCTAuditingMode>(data_->sct_auditing_mode));
  }
  inline void GetCtPolicyDataView(
      CTPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCtPolicy(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CTPolicyDataView, UserType>(),
    "Attempting to read the optional `ct_policy` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCtPolicy` instead "
    "of `ReadCtPolicy if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ct_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CTPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetCertVerifierParamsDataView(
      CertVerifierServiceRemoteParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertVerifierParams(UserType* output) {
    
    auto* pointer = data_->cert_verifier_params.Get();
    return mojo::internal::Deserialize<::network::mojom::CertVerifierServiceRemoteParamsDataView>(
        pointer, output, message_);
  }
  inline void GetCookieManagerParamsDataView(
      ::network::mojom::CookieManagerParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieManagerParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CookieManagerParamsDataView, UserType>(),
    "Attempting to read the optional `cookie_manager_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieManagerParams` instead "
    "of `ReadCookieManagerParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_manager_params.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieManagerParamsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCookieManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
            &data_->cookie_manager, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool enable_domain_reliability() const {
    return data_->enable_domain_reliability;
  }
  inline void GetDomainReliabilityUploadReporterDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomainReliabilityUploadReporter(UserType* output) {
    
    auto* pointer = data_->domain_reliability_upload_reporter.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool discard_domain_reliablity_uploads() const {
    return data_->discard_domain_reliablity_uploads;
  }
  inline void GetReportingDeliveryIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingDeliveryInterval(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `reporting_delivery_interval` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingDeliveryInterval` instead "
    "of `ReadReportingDeliveryInterval if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_delivery_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool skip_reporting_send_permission_check() const {
    return data_->skip_reporting_send_permission_check;
  }
  inline void GetCorsOriginAccessListDataView(
      mojo::ArrayDataView<::network::mojom::CorsOriginAccessPatternsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsOriginAccessList(UserType* output) {
    
    auto* pointer = data_->cors_origin_access_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CorsOriginAccessPatternsDataView>>(
        pointer, output, message_);
  }
  inline void GetCorsExemptHeaderListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsExemptHeaderList(UserType* output) {
    
    auto* pointer = data_->cors_exempt_header_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool allow_any_cors_exempt_header_for_browser() const {
    return data_->allow_any_cors_exempt_header_for_browser;
  }
  inline void GetHstsPolicyBypassListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHstsPolicyBypassList(UserType* output) {
    
    auto* pointer = data_->hsts_policy_bypass_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetHttpAuthStaticNetworkContextParamsDataView(
      HttpAuthStaticNetworkContextParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpAuthStaticNetworkContextParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::HttpAuthStaticNetworkContextParamsDataView, UserType>(),
    "Attempting to read the optional `http_auth_static_network_context_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHttpAuthStaticNetworkContextParams` instead "
    "of `ReadHttpAuthStaticNetworkContextParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->http_auth_static_network_context_params.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpAuthStaticNetworkContextParamsDataView>(
        pointer, output, message_);
  }
  bool reset_http_cache_backend() const {
    return data_->reset_http_cache_backend;
  }
  bool split_auth_cache_by_network_anonymization_key() const {
    return data_->split_auth_cache_by_network_anonymization_key;
  }
  bool require_network_anonymization_key() const {
    return data_->require_network_anonymization_key;
  }
  inline void GetFilePathsDataView(
      NetworkContextFilePathsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePaths(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::NetworkContextFilePathsDataView, UserType>(),
    "Attempting to read the optional `file_paths` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFilePaths` instead "
    "of `ReadFilePaths if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_paths.Get();
    return mojo::internal::Deserialize<::network::mojom::NetworkContextFilePathsDataView>(
        pointer, output, message_);
  }
  bool block_trust_tokens() const {
    return data_->block_trust_tokens;
  }
  bool shared_dictionary_enabled() const {
    return data_->shared_dictionary_enabled;
  }
  uint64_t shared_dictionary_cache_max_size() const {
    return data_->shared_dictionary_cache_max_size;
  }
  inline void GetFirstPartySetsAccessDelegateParamsDataView(
      ::network::mojom::FirstPartySetsAccessDelegateParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstPartySetsAccessDelegateParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::FirstPartySetsAccessDelegateParamsDataView, UserType>(),
    "Attempting to read the optional `first_party_sets_access_delegate_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstPartySetsAccessDelegateParams` instead "
    "of `ReadFirstPartySetsAccessDelegateParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_party_sets_access_delegate_params.Get();
    return mojo::internal::Deserialize<::network::mojom::FirstPartySetsAccessDelegateParamsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeFirstPartySetsAccessDelegateReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::FirstPartySetsAccessDelegateInterfaceBase>>(
            &data_->first_party_sets_access_delegate_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool acam_preflight_spec_conformant() const {
    return data_->acam_preflight_spec_conformant;
  }
  inline void GetCookieDeprecationLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieDeprecationLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cookie_deprecation_label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieDeprecationLabel` instead "
    "of `ReadCookieDeprecationLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_deprecation_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCookieEncryptionProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieEncryptionProviderInterfaceBase>>(
            &data_->cookie_encryption_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool device_bound_sessions_enabled() const {
    return data_->device_bound_sessions_enabled;
  }
  int64_t bound_network() const {
    return data_->bound_network;
  }
  inline void GetEnterpriseReportingEndpointsDataView(
      mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnterpriseReportingEndpoints(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>, UserType>(),
    "Attempting to read the optional `enterprise_reporting_endpoints` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEnterpriseReportingEndpoints` instead "
    "of `ReadEnterpriseReportingEndpoints if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->enterprise_reporting_endpoints.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  std::optional<int64_t> quic_idle_connection_timeout_seconds() const {

    return data_->quic_idle_connection_timeout_seconds_$flag
        ? std::make_optional(data_->quic_idle_connection_timeout_seconds_$value)
        : std::nullopt;
  }
 private:
  internal::NetworkContextParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkConditionsDataView {
 public:
  NetworkConditionsDataView() = default;

  NetworkConditionsDataView(
      internal::NetworkConditions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool offline() const {
    return data_->offline;
  }
  inline void GetLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatency(UserType* output) {
    
    auto* pointer = data_->latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  double download_throughput() const {
    return data_->download_throughput;
  }
  double upload_throughput() const {
    return data_->upload_throughput;
  }
  double packet_loss() const {
    return data_->packet_loss;
  }
  int32_t packet_queue_length() const {
    return data_->packet_queue_length;
  }
  bool packet_reordering() const {
    return data_->packet_reordering;
  }
 private:
  internal::NetworkConditions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedDictionaryInfoDataView {
 public:
  SharedDictionaryInfoDataView() = default;

  SharedDictionaryInfoDataView(
      internal::SharedDictionaryInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMatchDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatch(UserType* output) {
    
    auto* pointer = data_->match.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMatchDestDataView(
      mojo::ArrayDataView<::network::mojom::RequestDestination>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchDest(UserType* output) {
    
    auto* pointer = data_->match_dest.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::RequestDestination>>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDictionaryUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDictionaryUrl(UserType* output) {
    
    auto* pointer = data_->dictionary_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLastFetchTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastFetchTime(UserType* output) {
    
    auto* pointer = data_->last_fetch_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseTime(UserType* output) {
    
    auto* pointer = data_->response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLastUsedTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUsedTime(UserType* output) {
    
    auto* pointer = data_->last_used_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  uint64_t size() const {
    return data_->size;
  }
  inline void GetHashDataView(
      ::network::mojom::SHA256HashValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHash(UserType* output) {
    
    auto* pointer = data_->hash.Get();
    return mojo::internal::Deserialize<::network::mojom::SHA256HashValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedDictionaryInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignedExchangeReportDataView {
 public:
  SignedExchangeReportDataView() = default;

  SignedExchangeReportDataView(
      internal::SignedExchangeReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOuterUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOuterUrl(UserType* output) {
    
    auto* pointer = data_->outer_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInnerUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerUrl(UserType* output) {
    
    auto* pointer = data_->inner_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCertUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertUrl(UserType* output) {
    
    auto* pointer = data_->cert_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServerIpAddressDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerIpAddress(UserType* output) {
    
    auto* pointer = data_->server_ip_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
  inline void GetProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t status_code() const {
    return data_->status_code;
  }
  inline void GetElapsedTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElapsedTime(UserType* output) {
    
    auto* pointer = data_->elapsed_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::SignedExchangeReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderFactoryOverrideDataView {
 public:
  URLLoaderFactoryOverrideDataView() = default;

  URLLoaderFactoryOverrideDataView(
      internal::URLLoaderFactoryOverride_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeOverridingFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->overriding_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeOverriddenFactoryReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->overridden_factory_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool skip_cors_enabled_scheme_check() const {
    return data_->skip_cors_enabled_scheme_check;
  }
 private:
  internal::URLLoaderFactoryOverride_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderFactoryParamsDataView {
 public:
  URLLoaderFactoryParamsDataView() = default;

  URLLoaderFactoryParamsDataView(
      internal::URLLoaderFactoryParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t process_id() const {
    return data_->process_id;
  }
  inline void GetRequestInitiatorOriginLockDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestInitiatorOriginLock(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `request_initiator_origin_lock` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestInitiatorOriginLock` instead "
    "of `ReadRequestInitiatorOriginLock if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_initiator_origin_lock.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool is_orb_enabled() const {
    return data_->is_orb_enabled;
  }
  bool ignore_isolated_world_origin() const {
    return data_->ignore_isolated_world_origin;
  }
  bool unsafe_non_webby_initiator() const {
    return data_->unsafe_non_webby_initiator;
  }
  bool disable_web_security() const {
    return data_->disable_web_security;
  }
  template <typename UserType>
  UserType TakeHeaderClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::TrustedURLLoaderHeaderClientInterfaceBase>>(
            &data_->header_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetIsolationInfoDataView(
      ::network::mojom::IsolationInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolationInfo(UserType* output) {
    
    auto* pointer = data_->isolation_info.Get();
    return mojo::internal::Deserialize<::network::mojom::IsolationInfoDataView>(
        pointer, output, message_);
  }
  bool disable_secure_dns() const {
    return data_->disable_secure_dns;
  }
  bool is_trusted() const {
    return data_->is_trusted;
  }
  bool automatically_assign_isolation_info() const {
    return data_->automatically_assign_isolation_info;
  }
  inline void GetTopFrameIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `top_frame_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTopFrameId` instead "
    "of `ReadTopFrameId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->top_frame_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFactoryOverrideDataView(
      URLLoaderFactoryOverrideDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFactoryOverride(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLLoaderFactoryOverrideDataView, UserType>(),
    "Attempting to read the optional `factory_override` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFactoryOverride` instead "
    "of `ReadFactoryOverride if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->factory_override.Get();
    return mojo::internal::Deserialize<::network::mojom::URLLoaderFactoryOverrideDataView>(
        pointer, output, message_);
  }
  inline void GetClientSecurityStateDataView(
      ::network::mojom::ClientSecurityStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSecurityState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ClientSecurityStateDataView, UserType>(),
    "Attempting to read the optional `client_security_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClientSecurityState` instead "
    "of `ReadClientSecurityState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->client_security_state.Get();
    return mojo::internal::Deserialize<::network::mojom::ClientSecurityStateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCoepReporter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
            &data_->coep_reporter, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDipReporter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DocumentIsolationPolicyReporterInterfaceBase>>(
            &data_->dip_reporter, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCookieObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
            &data_->cookie_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeTrustTokenObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
            &data_->trust_token_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeSharedDictionaryObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
            &data_->shared_dictionary_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeUrlLoaderNetworkObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
            &data_->url_loader_network_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDevtoolsObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
            &data_->devtools_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDeviceBoundSessionObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
            &data_->device_bound_session_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenIssuancePolicy(UserType* output) const {
    auto data_value = data_->trust_token_issuance_policy;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationPolicyVerdict>(
        data_value, output);
  }
  TrustTokenOperationPolicyVerdict trust_token_issuance_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationPolicyVerdict>(data_->trust_token_issuance_policy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenRedemptionPolicy(UserType* output) const {
    auto data_value = data_->trust_token_redemption_policy;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationPolicyVerdict>(
        data_value, output);
  }
  TrustTokenOperationPolicyVerdict trust_token_redemption_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationPolicyVerdict>(data_->trust_token_redemption_policy));
  }
  inline void GetDebugTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugTag(UserType* output) {
    
    auto* pointer = data_->debug_tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCookieSettingOverridesDataView(
      ::network::mojom::CookieSettingOverridesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieSettingOverrides(UserType* output) {
    
    auto* pointer = data_->cookie_setting_overrides.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSettingOverridesDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsCookieSettingOverridesDataView(
      ::network::mojom::CookieSettingOverridesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsCookieSettingOverrides(UserType* output) {
    
    auto* pointer = data_->devtools_cookie_setting_overrides.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSettingOverridesDataView>(
        pointer, output, message_);
  }
  bool require_cross_site_request_for_cookies() const {
    return data_->require_cross_site_request_for_cookies;
  }
  bool ignore_factory_reset() const {
    return data_->ignore_factory_reset;
  }
 private:
  internal::URLLoaderFactoryParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_DATA_VIEW_H_