// services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"




#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::OriginWithPossibleWildcardsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::OriginWithPossibleWildcardsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::OriginWithPossibleWildcards_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scheme)::BaseType> scheme_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_scheme,
      scheme_fragment);

    fragment->scheme.Set(
        scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scheme.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scheme in OriginWithPossibleWildcards struct");

    decltype(Traits::host(input)) in_host = Traits::host(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host)::BaseType> host_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_host,
      host_fragment);

    fragment->host.Set(
        host_fragment.is_null() ? nullptr : host_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->host.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in OriginWithPossibleWildcards struct");

    fragment->port = Traits::port(input);

    fragment->is_host_wildcard = Traits::is_host_wildcard(input);

    fragment->is_port_wildcard = Traits::is_port_wildcard(input);
  }

  static bool Deserialize(::network::mojom::internal::OriginWithPossibleWildcards_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::OriginWithPossibleWildcardsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ParsedPermissionsPolicyDeclarationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ParsedPermissionsPolicyDeclarationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ParsedPermissionsPolicyDeclaration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::PermissionsPolicyFeature>(
      Traits::feature(input),
      &fragment->feature);

    decltype(Traits::allowed_origins(input)) in_allowed_origins = Traits::allowed_origins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowed_origins)::BaseType>
        allowed_origins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allowed_origins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::OriginWithPossibleWildcardsDataView>>(
      in_allowed_origins,
      allowed_origins_fragment,
      &allowed_origins_validate_params);

    fragment->allowed_origins.Set(
        allowed_origins_fragment.is_null() ? nullptr : allowed_origins_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allowed_origins.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allowed_origins in ParsedPermissionsPolicyDeclaration struct");

    decltype(Traits::self_if_matches(input)) in_self_if_matches = Traits::self_if_matches(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->self_if_matches)::BaseType> self_if_matches_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_self_if_matches,
      self_if_matches_fragment);

    fragment->self_if_matches.Set(
        self_if_matches_fragment.is_null() ? nullptr : self_if_matches_fragment.data());

    fragment->matches_all_origins = Traits::matches_all_origins(input);

    fragment->matches_opaque_src = Traits::matches_opaque_src(input);

    decltype(Traits::reporting_endpoint(input)) in_reporting_endpoint = Traits::reporting_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_endpoint)::BaseType> reporting_endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_reporting_endpoint,
      reporting_endpoint_fragment);

    fragment->reporting_endpoint.Set(
        reporting_endpoint_fragment.is_null() ? nullptr : reporting_endpoint_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::ParsedPermissionsPolicyDeclaration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ParsedPermissionsPolicyDeclarationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::PermissionsPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PermissionsPolicyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PermissionsPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in PermissionsPolicy struct");

    fragment->headerless = Traits::headerless(input);

    decltype(Traits::declarations(input)) in_declarations = Traits::declarations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->declarations)::BaseType>
        declarations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& declarations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
      in_declarations,
      declarations_fragment,
      &declarations_validate_params);

    fragment->declarations.Set(
        declarations_fragment.is_null() ? nullptr : declarations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->declarations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null declarations in PermissionsPolicy struct");

    decltype(Traits::inherited_policies(input)) in_inherited_policies = Traits::inherited_policies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->inherited_policies)::BaseType> inherited_policies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_inherited_policies,
      inherited_policies_fragment);

    fragment->inherited_policies.Set(
        inherited_policies_fragment.is_null() ? nullptr : inherited_policies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->inherited_policies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inherited_policies in PermissionsPolicy struct");
  }

  static bool Deserialize(::network::mojom::internal::PermissionsPolicy_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::PermissionsPolicyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void OriginWithPossibleWildcardsDataView::GetSchemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scheme.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OriginWithPossibleWildcardsDataView::GetHostDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ParsedPermissionsPolicyDeclarationDataView::GetAllowedOriginsDataView(
    mojo::ArrayDataView<OriginWithPossibleWildcardsDataView>* output) {
  auto pointer = data_->allowed_origins.Get();
  *output = mojo::ArrayDataView<OriginWithPossibleWildcardsDataView>(pointer, message_);
}
inline void ParsedPermissionsPolicyDeclarationDataView::GetSelfIfMatchesDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->self_if_matches.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void ParsedPermissionsPolicyDeclarationDataView::GetReportingEndpointDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reporting_endpoint.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PermissionsPolicyDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void PermissionsPolicyDataView::GetDeclarationsDataView(
    mojo::ArrayDataView<ParsedPermissionsPolicyDeclarationDataView>* output) {
  auto pointer = data_->declarations.Get();
  *output = mojo::ArrayDataView<ParsedPermissionsPolicyDeclarationDataView>(pointer, message_);
}
inline void PermissionsPolicyDataView::GetInheritedPoliciesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->inherited_policies.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SHARED_H_