// services/network/public/mojom/reporting_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/reporting_service.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/reporting_service.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::ReportingApiReportStatus>
    : public mojo::internal::EnumHashImpl<::network::mojom::ReportingApiReportStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ReportingApiReportStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ReportingApiReportStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ReportingApiReportStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ReportingApiReportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ReportingApiReportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ReportingApiReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ReportingApiReport struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ReportingApiReport struct");

    decltype(Traits::group(input)) in_group = Traits::group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group)::BaseType> group_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group,
      group_fragment);

    fragment->group.Set(
        group_fragment.is_null() ? nullptr : group_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group in ReportingApiReport struct");

    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_type,
      type_fragment);

    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in ReportingApiReport struct");

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in ReportingApiReport struct");

    fragment->depth = Traits::depth(input);

    fragment->attempts = Traits::attempts(input);

    decltype(Traits::body(input)) in_body = Traits::body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->body)::BaseType> body_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_body,
      body_fragment);

    fragment->body.Set(
        body_fragment.is_null() ? nullptr : body_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->body.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null body in ReportingApiReport struct");

    
    mojo::internal::Serialize<::network::mojom::ReportingApiReportStatus>(
      Traits::status(input),
      &fragment->status);
  }

  static bool Deserialize(::network::mojom::internal::ReportingApiReport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ReportingApiReportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ReportingApiEndpointDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ReportingApiEndpointDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ReportingApiEndpoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ReportingApiEndpoint struct");

    fragment->attempted_uploads = Traits::attempted_uploads(input);

    fragment->successful_uploads = Traits::successful_uploads(input);

    fragment->attempted_reports = Traits::attempted_reports(input);

    fragment->successful_reports = Traits::successful_reports(input);

    fragment->priority = Traits::priority(input);

    fragment->weight = Traits::weight(input);

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ReportingApiEndpoint struct");

    decltype(Traits::group_name(input)) in_group_name = Traits::group_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_name)::BaseType> group_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_name,
      group_name_fragment);

    fragment->group_name.Set(
        group_name_fragment.is_null() ? nullptr : group_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_name in ReportingApiEndpoint struct");

    decltype(Traits::network_anonymization_key(input)) in_network_anonymization_key = Traits::network_anonymization_key(input);
    mojo::internal::MessageFragment<decltype(fragment->network_anonymization_key)>
        network_anonymization_key_fragment(fragment.message());
    network_anonymization_key_fragment.Claim(&fragment->network_anonymization_key);
    
    mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
      in_network_anonymization_key,
      network_anonymization_key_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->network_anonymization_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_anonymization_key in ReportingApiEndpoint struct");

    decltype(Traits::reporting_source(input)) in_reporting_source = Traits::reporting_source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_source)::BaseType> reporting_source_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_reporting_source,
      reporting_source_fragment);

    fragment->reporting_source.Set(
        reporting_source_fragment.is_null() ? nullptr : reporting_source_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::ReportingApiEndpoint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ReportingApiEndpointDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ReportingApiReportDataView::GetIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetGroupDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetBodyDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->body.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}


inline void ReportingApiEndpointDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ReportingApiEndpointDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void ReportingApiEndpointDataView::GetGroupNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReportingApiEndpointDataView::GetNetworkAnonymizationKeyDataView(
    ::network::mojom::NetworkAnonymizationKeyDataView* output) {
  auto pointer = &data_->network_anonymization_key;
  *output = ::network::mojom::NetworkAnonymizationKeyDataView(pointer, message_);
}
inline void ReportingApiEndpointDataView::GetReportingSourceDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->reporting_source.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ReportingApiReportStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ReportingApiReportStatus value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SHARED_H_