// services/network/public/mojom/shared_dictionary_isolation_key.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ISOLATION_KEY_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ISOLATION_KEY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/schemeful_site.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/shared_dictionary_isolation_key_mojom_traits.h"




namespace network::mojom {








class  SharedDictionaryIsolationKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedDictionaryIsolationKey, T>::value>;
  using DataView = SharedDictionaryIsolationKeyDataView;
  using Data_ = internal::SharedDictionaryIsolationKey_Data;

  template <typename... Args>
  static SharedDictionaryIsolationKeyPtr New(Args&&... args) {
    return SharedDictionaryIsolationKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedDictionaryIsolationKeyPtr From(const U& u) {
    return mojo::TypeConverter<SharedDictionaryIsolationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedDictionaryIsolationKey>::Convert(*this);
  }


  SharedDictionaryIsolationKey();

  SharedDictionaryIsolationKey(
      const ::url::Origin& frame_origin,
      const ::net::SchemefulSite& top_frame_site);


  ~SharedDictionaryIsolationKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedDictionaryIsolationKeyPtr>
  SharedDictionaryIsolationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedDictionaryIsolationKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedDictionaryIsolationKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedDictionaryIsolationKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedDictionaryIsolationKey_UnserializedMessageContext<
            UserType, SharedDictionaryIsolationKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedDictionaryIsolationKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedDictionaryIsolationKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedDictionaryIsolationKey_UnserializedMessageContext<
            UserType, SharedDictionaryIsolationKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedDictionaryIsolationKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin frame_origin;
  
  ::net::SchemefulSite top_frame_site;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedDictionaryIsolationKeyPtr SharedDictionaryIsolationKey::Clone() const {
  return New(
      mojo::Clone(frame_origin),
      mojo::Clone(top_frame_site)
  );
}

template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>*>
bool SharedDictionaryIsolationKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_origin, other_struct.frame_origin))
    return false;
  if (!mojo::Equals(this->top_frame_site, other_struct.top_frame_site))
    return false;
  return true;
}

template <typename T, SharedDictionaryIsolationKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_origin < rhs.frame_origin)
    return true;
  if (rhs.frame_origin < lhs.frame_origin)
    return false;
  if (lhs.top_frame_site < rhs.top_frame_site)
    return true;
  if (rhs.top_frame_site < lhs.top_frame_site)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SharedDictionaryIsolationKey::DataView,
                                         ::network::mojom::SharedDictionaryIsolationKeyPtr> {
  static bool IsNull(const ::network::mojom::SharedDictionaryIsolationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedDictionaryIsolationKeyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedDictionaryIsolationKey::frame_origin)& frame_origin(
      const ::network::mojom::SharedDictionaryIsolationKeyPtr& input) {
    return input->frame_origin;
  }

  static const decltype(::network::mojom::SharedDictionaryIsolationKey::top_frame_site)& top_frame_site(
      const ::network::mojom::SharedDictionaryIsolationKeyPtr& input) {
    return input->top_frame_site;
  }

  static bool Read(::network::mojom::SharedDictionaryIsolationKey::DataView input, ::network::mojom::SharedDictionaryIsolationKeyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ISOLATION_KEY_MOJOM_H_