// services/network/public/mojom/tcp_socket.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/tcp_socket.mojom-shared-internal.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/ssl_config.mojom-shared.h"
#include "services/network/public/mojom/tls_socket.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/socket_connection_tracker.mojom-shared.h"


namespace network::mojom {
class TCPKeepAliveOptionsDataView;

class TCPConnectedSocketOptionsDataView;

class TCPServerSocketOptionsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TCPKeepAliveOptionsDataView> {
  using Data = ::network::mojom::internal::TCPKeepAliveOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TCPConnectedSocketOptionsDataView> {
  using Data = ::network::mojom::internal::TCPConnectedSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TCPServerSocketOptionsDataView> {
  using Data = ::network::mojom::internal::TCPServerSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class TCPBoundSocketInterfaceBase {};

using TCPBoundSocketPtrDataView =
    mojo::InterfacePtrDataView<TCPBoundSocketInterfaceBase>;
using TCPBoundSocketRequestDataView =
    mojo::InterfaceRequestDataView<TCPBoundSocketInterfaceBase>;
using TCPBoundSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TCPBoundSocketInterfaceBase>;
using TCPBoundSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TCPBoundSocketInterfaceBase>;
class TCPConnectedSocketInterfaceBase {};

using TCPConnectedSocketPtrDataView =
    mojo::InterfacePtrDataView<TCPConnectedSocketInterfaceBase>;
using TCPConnectedSocketRequestDataView =
    mojo::InterfaceRequestDataView<TCPConnectedSocketInterfaceBase>;
using TCPConnectedSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TCPConnectedSocketInterfaceBase>;
using TCPConnectedSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TCPConnectedSocketInterfaceBase>;
class SocketObserverInterfaceBase {};

using SocketObserverPtrDataView =
    mojo::InterfacePtrDataView<SocketObserverInterfaceBase>;
using SocketObserverRequestDataView =
    mojo::InterfaceRequestDataView<SocketObserverInterfaceBase>;
using SocketObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SocketObserverInterfaceBase>;
using SocketObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SocketObserverInterfaceBase>;
class TCPServerSocketInterfaceBase {};

using TCPServerSocketPtrDataView =
    mojo::InterfacePtrDataView<TCPServerSocketInterfaceBase>;
using TCPServerSocketRequestDataView =
    mojo::InterfaceRequestDataView<TCPServerSocketInterfaceBase>;
using TCPServerSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TCPServerSocketInterfaceBase>;
using TCPServerSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TCPServerSocketInterfaceBase>;


class TCPKeepAliveOptionsDataView {
 public:
  TCPKeepAliveOptionsDataView() = default;

  TCPKeepAliveOptionsDataView(
      internal::TCPKeepAliveOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enable() const {
    return data_->enable;
  }
  uint16_t delay() const {
    return data_->delay;
  }
 private:
  internal::TCPKeepAliveOptions_Data* data_ = nullptr;
};


class TCPConnectedSocketOptionsDataView {
 public:
  TCPConnectedSocketOptionsDataView() = default;

  TCPConnectedSocketOptionsDataView(
      internal::TCPConnectedSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t send_buffer_size() const {
    return data_->send_buffer_size;
  }
  int32_t receive_buffer_size() const {
    return data_->receive_buffer_size;
  }
  bool no_delay() const {
    return data_->no_delay;
  }
  inline void GetKeepAliveOptionsDataView(
      TCPKeepAliveOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeepAliveOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TCPKeepAliveOptionsDataView, UserType>(),
    "Attempting to read the optional `keep_alive_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeepAliveOptions` instead "
    "of `ReadKeepAliveOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->keep_alive_options.Get();
    return mojo::internal::Deserialize<::network::mojom::TCPKeepAliveOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::TCPConnectedSocketOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TCPServerSocketOptionsDataView {
 public:
  TCPServerSocketOptionsDataView() = default;

  TCPServerSocketOptionsDataView(
      internal::TCPServerSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t backlog() const {
    return data_->backlog;
  }
  std::optional<bool> ipv6_only() const {

    return data_->ipv6_only_$flag
        ? std::make_optional(!!data_->ipv6_only_$value)
        : std::nullopt;
  }
 private:
  internal::TCPServerSocketOptions_Data* data_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_DATA_VIEW_H_