// services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINKS_METRICS_RECORDER_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINKS_METRICS_RECORDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-forward.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class FrameSinksMetricsRecorderProxy;

template <typename ImplRefTraits>
class FrameSinksMetricsRecorderStub;

class FrameSinksMetricsRecorderRequestValidator;
class FrameSinksMetricsRecorderResponseValidator;


class FrameSinksMetricsRecorder
    : public FrameSinksMetricsRecorderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.FrameSinksMetricsRecorder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinksMetricsRecorderInterfaceBase;
  using Proxy_ = FrameSinksMetricsRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinksMetricsRecorderStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinksMetricsRecorderRequestValidator;
  using ResponseValidator_ = FrameSinksMetricsRecorderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartFrameCountingMinVersion = 0,
    kStopFrameCountingMinVersion = 0,
    kStartOverdrawTrackingMinVersion = 0,
    kStopOverdrawTrackingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartFrameCounting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopFrameCounting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartOverdrawTracking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopOverdrawTracking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinksMetricsRecorder() = default;

  virtual void StartFrameCounting(::base::TimeTicks start_time, ::base::TimeDelta bucket_size) = 0;

  using StopFrameCountingCallback = base::OnceCallback<void(FrameCountingDataPtr)>;
  using StopFrameCountingMojoCallback = base::OnceCallback<void(FrameCountingDataPtr)>;

  virtual void StopFrameCounting(StopFrameCountingCallback callback) = 0;

  virtual void StartOverdrawTracking(const ::viz::FrameSinkId& root_frame_sink_id, ::base::TimeDelta bucket_size) = 0;

  using StopOverdrawTrackingCallback = base::OnceCallback<void(OverdrawDataPtr)>;
  using StopOverdrawTrackingMojoCallback = base::OnceCallback<void(OverdrawDataPtr)>;

  virtual void StopOverdrawTracking(const ::viz::FrameSinkId& root_frame_sink_id, StopOverdrawTrackingCallback callback) = 0;
};



class  FrameSinksMetricsRecorderProxy
    : public FrameSinksMetricsRecorder {
 public:
  using InterfaceType = FrameSinksMetricsRecorder;

  explicit FrameSinksMetricsRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartFrameCounting(::base::TimeTicks start_time, ::base::TimeDelta bucket_size) final;
  
  void StopFrameCounting(StopFrameCountingCallback callback) final;
  
  void StartOverdrawTracking(const ::viz::FrameSinkId& root_frame_sink_id, ::base::TimeDelta bucket_size) final;
  
  void StopOverdrawTracking(const ::viz::FrameSinkId& root_frame_sink_id, StopOverdrawTrackingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameSinksMetricsRecorderStubDispatch {
 public:
  static bool Accept(FrameSinksMetricsRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinksMetricsRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinksMetricsRecorder>>
class FrameSinksMetricsRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinksMetricsRecorderStub() = default;
  ~FrameSinksMetricsRecorderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinksMetricsRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinksMetricsRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinksMetricsRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinksMetricsRecorderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  FrameCountingPerSinkData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameCountingPerSinkData, T>::value>;
  using DataView = FrameCountingPerSinkDataDataView;
  using Data_ = internal::FrameCountingPerSinkData_Data;

  template <typename... Args>
  static FrameCountingPerSinkDataPtr New(Args&&... args) {
    return FrameCountingPerSinkDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameCountingPerSinkDataPtr From(const U& u) {
    return mojo::TypeConverter<FrameCountingPerSinkDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameCountingPerSinkData>::Convert(*this);
  }


  FrameCountingPerSinkData();

  FrameCountingPerSinkData(
      bool is_root,
      const std::string& debug_label,
      uint16_t start_bucket,
      std::vector<uint16_t> presented_frames);


  ~FrameCountingPerSinkData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameCountingPerSinkDataPtr>
  FrameCountingPerSinkDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameCountingPerSinkData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameCountingPerSinkData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameCountingPerSinkData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameCountingPerSinkData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameCountingPerSinkData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameCountingPerSinkData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameCountingPerSinkData_UnserializedMessageContext<
            UserType, FrameCountingPerSinkData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameCountingPerSinkData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameCountingPerSinkData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameCountingPerSinkData_UnserializedMessageContext<
            UserType, FrameCountingPerSinkData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameCountingPerSinkData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_root;
  
  std::string debug_label;
  
  uint16_t start_bucket;
  
  std::vector<uint16_t> presented_frames;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameCountingPerSinkData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameCountingPerSinkData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameCountingPerSinkData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameCountingPerSinkData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FrameCountingData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameCountingData, T>::value>;
  using DataView = FrameCountingDataDataView;
  using Data_ = internal::FrameCountingData_Data;

  template <typename... Args>
  static FrameCountingDataPtr New(Args&&... args) {
    return FrameCountingDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameCountingDataPtr From(const U& u) {
    return mojo::TypeConverter<FrameCountingDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameCountingData>::Convert(*this);
  }


  FrameCountingData();

  explicit FrameCountingData(
      std::vector<FrameCountingPerSinkDataPtr> per_sink_data);

FrameCountingData(const FrameCountingData&) = delete;
FrameCountingData& operator=(const FrameCountingData&) = delete;

  ~FrameCountingData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameCountingDataPtr>
  FrameCountingDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameCountingData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameCountingData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameCountingData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameCountingData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameCountingData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameCountingData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameCountingData_UnserializedMessageContext<
            UserType, FrameCountingData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameCountingData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameCountingData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameCountingData_UnserializedMessageContext<
            UserType, FrameCountingData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameCountingData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<FrameCountingPerSinkDataPtr> per_sink_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameCountingData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameCountingData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameCountingData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameCountingData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  OverdrawData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OverdrawData, T>::value>;
  using DataView = OverdrawDataDataView;
  using Data_ = internal::OverdrawData_Data;

  template <typename... Args>
  static OverdrawDataPtr New(Args&&... args) {
    return OverdrawDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OverdrawDataPtr From(const U& u) {
    return mojo::TypeConverter<OverdrawDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OverdrawData>::Convert(*this);
  }


  OverdrawData();

  explicit OverdrawData(
      std::vector<float> average_overdraws);


  ~OverdrawData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OverdrawDataPtr>
  OverdrawDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OverdrawData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OverdrawData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OverdrawData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OverdrawData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OverdrawData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OverdrawData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OverdrawData_UnserializedMessageContext<
            UserType, OverdrawData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OverdrawData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OverdrawData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OverdrawData_UnserializedMessageContext<
            UserType, OverdrawData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OverdrawData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<float> average_overdraws;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OverdrawData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OverdrawData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OverdrawData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OverdrawData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameCountingPerSinkDataPtr FrameCountingPerSinkData::Clone() const {
  return New(
      mojo::Clone(is_root),
      mojo::Clone(debug_label),
      mojo::Clone(start_bucket),
      mojo::Clone(presented_frames)
  );
}

template <typename T, FrameCountingPerSinkData::EnableIfSame<T>*>
bool FrameCountingPerSinkData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_root, other_struct.is_root))
    return false;
  if (!mojo::Equals(this->debug_label, other_struct.debug_label))
    return false;
  if (!mojo::Equals(this->start_bucket, other_struct.start_bucket))
    return false;
  if (!mojo::Equals(this->presented_frames, other_struct.presented_frames))
    return false;
  return true;
}

template <typename T, FrameCountingPerSinkData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_root < rhs.is_root)
    return true;
  if (rhs.is_root < lhs.is_root)
    return false;
  if (lhs.debug_label < rhs.debug_label)
    return true;
  if (rhs.debug_label < lhs.debug_label)
    return false;
  if (lhs.start_bucket < rhs.start_bucket)
    return true;
  if (rhs.start_bucket < lhs.start_bucket)
    return false;
  if (lhs.presented_frames < rhs.presented_frames)
    return true;
  if (rhs.presented_frames < lhs.presented_frames)
    return false;
  return false;
}
template <typename StructPtrType>
FrameCountingDataPtr FrameCountingData::Clone() const {
  return New(
      mojo::Clone(per_sink_data)
  );
}

template <typename T, FrameCountingData::EnableIfSame<T>*>
bool FrameCountingData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->per_sink_data, other_struct.per_sink_data))
    return false;
  return true;
}

template <typename T, FrameCountingData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.per_sink_data < rhs.per_sink_data)
    return true;
  if (rhs.per_sink_data < lhs.per_sink_data)
    return false;
  return false;
}
template <typename StructPtrType>
OverdrawDataPtr OverdrawData::Clone() const {
  return New(
      mojo::Clone(average_overdraws)
  );
}

template <typename T, OverdrawData::EnableIfSame<T>*>
bool OverdrawData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->average_overdraws, other_struct.average_overdraws))
    return false;
  return true;
}

template <typename T, OverdrawData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.average_overdraws < rhs.average_overdraws)
    return true;
  if (rhs.average_overdraws < lhs.average_overdraws)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::FrameCountingPerSinkData::DataView,
                                         ::viz::mojom::FrameCountingPerSinkDataPtr> {
  static bool IsNull(const ::viz::mojom::FrameCountingPerSinkDataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::FrameCountingPerSinkDataPtr* output) { output->reset(); }

  static decltype(::viz::mojom::FrameCountingPerSinkData::is_root) is_root(
      const ::viz::mojom::FrameCountingPerSinkDataPtr& input) {
    return input->is_root;
  }

  static const decltype(::viz::mojom::FrameCountingPerSinkData::debug_label)& debug_label(
      const ::viz::mojom::FrameCountingPerSinkDataPtr& input) {
    return input->debug_label;
  }

  static decltype(::viz::mojom::FrameCountingPerSinkData::start_bucket) start_bucket(
      const ::viz::mojom::FrameCountingPerSinkDataPtr& input) {
    return input->start_bucket;
  }

  static const decltype(::viz::mojom::FrameCountingPerSinkData::presented_frames)& presented_frames(
      const ::viz::mojom::FrameCountingPerSinkDataPtr& input) {
    return input->presented_frames;
  }

  static bool Read(::viz::mojom::FrameCountingPerSinkData::DataView input, ::viz::mojom::FrameCountingPerSinkDataPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::FrameCountingData::DataView,
                                         ::viz::mojom::FrameCountingDataPtr> {
  static bool IsNull(const ::viz::mojom::FrameCountingDataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::FrameCountingDataPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::FrameCountingData::per_sink_data)& per_sink_data(
      const ::viz::mojom::FrameCountingDataPtr& input) {
    return input->per_sink_data;
  }

  static bool Read(::viz::mojom::FrameCountingData::DataView input, ::viz::mojom::FrameCountingDataPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::OverdrawData::DataView,
                                         ::viz::mojom::OverdrawDataPtr> {
  static bool IsNull(const ::viz::mojom::OverdrawDataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::OverdrawDataPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::OverdrawData::average_overdraws)& average_overdraws(
      const ::viz::mojom::OverdrawDataPtr& input) {
    return input->average_overdraws;
  }

  static bool Read(::viz::mojom::OverdrawData::DataView input, ::viz::mojom::OverdrawDataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINKS_METRICS_RECORDER_MOJOM_H_