// services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"


namespace viz::mojom {
class CompositorFrameTransitionDirectiveSharedElementDataView;

class CompositorFrameTransitionDirectiveDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView> {
  using Data = ::viz::mojom::internal::CompositorFrameTransitionDirectiveSharedElement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::CompositorFrameTransitionDirectiveDataView> {
  using Data = ::viz::mojom::internal::CompositorFrameTransitionDirective_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class CompositorFrameTransitionDirectiveType : int32_t {
  
  kSave = 0,
  
  kAnimateRenderer = 1,
  
  kRelease = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CompositorFrameTransitionDirectiveType value);
inline bool IsKnownEnumValue(CompositorFrameTransitionDirectiveType value) {
  return internal::CompositorFrameTransitionDirectiveType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CompositorFrameTransitionDirectiveSharedElementDataView {
 public:
  CompositorFrameTransitionDirectiveSharedElementDataView() = default;

  CompositorFrameTransitionDirectiveSharedElementDataView(
      internal::CompositorFrameTransitionDirectiveSharedElement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRenderPassIdDataView(
      ::viz::mojom::CompositorRenderPassIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRenderPassId(UserType* output) {
    
    auto* pointer = data_->render_pass_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::CompositorRenderPassIdDataView>(
        pointer, output, message_);
  }
  inline void GetViewTransitionElementResourceIdDataView(
      ::viz::mojom::ViewTransitionElementResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionElementResourceId(UserType* output) {
    
    auto* pointer = data_->view_transition_element_resource_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::CompositorFrameTransitionDirectiveSharedElement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CompositorFrameTransitionDirectiveDataView {
 public:
  CompositorFrameTransitionDirectiveDataView() = default;

  CompositorFrameTransitionDirectiveDataView(
      internal::CompositorFrameTransitionDirective_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTransitionTokenDataView(
      ::blink::mojom::ViewTransitionTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransitionToken(UserType* output) {
    
    auto* pointer = data_->transition_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionTokenDataView>(
        pointer, output, message_);
  }
  bool maybe_cross_frame_sink() const {
    return data_->maybe_cross_frame_sink;
  }
  uint32_t sequence_id() const {
    return data_->sequence_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::CompositorFrameTransitionDirectiveType>(
        data_value, output);
  }
  CompositorFrameTransitionDirectiveType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CompositorFrameTransitionDirectiveType>(data_->type));
  }
  inline void GetSharedElementsDataView(
      mojo::ArrayDataView<CompositorFrameTransitionDirectiveSharedElementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedElements(UserType* output) {
    
    auto* pointer = data_->shared_elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView>>(
        pointer, output, message_);
  }
  inline void GetDisplayColorSpacesDataView(
      ::gfx::mojom::DisplayColorSpacesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayColorSpaces(UserType* output) {
    
    auto* pointer = data_->display_color_spaces.Get();
    return mojo::internal::Deserialize<::gfx::mojom::DisplayColorSpacesDataView>(
        pointer, output, message_);
  }
 private:
  internal::CompositorFrameTransitionDirective_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_DATA_VIEW_H_