// services/viz/public/mojom/compositing/transferable_resource.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "skia/public/mojom/surface_origin.mojom-shared.h"


namespace viz::mojom {
class TransferableResourceDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::TransferableResourceDataView> {
  using Data = ::viz::mojom::internal::TransferableResource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class SynchronizationType : int32_t {
  
  kSyncToken = 0,
  
  kGpuCommandsCompleted = 1,
  
  kReleaseFence = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SynchronizationType value);
inline bool IsKnownEnumValue(SynchronizationType value) {
  return internal::SynchronizationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResourceSource : int32_t {
  
  kUnknown = 0,
  
  kAR = 1,
  
  kCanvas = 2,
  
  kDrawingBuffer = 3,
  
  kExoBuffer = 4,
  
  kHeadsUpDisplay = 5,
  
  kImageLayerBridge = 6,
  
  kPPBGraphics3D = 7,
  
  kPepperGraphics2D = 8,
  
  kViewTransition = 9,
  
  kStaleContent = 10,
  
  kTest = 11,
  
  kTileRasterTask = 12,
  
  kUI = 13,
  
  kVideo = 14,
  
  kWebGPUSwapBuffer = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

 std::ostream& operator<<(std::ostream& os, ResourceSource value);
inline bool IsKnownEnumValue(ResourceSource value) {
  return internal::ResourceSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class TransferableResourceDataView {
 public:
  TransferableResourceDataView() = default;

  TransferableResourceDataView(
      internal::TransferableResource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::viz::mojom::ResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetFormatDataView(
      ::viz::mojom::SharedImageFormatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) {
    
    auto* pointer = !data_->format.is_null() ? &data_->format : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::SharedImageFormatDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMemoryBufferIdDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemoryBufferId(UserType* output) {
    
    auto* pointer = data_->memory_buffer_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  uint32_t texture_target() const {
    return data_->texture_target;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSynchronizationType(UserType* output) const {
    auto data_value = data_->synchronization_type;
    return mojo::internal::Deserialize<::viz::mojom::SynchronizationType>(
        data_value, output);
  }
  SynchronizationType synchronization_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::SynchronizationType>(data_->synchronization_type));
  }
  bool is_software() const {
    return data_->is_software;
  }
  bool is_overlay_candidate() const {
    return data_->is_overlay_candidate;
  }
  bool is_low_latency_rendering() const {
    return data_->is_low_latency_rendering;
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  inline void GetHdrMetadataDataView(
      ::gfx::mojom::HDRMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHdrMetadata(UserType* output) {
    
    auto* pointer = data_->hdr_metadata.Get();
    return mojo::internal::Deserialize<::gfx::mojom::HDRMetadataDataView>(
        pointer, output, message_);
  }
  bool needs_detiling() const {
    return data_->needs_detiling;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) const {
    auto data_value = data_->origin;
    return mojo::internal::Deserialize<::skia::mojom::SurfaceOrigin>(
        data_value, output);
  }
  ::skia::mojom::SurfaceOrigin origin() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::SurfaceOrigin>(data_->origin));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlphaType(UserType* output) const {
    auto data_value = data_->alpha_type;
    return mojo::internal::Deserialize<::skia::mojom::AlphaType>(
        data_value, output);
  }
  ::skia::mojom::AlphaType alpha_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::AlphaType>(data_->alpha_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResourceSource(UserType* output) const {
    auto data_value = data_->resource_source;
    return mojo::internal::Deserialize<::viz::mojom::ResourceSource>(
        data_value, output);
  }
  ResourceSource resource_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::ResourceSource>(data_->resource_source));
  }
 private:
  internal::TransferableResource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_DATA_VIEW_H_