// skia/public/mojom/bitmap.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_DATA_VIEW_H_
#define SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "skia/public/mojom/bitmap.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"


namespace skia::mojom {
class BitmapN32DataView;

class BitmapWithArbitraryBppDataView;

class BitmapMappedFromTrustedProcessDataView;

class InlineBitmapDataView;



}  // skia::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::skia::mojom::BitmapN32DataView> {
  using Data = ::skia::mojom::internal::BitmapN32_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::skia::mojom::BitmapWithArbitraryBppDataView> {
  using Data = ::skia::mojom::internal::BitmapWithArbitraryBpp_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::skia::mojom::BitmapMappedFromTrustedProcessDataView> {
  using Data = ::skia::mojom::internal::BitmapMappedFromTrustedProcess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::skia::mojom::InlineBitmapDataView> {
  using Data = ::skia::mojom::internal::InlineBitmap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace skia::mojom {


class BitmapN32DataView {
 public:
  BitmapN32DataView() = default;

  BitmapN32DataView(
      internal::BitmapN32_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageInfoDataView(
      ::skia::mojom::BitmapN32ImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageInfo(UserType* output) {
    
    auto* pointer = data_->image_info.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32ImageInfoDataView>(
        pointer, output, message_);
  }
  inline void GetPixelDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelData(UserType* output) {
    
    auto* pointer = !data_->pixel_data.is_null() ? &data_->pixel_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::BitmapN32_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BitmapWithArbitraryBppDataView {
 public:
  BitmapWithArbitraryBppDataView() = default;

  BitmapWithArbitraryBppDataView(
      internal::BitmapWithArbitraryBpp_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageInfoDataView(
      ::skia::mojom::ImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageInfo(UserType* output) {
    
    auto* pointer = data_->image_info.Get();
    return mojo::internal::Deserialize<::skia::mojom::ImageInfoDataView>(
        pointer, output, message_);
  }
  uint64_t UNUSED_row_bytes() const {
    return data_->UNUSED_row_bytes;
  }
  inline void GetPixelDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelData(UserType* output) {
    
    auto* pointer = !data_->pixel_data.is_null() ? &data_->pixel_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::BitmapWithArbitraryBpp_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BitmapMappedFromTrustedProcessDataView {
 public:
  BitmapMappedFromTrustedProcessDataView() = default;

  BitmapMappedFromTrustedProcessDataView(
      internal::BitmapMappedFromTrustedProcess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageInfoDataView(
      ::skia::mojom::ImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageInfo(UserType* output) {
    
    auto* pointer = data_->image_info.Get();
    return mojo::internal::Deserialize<::skia::mojom::ImageInfoDataView>(
        pointer, output, message_);
  }
  uint64_t UNUSED_row_bytes() const {
    return data_->UNUSED_row_bytes;
  }
  inline void GetPixelDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelData(UserType* output) {
    
    auto* pointer = !data_->pixel_data.is_null() ? &data_->pixel_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::BitmapMappedFromTrustedProcess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InlineBitmapDataView {
 public:
  InlineBitmapDataView() = default;

  InlineBitmapDataView(
      internal::InlineBitmap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageInfoDataView(
      ::skia::mojom::BitmapN32ImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageInfo(UserType* output) {
    
    auto* pointer = data_->image_info.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32ImageInfoDataView>(
        pointer, output, message_);
  }
  inline void GetPixelDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelData(UserType* output) {
    
    auto* pointer = data_->pixel_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::InlineBitmap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // skia::mojom

#endif  // SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_DATA_VIEW_H_