// third_party/blink/public/mojom/background_sync/background_sync.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_SYNC_BACKGROUND_SYNC_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_SYNC_BACKGROUND_SYNC_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class OneShotBackgroundSyncServiceProxy;

template <typename ImplRefTraits>
class OneShotBackgroundSyncServiceStub;

class OneShotBackgroundSyncServiceRequestValidator;
class OneShotBackgroundSyncServiceResponseValidator;


class BLINK_COMMON_EXPORT OneShotBackgroundSyncService
    : public OneShotBackgroundSyncServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.OneShotBackgroundSyncService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OneShotBackgroundSyncServiceInterfaceBase;
  using Proxy_ = OneShotBackgroundSyncServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = OneShotBackgroundSyncServiceStub<ImplRefTraits>;

  using RequestValidator_ = OneShotBackgroundSyncServiceRequestValidator;
  using ResponseValidator_ = OneShotBackgroundSyncServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterMinVersion = 0,
    kDidResolveRegistrationMinVersion = 0,
    kGetRegistrationsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Register_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidResolveRegistration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRegistrations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OneShotBackgroundSyncService() = default;

  using RegisterCallback = base::OnceCallback<void(BackgroundSyncError, SyncRegistrationOptionsPtr)>;
  using RegisterMojoCallback = base::OnceCallback<void(BackgroundSyncError, SyncRegistrationOptionsPtr)>;

  virtual void Register(SyncRegistrationOptionsPtr options, int64_t service_worker_registration_id, RegisterCallback callback) = 0;

  virtual void DidResolveRegistration(BackgroundSyncRegistrationInfoPtr registration_info) = 0;

  using GetRegistrationsCallback = base::OnceCallback<void(BackgroundSyncError, std::vector<SyncRegistrationOptionsPtr>)>;
  using GetRegistrationsMojoCallback = base::OnceCallback<void(BackgroundSyncError, std::vector<SyncRegistrationOptionsPtr>)>;

  virtual void GetRegistrations(int64_t service_worker_registration_id, GetRegistrationsCallback callback) = 0;
};

class PeriodicBackgroundSyncServiceProxy;

template <typename ImplRefTraits>
class PeriodicBackgroundSyncServiceStub;

class PeriodicBackgroundSyncServiceRequestValidator;
class PeriodicBackgroundSyncServiceResponseValidator;


class BLINK_COMMON_EXPORT PeriodicBackgroundSyncService
    : public PeriodicBackgroundSyncServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PeriodicBackgroundSyncService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PeriodicBackgroundSyncServiceInterfaceBase;
  using Proxy_ = PeriodicBackgroundSyncServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PeriodicBackgroundSyncServiceStub<ImplRefTraits>;

  using RequestValidator_ = PeriodicBackgroundSyncServiceRequestValidator;
  using ResponseValidator_ = PeriodicBackgroundSyncServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterMinVersion = 0,
    kUnregisterMinVersion = 0,
    kGetRegistrationsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Register_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Unregister_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRegistrations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PeriodicBackgroundSyncService() = default;

  using RegisterCallback = base::OnceCallback<void(BackgroundSyncError, SyncRegistrationOptionsPtr)>;
  using RegisterMojoCallback = base::OnceCallback<void(BackgroundSyncError, SyncRegistrationOptionsPtr)>;

  virtual void Register(SyncRegistrationOptionsPtr options, int64_t service_worker_registration_id, RegisterCallback callback) = 0;

  using UnregisterCallback = base::OnceCallback<void(BackgroundSyncError)>;
  using UnregisterMojoCallback = base::OnceCallback<void(BackgroundSyncError)>;

  virtual void Unregister(int64_t service_worker_registration_id, const std::string& tag, UnregisterCallback callback) = 0;

  using GetRegistrationsCallback = base::OnceCallback<void(BackgroundSyncError, std::vector<SyncRegistrationOptionsPtr>)>;
  using GetRegistrationsMojoCallback = base::OnceCallback<void(BackgroundSyncError, std::vector<SyncRegistrationOptionsPtr>)>;

  virtual void GetRegistrations(int64_t service_worker_registration_id, GetRegistrationsCallback callback) = 0;
};



class BLINK_COMMON_EXPORT OneShotBackgroundSyncServiceProxy
    : public OneShotBackgroundSyncService {
 public:
  using InterfaceType = OneShotBackgroundSyncService;

  explicit OneShotBackgroundSyncServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Register(SyncRegistrationOptionsPtr options, int64_t service_worker_registration_id, RegisterCallback callback) final;
  
  void DidResolveRegistration(BackgroundSyncRegistrationInfoPtr registration_info) final;
  
  void GetRegistrations(int64_t service_worker_registration_id, GetRegistrationsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT PeriodicBackgroundSyncServiceProxy
    : public PeriodicBackgroundSyncService {
 public:
  using InterfaceType = PeriodicBackgroundSyncService;

  explicit PeriodicBackgroundSyncServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Register(SyncRegistrationOptionsPtr options, int64_t service_worker_registration_id, RegisterCallback callback) final;
  
  void Unregister(int64_t service_worker_registration_id, const std::string& tag, UnregisterCallback callback) final;
  
  void GetRegistrations(int64_t service_worker_registration_id, GetRegistrationsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT OneShotBackgroundSyncServiceStubDispatch {
 public:
  static bool Accept(OneShotBackgroundSyncService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OneShotBackgroundSyncService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OneShotBackgroundSyncService>>
class OneShotBackgroundSyncServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OneShotBackgroundSyncServiceStub() = default;
  ~OneShotBackgroundSyncServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OneShotBackgroundSyncServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OneShotBackgroundSyncServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PeriodicBackgroundSyncServiceStubDispatch {
 public:
  static bool Accept(PeriodicBackgroundSyncService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PeriodicBackgroundSyncService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PeriodicBackgroundSyncService>>
class PeriodicBackgroundSyncServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PeriodicBackgroundSyncServiceStub() = default;
  ~PeriodicBackgroundSyncServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PeriodicBackgroundSyncServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PeriodicBackgroundSyncServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT OneShotBackgroundSyncServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PeriodicBackgroundSyncServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT OneShotBackgroundSyncServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PeriodicBackgroundSyncServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT SyncRegistrationOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyncRegistrationOptions, T>::value>;
  using DataView = SyncRegistrationOptionsDataView;
  using Data_ = internal::SyncRegistrationOptions_Data;

  template <typename... Args>
  static SyncRegistrationOptionsPtr New(Args&&... args) {
    return SyncRegistrationOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyncRegistrationOptionsPtr From(const U& u) {
    return mojo::TypeConverter<SyncRegistrationOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyncRegistrationOptions>::Convert(*this);
  }


  SyncRegistrationOptions();

  SyncRegistrationOptions(
      const std::string& tag,
      int64_t min_interval);


  ~SyncRegistrationOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyncRegistrationOptionsPtr>
  SyncRegistrationOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyncRegistrationOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyncRegistrationOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyncRegistrationOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncRegistrationOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncRegistrationOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyncRegistrationOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyncRegistrationOptions_UnserializedMessageContext<
            UserType, SyncRegistrationOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyncRegistrationOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyncRegistrationOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyncRegistrationOptions_UnserializedMessageContext<
            UserType, SyncRegistrationOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyncRegistrationOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string tag;
  
  int64_t min_interval;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyncRegistrationOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyncRegistrationOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyncRegistrationOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyncRegistrationOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT BackgroundSyncRegistrationInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundSyncRegistrationInfo, T>::value>;
  using DataView = BackgroundSyncRegistrationInfoDataView;
  using Data_ = internal::BackgroundSyncRegistrationInfo_Data;

  template <typename... Args>
  static BackgroundSyncRegistrationInfoPtr New(Args&&... args) {
    return BackgroundSyncRegistrationInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundSyncRegistrationInfoPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundSyncRegistrationInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundSyncRegistrationInfo>::Convert(*this);
  }


  BackgroundSyncRegistrationInfo();

  BackgroundSyncRegistrationInfo(
      int64_t service_worker_registration_id,
      const std::string& tag,
      BackgroundSyncType sync_type);


  ~BackgroundSyncRegistrationInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundSyncRegistrationInfoPtr>
  BackgroundSyncRegistrationInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundSyncRegistrationInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundSyncRegistrationInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundSyncRegistrationInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundSyncRegistrationInfo_UnserializedMessageContext<
            UserType, BackgroundSyncRegistrationInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundSyncRegistrationInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundSyncRegistrationInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundSyncRegistrationInfo_UnserializedMessageContext<
            UserType, BackgroundSyncRegistrationInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundSyncRegistrationInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t service_worker_registration_id;
  
  std::string tag;
  
  BackgroundSyncType sync_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename StructPtrType>
SyncRegistrationOptionsPtr SyncRegistrationOptions::Clone() const {
  return New(
      mojo::Clone(tag),
      mojo::Clone(min_interval)
  );
}

template <typename T, SyncRegistrationOptions::EnableIfSame<T>*>
bool SyncRegistrationOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tag, other_struct.tag))
    return false;
  if (!mojo::Equals(this->min_interval, other_struct.min_interval))
    return false;
  return true;
}

template <typename T, SyncRegistrationOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tag < rhs.tag)
    return true;
  if (rhs.tag < lhs.tag)
    return false;
  if (lhs.min_interval < rhs.min_interval)
    return true;
  if (rhs.min_interval < lhs.min_interval)
    return false;
  return false;
}
template <typename StructPtrType>
BackgroundSyncRegistrationInfoPtr BackgroundSyncRegistrationInfo::Clone() const {
  return New(
      mojo::Clone(service_worker_registration_id),
      mojo::Clone(tag),
      mojo::Clone(sync_type)
  );
}

template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>*>
bool BackgroundSyncRegistrationInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->service_worker_registration_id, other_struct.service_worker_registration_id))
    return false;
  if (!mojo::Equals(this->tag, other_struct.tag))
    return false;
  if (!mojo::Equals(this->sync_type, other_struct.sync_type))
    return false;
  return true;
}

template <typename T, BackgroundSyncRegistrationInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.service_worker_registration_id < rhs.service_worker_registration_id)
    return true;
  if (rhs.service_worker_registration_id < lhs.service_worker_registration_id)
    return false;
  if (lhs.tag < rhs.tag)
    return true;
  if (rhs.tag < lhs.tag)
    return false;
  if (lhs.sync_type < rhs.sync_type)
    return true;
  if (rhs.sync_type < lhs.sync_type)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SyncRegistrationOptions::DataView,
                                         ::blink::mojom::SyncRegistrationOptionsPtr> {
  static bool IsNull(const ::blink::mojom::SyncRegistrationOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SyncRegistrationOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SyncRegistrationOptions::tag)& tag(
      const ::blink::mojom::SyncRegistrationOptionsPtr& input) {
    return input->tag;
  }

  static decltype(::blink::mojom::SyncRegistrationOptions::min_interval) min_interval(
      const ::blink::mojom::SyncRegistrationOptionsPtr& input) {
    return input->min_interval;
  }

  static bool Read(::blink::mojom::SyncRegistrationOptions::DataView input, ::blink::mojom::SyncRegistrationOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::BackgroundSyncRegistrationInfo::DataView,
                                         ::blink::mojom::BackgroundSyncRegistrationInfoPtr> {
  static bool IsNull(const ::blink::mojom::BackgroundSyncRegistrationInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::BackgroundSyncRegistrationInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::BackgroundSyncRegistrationInfo::service_worker_registration_id) service_worker_registration_id(
      const ::blink::mojom::BackgroundSyncRegistrationInfoPtr& input) {
    return input->service_worker_registration_id;
  }

  static const decltype(::blink::mojom::BackgroundSyncRegistrationInfo::tag)& tag(
      const ::blink::mojom::BackgroundSyncRegistrationInfoPtr& input) {
    return input->tag;
  }

  static decltype(::blink::mojom::BackgroundSyncRegistrationInfo::sync_type) sync_type(
      const ::blink::mojom::BackgroundSyncRegistrationInfoPtr& input) {
    return input->sync_type;
  }

  static bool Read(::blink::mojom::BackgroundSyncRegistrationInfo::DataView input, ::blink::mojom::BackgroundSyncRegistrationInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_SYNC_BACKGROUND_SYNC_MOJOM_H_