// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* FileSystemAccessAccessHandleLockModeToStringHelper(FileSystemAccessAccessHandleLockMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FileSystemAccessAccessHandleLockMode::kReadwrite:
      return "kReadwrite";
    case FileSystemAccessAccessHandleLockMode::kReadOnly:
      return "kReadOnly";
    case FileSystemAccessAccessHandleLockMode::kReadwriteUnsafe:
      return "kReadwriteUnsafe";
    default:
      return nullptr;
  }
}

std::string FileSystemAccessAccessHandleLockModeToString(FileSystemAccessAccessHandleLockMode value) {
  const char *str = FileSystemAccessAccessHandleLockModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FileSystemAccessAccessHandleLockMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FileSystemAccessAccessHandleLockMode value) {
  return os << FileSystemAccessAccessHandleLockModeToString(value);
}

NOINLINE static const char* FileSystemAccessWritableFileStreamLockModeToStringHelper(FileSystemAccessWritableFileStreamLockMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FileSystemAccessWritableFileStreamLockMode::kExclusive:
      return "kExclusive";
    case FileSystemAccessWritableFileStreamLockMode::kSiloed:
      return "kSiloed";
    default:
      return nullptr;
  }
}

std::string FileSystemAccessWritableFileStreamLockModeToString(FileSystemAccessWritableFileStreamLockMode value) {
  const char *str = FileSystemAccessWritableFileStreamLockModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FileSystemAccessWritableFileStreamLockMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FileSystemAccessWritableFileStreamLockMode value) {
  return os << FileSystemAccessWritableFileStreamLockModeToString(value);
}

namespace internal {
// static
bool FileSystemAccessAccessHandleFile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FileSystemAccessAccessHandleFile_Data* object = static_cast<const FileSystemAccessAccessHandleFile_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FileSystemAccessAccessHandleFile_Tag::kRegularFile: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_regular_file, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_regular_file, validation_context))
        return false;
      return true;
    }
    case FileSystemAccessAccessHandleFile_Tag::kIncognitoFileDelegate: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_incognito_file_delegate, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_incognito_file_delegate,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FileSystemAccessAccessHandleFile");
      return false;
    }
  }
}


// static
bool FileSystemAccessRegularFile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessRegularFile_Data* object =
      static_cast<const FileSystemAccessRegularFile_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->os_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->os_file, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->file_modification_host, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->file_modification_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessRegularFile_Data::FileSystemAccessRegularFile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_GetPermissionStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_GetPermissionStatus_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_GetPermissionStatus_Params_Data*>(data);


  if (!::blink::mojom::internal::FileSystemAccessPermissionMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_GetPermissionStatus_Params_Data::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_RequestPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_RequestPermission_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_RequestPermission_Params_Data*>(data);


  if (!::blink::mojom::internal::FileSystemAccessPermissionMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_RequestPermission_Params_Data::FileSystemAccessFileHandle_RequestPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_AsBlob_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_AsBlob_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_AsBlob_Params_Data*>(data);

  return true;
}

FileSystemAccessFileHandle_AsBlob_Params_Data::FileSystemAccessFileHandle_AsBlob_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_AsBlob_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_AsBlob_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_AsBlob_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blob, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_AsBlob_ResponseParams_Data::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_CreateFileWriter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_CreateFileWriter_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_CreateFileWriter_Params_Data*>(data);


  if (!::blink::mojom::internal::FileSystemAccessWritableFileStreamLockMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_CreateFileWriter_Params_Data::FileSystemAccessFileHandle_CreateFileWriter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->writer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_Rename_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_Rename_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_Rename_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_entry_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_entry_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_entry_name, validation_context,
                                         &new_entry_name_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessFileHandle_Rename_Params_Data::FileSystemAccessFileHandle_Rename_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_Rename_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_Rename_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_Rename_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_Rename_ResponseParams_Data::FileSystemAccessFileHandle_Rename_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_Move_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_Move_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_Move_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->destination_directory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->destination_directory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_entry_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_entry_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_entry_name, validation_context,
                                         &new_entry_name_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessFileHandle_Move_Params_Data::FileSystemAccessFileHandle_Move_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_Move_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_Move_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_Move_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_Move_ResponseParams_Data::FileSystemAccessFileHandle_Move_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_Remove_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_Remove_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_Remove_Params_Data*>(data);

  return true;
}

FileSystemAccessFileHandle_Remove_Params_Data::FileSystemAccessFileHandle_Remove_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_Remove_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_Remove_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_Remove_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_Remove_ResponseParams_Data::FileSystemAccessFileHandle_Remove_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_OpenAccessHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_OpenAccessHandle_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_OpenAccessHandle_Params_Data*>(data);


  if (!::blink::mojom::internal::FileSystemAccessAccessHandleLockMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_OpenAccessHandle_Params_Data::FileSystemAccessFileHandle_OpenAccessHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->file, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->access_handle_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data::FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_IsSameEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_IsSameEntry_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_IsSameEntry_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->other, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->other,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessFileHandle_IsSameEntry_Params_Data::FileSystemAccessFileHandle_IsSameEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_Transfer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_Transfer_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_Transfer_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->token,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessFileHandle_Transfer_Params_Data::FileSystemAccessFileHandle_Transfer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_GetUniqueId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_GetUniqueId_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_GetUniqueId_Params_Data*>(data);

  return true;
}

FileSystemAccessFileHandle_GetUniqueId_Params_Data::FileSystemAccessFileHandle_GetUniqueId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data::FileSystemAccessFileHandle_GetUniqueId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data* object =
      static_cast<const FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data*>(data);

  return true;
}

FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data::FileSystemAccessFileHandle_GetCloudIdentifiers_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data* object =
      static_cast<const FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cloud_identifiers, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cloud_identifiers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cloud_identifiers, validation_context,
                                         &cloud_identifiers_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data::FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FileSystemAccessAccessHandleLockMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FileSystemAccessAccessHandleLockMode value) {
  return std::move(context).WriteString(::blink::mojom::FileSystemAccessAccessHandleLockModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FileSystemAccessWritableFileStreamLockMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FileSystemAccessWritableFileStreamLockMode value) {
  return std::move(context).WriteString(::blink::mojom::FileSystemAccessWritableFileStreamLockModeToString(value));
}

} // namespace perfetto