// third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared-internal.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"




#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FrameReplicationStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FrameReplicationStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FrameReplicationState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in FrameReplicationState struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in FrameReplicationState struct");

    decltype(Traits::unique_name(input)) in_unique_name = Traits::unique_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unique_name)::BaseType> unique_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_unique_name,
      unique_name_fragment);

    fragment->unique_name.Set(
        unique_name_fragment.is_null() ? nullptr : unique_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->unique_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unique_name in FrameReplicationState struct");

    decltype(Traits::permissions_policy_header(input)) in_permissions_policy_header = Traits::permissions_policy_header(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permissions_policy_header)::BaseType>
        permissions_policy_header_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permissions_policy_header_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
      in_permissions_policy_header,
      permissions_policy_header_fragment,
      &permissions_policy_header_validate_params);

    fragment->permissions_policy_header.Set(
        permissions_policy_header_fragment.is_null() ? nullptr : permissions_policy_header_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permissions_policy_header.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permissions_policy_header in FrameReplicationState struct");

    
    mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
      Traits::active_sandbox_flags(input),
      &fragment->active_sandbox_flags);

    decltype(Traits::frame_policy(input)) in_frame_policy = Traits::frame_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_policy)::BaseType> frame_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
      in_frame_policy,
      frame_policy_fragment);

    fragment->frame_policy.Set(
        frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_policy in FrameReplicationState struct");

    
    mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
      Traits::insecure_request_policy(input),
      &fragment->insecure_request_policy);

    decltype(Traits::insecure_navigations_set(input)) in_insecure_navigations_set = Traits::insecure_navigations_set(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->insecure_navigations_set)::BaseType>
        insecure_navigations_set_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& insecure_navigations_set_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_insecure_navigations_set,
      insecure_navigations_set_fragment,
      &insecure_navigations_set_validate_params);

    fragment->insecure_navigations_set.Set(
        insecure_navigations_set_fragment.is_null() ? nullptr : insecure_navigations_set_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->insecure_navigations_set.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null insecure_navigations_set in FrameReplicationState struct");

    fragment->has_potentially_trustworthy_unique_origin = Traits::has_potentially_trustworthy_unique_origin(input);

    fragment->has_active_user_gesture = Traits::has_active_user_gesture(input);

    fragment->has_received_user_gesture_before_nav = Traits::has_received_user_gesture_before_nav(input);

    fragment->is_ad_frame = Traits::is_ad_frame(input);
  }

  static bool Deserialize(::blink::mojom::internal::FrameReplicationState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FrameReplicationStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FrameReplicationStateDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void FrameReplicationStateDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FrameReplicationStateDataView::GetUniqueNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->unique_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FrameReplicationStateDataView::GetPermissionsPolicyHeaderDataView(
    mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output) {
  auto pointer = data_->permissions_policy_header.Get();
  *output = mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>(pointer, message_);
}
inline void FrameReplicationStateDataView::GetFramePolicyDataView(
    ::blink::mojom::FramePolicyDataView* output) {
  auto pointer = data_->frame_policy.Get();
  *output = ::blink::mojom::FramePolicyDataView(pointer, message_);
}
inline void FrameReplicationStateDataView::GetInsecureNavigationsSetDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->insecure_navigations_set.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_SHARED_H_