// third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_URL_LOADER_FACTORY_BUNDLE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_URL_LOADER_FACTORY_BUNDLE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared.h"


namespace blink::mojom {
class URLLoaderFactoryBundleDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::URLLoaderFactoryBundleDataView> {
  using Data = ::blink::mojom::internal::URLLoaderFactoryBundle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class URLLoaderFactoryBundleDataView {
 public:
  URLLoaderFactoryBundleDataView() = default;

  URLLoaderFactoryBundleDataView(
      internal::URLLoaderFactoryBundle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDefaultFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->default_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetSchemeSpecificFactoriesDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSchemeSpecificFactories(UserType* output) {
    
    auto* pointer = data_->scheme_specific_factories.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>>(
        pointer, output, message_);
  }
  inline void GetIsolatedWorldFactoriesDataView(
      mojo::MapDataView<::url::mojom::OriginDataView, mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolatedWorldFactories(UserType* output) {
    
    auto* pointer = data_->isolated_world_factories.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>>(
        pointer, output, message_);
  }
  bool bypass_redirect_checks() const {
    return data_->bypass_redirect_checks;
  }
  inline void GetLocalResourceLoaderConfigDataView(
      ::blink::mojom::LocalResourceLoaderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalResourceLoaderConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LocalResourceLoaderConfigDataView, UserType>(),
    "Attempting to read the optional `local_resource_loader_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalResourceLoaderConfig` instead "
    "of `ReadLocalResourceLoaderConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_resource_loader_config.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalResourceLoaderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderFactoryBundle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_URL_LOADER_FACTORY_BUNDLE_MOJOM_DATA_VIEW_H_