// third_party/blink/public/mojom/manifest/manifest.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/device/public/mojom/screen_orientation_lock_types.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/capture_links.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class ManifestDataView;

class ManifestLocalizedTextObjectDataView;

class ManifestShortcutItemDataView;

class ManifestImageResourceDataView;

class ManifestScreenshotDataView;

class ManifestFileFilterDataView;

class ManifestProtocolHandlerDataView;

class ManifestScopeExtensionDataView;

class ManifestLockScreenDataView;

class ManifestNoteTakingDataView;

class ManifestRelatedApplicationDataView;

class ManifestShareTargetParamsDataView;

class ManifestShareTargetDataView;

class ManifestFileHandlerDataView;

class ManifestTranslationItemDataView;

class ManifestTabStripDataView;

class HomeTabParamsDataView;

class NewTabButtonParamsDataView;

class ManifestDebugInfoDataView;

class ManifestErrorDataView;

class HomeTabUnionDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ManifestDataView> {
  using Data = ::blink::mojom::internal::Manifest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestLocalizedTextObjectDataView> {
  using Data = ::blink::mojom::internal::ManifestLocalizedTextObject_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestShortcutItemDataView> {
  using Data = ::blink::mojom::internal::ManifestShortcutItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestImageResourceDataView> {
  using Data = ::blink::mojom::internal::ManifestImageResource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestScreenshotDataView> {
  using Data = ::blink::mojom::internal::ManifestScreenshot_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestFileFilterDataView> {
  using Data = ::blink::mojom::internal::ManifestFileFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestProtocolHandlerDataView> {
  using Data = ::blink::mojom::internal::ManifestProtocolHandler_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestScopeExtensionDataView> {
  using Data = ::blink::mojom::internal::ManifestScopeExtension_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestLockScreenDataView> {
  using Data = ::blink::mojom::internal::ManifestLockScreen_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestNoteTakingDataView> {
  using Data = ::blink::mojom::internal::ManifestNoteTaking_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestRelatedApplicationDataView> {
  using Data = ::blink::mojom::internal::ManifestRelatedApplication_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestShareTargetParamsDataView> {
  using Data = ::blink::mojom::internal::ManifestShareTargetParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestShareTargetDataView> {
  using Data = ::blink::mojom::internal::ManifestShareTarget_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestFileHandlerDataView> {
  using Data = ::blink::mojom::internal::ManifestFileHandler_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestTranslationItemDataView> {
  using Data = ::blink::mojom::internal::ManifestTranslationItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestTabStripDataView> {
  using Data = ::blink::mojom::internal::ManifestTabStrip_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HomeTabParamsDataView> {
  using Data = ::blink::mojom::internal::HomeTabParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::NewTabButtonParamsDataView> {
  using Data = ::blink::mojom::internal::NewTabButtonParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestDebugInfoDataView> {
  using Data = ::blink::mojom::internal::ManifestDebugInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestErrorDataView> {
  using Data = ::blink::mojom::internal::ManifestError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HomeTabUnionDataView> {
  using Data = ::blink::mojom::internal::HomeTabUnion_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class TabStripMemberVisibility : int32_t {
  
  kAuto = 0,
  
  kAbsent = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, TabStripMemberVisibility value);
inline bool IsKnownEnumValue(TabStripMemberVisibility value) {
  return internal::TabStripMemberVisibility_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestRequestResult : int32_t {
  
  kUnexpectedFailure = 0,
  
  kNoManifestAllowed = 1,
  
  kNoManifestSpecified = 2,
  
  kManifestFailedToFetch = 3,
  
  kManifestFailedToParse = 4,
  
  kSuccess = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestRequestResult value);
inline bool IsKnownEnumValue(ManifestRequestResult value) {
  return internal::ManifestRequestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Manifest_TextDirection : int32_t {
  
  kAuto = 0,
  
  kLTR = 1,
  
  kRTL = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Manifest_TextDirection value);
inline bool IsKnownEnumValue(Manifest_TextDirection value) {
  return internal::Manifest_TextDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestImageResource_Purpose : int32_t {
  
  ANY = 0,
  
  MONOCHROME = 1,
  
  MASKABLE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestImageResource_Purpose value);
inline bool IsKnownEnumValue(ManifestImageResource_Purpose value) {
  return internal::ManifestImageResource_Purpose_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestScreenshot_FormFactor : int32_t {
  
  kUnknown = 0,
  
  kWide = 1,
  
  kNarrow = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestScreenshot_FormFactor value);
inline bool IsKnownEnumValue(ManifestScreenshot_FormFactor value) {
  return internal::ManifestScreenshot_FormFactor_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestShareTarget_Method : int32_t {
  
  kGet = 0,
  
  kPost = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestShareTarget_Method value);
inline bool IsKnownEnumValue(ManifestShareTarget_Method value) {
  return internal::ManifestShareTarget_Method_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestShareTarget_Enctype : int32_t {
  
  kFormUrlEncoded = 0,
  
  kMultipartFormData = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestShareTarget_Enctype value);
inline bool IsKnownEnumValue(ManifestShareTarget_Enctype value) {
  return internal::ManifestShareTarget_Enctype_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestFileHandler_LaunchType : int32_t {
  
  kSingleClient = 0,
  
  kMultipleClients = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestFileHandler_LaunchType value);
inline bool IsKnownEnumValue(ManifestFileHandler_LaunchType value) {
  return internal::ManifestFileHandler_LaunchType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ManifestDataView {
 public:
  ManifestDataView() = default;

  ManifestDataView(
      internal::Manifest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetManifestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManifestUrl(UserType* output) {
    
    auto* pointer = data_->manifest_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDir(UserType* output) const {
    auto data_value = data_->dir;
    return mojo::internal::Deserialize<::blink::mojom::Manifest_TextDirection>(
        data_value, output);
  }
  Manifest_TextDirection dir() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Manifest_TextDirection>(data_->dir));
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetShortNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `short_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShortName` instead "
    "of `ReadShortName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->short_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool has_custom_id() const {
    return data_->has_custom_id;
  }
  inline void GetStartUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartUrl(UserType* output) {
    
    auto* pointer = data_->start_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool has_valid_specified_start_url() const {
    return data_->has_valid_specified_start_url;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisplay(UserType* output) const {
    auto data_value = data_->display;
    return mojo::internal::Deserialize<::blink::mojom::DisplayMode>(
        data_value, output);
  }
  ::blink::mojom::DisplayMode display() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DisplayMode>(data_->display));
  }
  inline void GetDisplayOverrideDataView(
      mojo::ArrayDataView<::blink::mojom::DisplayMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayOverride(UserType* output) {
    
    auto* pointer = data_->display_override.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::DisplayMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) const {
    auto data_value = data_->orientation;
    return mojo::internal::Deserialize<::device::mojom::ScreenOrientationLockType>(
        data_value, output);
  }
  ::device::mojom::ScreenOrientationLockType orientation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::ScreenOrientationLockType>(data_->orientation));
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetScreenshotsDataView(
      mojo::ArrayDataView<ManifestScreenshotDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenshots(UserType* output) {
    
    auto* pointer = data_->screenshots.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestScreenshotDataView>>(
        pointer, output, message_);
  }
  inline void GetShortcutsDataView(
      mojo::ArrayDataView<ManifestShortcutItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortcuts(UserType* output) {
    
    auto* pointer = data_->shortcuts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestShortcutItemDataView>>(
        pointer, output, message_);
  }
  inline void GetShareTargetDataView(
      ManifestShareTargetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShareTarget(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestShareTargetDataView, UserType>(),
    "Attempting to read the optional `share_target` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShareTarget` instead "
    "of `ReadShareTarget if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->share_target.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestShareTargetDataView>(
        pointer, output, message_);
  }
  inline void GetFileHandlersDataView(
      mojo::ArrayDataView<ManifestFileHandlerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileHandlers(UserType* output) {
    
    auto* pointer = data_->file_handlers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestFileHandlerDataView>>(
        pointer, output, message_);
  }
  inline void GetProtocolHandlersDataView(
      mojo::ArrayDataView<ManifestProtocolHandlerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocolHandlers(UserType* output) {
    
    auto* pointer = data_->protocol_handlers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestProtocolHandlerDataView>>(
        pointer, output, message_);
  }
  inline void GetScopeExtensionsDataView(
      mojo::ArrayDataView<ManifestScopeExtensionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScopeExtensions(UserType* output) {
    
    auto* pointer = data_->scope_extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestScopeExtensionDataView>>(
        pointer, output, message_);
  }
  inline void GetLockScreenDataView(
      ManifestLockScreenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLockScreen(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestLockScreenDataView, UserType>(),
    "Attempting to read the optional `lock_screen` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLockScreen` instead "
    "of `ReadLockScreen if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->lock_screen.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestLockScreenDataView>(
        pointer, output, message_);
  }
  inline void GetNoteTakingDataView(
      ManifestNoteTakingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNoteTaking(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestNoteTakingDataView, UserType>(),
    "Attempting to read the optional `note_taking` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNoteTaking` instead "
    "of `ReadNoteTaking if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->note_taking.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestNoteTakingDataView>(
        pointer, output, message_);
  }
  inline void GetRelatedApplicationsDataView(
      mojo::ArrayDataView<ManifestRelatedApplicationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelatedApplications(UserType* output) {
    
    auto* pointer = data_->related_applications.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestRelatedApplicationDataView>>(
        pointer, output, message_);
  }
  bool prefer_related_applications() const {
    return data_->prefer_related_applications;
  }
  bool has_theme_color() const {
    return data_->has_theme_color;
  }
  uint32_t theme_color() const {
    return data_->theme_color;
  }
  bool has_background_color() const {
    return data_->has_background_color;
  }
  uint32_t background_color() const {
    return data_->background_color;
  }
  inline void GetGcmSenderIdDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGcmSenderId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `gcm_sender_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGcmSenderId` instead "
    "of `ReadGcmSenderId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gcm_sender_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCaptureLinks(UserType* output) const {
    auto data_value = data_->capture_links;
    return mojo::internal::Deserialize<::blink::mojom::CaptureLinks>(
        data_value, output);
  }
  ::blink::mojom::CaptureLinks capture_links() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CaptureLinks>(data_->capture_links));
  }
  inline void GetPermissionsPolicyDataView(
      mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionsPolicy(UserType* output) {
    
    auto* pointer = data_->permissions_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  inline void GetLaunchHandlerDataView(
      ::blink::mojom::ManifestLaunchHandlerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLaunchHandler(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestLaunchHandlerDataView, UserType>(),
    "Attempting to read the optional `launch_handler` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLaunchHandler` instead "
    "of `ReadLaunchHandler if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->launch_handler.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestLaunchHandlerDataView>(
        pointer, output, message_);
  }
  inline void GetTranslationsDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestTranslationItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranslations(UserType* output) {
    
    auto* pointer = data_->translations.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestTranslationItemDataView>>(
        pointer, output, message_);
  }
  bool has_dark_theme_color() const {
    return data_->has_dark_theme_color;
  }
  uint32_t dark_theme_color() const {
    return data_->dark_theme_color;
  }
  bool has_dark_background_color() const {
    return data_->has_dark_background_color;
  }
  uint32_t dark_background_color() const {
    return data_->dark_background_color;
  }
  inline void GetTabStripDataView(
      ManifestTabStripDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabStrip(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestTabStripDataView, UserType>(),
    "Attempting to read the optional `tab_strip` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTabStrip` instead "
    "of `ReadTabStrip if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tab_strip.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestTabStripDataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `version` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersion` instead "
    "of `ReadVersion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameLocalizedDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameLocalized(UserType* output) {
    
    auto* pointer = data_->name_localized.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
        pointer, output, message_);
  }
  inline void GetShortNameLocalizedDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortNameLocalized(UserType* output) {
    
    auto* pointer = data_->short_name_localized.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
        pointer, output, message_);
  }
  inline void GetDescriptionLocalizedDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptionLocalized(UserType* output) {
    
    auto* pointer = data_->description_localized.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
        pointer, output, message_);
  }
  inline void GetIconsLocalizedDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<ManifestImageResourceDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconsLocalized(UserType* output) {
    
    auto* pointer = data_->icons_localized.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::Manifest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestLocalizedTextObjectDataView {
 public:
  ManifestLocalizedTextObjectDataView() = default;

  ManifestLocalizedTextObjectDataView(
      internal::ManifestLocalizedTextObject_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDir(UserType* output) const {
    if (!data_->dir_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::Manifest_TextDirection>(
        data_->dir_$value, &output->emplace());
  }
  std::optional<Manifest_TextDirection> dir() const {
    if (!data_->dir_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Manifest_TextDirection>(data_->dir_$value));
  }
  inline void GetLangDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLang(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `lang` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLang` instead "
    "of `ReadLang if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->lang.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestLocalizedTextObject_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestShortcutItemDataView {
 public:
  ManifestShortcutItemDataView() = default;

  ManifestShortcutItemDataView(
      internal::ManifestShortcutItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetShortNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `short_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShortName` instead "
    "of `ReadShortName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->short_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetNameLocalizedDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameLocalized(UserType* output) {
    
    auto* pointer = data_->name_localized.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
        pointer, output, message_);
  }
  inline void GetShortNameLocalizedDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortNameLocalized(UserType* output) {
    
    auto* pointer = data_->short_name_localized.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
        pointer, output, message_);
  }
  inline void GetDescriptionLocalizedDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestLocalizedTextObjectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptionLocalized(UserType* output) {
    
    auto* pointer = data_->description_localized.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestLocalizedTextObjectDataView>>(
        pointer, output, message_);
  }
  inline void GetIconsLocalizedDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<ManifestImageResourceDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconsLocalized(UserType* output) {
    
    auto* pointer = data_->icons_localized.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestShortcutItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestImageResourceDataView {
 public:
  ManifestImageResourceDataView() = default;

  ManifestImageResourceDataView(
      internal::ManifestImageResource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrcDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTypeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadType` instead "
    "of `ReadType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizes(UserType* output) {
    
    auto* pointer = data_->sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
  inline void GetPurposeDataView(
      mojo::ArrayDataView<ManifestImageResource_Purpose>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPurpose(UserType* output) {
    
    auto* pointer = data_->purpose.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResource_Purpose>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestImageResource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestScreenshotDataView {
 public:
  ManifestScreenshotDataView() = default;

  ManifestScreenshotDataView(
      internal::ManifestScreenshot_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageDataView(
      ManifestImageResourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) {
    
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestImageResourceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormFactor(UserType* output) const {
    auto data_value = data_->form_factor;
    return mojo::internal::Deserialize<::blink::mojom::ManifestScreenshot_FormFactor>(
        data_value, output);
  }
  ManifestScreenshot_FormFactor form_factor() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ManifestScreenshot_FormFactor>(data_->form_factor));
  }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLabel` instead "
    "of `ReadLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestScreenshot_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestFileFilterDataView {
 public:
  ManifestFileFilterDataView() = default;

  ManifestFileFilterDataView(
      internal::ManifestFileFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAcceptDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccept(UserType* output) {
    
    auto* pointer = data_->accept.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestFileFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestProtocolHandlerDataView {
 public:
  ManifestProtocolHandlerDataView() = default;

  ManifestProtocolHandlerDataView(
      internal::ManifestProtocolHandler_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProtocolDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestProtocolHandler_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestScopeExtensionDataView {
 public:
  ManifestScopeExtensionDataView() = default;

  ManifestScopeExtensionDataView(
      internal::ManifestScopeExtension_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool has_origin_wildcard() const {
    return data_->has_origin_wildcard;
  }
 private:
  internal::ManifestScopeExtension_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestLockScreenDataView {
 public:
  ManifestLockScreenDataView() = default;

  ManifestLockScreenDataView(
      internal::ManifestLockScreen_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartUrl(UserType* output) {
    
    auto* pointer = data_->start_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestLockScreen_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestNoteTakingDataView {
 public:
  ManifestNoteTakingDataView() = default;

  ManifestNoteTakingDataView(
      internal::ManifestNoteTaking_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNewNoteUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewNoteUrl(UserType* output) {
    
    auto* pointer = data_->new_note_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestNoteTaking_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestRelatedApplicationDataView {
 public:
  ManifestRelatedApplicationDataView() = default;

  ManifestRelatedApplicationDataView(
      internal::ManifestRelatedApplication_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPlatformDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlatform(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `platform` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlatform` instead "
    "of `ReadPlatform if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->platform.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestRelatedApplication_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestShareTargetParamsDataView {
 public:
  ManifestShareTargetParamsDataView() = default;

  ManifestShareTargetParamsDataView(
      internal::ManifestShareTargetParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadText` instead "
    "of `ReadText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetFilesDataView(
      mojo::ArrayDataView<ManifestFileFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiles(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::ManifestFileFilterDataView>, UserType>(),
    "Attempting to read the optional `files` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFiles` instead "
    "of `ReadFiles if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestFileFilterDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestShareTargetParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestShareTargetDataView {
 public:
  ManifestShareTargetDataView() = default;

  ManifestShareTargetDataView(
      internal::ManifestShareTarget_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) const {
    auto data_value = data_->method;
    return mojo::internal::Deserialize<::blink::mojom::ManifestShareTarget_Method>(
        data_value, output);
  }
  ManifestShareTarget_Method method() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ManifestShareTarget_Method>(data_->method));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnctype(UserType* output) const {
    auto data_value = data_->enctype;
    return mojo::internal::Deserialize<::blink::mojom::ManifestShareTarget_Enctype>(
        data_value, output);
  }
  ManifestShareTarget_Enctype enctype() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ManifestShareTarget_Enctype>(data_->enctype));
  }
  inline void GetParamsDataView(
      ManifestShareTargetParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestShareTargetParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestShareTarget_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestFileHandlerDataView {
 public:
  ManifestFileHandlerDataView() = default;

  ManifestFileHandlerDataView(
      internal::ManifestFileHandler_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetAcceptDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccept(UserType* output) {
    
    auto* pointer = data_->accept.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLaunchType(UserType* output) const {
    auto data_value = data_->launch_type;
    return mojo::internal::Deserialize<::blink::mojom::ManifestFileHandler_LaunchType>(
        data_value, output);
  }
  ManifestFileHandler_LaunchType launch_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ManifestFileHandler_LaunchType>(data_->launch_type));
  }
 private:
  internal::ManifestFileHandler_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestTranslationItemDataView {
 public:
  ManifestTranslationItemDataView() = default;

  ManifestTranslationItemDataView(
      internal::ManifestTranslationItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetShortNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `short_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShortName` instead "
    "of `ReadShortName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->short_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestTranslationItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestTabStripDataView {
 public:
  ManifestTabStripDataView() = default;

  ManifestTabStripDataView(
      internal::ManifestTabStrip_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHomeTabDataView(
      HomeTabUnionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHomeTab(UserType* output) {
    
    auto* pointer = !data_->home_tab.is_null() ? &data_->home_tab : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::HomeTabUnionDataView>(
        pointer, output, message_);
  }
  inline void GetNewTabButtonDataView(
      NewTabButtonParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewTabButton(UserType* output) {
    
    auto* pointer = data_->new_tab_button.Get();
    return mojo::internal::Deserialize<::blink::mojom::NewTabButtonParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestTabStrip_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HomeTabParamsDataView {
 public:
  HomeTabParamsDataView() = default;

  HomeTabParamsDataView(
      internal::HomeTabParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetScopePatternsDataView(
      mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScopePatterns(UserType* output) {
    
    auto* pointer = data_->scope_patterns.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HomeTabParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NewTabButtonParamsDataView {
 public:
  NewTabButtonParamsDataView() = default;

  NewTabButtonParamsDataView(
      internal::NewTabButtonParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::NewTabButtonParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestDebugInfoDataView {
 public:
  ManifestDebugInfoDataView() = default;

  ManifestDebugInfoDataView(
      internal::ManifestDebugInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetErrorsDataView(
      mojo::ArrayDataView<ManifestErrorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrors(UserType* output) {
    
    auto* pointer = data_->errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestErrorDataView>>(
        pointer, output, message_);
  }
  inline void GetRawManifestDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawManifest(UserType* output) {
    
    auto* pointer = data_->raw_manifest.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestDebugInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestErrorDataView {
 public:
  ManifestErrorDataView() = default;

  ManifestErrorDataView(
      internal::ManifestError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool critical() const {
    return data_->critical;
  }
  uint32_t line() const {
    return data_->line;
  }
  uint32_t column() const {
    return data_->column;
  }
 private:
  internal::ManifestError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HomeTabUnionDataView {
 public:
  using Tag = internal::HomeTabUnion_Data::HomeTabUnion_Tag;

  HomeTabUnionDataView() = default;

  HomeTabUnionDataView(
      internal::HomeTabUnion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_visibility() const { return data_->tag == Tag::kVisibility; }
  template <typename UserType>
  [[nodiscard]] bool ReadVisibility(UserType* output) const {
    CHECK(is_visibility());
    return mojo::internal::Deserialize<::blink::mojom::TabStripMemberVisibility>(
        data_->data.f_visibility, output);
  }
  TabStripMemberVisibility visibility() const {
    CHECK(is_visibility());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::TabStripMemberVisibility>(data_->data.f_visibility));
  }
  bool is_params() const { return data_->tag == Tag::kParams; }
  inline void GetParamsDataView(
      HomeTabParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) const {
    
    CHECK(is_params());
    return mojo::internal::Deserialize<::blink::mojom::HomeTabParamsDataView>(
        data_->data.f_params.Get(), output, message_);
  }

 private:
  internal::HomeTabUnion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_DATA_VIEW_H_