// third_party/blink/public/mojom/manifest/manifest.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "services/device/public/mojom/screen_orientation_lock_types.mojom-forward.h"
#include "third_party/blink/public/mojom/manifest/capture_links.mojom-forward.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-forward.h"
#include "third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"
#include "third_party/blink/public/common/manifest/manifest.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {
























class BLINK_COMMON_EXPORT ManifestError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestError, T>::value>;
  using DataView = ManifestErrorDataView;
  using Data_ = internal::ManifestError_Data;

  template <typename... Args>
  static ManifestErrorPtr New(Args&&... args) {
    return ManifestErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestErrorPtr From(const U& u) {
    return mojo::TypeConverter<ManifestErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestError>::Convert(*this);
  }


  ManifestError();

  ManifestError(
      const std::string& message,
      bool critical,
      uint32_t line,
      uint32_t column);


  ~ManifestError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestErrorPtr>
  ManifestErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestError_UnserializedMessageContext<
            UserType, ManifestError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestError_UnserializedMessageContext<
            UserType, ManifestError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string message;
  
  bool critical;
  
  uint32_t line;
  
  uint32_t column;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT HomeTabUnion {
 public:
  using DataView = HomeTabUnionDataView;
  using Data_ = internal::HomeTabUnion_Data;
  using Tag = Data_::HomeTabUnion_Tag;

  template <typename... Args>
  static HomeTabUnionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |visibility|.
  static HomeTabUnionPtr NewVisibility(
      TabStripMemberVisibility value);
  // Construct an instance holding |params|.
  static HomeTabUnionPtr NewParams(
      HomeTabParamsPtr value);

  template <typename U>
  static HomeTabUnionPtr From(const U& u) {
    return mojo::TypeConverter<HomeTabUnionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HomeTabUnion>::Convert(*this);
  }
  ~HomeTabUnion();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  HomeTabUnion(const HomeTabUnion& other) = delete;
  HomeTabUnion& operator=(const HomeTabUnion& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = HomeTabUnionPtr>
  HomeTabUnionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, HomeTabUnion>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, HomeTabUnion>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_visibility() const { return tag_ == Tag::kVisibility; }
  TabStripMemberVisibility get_visibility() const {
    CHECK(tag_ == Tag::kVisibility);
    return data_.visibility;
  }
  void set_visibility(TabStripMemberVisibility visibility);

  bool is_params() const { return tag_ == Tag::kParams; }
  const HomeTabParamsPtr& get_params() const {
    CHECK(tag_ == Tag::kParams);
    return data_.params;
  }
  HomeTabParamsPtr& get_params() {
    CHECK(tag_ == Tag::kParams);
    return data_.params;
  }
  void set_params(HomeTabParamsPtr params);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HomeTabUnion::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<HomeTabUnion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kVisibility)>,
        TabStripMemberVisibility value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kParams)>,
        HomeTabParamsPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    TabStripMemberVisibility visibility;
    HomeTabParamsPtr params;
  };

  HomeTabUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kVisibility)>,
      TabStripMemberVisibility value);
  HomeTabUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kParams)>,
      HomeTabParamsPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT Manifest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Manifest, T>::value>;
  using DataView = ManifestDataView;
  using Data_ = internal::Manifest_Data;
  using TextDirection = Manifest_TextDirection;

  template <typename... Args>
  static ManifestPtr New(Args&&... args) {
    return ManifestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestPtr From(const U& u) {
    return mojo::TypeConverter<ManifestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Manifest>::Convert(*this);
  }


  Manifest();

  Manifest(
      const ::GURL& manifest_url,
      Manifest::TextDirection dir,
      const std::optional<::std::u16string>& name,
      const std::optional<::std::u16string>& short_name,
      const std::optional<::std::u16string>& description,
      const ::GURL& id,
      bool has_custom_id,
      const ::GURL& start_url,
      bool has_valid_specified_start_url,
      ::blink::mojom::DisplayMode display,
      std::vector<::blink::mojom::DisplayMode> display_override,
      ::device::mojom::ScreenOrientationLockType orientation,
      std::vector<::blink::Manifest::ImageResource> icons,
      std::vector<ManifestScreenshotPtr> screenshots,
      std::vector<::blink::Manifest::ShortcutItem> shortcuts,
      const std::optional<::blink::Manifest::ShareTarget>& share_target,
      std::vector<ManifestFileHandlerPtr> file_handlers,
      std::vector<ManifestProtocolHandlerPtr> protocol_handlers,
      std::vector<ManifestScopeExtensionPtr> scope_extensions,
      ManifestLockScreenPtr lock_screen,
      ManifestNoteTakingPtr note_taking,
      std::vector<::blink::Manifest::RelatedApplication> related_applications,
      bool prefer_related_applications,
      bool has_theme_color,
      uint32_t theme_color,
      bool has_background_color,
      uint32_t background_color,
      const std::optional<::std::u16string>& gcm_sender_id,
      const ::GURL& scope,
      ::blink::mojom::CaptureLinks capture_links,
      std::vector<::network::ParsedPermissionsPolicyDeclaration> permissions_policy,
      const std::optional<::blink::Manifest::LaunchHandler>& launch_handler,
      const base::flat_map<::std::u16string, ::blink::Manifest::TranslationItem>& translations,
      bool has_dark_theme_color,
      uint32_t dark_theme_color,
      bool has_dark_background_color,
      uint32_t dark_background_color,
      const std::optional<::blink::Manifest::TabStrip>& tab_strip,
      const std::optional<::std::u16string>& version,
      base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> name_localized,
      base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> short_name_localized,
      base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> description_localized,
      const base::flat_map<::std::u16string, std::vector<::blink::Manifest::ImageResource>>& icons_localized);

Manifest(const Manifest&) = delete;
Manifest& operator=(const Manifest&) = delete;

  ~Manifest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestPtr>
  ManifestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Manifest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Manifest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Manifest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Manifest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Manifest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Manifest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Manifest_UnserializedMessageContext<
            UserType, Manifest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Manifest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Manifest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Manifest_UnserializedMessageContext<
            UserType, Manifest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Manifest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL manifest_url;
  
  Manifest::TextDirection dir;
  
  std::optional<::std::u16string> name;
  
  std::optional<::std::u16string> short_name;
  
  std::optional<::std::u16string> description;
  
  ::GURL id;
  
  bool has_custom_id;
  
  ::GURL start_url;
  
  bool has_valid_specified_start_url;
  
  ::blink::mojom::DisplayMode display;
  
  std::vector<::blink::mojom::DisplayMode> display_override;
  
  ::device::mojom::ScreenOrientationLockType orientation;
  
  std::vector<::blink::Manifest::ImageResource> icons;
  
  std::vector<ManifestScreenshotPtr> screenshots;
  
  std::vector<::blink::Manifest::ShortcutItem> shortcuts;
  
  std::optional<::blink::Manifest::ShareTarget> share_target;
  
  std::vector<ManifestFileHandlerPtr> file_handlers;
  
  std::vector<ManifestProtocolHandlerPtr> protocol_handlers;
  
  std::vector<ManifestScopeExtensionPtr> scope_extensions;
  
  ManifestLockScreenPtr lock_screen;
  
  ManifestNoteTakingPtr note_taking;
  
  std::vector<::blink::Manifest::RelatedApplication> related_applications;
  
  bool prefer_related_applications;
  
  bool has_theme_color;
  
  uint32_t theme_color;
  
  bool has_background_color;
  
  uint32_t background_color;
  
  std::optional<::std::u16string> gcm_sender_id;
  
  ::GURL scope;
  
  ::blink::mojom::CaptureLinks capture_links;
  
  std::vector<::network::ParsedPermissionsPolicyDeclaration> permissions_policy;
  
  std::optional<::blink::Manifest::LaunchHandler> launch_handler;
  
  base::flat_map<::std::u16string, ::blink::Manifest::TranslationItem> translations;
  
  bool has_dark_theme_color;
  
  uint32_t dark_theme_color;
  
  bool has_dark_background_color;
  
  uint32_t dark_background_color;
  
  std::optional<::blink::Manifest::TabStrip> tab_strip;
  
  std::optional<::std::u16string> version;
  
  base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> name_localized;
  
  base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> short_name_localized;
  
  base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> description_localized;
  
  base::flat_map<::std::u16string, std::vector<::blink::Manifest::ImageResource>> icons_localized;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Manifest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Manifest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Manifest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Manifest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestLocalizedTextObject {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestLocalizedTextObject, T>::value>;
  using DataView = ManifestLocalizedTextObjectDataView;
  using Data_ = internal::ManifestLocalizedTextObject_Data;

  template <typename... Args>
  static ManifestLocalizedTextObjectPtr New(Args&&... args) {
    return ManifestLocalizedTextObjectPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestLocalizedTextObjectPtr From(const U& u) {
    return mojo::TypeConverter<ManifestLocalizedTextObjectPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestLocalizedTextObject>::Convert(*this);
  }


  ManifestLocalizedTextObject();

  ManifestLocalizedTextObject(
      const ::std::u16string& value,
      std::optional<Manifest::TextDirection> dir,
      const std::optional<::std::u16string>& lang);


  ~ManifestLocalizedTextObject();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestLocalizedTextObjectPtr>
  ManifestLocalizedTextObjectPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestLocalizedTextObject::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestLocalizedTextObject::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestLocalizedTextObject::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestLocalizedTextObject_UnserializedMessageContext<
            UserType, ManifestLocalizedTextObject::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestLocalizedTextObject::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestLocalizedTextObject::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestLocalizedTextObject_UnserializedMessageContext<
            UserType, ManifestLocalizedTextObject::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestLocalizedTextObject::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string value;
  
  std::optional<Manifest::TextDirection> dir;
  
  std::optional<::std::u16string> lang;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestShortcutItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestShortcutItem, T>::value>;
  using DataView = ManifestShortcutItemDataView;
  using Data_ = internal::ManifestShortcutItem_Data;

  template <typename... Args>
  static ManifestShortcutItemPtr New(Args&&... args) {
    return ManifestShortcutItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestShortcutItemPtr From(const U& u) {
    return mojo::TypeConverter<ManifestShortcutItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestShortcutItem>::Convert(*this);
  }


  ManifestShortcutItem();

  ManifestShortcutItem(
      const ::std::u16string& name,
      const std::optional<::std::u16string>& short_name,
      const std::optional<::std::u16string>& description,
      const ::GURL& url,
      std::vector<::blink::Manifest::ImageResource> icons,
      base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> name_localized,
      base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> short_name_localized,
      base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> description_localized,
      const base::flat_map<::std::u16string, std::vector<::blink::Manifest::ImageResource>>& icons_localized);

ManifestShortcutItem(const ManifestShortcutItem&) = delete;
ManifestShortcutItem& operator=(const ManifestShortcutItem&) = delete;

  ~ManifestShortcutItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestShortcutItemPtr>
  ManifestShortcutItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShortcutItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShortcutItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestShortcutItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestShortcutItem_UnserializedMessageContext<
            UserType, ManifestShortcutItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestShortcutItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestShortcutItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestShortcutItem_UnserializedMessageContext<
            UserType, ManifestShortcutItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestShortcutItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  std::optional<::std::u16string> short_name;
  
  std::optional<::std::u16string> description;
  
  ::GURL url;
  
  std::vector<::blink::Manifest::ImageResource> icons;
  
  base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> name_localized;
  
  base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> short_name_localized;
  
  base::flat_map<::std::u16string, ManifestLocalizedTextObjectPtr> description_localized;
  
  base::flat_map<::std::u16string, std::vector<::blink::Manifest::ImageResource>> icons_localized;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestShortcutItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestImageResource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestImageResource, T>::value>;
  using DataView = ManifestImageResourceDataView;
  using Data_ = internal::ManifestImageResource_Data;
  using Purpose = ManifestImageResource_Purpose;

  template <typename... Args>
  static ManifestImageResourcePtr New(Args&&... args) {
    return ManifestImageResourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestImageResourcePtr From(const U& u) {
    return mojo::TypeConverter<ManifestImageResourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestImageResource>::Convert(*this);
  }


  ManifestImageResource();

  ManifestImageResource(
      const ::GURL& src,
      const std::optional<::std::u16string>& type,
      std::vector<::gfx::Size> sizes,
      std::vector<ManifestImageResource::Purpose> purpose);


  ~ManifestImageResource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestImageResourcePtr>
  ManifestImageResourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestImageResource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestImageResource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestImageResource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestImageResource_UnserializedMessageContext<
            UserType, ManifestImageResource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestImageResource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestImageResource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestImageResource_UnserializedMessageContext<
            UserType, ManifestImageResource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestImageResource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL src;
  
  std::optional<::std::u16string> type;
  
  std::vector<::gfx::Size> sizes;
  
  std::vector<ManifestImageResource::Purpose> purpose;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestImageResource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestScreenshot {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestScreenshot, T>::value>;
  using DataView = ManifestScreenshotDataView;
  using Data_ = internal::ManifestScreenshot_Data;
  using FormFactor = ManifestScreenshot_FormFactor;

  template <typename... Args>
  static ManifestScreenshotPtr New(Args&&... args) {
    return ManifestScreenshotPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestScreenshotPtr From(const U& u) {
    return mojo::TypeConverter<ManifestScreenshotPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestScreenshot>::Convert(*this);
  }


  ManifestScreenshot();

  ManifestScreenshot(
      const ::blink::Manifest::ImageResource& image,
      ManifestScreenshot::FormFactor form_factor,
      const std::optional<::std::u16string>& label);


  ~ManifestScreenshot();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestScreenshotPtr>
  ManifestScreenshotPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestScreenshot::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestScreenshot::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestScreenshot::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestScreenshot::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestScreenshot::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestScreenshot::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestScreenshot_UnserializedMessageContext<
            UserType, ManifestScreenshot::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestScreenshot::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestScreenshot::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestScreenshot_UnserializedMessageContext<
            UserType, ManifestScreenshot::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestScreenshot::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Manifest::ImageResource image;
  
  ManifestScreenshot::FormFactor form_factor;
  
  std::optional<::std::u16string> label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestScreenshot::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestScreenshot::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestScreenshot::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestScreenshot::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestFileFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestFileFilter, T>::value>;
  using DataView = ManifestFileFilterDataView;
  using Data_ = internal::ManifestFileFilter_Data;

  template <typename... Args>
  static ManifestFileFilterPtr New(Args&&... args) {
    return ManifestFileFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestFileFilterPtr From(const U& u) {
    return mojo::TypeConverter<ManifestFileFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestFileFilter>::Convert(*this);
  }


  ManifestFileFilter();

  ManifestFileFilter(
      const std::optional<::std::u16string>& name,
      std::vector<::std::u16string> accept);


  ~ManifestFileFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestFileFilterPtr>
  ManifestFileFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestFileFilter::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestFileFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestFileFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestFileFilter_UnserializedMessageContext<
            UserType, ManifestFileFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestFileFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestFileFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestFileFilter_UnserializedMessageContext<
            UserType, ManifestFileFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestFileFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::std::u16string> name;
  
  std::vector<::std::u16string> accept;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestFileFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestProtocolHandler {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestProtocolHandler, T>::value>;
  using DataView = ManifestProtocolHandlerDataView;
  using Data_ = internal::ManifestProtocolHandler_Data;

  template <typename... Args>
  static ManifestProtocolHandlerPtr New(Args&&... args) {
    return ManifestProtocolHandlerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestProtocolHandlerPtr From(const U& u) {
    return mojo::TypeConverter<ManifestProtocolHandlerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestProtocolHandler>::Convert(*this);
  }


  ManifestProtocolHandler();

  ManifestProtocolHandler(
      const ::std::u16string& protocol,
      const ::GURL& url);


  ~ManifestProtocolHandler();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestProtocolHandlerPtr>
  ManifestProtocolHandlerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestProtocolHandler::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestProtocolHandler::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestProtocolHandler::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestProtocolHandler_UnserializedMessageContext<
            UserType, ManifestProtocolHandler::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestProtocolHandler::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestProtocolHandler::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestProtocolHandler_UnserializedMessageContext<
            UserType, ManifestProtocolHandler::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestProtocolHandler::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string protocol;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestProtocolHandler::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestScopeExtension {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestScopeExtension, T>::value>;
  using DataView = ManifestScopeExtensionDataView;
  using Data_ = internal::ManifestScopeExtension_Data;

  template <typename... Args>
  static ManifestScopeExtensionPtr New(Args&&... args) {
    return ManifestScopeExtensionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestScopeExtensionPtr From(const U& u) {
    return mojo::TypeConverter<ManifestScopeExtensionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestScopeExtension>::Convert(*this);
  }


  ManifestScopeExtension();

  ManifestScopeExtension(
      const ::url::Origin& origin,
      bool has_origin_wildcard);


  ~ManifestScopeExtension();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestScopeExtensionPtr>
  ManifestScopeExtensionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestScopeExtension::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestScopeExtension::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestScopeExtension::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestScopeExtension::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestScopeExtension::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestScopeExtension::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestScopeExtension_UnserializedMessageContext<
            UserType, ManifestScopeExtension::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestScopeExtension::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestScopeExtension::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestScopeExtension_UnserializedMessageContext<
            UserType, ManifestScopeExtension::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestScopeExtension::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  bool has_origin_wildcard;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestScopeExtension::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestScopeExtension::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestScopeExtension::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestScopeExtension::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestLockScreen {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestLockScreen, T>::value>;
  using DataView = ManifestLockScreenDataView;
  using Data_ = internal::ManifestLockScreen_Data;

  template <typename... Args>
  static ManifestLockScreenPtr New(Args&&... args) {
    return ManifestLockScreenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestLockScreenPtr From(const U& u) {
    return mojo::TypeConverter<ManifestLockScreenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestLockScreen>::Convert(*this);
  }


  ManifestLockScreen();

  explicit ManifestLockScreen(
      const ::GURL& start_url);


  ~ManifestLockScreen();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestLockScreenPtr>
  ManifestLockScreenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestLockScreen::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestLockScreen::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestLockScreen::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestLockScreen::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestLockScreen::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestLockScreen::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestLockScreen_UnserializedMessageContext<
            UserType, ManifestLockScreen::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestLockScreen::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestLockScreen::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestLockScreen_UnserializedMessageContext<
            UserType, ManifestLockScreen::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestLockScreen::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL start_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestLockScreen::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestLockScreen::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestLockScreen::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestLockScreen::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestNoteTaking {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestNoteTaking, T>::value>;
  using DataView = ManifestNoteTakingDataView;
  using Data_ = internal::ManifestNoteTaking_Data;

  template <typename... Args>
  static ManifestNoteTakingPtr New(Args&&... args) {
    return ManifestNoteTakingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestNoteTakingPtr From(const U& u) {
    return mojo::TypeConverter<ManifestNoteTakingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestNoteTaking>::Convert(*this);
  }


  ManifestNoteTaking();

  explicit ManifestNoteTaking(
      const ::GURL& new_note_url);


  ~ManifestNoteTaking();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestNoteTakingPtr>
  ManifestNoteTakingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestNoteTaking::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestNoteTaking::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestNoteTaking::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestNoteTaking::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestNoteTaking::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestNoteTaking::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestNoteTaking_UnserializedMessageContext<
            UserType, ManifestNoteTaking::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestNoteTaking::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestNoteTaking::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestNoteTaking_UnserializedMessageContext<
            UserType, ManifestNoteTaking::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestNoteTaking::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL new_note_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestNoteTaking::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestNoteTaking::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestNoteTaking::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestNoteTaking::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestRelatedApplication {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestRelatedApplication, T>::value>;
  using DataView = ManifestRelatedApplicationDataView;
  using Data_ = internal::ManifestRelatedApplication_Data;

  template <typename... Args>
  static ManifestRelatedApplicationPtr New(Args&&... args) {
    return ManifestRelatedApplicationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestRelatedApplicationPtr From(const U& u) {
    return mojo::TypeConverter<ManifestRelatedApplicationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestRelatedApplication>::Convert(*this);
  }


  ManifestRelatedApplication();

  ManifestRelatedApplication(
      const std::optional<::std::u16string>& platform,
      const std::optional<::GURL>& url,
      const std::optional<::std::u16string>& id);


  ~ManifestRelatedApplication();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestRelatedApplicationPtr>
  ManifestRelatedApplicationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestRelatedApplication::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestRelatedApplication::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestRelatedApplication::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestRelatedApplication_UnserializedMessageContext<
            UserType, ManifestRelatedApplication::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestRelatedApplication::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestRelatedApplication::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestRelatedApplication_UnserializedMessageContext<
            UserType, ManifestRelatedApplication::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestRelatedApplication::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::std::u16string> platform;
  
  std::optional<::GURL> url;
  
  std::optional<::std::u16string> id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestRelatedApplication::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestShareTargetParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestShareTargetParams, T>::value>;
  using DataView = ManifestShareTargetParamsDataView;
  using Data_ = internal::ManifestShareTargetParams_Data;

  template <typename... Args>
  static ManifestShareTargetParamsPtr New(Args&&... args) {
    return ManifestShareTargetParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestShareTargetParamsPtr From(const U& u) {
    return mojo::TypeConverter<ManifestShareTargetParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestShareTargetParams>::Convert(*this);
  }


  ManifestShareTargetParams();

  ManifestShareTargetParams(
      const std::optional<::std::u16string>& title,
      const std::optional<::std::u16string>& text,
      const std::optional<::std::u16string>& url,
      std::optional<std::vector<ManifestFileFilterPtr>> files);

ManifestShareTargetParams(const ManifestShareTargetParams&) = delete;
ManifestShareTargetParams& operator=(const ManifestShareTargetParams&) = delete;

  ~ManifestShareTargetParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestShareTargetParamsPtr>
  ManifestShareTargetParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShareTargetParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShareTargetParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestShareTargetParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestShareTargetParams_UnserializedMessageContext<
            UserType, ManifestShareTargetParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestShareTargetParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestShareTargetParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestShareTargetParams_UnserializedMessageContext<
            UserType, ManifestShareTargetParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestShareTargetParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::std::u16string> title;
  
  std::optional<::std::u16string> text;
  
  std::optional<::std::u16string> url;
  
  std::optional<std::vector<ManifestFileFilterPtr>> files;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestShareTargetParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestShareTarget {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestShareTarget, T>::value>;
  using DataView = ManifestShareTargetDataView;
  using Data_ = internal::ManifestShareTarget_Data;
  using Method = ManifestShareTarget_Method;
  using Enctype = ManifestShareTarget_Enctype;

  template <typename... Args>
  static ManifestShareTargetPtr New(Args&&... args) {
    return ManifestShareTargetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestShareTargetPtr From(const U& u) {
    return mojo::TypeConverter<ManifestShareTargetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestShareTarget>::Convert(*this);
  }


  ManifestShareTarget();

  ManifestShareTarget(
      const ::GURL& action,
      ManifestShareTarget::Method method,
      ManifestShareTarget::Enctype enctype,
      ManifestShareTargetParamsPtr params);

ManifestShareTarget(const ManifestShareTarget&) = delete;
ManifestShareTarget& operator=(const ManifestShareTarget&) = delete;

  ~ManifestShareTarget();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestShareTargetPtr>
  ManifestShareTargetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShareTarget::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestShareTarget::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestShareTarget::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestShareTarget_UnserializedMessageContext<
            UserType, ManifestShareTarget::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestShareTarget::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestShareTarget::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestShareTarget_UnserializedMessageContext<
            UserType, ManifestShareTarget::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestShareTarget::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL action;
  
  ManifestShareTarget::Method method;
  
  ManifestShareTarget::Enctype enctype;
  
  ManifestShareTargetParamsPtr params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestShareTarget::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestFileHandler {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestFileHandler, T>::value>;
  using DataView = ManifestFileHandlerDataView;
  using Data_ = internal::ManifestFileHandler_Data;
  using LaunchType = ManifestFileHandler_LaunchType;

  template <typename... Args>
  static ManifestFileHandlerPtr New(Args&&... args) {
    return ManifestFileHandlerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestFileHandlerPtr From(const U& u) {
    return mojo::TypeConverter<ManifestFileHandlerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestFileHandler>::Convert(*this);
  }


  ManifestFileHandler();

  ManifestFileHandler(
      const ::GURL& action,
      const ::std::u16string& name,
      std::vector<::blink::Manifest::ImageResource> icons,
      const base::flat_map<::std::u16string, std::vector<::std::u16string>>& accept,
      ManifestFileHandler::LaunchType launch_type);


  ~ManifestFileHandler();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestFileHandlerPtr>
  ManifestFileHandlerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestFileHandler::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestFileHandler::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestFileHandler::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestFileHandler_UnserializedMessageContext<
            UserType, ManifestFileHandler::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestFileHandler::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestFileHandler::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestFileHandler_UnserializedMessageContext<
            UserType, ManifestFileHandler::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestFileHandler::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL action;
  
  ::std::u16string name;
  
  std::vector<::blink::Manifest::ImageResource> icons;
  
  base::flat_map<::std::u16string, std::vector<::std::u16string>> accept;
  
  ManifestFileHandler::LaunchType launch_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestFileHandler::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestTranslationItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestTranslationItem, T>::value>;
  using DataView = ManifestTranslationItemDataView;
  using Data_ = internal::ManifestTranslationItem_Data;

  template <typename... Args>
  static ManifestTranslationItemPtr New(Args&&... args) {
    return ManifestTranslationItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestTranslationItemPtr From(const U& u) {
    return mojo::TypeConverter<ManifestTranslationItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestTranslationItem>::Convert(*this);
  }


  ManifestTranslationItem();

  ManifestTranslationItem(
      const std::optional<::std::u16string>& name,
      const std::optional<::std::u16string>& short_name,
      const std::optional<::std::u16string>& description);


  ~ManifestTranslationItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestTranslationItemPtr>
  ManifestTranslationItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestTranslationItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestTranslationItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestTranslationItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestTranslationItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestTranslationItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestTranslationItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestTranslationItem_UnserializedMessageContext<
            UserType, ManifestTranslationItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestTranslationItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestTranslationItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestTranslationItem_UnserializedMessageContext<
            UserType, ManifestTranslationItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestTranslationItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::std::u16string> name;
  
  std::optional<::std::u16string> short_name;
  
  std::optional<::std::u16string> description;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestTranslationItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestTranslationItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestTranslationItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestTranslationItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestTabStrip {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestTabStrip, T>::value>;
  using DataView = ManifestTabStripDataView;
  using Data_ = internal::ManifestTabStrip_Data;

  template <typename... Args>
  static ManifestTabStripPtr New(Args&&... args) {
    return ManifestTabStripPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestTabStripPtr From(const U& u) {
    return mojo::TypeConverter<ManifestTabStripPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestTabStrip>::Convert(*this);
  }


  ManifestTabStrip();

  ManifestTabStrip(
      HomeTabUnionPtr home_tab,
      NewTabButtonParamsPtr new_tab_button);

ManifestTabStrip(const ManifestTabStrip&) = delete;
ManifestTabStrip& operator=(const ManifestTabStrip&) = delete;

  ~ManifestTabStrip();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestTabStripPtr>
  ManifestTabStripPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestTabStrip::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestTabStrip::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestTabStrip::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestTabStrip::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestTabStrip::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestTabStrip::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestTabStrip_UnserializedMessageContext<
            UserType, ManifestTabStrip::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestTabStrip::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestTabStrip::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestTabStrip_UnserializedMessageContext<
            UserType, ManifestTabStrip::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestTabStrip::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  HomeTabUnionPtr home_tab;
  
  NewTabButtonParamsPtr new_tab_button;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestTabStrip::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestTabStrip::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestTabStrip::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestTabStrip::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT HomeTabParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HomeTabParams, T>::value>;
  using DataView = HomeTabParamsDataView;
  using Data_ = internal::HomeTabParams_Data;

  template <typename... Args>
  static HomeTabParamsPtr New(Args&&... args) {
    return HomeTabParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HomeTabParamsPtr From(const U& u) {
    return mojo::TypeConverter<HomeTabParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HomeTabParams>::Convert(*this);
  }


  HomeTabParams();

  HomeTabParams(
      std::vector<::blink::Manifest::ImageResource> icons,
      std::vector<::blink::SafeUrlPattern> scope_patterns);


  ~HomeTabParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HomeTabParamsPtr>
  HomeTabParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HomeTabParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HomeTabParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HomeTabParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HomeTabParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HomeTabParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HomeTabParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HomeTabParams_UnserializedMessageContext<
            UserType, HomeTabParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HomeTabParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HomeTabParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HomeTabParams_UnserializedMessageContext<
            UserType, HomeTabParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HomeTabParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::blink::Manifest::ImageResource> icons;
  
  std::vector<::blink::SafeUrlPattern> scope_patterns;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HomeTabParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HomeTabParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HomeTabParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HomeTabParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT NewTabButtonParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NewTabButtonParams, T>::value>;
  using DataView = NewTabButtonParamsDataView;
  using Data_ = internal::NewTabButtonParams_Data;

  template <typename... Args>
  static NewTabButtonParamsPtr New(Args&&... args) {
    return NewTabButtonParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NewTabButtonParamsPtr From(const U& u) {
    return mojo::TypeConverter<NewTabButtonParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NewTabButtonParams>::Convert(*this);
  }


  NewTabButtonParams();

  explicit NewTabButtonParams(
      const std::optional<::GURL>& url);


  ~NewTabButtonParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NewTabButtonParamsPtr>
  NewTabButtonParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NewTabButtonParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NewTabButtonParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NewTabButtonParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NewTabButtonParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NewTabButtonParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NewTabButtonParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NewTabButtonParams_UnserializedMessageContext<
            UserType, NewTabButtonParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NewTabButtonParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NewTabButtonParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NewTabButtonParams_UnserializedMessageContext<
            UserType, NewTabButtonParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NewTabButtonParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::GURL> url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NewTabButtonParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NewTabButtonParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NewTabButtonParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NewTabButtonParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ManifestDebugInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestDebugInfo, T>::value>;
  using DataView = ManifestDebugInfoDataView;
  using Data_ = internal::ManifestDebugInfo_Data;

  template <typename... Args>
  static ManifestDebugInfoPtr New(Args&&... args) {
    return ManifestDebugInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestDebugInfoPtr From(const U& u) {
    return mojo::TypeConverter<ManifestDebugInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestDebugInfo>::Convert(*this);
  }


  ManifestDebugInfo();

  ManifestDebugInfo(
      std::vector<ManifestErrorPtr> errors,
      const std::string& raw_manifest);

ManifestDebugInfo(const ManifestDebugInfo&) = delete;
ManifestDebugInfo& operator=(const ManifestDebugInfo&) = delete;

  ~ManifestDebugInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestDebugInfoPtr>
  ManifestDebugInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestDebugInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestDebugInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestDebugInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestDebugInfo_UnserializedMessageContext<
            UserType, ManifestDebugInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestDebugInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestDebugInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestDebugInfo_UnserializedMessageContext<
            UserType, ManifestDebugInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestDebugInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ManifestErrorPtr> errors;
  
  std::string raw_manifest;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestDebugInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
HomeTabUnionPtr HomeTabUnion::Clone() const {
  switch (tag_) {
    case Tag::kVisibility:
      return NewVisibility(
          mojo::Clone(data_.visibility));
    case Tag::kParams:
      return NewParams(
          mojo::Clone(data_.params));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, HomeTabUnion>::value>::type*>
bool HomeTabUnion::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kVisibility:
      return mojo::Equals(data_.visibility, other.data_.visibility);
    case Tag::kParams:
      return mojo::Equals(data_.params, other.data_.params);
  }

  return false;
}
template <typename StructPtrType>
ManifestPtr Manifest::Clone() const {
  return New(
      mojo::Clone(manifest_url),
      mojo::Clone(dir),
      mojo::Clone(name),
      mojo::Clone(short_name),
      mojo::Clone(description),
      mojo::Clone(id),
      mojo::Clone(has_custom_id),
      mojo::Clone(start_url),
      mojo::Clone(has_valid_specified_start_url),
      mojo::Clone(display),
      mojo::Clone(display_override),
      mojo::Clone(orientation),
      mojo::Clone(icons),
      mojo::Clone(screenshots),
      mojo::Clone(shortcuts),
      mojo::Clone(share_target),
      mojo::Clone(file_handlers),
      mojo::Clone(protocol_handlers),
      mojo::Clone(scope_extensions),
      mojo::Clone(lock_screen),
      mojo::Clone(note_taking),
      mojo::Clone(related_applications),
      mojo::Clone(prefer_related_applications),
      mojo::Clone(has_theme_color),
      mojo::Clone(theme_color),
      mojo::Clone(has_background_color),
      mojo::Clone(background_color),
      mojo::Clone(gcm_sender_id),
      mojo::Clone(scope),
      mojo::Clone(capture_links),
      mojo::Clone(permissions_policy),
      mojo::Clone(launch_handler),
      mojo::Clone(translations),
      mojo::Clone(has_dark_theme_color),
      mojo::Clone(dark_theme_color),
      mojo::Clone(has_dark_background_color),
      mojo::Clone(dark_background_color),
      mojo::Clone(tab_strip),
      mojo::Clone(version),
      mojo::Clone(name_localized),
      mojo::Clone(short_name_localized),
      mojo::Clone(description_localized),
      mojo::Clone(icons_localized)
  );
}

template <typename T, Manifest::EnableIfSame<T>*>
bool Manifest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->manifest_url, other_struct.manifest_url))
    return false;
  if (!mojo::Equals(this->dir, other_struct.dir))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->short_name, other_struct.short_name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->has_custom_id, other_struct.has_custom_id))
    return false;
  if (!mojo::Equals(this->start_url, other_struct.start_url))
    return false;
  if (!mojo::Equals(this->has_valid_specified_start_url, other_struct.has_valid_specified_start_url))
    return false;
  if (!mojo::Equals(this->display, other_struct.display))
    return false;
  if (!mojo::Equals(this->display_override, other_struct.display_override))
    return false;
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->screenshots, other_struct.screenshots))
    return false;
  if (!mojo::Equals(this->shortcuts, other_struct.shortcuts))
    return false;
  if (!mojo::Equals(this->share_target, other_struct.share_target))
    return false;
  if (!mojo::Equals(this->file_handlers, other_struct.file_handlers))
    return false;
  if (!mojo::Equals(this->protocol_handlers, other_struct.protocol_handlers))
    return false;
  if (!mojo::Equals(this->scope_extensions, other_struct.scope_extensions))
    return false;
  if (!mojo::Equals(this->lock_screen, other_struct.lock_screen))
    return false;
  if (!mojo::Equals(this->note_taking, other_struct.note_taking))
    return false;
  if (!mojo::Equals(this->related_applications, other_struct.related_applications))
    return false;
  if (!mojo::Equals(this->prefer_related_applications, other_struct.prefer_related_applications))
    return false;
  if (!mojo::Equals(this->has_theme_color, other_struct.has_theme_color))
    return false;
  if (!mojo::Equals(this->theme_color, other_struct.theme_color))
    return false;
  if (!mojo::Equals(this->has_background_color, other_struct.has_background_color))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->gcm_sender_id, other_struct.gcm_sender_id))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->capture_links, other_struct.capture_links))
    return false;
  if (!mojo::Equals(this->permissions_policy, other_struct.permissions_policy))
    return false;
  if (!mojo::Equals(this->launch_handler, other_struct.launch_handler))
    return false;
  if (!mojo::Equals(this->translations, other_struct.translations))
    return false;
  if (!mojo::Equals(this->has_dark_theme_color, other_struct.has_dark_theme_color))
    return false;
  if (!mojo::Equals(this->dark_theme_color, other_struct.dark_theme_color))
    return false;
  if (!mojo::Equals(this->has_dark_background_color, other_struct.has_dark_background_color))
    return false;
  if (!mojo::Equals(this->dark_background_color, other_struct.dark_background_color))
    return false;
  if (!mojo::Equals(this->tab_strip, other_struct.tab_strip))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->name_localized, other_struct.name_localized))
    return false;
  if (!mojo::Equals(this->short_name_localized, other_struct.short_name_localized))
    return false;
  if (!mojo::Equals(this->description_localized, other_struct.description_localized))
    return false;
  if (!mojo::Equals(this->icons_localized, other_struct.icons_localized))
    return false;
  return true;
}

template <typename T, Manifest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.manifest_url < rhs.manifest_url)
    return true;
  if (rhs.manifest_url < lhs.manifest_url)
    return false;
  if (lhs.dir < rhs.dir)
    return true;
  if (rhs.dir < lhs.dir)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.short_name < rhs.short_name)
    return true;
  if (rhs.short_name < lhs.short_name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.has_custom_id < rhs.has_custom_id)
    return true;
  if (rhs.has_custom_id < lhs.has_custom_id)
    return false;
  if (lhs.start_url < rhs.start_url)
    return true;
  if (rhs.start_url < lhs.start_url)
    return false;
  if (lhs.has_valid_specified_start_url < rhs.has_valid_specified_start_url)
    return true;
  if (rhs.has_valid_specified_start_url < lhs.has_valid_specified_start_url)
    return false;
  if (lhs.display < rhs.display)
    return true;
  if (rhs.display < lhs.display)
    return false;
  if (lhs.display_override < rhs.display_override)
    return true;
  if (rhs.display_override < lhs.display_override)
    return false;
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  if (lhs.screenshots < rhs.screenshots)
    return true;
  if (rhs.screenshots < lhs.screenshots)
    return false;
  if (lhs.shortcuts < rhs.shortcuts)
    return true;
  if (rhs.shortcuts < lhs.shortcuts)
    return false;
  if (lhs.share_target < rhs.share_target)
    return true;
  if (rhs.share_target < lhs.share_target)
    return false;
  if (lhs.file_handlers < rhs.file_handlers)
    return true;
  if (rhs.file_handlers < lhs.file_handlers)
    return false;
  if (lhs.protocol_handlers < rhs.protocol_handlers)
    return true;
  if (rhs.protocol_handlers < lhs.protocol_handlers)
    return false;
  if (lhs.scope_extensions < rhs.scope_extensions)
    return true;
  if (rhs.scope_extensions < lhs.scope_extensions)
    return false;
  if (lhs.lock_screen < rhs.lock_screen)
    return true;
  if (rhs.lock_screen < lhs.lock_screen)
    return false;
  if (lhs.note_taking < rhs.note_taking)
    return true;
  if (rhs.note_taking < lhs.note_taking)
    return false;
  if (lhs.related_applications < rhs.related_applications)
    return true;
  if (rhs.related_applications < lhs.related_applications)
    return false;
  if (lhs.prefer_related_applications < rhs.prefer_related_applications)
    return true;
  if (rhs.prefer_related_applications < lhs.prefer_related_applications)
    return false;
  if (lhs.has_theme_color < rhs.has_theme_color)
    return true;
  if (rhs.has_theme_color < lhs.has_theme_color)
    return false;
  if (lhs.theme_color < rhs.theme_color)
    return true;
  if (rhs.theme_color < lhs.theme_color)
    return false;
  if (lhs.has_background_color < rhs.has_background_color)
    return true;
  if (rhs.has_background_color < lhs.has_background_color)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.gcm_sender_id < rhs.gcm_sender_id)
    return true;
  if (rhs.gcm_sender_id < lhs.gcm_sender_id)
    return false;
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  if (lhs.capture_links < rhs.capture_links)
    return true;
  if (rhs.capture_links < lhs.capture_links)
    return false;
  if (lhs.permissions_policy < rhs.permissions_policy)
    return true;
  if (rhs.permissions_policy < lhs.permissions_policy)
    return false;
  if (lhs.launch_handler < rhs.launch_handler)
    return true;
  if (rhs.launch_handler < lhs.launch_handler)
    return false;
  if (lhs.translations < rhs.translations)
    return true;
  if (rhs.translations < lhs.translations)
    return false;
  if (lhs.has_dark_theme_color < rhs.has_dark_theme_color)
    return true;
  if (rhs.has_dark_theme_color < lhs.has_dark_theme_color)
    return false;
  if (lhs.dark_theme_color < rhs.dark_theme_color)
    return true;
  if (rhs.dark_theme_color < lhs.dark_theme_color)
    return false;
  if (lhs.has_dark_background_color < rhs.has_dark_background_color)
    return true;
  if (rhs.has_dark_background_color < lhs.has_dark_background_color)
    return false;
  if (lhs.dark_background_color < rhs.dark_background_color)
    return true;
  if (rhs.dark_background_color < lhs.dark_background_color)
    return false;
  if (lhs.tab_strip < rhs.tab_strip)
    return true;
  if (rhs.tab_strip < lhs.tab_strip)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.name_localized < rhs.name_localized)
    return true;
  if (rhs.name_localized < lhs.name_localized)
    return false;
  if (lhs.short_name_localized < rhs.short_name_localized)
    return true;
  if (rhs.short_name_localized < lhs.short_name_localized)
    return false;
  if (lhs.description_localized < rhs.description_localized)
    return true;
  if (rhs.description_localized < lhs.description_localized)
    return false;
  if (lhs.icons_localized < rhs.icons_localized)
    return true;
  if (rhs.icons_localized < lhs.icons_localized)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestLocalizedTextObjectPtr ManifestLocalizedTextObject::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(dir),
      mojo::Clone(lang)
  );
}

template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>*>
bool ManifestLocalizedTextObject::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->dir, other_struct.dir))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  return true;
}

template <typename T, ManifestLocalizedTextObject::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.dir < rhs.dir)
    return true;
  if (rhs.dir < lhs.dir)
    return false;
  if (lhs.lang < rhs.lang)
    return true;
  if (rhs.lang < lhs.lang)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestShortcutItemPtr ManifestShortcutItem::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(short_name),
      mojo::Clone(description),
      mojo::Clone(url),
      mojo::Clone(icons),
      mojo::Clone(name_localized),
      mojo::Clone(short_name_localized),
      mojo::Clone(description_localized),
      mojo::Clone(icons_localized)
  );
}

template <typename T, ManifestShortcutItem::EnableIfSame<T>*>
bool ManifestShortcutItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->short_name, other_struct.short_name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->name_localized, other_struct.name_localized))
    return false;
  if (!mojo::Equals(this->short_name_localized, other_struct.short_name_localized))
    return false;
  if (!mojo::Equals(this->description_localized, other_struct.description_localized))
    return false;
  if (!mojo::Equals(this->icons_localized, other_struct.icons_localized))
    return false;
  return true;
}

template <typename T, ManifestShortcutItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.short_name < rhs.short_name)
    return true;
  if (rhs.short_name < lhs.short_name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  if (lhs.name_localized < rhs.name_localized)
    return true;
  if (rhs.name_localized < lhs.name_localized)
    return false;
  if (lhs.short_name_localized < rhs.short_name_localized)
    return true;
  if (rhs.short_name_localized < lhs.short_name_localized)
    return false;
  if (lhs.description_localized < rhs.description_localized)
    return true;
  if (rhs.description_localized < lhs.description_localized)
    return false;
  if (lhs.icons_localized < rhs.icons_localized)
    return true;
  if (rhs.icons_localized < lhs.icons_localized)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestImageResourcePtr ManifestImageResource::Clone() const {
  return New(
      mojo::Clone(src),
      mojo::Clone(type),
      mojo::Clone(sizes),
      mojo::Clone(purpose)
  );
}

template <typename T, ManifestImageResource::EnableIfSame<T>*>
bool ManifestImageResource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->sizes, other_struct.sizes))
    return false;
  if (!mojo::Equals(this->purpose, other_struct.purpose))
    return false;
  return true;
}

template <typename T, ManifestImageResource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.src < rhs.src)
    return true;
  if (rhs.src < lhs.src)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.sizes < rhs.sizes)
    return true;
  if (rhs.sizes < lhs.sizes)
    return false;
  if (lhs.purpose < rhs.purpose)
    return true;
  if (rhs.purpose < lhs.purpose)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestScreenshotPtr ManifestScreenshot::Clone() const {
  return New(
      mojo::Clone(image),
      mojo::Clone(form_factor),
      mojo::Clone(label)
  );
}

template <typename T, ManifestScreenshot::EnableIfSame<T>*>
bool ManifestScreenshot::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image, other_struct.image))
    return false;
  if (!mojo::Equals(this->form_factor, other_struct.form_factor))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, ManifestScreenshot::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image < rhs.image)
    return true;
  if (rhs.image < lhs.image)
    return false;
  if (lhs.form_factor < rhs.form_factor)
    return true;
  if (rhs.form_factor < lhs.form_factor)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestFileFilterPtr ManifestFileFilter::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(accept)
  );
}

template <typename T, ManifestFileFilter::EnableIfSame<T>*>
bool ManifestFileFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->accept, other_struct.accept))
    return false;
  return true;
}

template <typename T, ManifestFileFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.accept < rhs.accept)
    return true;
  if (rhs.accept < lhs.accept)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestProtocolHandlerPtr ManifestProtocolHandler::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(url)
  );
}

template <typename T, ManifestProtocolHandler::EnableIfSame<T>*>
bool ManifestProtocolHandler::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, ManifestProtocolHandler::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.protocol < rhs.protocol)
    return true;
  if (rhs.protocol < lhs.protocol)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestScopeExtensionPtr ManifestScopeExtension::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(has_origin_wildcard)
  );
}

template <typename T, ManifestScopeExtension::EnableIfSame<T>*>
bool ManifestScopeExtension::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->has_origin_wildcard, other_struct.has_origin_wildcard))
    return false;
  return true;
}

template <typename T, ManifestScopeExtension::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.has_origin_wildcard < rhs.has_origin_wildcard)
    return true;
  if (rhs.has_origin_wildcard < lhs.has_origin_wildcard)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestLockScreenPtr ManifestLockScreen::Clone() const {
  return New(
      mojo::Clone(start_url)
  );
}

template <typename T, ManifestLockScreen::EnableIfSame<T>*>
bool ManifestLockScreen::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start_url, other_struct.start_url))
    return false;
  return true;
}

template <typename T, ManifestLockScreen::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.start_url < rhs.start_url)
    return true;
  if (rhs.start_url < lhs.start_url)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestNoteTakingPtr ManifestNoteTaking::Clone() const {
  return New(
      mojo::Clone(new_note_url)
  );
}

template <typename T, ManifestNoteTaking::EnableIfSame<T>*>
bool ManifestNoteTaking::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->new_note_url, other_struct.new_note_url))
    return false;
  return true;
}

template <typename T, ManifestNoteTaking::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.new_note_url < rhs.new_note_url)
    return true;
  if (rhs.new_note_url < lhs.new_note_url)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestRelatedApplicationPtr ManifestRelatedApplication::Clone() const {
  return New(
      mojo::Clone(platform),
      mojo::Clone(url),
      mojo::Clone(id)
  );
}

template <typename T, ManifestRelatedApplication::EnableIfSame<T>*>
bool ManifestRelatedApplication::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->platform, other_struct.platform))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, ManifestRelatedApplication::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.platform < rhs.platform)
    return true;
  if (rhs.platform < lhs.platform)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestShareTargetParamsPtr ManifestShareTargetParams::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(text),
      mojo::Clone(url),
      mojo::Clone(files)
  );
}

template <typename T, ManifestShareTargetParams::EnableIfSame<T>*>
bool ManifestShareTargetParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->files, other_struct.files))
    return false;
  return true;
}

template <typename T, ManifestShareTargetParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.files < rhs.files)
    return true;
  if (rhs.files < lhs.files)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestShareTargetPtr ManifestShareTarget::Clone() const {
  return New(
      mojo::Clone(action),
      mojo::Clone(method),
      mojo::Clone(enctype),
      mojo::Clone(params)
  );
}

template <typename T, ManifestShareTarget::EnableIfSame<T>*>
bool ManifestShareTarget::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->enctype, other_struct.enctype))
    return false;
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  return true;
}

template <typename T, ManifestShareTarget::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.enctype < rhs.enctype)
    return true;
  if (rhs.enctype < lhs.enctype)
    return false;
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestFileHandlerPtr ManifestFileHandler::Clone() const {
  return New(
      mojo::Clone(action),
      mojo::Clone(name),
      mojo::Clone(icons),
      mojo::Clone(accept),
      mojo::Clone(launch_type)
  );
}

template <typename T, ManifestFileHandler::EnableIfSame<T>*>
bool ManifestFileHandler::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->accept, other_struct.accept))
    return false;
  if (!mojo::Equals(this->launch_type, other_struct.launch_type))
    return false;
  return true;
}

template <typename T, ManifestFileHandler::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  if (lhs.accept < rhs.accept)
    return true;
  if (rhs.accept < lhs.accept)
    return false;
  if (lhs.launch_type < rhs.launch_type)
    return true;
  if (rhs.launch_type < lhs.launch_type)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestTranslationItemPtr ManifestTranslationItem::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(short_name),
      mojo::Clone(description)
  );
}

template <typename T, ManifestTranslationItem::EnableIfSame<T>*>
bool ManifestTranslationItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->short_name, other_struct.short_name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  return true;
}

template <typename T, ManifestTranslationItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.short_name < rhs.short_name)
    return true;
  if (rhs.short_name < lhs.short_name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestTabStripPtr ManifestTabStrip::Clone() const {
  return New(
      mojo::Clone(home_tab),
      mojo::Clone(new_tab_button)
  );
}

template <typename T, ManifestTabStrip::EnableIfSame<T>*>
bool ManifestTabStrip::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->home_tab, other_struct.home_tab))
    return false;
  if (!mojo::Equals(this->new_tab_button, other_struct.new_tab_button))
    return false;
  return true;
}

template <typename T, ManifestTabStrip::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.home_tab < rhs.home_tab)
    return true;
  if (rhs.home_tab < lhs.home_tab)
    return false;
  if (lhs.new_tab_button < rhs.new_tab_button)
    return true;
  if (rhs.new_tab_button < lhs.new_tab_button)
    return false;
  return false;
}
template <typename StructPtrType>
HomeTabParamsPtr HomeTabParams::Clone() const {
  return New(
      mojo::Clone(icons),
      mojo::Clone(scope_patterns)
  );
}

template <typename T, HomeTabParams::EnableIfSame<T>*>
bool HomeTabParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->scope_patterns, other_struct.scope_patterns))
    return false;
  return true;
}

template <typename T, HomeTabParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  if (lhs.scope_patterns < rhs.scope_patterns)
    return true;
  if (rhs.scope_patterns < lhs.scope_patterns)
    return false;
  return false;
}
template <typename StructPtrType>
NewTabButtonParamsPtr NewTabButtonParams::Clone() const {
  return New(
      mojo::Clone(url)
  );
}

template <typename T, NewTabButtonParams::EnableIfSame<T>*>
bool NewTabButtonParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, NewTabButtonParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestDebugInfoPtr ManifestDebugInfo::Clone() const {
  return New(
      mojo::Clone(errors),
      mojo::Clone(raw_manifest)
  );
}

template <typename T, ManifestDebugInfo::EnableIfSame<T>*>
bool ManifestDebugInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->errors, other_struct.errors))
    return false;
  if (!mojo::Equals(this->raw_manifest, other_struct.raw_manifest))
    return false;
  return true;
}

template <typename T, ManifestDebugInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.errors < rhs.errors)
    return true;
  if (rhs.errors < lhs.errors)
    return false;
  if (lhs.raw_manifest < rhs.raw_manifest)
    return true;
  if (rhs.raw_manifest < lhs.raw_manifest)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestErrorPtr ManifestError::Clone() const {
  return New(
      mojo::Clone(message),
      mojo::Clone(critical),
      mojo::Clone(line),
      mojo::Clone(column)
  );
}

template <typename T, ManifestError::EnableIfSame<T>*>
bool ManifestError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->critical, other_struct.critical))
    return false;
  if (!mojo::Equals(this->line, other_struct.line))
    return false;
  if (!mojo::Equals(this->column, other_struct.column))
    return false;
  return true;
}

template <typename T, ManifestError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.critical < rhs.critical)
    return true;
  if (rhs.critical < lhs.critical)
    return false;
  if (lhs.line < rhs.line)
    return true;
  if (rhs.line < lhs.line)
    return false;
  if (lhs.column < rhs.column)
    return true;
  if (rhs.column < lhs.column)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::Manifest::DataView,
                                         ::blink::mojom::ManifestPtr> {
  static bool IsNull(const ::blink::mojom::ManifestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::Manifest::manifest_url)& manifest_url(
      const ::blink::mojom::ManifestPtr& input) {
    return input->manifest_url;
  }

  static decltype(::blink::mojom::Manifest::dir) dir(
      const ::blink::mojom::ManifestPtr& input) {
    return input->dir;
  }

  static const decltype(::blink::mojom::Manifest::name)& name(
      const ::blink::mojom::ManifestPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::Manifest::short_name)& short_name(
      const ::blink::mojom::ManifestPtr& input) {
    return input->short_name;
  }

  static const decltype(::blink::mojom::Manifest::description)& description(
      const ::blink::mojom::ManifestPtr& input) {
    return input->description;
  }

  static const decltype(::blink::mojom::Manifest::id)& id(
      const ::blink::mojom::ManifestPtr& input) {
    return input->id;
  }

  static decltype(::blink::mojom::Manifest::has_custom_id) has_custom_id(
      const ::blink::mojom::ManifestPtr& input) {
    return input->has_custom_id;
  }

  static const decltype(::blink::mojom::Manifest::start_url)& start_url(
      const ::blink::mojom::ManifestPtr& input) {
    return input->start_url;
  }

  static decltype(::blink::mojom::Manifest::has_valid_specified_start_url) has_valid_specified_start_url(
      const ::blink::mojom::ManifestPtr& input) {
    return input->has_valid_specified_start_url;
  }

  static decltype(::blink::mojom::Manifest::display) display(
      const ::blink::mojom::ManifestPtr& input) {
    return input->display;
  }

  static const decltype(::blink::mojom::Manifest::display_override)& display_override(
      const ::blink::mojom::ManifestPtr& input) {
    return input->display_override;
  }

  static decltype(::blink::mojom::Manifest::orientation) orientation(
      const ::blink::mojom::ManifestPtr& input) {
    return input->orientation;
  }

  static const decltype(::blink::mojom::Manifest::icons)& icons(
      const ::blink::mojom::ManifestPtr& input) {
    return input->icons;
  }

  static const decltype(::blink::mojom::Manifest::screenshots)& screenshots(
      const ::blink::mojom::ManifestPtr& input) {
    return input->screenshots;
  }

  static const decltype(::blink::mojom::Manifest::shortcuts)& shortcuts(
      const ::blink::mojom::ManifestPtr& input) {
    return input->shortcuts;
  }

  static const decltype(::blink::mojom::Manifest::share_target)& share_target(
      const ::blink::mojom::ManifestPtr& input) {
    return input->share_target;
  }

  static const decltype(::blink::mojom::Manifest::file_handlers)& file_handlers(
      const ::blink::mojom::ManifestPtr& input) {
    return input->file_handlers;
  }

  static const decltype(::blink::mojom::Manifest::protocol_handlers)& protocol_handlers(
      const ::blink::mojom::ManifestPtr& input) {
    return input->protocol_handlers;
  }

  static const decltype(::blink::mojom::Manifest::scope_extensions)& scope_extensions(
      const ::blink::mojom::ManifestPtr& input) {
    return input->scope_extensions;
  }

  static const decltype(::blink::mojom::Manifest::lock_screen)& lock_screen(
      const ::blink::mojom::ManifestPtr& input) {
    return input->lock_screen;
  }

  static const decltype(::blink::mojom::Manifest::note_taking)& note_taking(
      const ::blink::mojom::ManifestPtr& input) {
    return input->note_taking;
  }

  static const decltype(::blink::mojom::Manifest::related_applications)& related_applications(
      const ::blink::mojom::ManifestPtr& input) {
    return input->related_applications;
  }

  static decltype(::blink::mojom::Manifest::prefer_related_applications) prefer_related_applications(
      const ::blink::mojom::ManifestPtr& input) {
    return input->prefer_related_applications;
  }

  static decltype(::blink::mojom::Manifest::has_theme_color) has_theme_color(
      const ::blink::mojom::ManifestPtr& input) {
    return input->has_theme_color;
  }

  static decltype(::blink::mojom::Manifest::theme_color) theme_color(
      const ::blink::mojom::ManifestPtr& input) {
    return input->theme_color;
  }

  static decltype(::blink::mojom::Manifest::has_background_color) has_background_color(
      const ::blink::mojom::ManifestPtr& input) {
    return input->has_background_color;
  }

  static decltype(::blink::mojom::Manifest::background_color) background_color(
      const ::blink::mojom::ManifestPtr& input) {
    return input->background_color;
  }

  static const decltype(::blink::mojom::Manifest::gcm_sender_id)& gcm_sender_id(
      const ::blink::mojom::ManifestPtr& input) {
    return input->gcm_sender_id;
  }

  static const decltype(::blink::mojom::Manifest::scope)& scope(
      const ::blink::mojom::ManifestPtr& input) {
    return input->scope;
  }

  static decltype(::blink::mojom::Manifest::capture_links) capture_links(
      const ::blink::mojom::ManifestPtr& input) {
    return input->capture_links;
  }

  static const decltype(::blink::mojom::Manifest::permissions_policy)& permissions_policy(
      const ::blink::mojom::ManifestPtr& input) {
    return input->permissions_policy;
  }

  static const decltype(::blink::mojom::Manifest::launch_handler)& launch_handler(
      const ::blink::mojom::ManifestPtr& input) {
    return input->launch_handler;
  }

  static const decltype(::blink::mojom::Manifest::translations)& translations(
      const ::blink::mojom::ManifestPtr& input) {
    return input->translations;
  }

  static decltype(::blink::mojom::Manifest::has_dark_theme_color) has_dark_theme_color(
      const ::blink::mojom::ManifestPtr& input) {
    return input->has_dark_theme_color;
  }

  static decltype(::blink::mojom::Manifest::dark_theme_color) dark_theme_color(
      const ::blink::mojom::ManifestPtr& input) {
    return input->dark_theme_color;
  }

  static decltype(::blink::mojom::Manifest::has_dark_background_color) has_dark_background_color(
      const ::blink::mojom::ManifestPtr& input) {
    return input->has_dark_background_color;
  }

  static decltype(::blink::mojom::Manifest::dark_background_color) dark_background_color(
      const ::blink::mojom::ManifestPtr& input) {
    return input->dark_background_color;
  }

  static const decltype(::blink::mojom::Manifest::tab_strip)& tab_strip(
      const ::blink::mojom::ManifestPtr& input) {
    return input->tab_strip;
  }

  static const decltype(::blink::mojom::Manifest::version)& version(
      const ::blink::mojom::ManifestPtr& input) {
    return input->version;
  }

  static const decltype(::blink::mojom::Manifest::name_localized)& name_localized(
      const ::blink::mojom::ManifestPtr& input) {
    return input->name_localized;
  }

  static const decltype(::blink::mojom::Manifest::short_name_localized)& short_name_localized(
      const ::blink::mojom::ManifestPtr& input) {
    return input->short_name_localized;
  }

  static const decltype(::blink::mojom::Manifest::description_localized)& description_localized(
      const ::blink::mojom::ManifestPtr& input) {
    return input->description_localized;
  }

  static const decltype(::blink::mojom::Manifest::icons_localized)& icons_localized(
      const ::blink::mojom::ManifestPtr& input) {
    return input->icons_localized;
  }

  static bool Read(::blink::mojom::Manifest::DataView input, ::blink::mojom::ManifestPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestLocalizedTextObject::DataView,
                                         ::blink::mojom::ManifestLocalizedTextObjectPtr> {
  static bool IsNull(const ::blink::mojom::ManifestLocalizedTextObjectPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestLocalizedTextObjectPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestLocalizedTextObject::value)& value(
      const ::blink::mojom::ManifestLocalizedTextObjectPtr& input) {
    return input->value;
  }

  static decltype(::blink::mojom::ManifestLocalizedTextObject::dir) dir(
      const ::blink::mojom::ManifestLocalizedTextObjectPtr& input) {
    return input->dir;
  }

  static const decltype(::blink::mojom::ManifestLocalizedTextObject::lang)& lang(
      const ::blink::mojom::ManifestLocalizedTextObjectPtr& input) {
    return input->lang;
  }

  static bool Read(::blink::mojom::ManifestLocalizedTextObject::DataView input, ::blink::mojom::ManifestLocalizedTextObjectPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestShortcutItem::DataView,
                                         ::blink::mojom::ManifestShortcutItemPtr> {
  static bool IsNull(const ::blink::mojom::ManifestShortcutItemPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestShortcutItemPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestShortcutItem::name)& name(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::ManifestShortcutItem::short_name)& short_name(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->short_name;
  }

  static const decltype(::blink::mojom::ManifestShortcutItem::description)& description(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->description;
  }

  static const decltype(::blink::mojom::ManifestShortcutItem::url)& url(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::ManifestShortcutItem::icons)& icons(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->icons;
  }

  static const decltype(::blink::mojom::ManifestShortcutItem::name_localized)& name_localized(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->name_localized;
  }

  static const decltype(::blink::mojom::ManifestShortcutItem::short_name_localized)& short_name_localized(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->short_name_localized;
  }

  static const decltype(::blink::mojom::ManifestShortcutItem::description_localized)& description_localized(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->description_localized;
  }

  static const decltype(::blink::mojom::ManifestShortcutItem::icons_localized)& icons_localized(
      const ::blink::mojom::ManifestShortcutItemPtr& input) {
    return input->icons_localized;
  }

  static bool Read(::blink::mojom::ManifestShortcutItem::DataView input, ::blink::mojom::ManifestShortcutItemPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestImageResource::DataView,
                                         ::blink::mojom::ManifestImageResourcePtr> {
  static bool IsNull(const ::blink::mojom::ManifestImageResourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestImageResourcePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestImageResource::src)& src(
      const ::blink::mojom::ManifestImageResourcePtr& input) {
    return input->src;
  }

  static const decltype(::blink::mojom::ManifestImageResource::type)& type(
      const ::blink::mojom::ManifestImageResourcePtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::ManifestImageResource::sizes)& sizes(
      const ::blink::mojom::ManifestImageResourcePtr& input) {
    return input->sizes;
  }

  static const decltype(::blink::mojom::ManifestImageResource::purpose)& purpose(
      const ::blink::mojom::ManifestImageResourcePtr& input) {
    return input->purpose;
  }

  static bool Read(::blink::mojom::ManifestImageResource::DataView input, ::blink::mojom::ManifestImageResourcePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestScreenshot::DataView,
                                         ::blink::mojom::ManifestScreenshotPtr> {
  static bool IsNull(const ::blink::mojom::ManifestScreenshotPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestScreenshotPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestScreenshot::image)& image(
      const ::blink::mojom::ManifestScreenshotPtr& input) {
    return input->image;
  }

  static decltype(::blink::mojom::ManifestScreenshot::form_factor) form_factor(
      const ::blink::mojom::ManifestScreenshotPtr& input) {
    return input->form_factor;
  }

  static const decltype(::blink::mojom::ManifestScreenshot::label)& label(
      const ::blink::mojom::ManifestScreenshotPtr& input) {
    return input->label;
  }

  static bool Read(::blink::mojom::ManifestScreenshot::DataView input, ::blink::mojom::ManifestScreenshotPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestFileFilter::DataView,
                                         ::blink::mojom::ManifestFileFilterPtr> {
  static bool IsNull(const ::blink::mojom::ManifestFileFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestFileFilterPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestFileFilter::name)& name(
      const ::blink::mojom::ManifestFileFilterPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::ManifestFileFilter::accept)& accept(
      const ::blink::mojom::ManifestFileFilterPtr& input) {
    return input->accept;
  }

  static bool Read(::blink::mojom::ManifestFileFilter::DataView input, ::blink::mojom::ManifestFileFilterPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestProtocolHandler::DataView,
                                         ::blink::mojom::ManifestProtocolHandlerPtr> {
  static bool IsNull(const ::blink::mojom::ManifestProtocolHandlerPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestProtocolHandlerPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestProtocolHandler::protocol)& protocol(
      const ::blink::mojom::ManifestProtocolHandlerPtr& input) {
    return input->protocol;
  }

  static const decltype(::blink::mojom::ManifestProtocolHandler::url)& url(
      const ::blink::mojom::ManifestProtocolHandlerPtr& input) {
    return input->url;
  }

  static bool Read(::blink::mojom::ManifestProtocolHandler::DataView input, ::blink::mojom::ManifestProtocolHandlerPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestScopeExtension::DataView,
                                         ::blink::mojom::ManifestScopeExtensionPtr> {
  static bool IsNull(const ::blink::mojom::ManifestScopeExtensionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestScopeExtensionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestScopeExtension::origin)& origin(
      const ::blink::mojom::ManifestScopeExtensionPtr& input) {
    return input->origin;
  }

  static decltype(::blink::mojom::ManifestScopeExtension::has_origin_wildcard) has_origin_wildcard(
      const ::blink::mojom::ManifestScopeExtensionPtr& input) {
    return input->has_origin_wildcard;
  }

  static bool Read(::blink::mojom::ManifestScopeExtension::DataView input, ::blink::mojom::ManifestScopeExtensionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestLockScreen::DataView,
                                         ::blink::mojom::ManifestLockScreenPtr> {
  static bool IsNull(const ::blink::mojom::ManifestLockScreenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestLockScreenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestLockScreen::start_url)& start_url(
      const ::blink::mojom::ManifestLockScreenPtr& input) {
    return input->start_url;
  }

  static bool Read(::blink::mojom::ManifestLockScreen::DataView input, ::blink::mojom::ManifestLockScreenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestNoteTaking::DataView,
                                         ::blink::mojom::ManifestNoteTakingPtr> {
  static bool IsNull(const ::blink::mojom::ManifestNoteTakingPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestNoteTakingPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestNoteTaking::new_note_url)& new_note_url(
      const ::blink::mojom::ManifestNoteTakingPtr& input) {
    return input->new_note_url;
  }

  static bool Read(::blink::mojom::ManifestNoteTaking::DataView input, ::blink::mojom::ManifestNoteTakingPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestRelatedApplication::DataView,
                                         ::blink::mojom::ManifestRelatedApplicationPtr> {
  static bool IsNull(const ::blink::mojom::ManifestRelatedApplicationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestRelatedApplicationPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestRelatedApplication::platform)& platform(
      const ::blink::mojom::ManifestRelatedApplicationPtr& input) {
    return input->platform;
  }

  static const decltype(::blink::mojom::ManifestRelatedApplication::url)& url(
      const ::blink::mojom::ManifestRelatedApplicationPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::ManifestRelatedApplication::id)& id(
      const ::blink::mojom::ManifestRelatedApplicationPtr& input) {
    return input->id;
  }

  static bool Read(::blink::mojom::ManifestRelatedApplication::DataView input, ::blink::mojom::ManifestRelatedApplicationPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestShareTargetParams::DataView,
                                         ::blink::mojom::ManifestShareTargetParamsPtr> {
  static bool IsNull(const ::blink::mojom::ManifestShareTargetParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestShareTargetParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestShareTargetParams::title)& title(
      const ::blink::mojom::ManifestShareTargetParamsPtr& input) {
    return input->title;
  }

  static const decltype(::blink::mojom::ManifestShareTargetParams::text)& text(
      const ::blink::mojom::ManifestShareTargetParamsPtr& input) {
    return input->text;
  }

  static const decltype(::blink::mojom::ManifestShareTargetParams::url)& url(
      const ::blink::mojom::ManifestShareTargetParamsPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::ManifestShareTargetParams::files)& files(
      const ::blink::mojom::ManifestShareTargetParamsPtr& input) {
    return input->files;
  }

  static bool Read(::blink::mojom::ManifestShareTargetParams::DataView input, ::blink::mojom::ManifestShareTargetParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestShareTarget::DataView,
                                         ::blink::mojom::ManifestShareTargetPtr> {
  static bool IsNull(const ::blink::mojom::ManifestShareTargetPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestShareTargetPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestShareTarget::action)& action(
      const ::blink::mojom::ManifestShareTargetPtr& input) {
    return input->action;
  }

  static decltype(::blink::mojom::ManifestShareTarget::method) method(
      const ::blink::mojom::ManifestShareTargetPtr& input) {
    return input->method;
  }

  static decltype(::blink::mojom::ManifestShareTarget::enctype) enctype(
      const ::blink::mojom::ManifestShareTargetPtr& input) {
    return input->enctype;
  }

  static const decltype(::blink::mojom::ManifestShareTarget::params)& params(
      const ::blink::mojom::ManifestShareTargetPtr& input) {
    return input->params;
  }

  static bool Read(::blink::mojom::ManifestShareTarget::DataView input, ::blink::mojom::ManifestShareTargetPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestFileHandler::DataView,
                                         ::blink::mojom::ManifestFileHandlerPtr> {
  static bool IsNull(const ::blink::mojom::ManifestFileHandlerPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestFileHandlerPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestFileHandler::action)& action(
      const ::blink::mojom::ManifestFileHandlerPtr& input) {
    return input->action;
  }

  static const decltype(::blink::mojom::ManifestFileHandler::name)& name(
      const ::blink::mojom::ManifestFileHandlerPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::ManifestFileHandler::icons)& icons(
      const ::blink::mojom::ManifestFileHandlerPtr& input) {
    return input->icons;
  }

  static const decltype(::blink::mojom::ManifestFileHandler::accept)& accept(
      const ::blink::mojom::ManifestFileHandlerPtr& input) {
    return input->accept;
  }

  static decltype(::blink::mojom::ManifestFileHandler::launch_type) launch_type(
      const ::blink::mojom::ManifestFileHandlerPtr& input) {
    return input->launch_type;
  }

  static bool Read(::blink::mojom::ManifestFileHandler::DataView input, ::blink::mojom::ManifestFileHandlerPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestTranslationItem::DataView,
                                         ::blink::mojom::ManifestTranslationItemPtr> {
  static bool IsNull(const ::blink::mojom::ManifestTranslationItemPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestTranslationItemPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestTranslationItem::name)& name(
      const ::blink::mojom::ManifestTranslationItemPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::ManifestTranslationItem::short_name)& short_name(
      const ::blink::mojom::ManifestTranslationItemPtr& input) {
    return input->short_name;
  }

  static const decltype(::blink::mojom::ManifestTranslationItem::description)& description(
      const ::blink::mojom::ManifestTranslationItemPtr& input) {
    return input->description;
  }

  static bool Read(::blink::mojom::ManifestTranslationItem::DataView input, ::blink::mojom::ManifestTranslationItemPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestTabStrip::DataView,
                                         ::blink::mojom::ManifestTabStripPtr> {
  static bool IsNull(const ::blink::mojom::ManifestTabStripPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestTabStripPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestTabStrip::home_tab)& home_tab(
      const ::blink::mojom::ManifestTabStripPtr& input) {
    return input->home_tab;
  }

  static const decltype(::blink::mojom::ManifestTabStrip::new_tab_button)& new_tab_button(
      const ::blink::mojom::ManifestTabStripPtr& input) {
    return input->new_tab_button;
  }

  static bool Read(::blink::mojom::ManifestTabStrip::DataView input, ::blink::mojom::ManifestTabStripPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::HomeTabParams::DataView,
                                         ::blink::mojom::HomeTabParamsPtr> {
  static bool IsNull(const ::blink::mojom::HomeTabParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::HomeTabParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::HomeTabParams::icons)& icons(
      const ::blink::mojom::HomeTabParamsPtr& input) {
    return input->icons;
  }

  static const decltype(::blink::mojom::HomeTabParams::scope_patterns)& scope_patterns(
      const ::blink::mojom::HomeTabParamsPtr& input) {
    return input->scope_patterns;
  }

  static bool Read(::blink::mojom::HomeTabParams::DataView input, ::blink::mojom::HomeTabParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::NewTabButtonParams::DataView,
                                         ::blink::mojom::NewTabButtonParamsPtr> {
  static bool IsNull(const ::blink::mojom::NewTabButtonParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::NewTabButtonParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::NewTabButtonParams::url)& url(
      const ::blink::mojom::NewTabButtonParamsPtr& input) {
    return input->url;
  }

  static bool Read(::blink::mojom::NewTabButtonParams::DataView input, ::blink::mojom::NewTabButtonParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestDebugInfo::DataView,
                                         ::blink::mojom::ManifestDebugInfoPtr> {
  static bool IsNull(const ::blink::mojom::ManifestDebugInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestDebugInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestDebugInfo::errors)& errors(
      const ::blink::mojom::ManifestDebugInfoPtr& input) {
    return input->errors;
  }

  static const decltype(::blink::mojom::ManifestDebugInfo::raw_manifest)& raw_manifest(
      const ::blink::mojom::ManifestDebugInfoPtr& input) {
    return input->raw_manifest;
  }

  static bool Read(::blink::mojom::ManifestDebugInfo::DataView input, ::blink::mojom::ManifestDebugInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ManifestError::DataView,
                                         ::blink::mojom::ManifestErrorPtr> {
  static bool IsNull(const ::blink::mojom::ManifestErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ManifestErrorPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ManifestError::message)& message(
      const ::blink::mojom::ManifestErrorPtr& input) {
    return input->message;
  }

  static decltype(::blink::mojom::ManifestError::critical) critical(
      const ::blink::mojom::ManifestErrorPtr& input) {
    return input->critical;
  }

  static decltype(::blink::mojom::ManifestError::line) line(
      const ::blink::mojom::ManifestErrorPtr& input) {
    return input->line;
  }

  static decltype(::blink::mojom::ManifestError::column) column(
      const ::blink::mojom::ManifestErrorPtr& input) {
    return input->column;
  }

  static bool Read(::blink::mojom::ManifestError::DataView input, ::blink::mojom::ManifestErrorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::HomeTabUnion::DataView,
                                        ::blink::mojom::HomeTabUnionPtr> {
  static bool IsNull(const ::blink::mojom::HomeTabUnionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::HomeTabUnionPtr* output) { output->reset(); }

  static ::blink::mojom::HomeTabUnion::Tag GetTag(const ::blink::mojom::HomeTabUnionPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::TabStripMemberVisibility visibility(const ::blink::mojom::HomeTabUnionPtr& input) {
    return input->get_visibility();
  }

  static const ::blink::mojom::HomeTabParamsPtr& params(const ::blink::mojom::HomeTabUnionPtr& input) {
    return input->get_params();
  }

  static bool Read(::blink::mojom::HomeTabUnion::DataView input, ::blink::mojom::HomeTabUnionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_H_