// third_party/blink/public/mojom/sms/webotp_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* SmsStatusToStringHelper(SmsStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SmsStatus::kSuccess:
      return "kSuccess";
    case SmsStatus::kUnhandledRequest:
      return "kUnhandledRequest";
    case SmsStatus::kCancelled:
      return "kCancelled";
    case SmsStatus::kAborted:
      return "kAborted";
    case SmsStatus::kTimeout:
      return "kTimeout";
    case SmsStatus::kBackendNotAvailable:
      return "kBackendNotAvailable";
    default:
      return nullptr;
  }
}

std::string SmsStatusToString(SmsStatus value) {
  const char *str = SmsStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SmsStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SmsStatus value) {
  return os << SmsStatusToString(value);
}

namespace internal {


// static
bool WebOTPService_Receive_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebOTPService_Receive_Params_Data* object =
      static_cast<const WebOTPService_Receive_Params_Data*>(data);

  return true;
}

WebOTPService_Receive_Params_Data::WebOTPService_Receive_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebOTPService_Receive_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebOTPService_Receive_ResponseParams_Data* object =
      static_cast<const WebOTPService_Receive_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::SmsStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& otp_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->otp, validation_context,
                                         &otp_validate_params)) {
    return false;
  }

  return true;
}

WebOTPService_Receive_ResponseParams_Data::WebOTPService_Receive_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebOTPService_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebOTPService_Abort_Params_Data* object =
      static_cast<const WebOTPService_Abort_Params_Data*>(data);

  return true;
}

WebOTPService_Abort_Params_Data::WebOTPService_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SmsStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SmsStatus value) {
  return std::move(context).WriteString(::blink::mojom::SmsStatusToString(value));
}

} // namespace perfetto