// ui/accessibility/mojom/ax_action_data.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_DATA_VIEW_H_
#define UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/accessibility/mojom/ax_action_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace ax::mojom {
class AXActionDataDataView;



}  // ax::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXActionDataDataView> {
  using Data = ::ax::mojom::internal::AXActionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXActionDataDataView {
 public:
  AXActionDataDataView() = default;

  AXActionDataDataView(
      internal::AXActionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::ax::mojom::Action>(
        data_value, output);
  }
  ::ax::mojom::Action action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Action>(data_->action));
  }
  inline void GetTargetTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetTreeId(UserType* output) {
    
    auto* pointer = !data_->target_tree_id.is_null() ? &data_->target_tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, message_);
  }
  inline void GetSourceExtensionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceExtensionId(UserType* output) {
    
    auto* pointer = data_->source_extension_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t target_node_id() const {
    return data_->target_node_id;
  }
  int32_t request_id() const {
    return data_->request_id;
  }
  int32_t flags() const {
    return data_->flags;
  }
  int32_t anchor_node_id() const {
    return data_->anchor_node_id;
  }
  int32_t anchor_offset() const {
    return data_->anchor_offset;
  }
  int32_t focus_node_id() const {
    return data_->focus_node_id;
  }
  int32_t focus_offset() const {
    return data_->focus_offset;
  }
  int32_t custom_action_id() const {
    return data_->custom_action_id;
  }
  inline void GetTargetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetRect(UserType* output) {
    
    auto* pointer = data_->target_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetTargetPointDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetPoint(UserType* output) {
    
    auto* pointer = data_->target_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHitTestEventToFire(UserType* output) const {
    auto data_value = data_->hit_test_event_to_fire;
    return mojo::internal::Deserialize<::ax::mojom::Event>(
        data_value, output);
  }
  ::ax::mojom::Event hit_test_event_to_fire() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Event>(data_->hit_test_event_to_fire));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHorizontalScrollAlignment(UserType* output) const {
    auto data_value = data_->horizontal_scroll_alignment;
    return mojo::internal::Deserialize<::ax::mojom::ScrollAlignment>(
        data_value, output);
  }
  ::ax::mojom::ScrollAlignment horizontal_scroll_alignment() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::ScrollAlignment>(data_->horizontal_scroll_alignment));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVerticalScrollAlignment(UserType* output) const {
    auto data_value = data_->vertical_scroll_alignment;
    return mojo::internal::Deserialize<::ax::mojom::ScrollAlignment>(
        data_value, output);
  }
  ::ax::mojom::ScrollAlignment vertical_scroll_alignment() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::ScrollAlignment>(data_->vertical_scroll_alignment));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScrollBehavior(UserType* output) const {
    auto data_value = data_->scroll_behavior;
    return mojo::internal::Deserialize<::ax::mojom::ScrollBehavior>(
        data_value, output);
  }
  ::ax::mojom::ScrollBehavior scroll_behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::ScrollBehavior>(data_->scroll_behavior));
  }
  inline void GetChildTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildTreeId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ax::mojom::AXTreeIDDataView, UserType>(),
    "Attempting to read the optional `child_tree_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadChildTreeId` instead "
    "of `ReadChildTreeId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1 && !data_->child_tree_id.is_null()
                    ? &data_->child_tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetRole(UserType* output) const {
    auto data_value = data_->header_.version >= 2
                      ? data_->target_role : 0;
    return mojo::internal::Deserialize<::ax::mojom::Role>(
        data_value, output);
  }
  ::ax::mojom::Role target_role() const {
    if (data_->header_.version < 2)
      return ::ax::mojom::Role{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Role>(data_->target_role));
  }
 private:
  internal::AXActionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

#endif  // UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_DATA_VIEW_H_