// ui/display/mojom/screen_infos.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/screen_infos.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/screen_infos.mojom-params-data.h"
#include "ui/display/mojom/screen_infos.mojom-shared-message-ids.h"

#include "ui/display/mojom/screen_infos.mojom-import-headers.h"
#include "ui/display/mojom/screen_infos.mojom-test-utils.h"


namespace display::mojom {
ScreenInfos::ScreenInfos()
    : screen_infos(),
      current_display_id(),
      system_cursor_size() {}

ScreenInfos::ScreenInfos(
    std::vector<::display::ScreenInfo> screen_infos_in,
    int64_t current_display_id_in,
    const ::gfx::Size& system_cursor_size_in)
    : screen_infos(std::move(screen_infos_in)),
      current_display_id(std::move(current_display_id_in)),
      system_cursor_size(std::move(system_cursor_size_in)) {}

ScreenInfos::~ScreenInfos() = default;

void ScreenInfos::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screen_infos"), this->screen_infos,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::display::ScreenInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_display_id"), this->current_display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "system_cursor_size"), this->system_cursor_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScreenInfos::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // display::mojom


namespace mojo {


// static
bool StructTraits<::display::mojom::ScreenInfos::DataView, ::display::mojom::ScreenInfosPtr>::Read(
    ::display::mojom::ScreenInfos::DataView input,
    ::display::mojom::ScreenInfosPtr* output) {
  bool success = true;
  ::display::mojom::ScreenInfosPtr result(::display::mojom::ScreenInfos::New());
  
      if (success && !input.ReadScreenInfos(&result->screen_infos))
        success = false;
      if (success)
        result->current_display_id = input.current_display_id();
      if (success && !input.ReadSystemCursorSize(&result->system_cursor_size))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace display::mojom {




}  // display::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif