// ui/gfx/mojom/swap_timings.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/swap_timings.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"




#include "ui/gfx/mojom/swap_timings.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::SwapTimingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::SwapTimingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::SwapTimings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::swap_start(input)) in_swap_start = Traits::swap_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->swap_start)::BaseType> swap_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_swap_start,
      swap_start_fragment);

    fragment->swap_start.Set(
        swap_start_fragment.is_null() ? nullptr : swap_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->swap_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null swap_start in SwapTimings struct");

    decltype(Traits::swap_end(input)) in_swap_end = Traits::swap_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->swap_end)::BaseType> swap_end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_swap_end,
      swap_end_fragment);

    fragment->swap_end.Set(
        swap_end_fragment.is_null() ? nullptr : swap_end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->swap_end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null swap_end in SwapTimings struct");
  }

  static bool Deserialize(::gfx::mojom::internal::SwapTimings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::SwapTimingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void SwapTimingsDataView::GetSwapStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->swap_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void SwapTimingsDataView::GetSwapEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->swap_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_SHARED_H_