// ui/gl/mojom/gl_implementation.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_H_
#define UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gl/mojom/gl_implementation.mojom-features.h"  // IWYU pragma: export
#include "ui/gl/mojom/gl_implementation.mojom-shared.h"  // IWYU pragma: export
#include "ui/gl/mojom/gl_implementation.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "ui/gl/mojom/gl_implementation_mojom_traits.h"
#include "ui/gl/mojom/gpu_preference_mojom_traits.h"
#include "base/component_export.h"




namespace gl::mojom {





class COMPONENT_EXPORT(GL_MOJOM) GLImplementationParts {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GLImplementationParts, T>::value>;
  using DataView = GLImplementationPartsDataView;
  using Data_ = internal::GLImplementationParts_Data;

  template <typename... Args>
  static GLImplementationPartsPtr New(Args&&... args) {
    return GLImplementationPartsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GLImplementationPartsPtr From(const U& u) {
    return mojo::TypeConverter<GLImplementationPartsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GLImplementationParts>::Convert(*this);
  }


  GLImplementationParts();

  GLImplementationParts(
      ::gl::GLImplementation gl,
      ANGLEImplementation angle);


  ~GLImplementationParts();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GLImplementationPartsPtr>
  GLImplementationPartsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GLImplementationParts::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GLImplementationParts::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GLImplementationParts::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GLImplementationParts::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GLImplementationParts::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GLImplementationParts::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GLImplementationParts_UnserializedMessageContext<
            UserType, GLImplementationParts::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GLImplementationParts::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GLImplementationParts::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GLImplementationParts_UnserializedMessageContext<
            UserType, GLImplementationParts::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GLImplementationParts::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gl::GLImplementation gl;
  
  ANGLEImplementation angle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GLImplementationParts::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GLImplementationParts::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GLImplementationParts::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GLImplementationParts::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
GLImplementationPartsPtr GLImplementationParts::Clone() const {
  return New(
      mojo::Clone(gl),
      mojo::Clone(angle)
  );
}

template <typename T, GLImplementationParts::EnableIfSame<T>*>
bool GLImplementationParts::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gl, other_struct.gl))
    return false;
  if (!mojo::Equals(this->angle, other_struct.angle))
    return false;
  return true;
}

template <typename T, GLImplementationParts::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gl < rhs.gl)
    return true;
  if (rhs.gl < lhs.gl)
    return false;
  if (lhs.angle < rhs.angle)
    return true;
  if (rhs.angle < lhs.angle)
    return false;
  return false;
}


}  // gl::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(GL_MOJOM) StructTraits<::gl::mojom::GLImplementationParts::DataView,
                                         ::gl::mojom::GLImplementationPartsPtr> {
  static bool IsNull(const ::gl::mojom::GLImplementationPartsPtr& input) { return !input; }
  static void SetToNull(::gl::mojom::GLImplementationPartsPtr* output) { output->reset(); }

  static decltype(::gl::mojom::GLImplementationParts::gl) gl(
      const ::gl::mojom::GLImplementationPartsPtr& input) {
    return input->gl;
  }

  static decltype(::gl::mojom::GLImplementationParts::angle) angle(
      const ::gl::mojom::GLImplementationPartsPtr& input) {
    return input->angle;
  }

  static bool Read(::gl::mojom::GLImplementationParts::DataView input, ::gl::mojom::GLImplementationPartsPtr* output);
};

}  // namespace mojo

#endif  // UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_H_