const char *spheres_fs =
  "varying vec2 v_texCoord;\n"
  "varying vec4 eyePosition;\n"
  "varying vec3 fColor;\n"
  "uniform mat3 normal;\n"
  "varying float radius;\n"
  "\n"
  "uniform float opacity;\n"
  "uniform mat4 projection;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  // Figure out if we are inside our sphere.\n"
  "  float zz = 1.0 - v_texCoord.x*v_texCoord.x - v_texCoord.y*v_texCoord.y;\n"
  "  if (zz <= 0.0)\n"
  "    discard;\n"
  "\n"
  "  vec3 N = vec3(v_texCoord, sqrt(zz));\n"
  "  vec3 L = normalize(vec3(0, 1, 1));\n"
  "  vec3 E = vec3(0, 0, 1);\n"
  "  vec3 H = normalize(L + E);\n"
  "  float df = max(0.0, dot(N, L)); // cos_alpha\n"
  "  float sf = max(0.0, dot(N, H)); // cos_beta\n"
  "  vec3 ambient = 0.4 * fColor;\n"
  "  vec3 diffuse = 0.55 * fColor;\n"
  "  vec3 specular = 0.5 * (vec3(1, 1, 1) - fColor);\n"
  "  vec3 color = ambient + df * diffuse + pow(sf, 20.0) * specular;\n"
  "  gl_FragColor = vec4(color, opacity);\n"
  "\n"
  "  // determine fragment depth\n"
  "  vec4 pos = eyePosition;\n"
  "  pos.z += N.z * radius;//The radius is 1.0\n"
  "  pos = projection * pos;\n"
  "  gl_FragDepth = (pos.z / pos.w + 1.0) / 2.0;\n"
  "}\n"
  "\n";
