/* baobab-application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from baobab-application.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include "config.h"
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BAOBAB_APPLICATION_0_PROPERTY,
	BAOBAB_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* baobab_application_properties[BAOBAB_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BaobabApplicationPrivate {
	BaobabWindow* window;
};

static gint BaobabApplication_private_offset;
static gpointer baobab_application_parent_class = NULL;
static gboolean baobab_application_all_file_systems;
static gboolean baobab_application_all_file_systems = FALSE;

static void baobab_application_on_quit_activate (BaobabApplication* self);
static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void baobab_application_real_activate (GApplication* base);
static void baobab_application_ensure_window (BaobabApplication* self);
static void baobab_application_real_open (GApplication* base,
                                   GFile** files,
                                   gint files_length1,
                                   const gchar* hint);
static void _g_free0_ (gpointer var);
static void baobab_application_real_startup (GApplication* base);
static gint baobab_application_real_handle_local_options (GApplication* base,
                                                   GVariantDict* options);
static void baobab_application_finalize (GObject * obj);
static GType baobab_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry BAOBAB_APPLICATION_option_entries[3] = {{"all-file-systems", 'a', (gint) 0, G_OPTION_ARG_NONE, &baobab_application_all_file_systems, N_ ("Do not skip directories on different file systems. Ignored if DIRECTOR" \
"Y is not specified."), NULL}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Print version information and exit"), NULL}, {NULL}};
static const GActionEntry BAOBAB_APPLICATION_action_entries[1] = {{"quit", _baobab_application_on_quit_activate_gsimple_action_activate_callback}};

static inline gpointer
baobab_application_get_instance_private (BaobabApplication* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabApplication_private_offset);
}

static void
_baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	baobab_application_on_quit_activate ((BaobabApplication*) self);
}

static void
baobab_application_real_activate (GApplication* base)
{
	BaobabApplication * self;
	BaobabWindow* _tmp0_;
	self = (BaobabApplication*) base;
	baobab_application_ensure_window (self);
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}

static void
baobab_application_real_open (GApplication* base,
                              GFile** files,
                              gint files_length1,
                              const gchar* hint)
{
	BaobabApplication * self;
	BaobabScanFlags _tmp0_ = 0U;
	BaobabScanFlags scan_flags = 0U;
	BaobabWindow* _tmp1_;
	GFile* _tmp2_;
	self = (BaobabApplication*) base;
	g_return_if_fail (hint != NULL);
	baobab_application_ensure_window (self);
	if (baobab_application_all_file_systems) {
		_tmp0_ = BAOBAB_SCAN_FLAGS_NONE;
	} else {
		_tmp0_ = BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS;
	}
	scan_flags = _tmp0_;
	_tmp1_ = self->priv->window;
	_tmp2_ = files[0];
	baobab_window_scan_directory (_tmp1_, _tmp2_, scan_flags);
}

static void
baobab_application_ensure_window (BaobabApplication* self)
{
	BaobabWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		BaobabWindow* _tmp1_;
		_tmp1_ = baobab_window_new (self);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->window);
		self->priv->window = _tmp1_;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BaobabApplication*
baobab_application_get_default (void)
{
	GApplication* _tmp0_;
	BaobabApplication* _tmp1_;
	BaobabApplication* result;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BAOBAB_TYPE_APPLICATION, BaobabApplication));
	result = _tmp1_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

GHashTable*
baobab_application_get_excluded_locations (BaobabApplication* self)
{
	GHashTable* excluded_locations = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSettings* prefs_settings = NULL;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	excluded_locations = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.baobab.preferences");
	prefs_settings = _tmp3_;
	_tmp4_ = prefs_settings;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "excluded-uris");
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp6_;
		uri_collection_length1 = _vala_array_length (_tmp5_);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp7_;
			gchar* uri = NULL;
			_tmp7_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp7_;
			{
				GHashTable* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = excluded_locations;
				_tmp9_ = uri;
				_tmp10_ = g_strdup (_tmp9_);
				g_hash_table_add (_tmp8_, _tmp10_);
				_g_free0 (uri);
			}
		}
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = excluded_locations;
	_g_object_unref0 (prefs_settings);
	return result;
}

static void
baobab_application_real_startup (GApplication* base)
{
	BaobabApplication * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	self = (BaobabApplication*) base;
	G_APPLICATION_CLASS (baobab_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = g_strdup ("<Primary>comma");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.show-preferences", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("F10");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.show-primary-menu", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Primary>o");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.scan-folder", _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<Primary>r");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.reload", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("F1");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.help", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<Primary>q");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
}

static gint
baobab_application_real_handle_local_options (GApplication* base,
                                              GVariantDict* options)
{
	BaobabApplication * self;
	gint result;
	self = (BaobabApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		const gchar* _tmp0_;
		_tmp0_ = g_get_application_name ();
		g_print ("%s %s\n", _tmp0_, VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}

BaobabApplication*
baobab_application_construct (GType object_type)
{
	BaobabApplication * self = NULL;
	self = (BaobabApplication*) g_object_new (object_type, "application-id", "org.gnome.baobab", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_application_set_resource_base_path ((GApplication*) self, "/org/gnome/baobab/");
	g_application_add_main_option_entries ((GApplication*) self, BAOBAB_APPLICATION_option_entries);
	g_application_set_option_context_parameter_string ((GApplication*) self, "[DIRECTORY]");
	g_action_map_add_action_entries ((GActionMap*) self, BAOBAB_APPLICATION_action_entries, (gint) G_N_ELEMENTS (BAOBAB_APPLICATION_action_entries), self);
	return self;
}

BaobabApplication*
baobab_application_new (void)
{
	return baobab_application_construct (BAOBAB_TYPE_APPLICATION);
}

static void
baobab_application_on_quit_activate (BaobabApplication* self)
{
	g_return_if_fail (self != NULL);
	g_application_quit ((GApplication*) self);
}

static void
baobab_application_class_init (BaobabApplicationClass * klass,
                               gpointer klass_data)
{
	baobab_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabApplication_private_offset);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) baobab_application_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) baobab_application_real_open;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) baobab_application_real_startup;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) baobab_application_real_handle_local_options;
	G_OBJECT_CLASS (klass)->finalize = baobab_application_finalize;
}

static void
baobab_application_instance_init (BaobabApplication * self,
                                  gpointer klass)
{
	self->priv = baobab_application_get_instance_private (self);
}

static void
baobab_application_finalize (GObject * obj)
{
	BaobabApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_APPLICATION, BaobabApplication);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (baobab_application_parent_class)->finalize (obj);
}

static GType
baobab_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabApplication), 0, (GInstanceInitFunc) baobab_application_instance_init, NULL };
	GType baobab_application_type_id;
	baobab_application_type_id = g_type_register_static (adw_application_get_type (), "BaobabApplication", &g_define_type_info, 0);
	BaobabApplication_private_offset = g_type_add_instance_private (baobab_application_type_id, sizeof (BaobabApplicationPrivate));
	return baobab_application_type_id;
}

GType
baobab_application_get_type (void)
{
	static volatile gsize baobab_application_type_id__once = 0;
	if (g_once_init_enter (&baobab_application_type_id__once)) {
		GType baobab_application_type_id;
		baobab_application_type_id = baobab_application_get_type_once ();
		g_once_init_leave (&baobab_application_type_id__once, baobab_application_type_id);
	}
	return baobab_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

